from textwrap import dedent
from generate_statuscode import status_codes
from string import Template
from pathlib import Path
from datetime import datetime
BASE_DIR = Path.cwd().parent

if __name__ == "__main__":
    codes = status_codes()

    with open(BASE_DIR / "asyncua" / "ua" / "uaerrors" / "_auto.py", "w") as f:
        preamble = f"""\
        #AUTOGENERATED!!! Date: {datetime.utcnow()}

        from asyncua.ua.uaerrors import UaStatusCodeError


        """

        f.write(dedent(preamble))

        for name, code, _ in codes:
            # skip non-bad because they should not be thrown as exceptions
            if not name.startswith("Bad"):
                continue

            template = Template(dedent("""\
            class $name(UaStatusCodeError):
                code = $code

            """))
            print(template.safe_substitute(name=name, code=code), file=f)
