from pathlib import Path
from datetime import datetime

BASE_DIR = Path.cwd().parent

if __name__ == "__main__":
    inputfile = open(BASE_DIR / "schemas" / "UA-Nodeset-master" / "Schema" / "NodeIds.csv")
    outputfile = open(BASE_DIR / "asyncua" / "ua" / "object_ids.py", "w")
    outputfile.write(f"#AUTOGENERATED!!!\n"
                     f"\n"
                     f"from enum import IntEnum\n"
                     f"\n"
                     # Making ObjectIds inherit IntEnum has a huge performance impact!!!!!
                     # so we use a normal class and a reverse one for the few places we need it
                     f"class ObjectIds:\n"
                     f"    Null = 0\n")
    nb = None
    name = None
    for line in inputfile:
        name, nb, datatype = line.split(",")
        outputfile.write(f"    {name} = {nb}\n")
    inputfile.close()
    inputfile = open(BASE_DIR / "schemas" / "UA-Nodeset-master" / "Schema" / "NodeIds.csv")
    outputfile.write("\n\nObjectIdNames = {}\n"
                     "ObjectIdNames[0] = 'Null'\n")
    for line in inputfile:
        name, nb, datatype = line.split(",")
        outputfile.write("ObjectIdNames[{0}] = '{1}'\n".format(nb, name))

    inputfile = open(BASE_DIR / "schemas" / "UA-Nodeset-master" / "Schema" / "AttributeIds.csv")
    outputfile = open(BASE_DIR / "asyncua" / "ua" / "attribute_ids.py", "w")
    outputfile.write(f"#AUTOGENERATED!!! Date: {datetime.utcnow()}\n"
                     f"\n"
                     f"from enum import IntEnum\n"
                     f"\n"
                     f"class AttributeIds(IntEnum):\n")
    for line in inputfile:
        name, nb = line.split(",")
        outputfile.write("    {0} = {1}\n".format(name.strip(), nb.strip()))

    print("generate done!")
