
"""
Autogenerated code from xml"

Model Uri:http://opcfoundation.org/UA/"
Version:1.05.01"
Publication date:2022-02-24T00:00:00Z"

File creation Date:2023-07-25 09:08:45.084676"
"""
from asyncua import ua
from .events import Event


__all__ = ["BaseEvent", "AuditEvent", "AuditSecurityEvent", "AuditChannelEvent", "AuditOpenSecureChannelEvent", "AuditSessionEvent", "AuditCreateSessionEvent", "AuditActivateSessionEvent", "AuditCancelEvent", "AuditCertificateEvent", "AuditCertificateDataMismatchEvent", "AuditCertificateExpiredEvent", "AuditCertificateInvalidEvent", "AuditCertificateUntrustedEvent", "AuditCertificateRevokedEvent", "AuditCertificateMismatchEvent", "AuditNodeManagementEvent", "AuditAddNodesEvent", "AuditDeleteNodesEvent", "AuditAddReferencesEvent", "AuditDeleteReferencesEvent", "AuditUpdateEvent", "AuditWriteUpdateEvent", "AuditHistoryUpdateEvent", "AuditUpdateMethodEvent", "SystemEvent", "DeviceFailureEvent", "BaseModelChangeEvent", "GeneralModelChangeEvent", "TransitionEvent", "AuditUpdateStateEvent", "ProgramTransitionEvent", "SemanticChangeEvent", "AuditUrlMismatchEvent", "Condition", "RefreshStartEvent", "RefreshEndEvent", "RefreshRequiredEvent", "AuditConditionEvent", "AuditConditionEnableEvent", "AuditConditionCommentEvent", "DialogCondition", "AcknowledgeableCondition", "AlarmCondition", "LimitAlarm", "AuditHistoryEventUpdateEvent", "AuditHistoryValueUpdateEvent", "AuditHistoryDeleteEvent", "AuditHistoryRawModifyDeleteEvent", "AuditHistoryAtTimeDeleteEvent", "AuditHistoryEventDeleteEvent", "EventQueueOverflowEvent", "ProgramTransitionAuditEvent", "AuditConditionRespondEvent", "AuditConditionAcknowledgeEvent", "AuditConditionConfirmEvent", "ExclusiveLimitAlarm", "ExclusiveLevelAlarm", "ExclusiveRateOfChangeAlarm", "ExclusiveDeviationAlarm", "NonExclusiveLimitAlarm", "NonExclusiveLevelAlarm", "NonExclusiveRateOfChangeAlarm", "NonExclusiveDeviationAlarm", "DiscreteAlarm", "OffNormalAlarm", "TripAlarm", "AuditConditionShelvingEvent", "ProgressEvent", "SystemStatusChangeEvent", "SystemOffNormalAlarm", "AuditProgramTransitionEvent", "TrustListUpdatedAuditEvent", "CertificateUpdatedAuditEvent", "CertificateExpirationAlarm", "AuditConditionResetEvent", "PubSubStatusEvent", "PubSubTransportLimitsExceedEvent", "PubSubCommunicationFailureEvent", "DiscrepancyAlarm", "AuditConditionSuppressionEvent", "AuditConditionSilenceEvent", "AuditConditionOutOfServiceEvent", "RoleMappingRuleChangedAuditEvent", "KeyCredentialAuditEvent", "KeyCredentialUpdatedAuditEvent", "KeyCredentialDeletedAuditEvent", "InstrumentDiagnosticAlarm", "SystemDiagnosticAlarm", "AuditHistoryAnnotationUpdateEvent", "TrustListOutOfDateAlarm", "AuditClientEvent", "AuditClientUpdateMethodResultEvent"]



class BaseEvent(Event):
    """
    BaseEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        Event.__init__(self)
        self.add_property('EventId', None, ua.VariantType.ByteString)
        self.add_property('EventType', ua.NodeId(ua.ObjectIds.BaseEventType), ua.VariantType.NodeId)
        self.add_property('SourceNode', sourcenode, ua.VariantType.NodeId)
        self.add_property('SourceName', None, ua.VariantType.String)
        self.add_property('Time', None, ua.VariantType.DateTime)
        self.add_property('ReceiveTime', None, ua.VariantType.DateTime)
        self.add_property('LocalTime', ua.uaprotocol_auto.TimeZoneDataType(), ua.VariantType.ExtensionObject)
        self.add_property('Message', ua.LocalizedText(message), ua.VariantType.LocalizedText)
        self.add_property('Severity', severity, ua.VariantType.UInt16)


class AuditEvent(BaseEvent):
    """
    AuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditEventType)
        self.add_property('ActionTimeStamp', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('Status', False, ua.VariantType.Boolean)
        self.add_property('ServerId', None, ua.VariantType.String)
        self.add_property('ClientAuditEntryId', None, ua.VariantType.String)
        self.add_property('ClientUserId', None, ua.VariantType.String)


class AuditSecurityEvent(AuditEvent):
    """
    AuditSecurityEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditSecurityEventType)
        self.add_property('StatusCodeId', None, ua.VariantType.StatusCode)


class AuditChannelEvent(AuditSecurityEvent):
    """
    AuditChannelEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditChannelEventType)
        self.add_property('SecureChannelId', None, ua.VariantType.String)


class AuditOpenSecureChannelEvent(AuditChannelEvent):
    """
    AuditOpenSecureChannelEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditOpenSecureChannelEventType)
        self.add_property('ClientCertificate', None, ua.VariantType.ByteString)
        self.add_property('ClientCertificateThumbprint', None, ua.VariantType.String)
        self.add_property('RequestType', None, ua.NodeId(ua.ObjectIds.SecurityTokenRequestType))
        self.add_property('SecurityPolicyUri', None, ua.VariantType.String)
        self.add_property('SecurityMode', None, ua.NodeId(ua.ObjectIds.MessageSecurityMode))
        self.add_property('RequestedLifetime', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_property('CertificateErrorEventId', None, ua.VariantType.String)


class AuditSessionEvent(AuditSecurityEvent):
    """
    AuditSessionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditSessionEventType)
        self.add_property('SessionId', None, ua.VariantType.NodeId)


class AuditCreateSessionEvent(AuditSessionEvent):
    """
    AuditCreateSessionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCreateSessionEventType)
        self.add_property('SecureChannelId', None, ua.VariantType.String)
        self.add_property('ClientCertificate', None, ua.VariantType.ByteString)
        self.add_property('ClientCertificateThumbprint', None, ua.VariantType.String)
        self.add_property('RevisedSessionTimeout', None, ua.NodeId(ua.ObjectIds.Duration))


class AuditActivateSessionEvent(AuditSessionEvent):
    """
    AuditActivateSessionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditActivateSessionEventType)
        self.add_property('ClientSoftwareCertificates', None, ua.NodeId(ua.ObjectIds.SignedSoftwareCertificate))
        self.add_property('UserIdentityToken', None, ua.NodeId(ua.ObjectIds.UserIdentityToken))
        self.add_property('SecureChannelId', None, ua.VariantType.String)


class AuditCancelEvent(AuditSessionEvent):
    """
    AuditCancelEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCancelEventType)
        self.add_property('RequestHandle', None, ua.VariantType.UInt32)


class AuditCertificateEvent(AuditSecurityEvent):
    """
    AuditCertificateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateEventType)
        self.add_property('Certificate', None, ua.VariantType.ByteString)


class AuditCertificateDataMismatchEvent(AuditCertificateEvent):
    """
    AuditCertificateDataMismatchEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateDataMismatchEventType)
        self.add_property('InvalidHostname', None, ua.VariantType.String)
        self.add_property('InvalidUri', None, ua.VariantType.String)


class AuditCertificateExpiredEvent(AuditCertificateEvent):
    """
    AuditCertificateExpiredEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateExpiredEventType)


class AuditCertificateInvalidEvent(AuditCertificateEvent):
    """
    AuditCertificateInvalidEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateInvalidEventType)


class AuditCertificateUntrustedEvent(AuditCertificateEvent):
    """
    AuditCertificateUntrustedEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateUntrustedEventType)


class AuditCertificateRevokedEvent(AuditCertificateEvent):
    """
    AuditCertificateRevokedEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateRevokedEventType)


class AuditCertificateMismatchEvent(AuditCertificateEvent):
    """
    AuditCertificateMismatchEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditCertificateMismatchEventType)


class AuditNodeManagementEvent(AuditEvent):
    """
    AuditNodeManagementEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditNodeManagementEventType)


class AuditAddNodesEvent(AuditNodeManagementEvent):
    """
    AuditAddNodesEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditAddNodesEventType)
        self.add_property('NodesToAdd', None, ua.NodeId(ua.ObjectIds.AddNodesItem))


class AuditDeleteNodesEvent(AuditNodeManagementEvent):
    """
    AuditDeleteNodesEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditDeleteNodesEventType)
        self.add_property('NodesToDelete', None, ua.NodeId(ua.ObjectIds.DeleteNodesItem))


class AuditAddReferencesEvent(AuditNodeManagementEvent):
    """
    AuditAddReferencesEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditAddReferencesEventType)
        self.add_property('ReferencesToAdd', None, ua.NodeId(ua.ObjectIds.AddReferencesItem))


class AuditDeleteReferencesEvent(AuditNodeManagementEvent):
    """
    AuditDeleteReferencesEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditDeleteReferencesEventType)
        self.add_property('ReferencesToDelete', None, ua.NodeId(ua.ObjectIds.DeleteReferencesItem))


class AuditUpdateEvent(AuditEvent):
    """
    AuditUpdateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditUpdateEventType)


class AuditWriteUpdateEvent(AuditUpdateEvent):
    """
    AuditWriteUpdateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditWriteUpdateEventType)
        self.add_property('AttributeId', None, ua.VariantType.UInt32)
        self.add_property('IndexRange', None, ua.NodeId(ua.ObjectIds.NumericRange))
        self.add_property('OldValue', None, ua.VariantType.Variant)
        self.add_property('NewValue', None, ua.VariantType.Variant)


class AuditHistoryUpdateEvent(AuditUpdateEvent):
    """
    AuditHistoryUpdateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryUpdateEventType)
        self.add_property('ParameterDataTypeId', None, ua.VariantType.NodeId)


class AuditUpdateMethodEvent(AuditEvent):
    """
    AuditUpdateMethodEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditUpdateMethodEventType)
        self.add_property('MethodId', None, ua.VariantType.NodeId)
        self.add_property('InputArguments', None, ua.VariantType.Variant)


class SystemEvent(BaseEvent):
    """
    SystemEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.SystemEventType)


class DeviceFailureEvent(SystemEvent):
    """
    DeviceFailureEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.DeviceFailureEventType)


class BaseModelChangeEvent(BaseEvent):
    """
    BaseModelChangeEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.BaseModelChangeEventType)


class GeneralModelChangeEvent(BaseModelChangeEvent):
    """
    GeneralModelChangeEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.GeneralModelChangeEventType)
        self.add_property('Changes', None, ua.NodeId(ua.ObjectIds.ModelChangeStructureDataType))


class TransitionEvent(BaseEvent):
    """
    TransitionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.TransitionEventType)
        self.add_property('Transition/Id', None, ua.VariantType.Variant)
        self.add_variable('Transition', None, ua.VariantType.LocalizedText)
        self.add_property('FromState/Id', None, ua.VariantType.Variant)
        self.add_variable('FromState', None, ua.VariantType.LocalizedText)
        self.add_property('ToState/Id', None, ua.VariantType.Variant)
        self.add_variable('ToState', None, ua.VariantType.LocalizedText)


class AuditUpdateStateEvent(AuditUpdateMethodEvent):
    """
    AuditUpdateStateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditUpdateStateEventType)
        self.add_property('OldStateId', None, ua.VariantType.Variant)
        self.add_property('NewStateId', None, ua.VariantType.Variant)


class ProgramTransitionEvent(TransitionEvent):
    """
    ProgramTransitionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ProgramTransitionEventType)
        self.add_variable('IntermediateResult', None, ua.VariantType.Variant)


class SemanticChangeEvent(BaseEvent):
    """
    SemanticChangeEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.SemanticChangeEventType)
        self.add_property('Changes', None, ua.NodeId(ua.ObjectIds.SemanticChangeStructureDataType))


class AuditUrlMismatchEvent(AuditCreateSessionEvent):
    """
    AuditUrlMismatchEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditUrlMismatchEventType)
        self.add_property('EndpointUrl', None, ua.VariantType.String)


class Condition(BaseEvent):
    """
    Condition:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ConditionType)
        self.add_property('ConditionClassId', None, ua.VariantType.NodeId)
        self.add_property('ConditionClassName', None, ua.VariantType.LocalizedText)
        self.add_property('ConditionSubClassId', None, ua.VariantType.NodeId)
        self.add_property('ConditionSubClassName', None, ua.VariantType.LocalizedText)
        self.add_property('ConditionName', None, ua.VariantType.String)
        self.add_property('BranchId', None, ua.VariantType.NodeId)
        self.add_property('Retain', None, ua.VariantType.Boolean)
        self.add_property('EnabledState/Id', None, ua.VariantType.Boolean)
        self.add_property('EnabledState/EffectiveDisplayName', None, ua.VariantType.LocalizedText)
        self.add_property('EnabledState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('EnabledState/EffectiveTransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('EnabledState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('EnabledState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('EnabledState', None, ua.VariantType.LocalizedText)
        self.add_property('Quality/SourceTimestamp', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_variable('Quality', None, ua.VariantType.StatusCode)
        self.add_property('LastSeverity/SourceTimestamp', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_variable('LastSeverity', None, ua.VariantType.UInt16)
        self.add_property('Comment/SourceTimestamp', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_variable('Comment', None, ua.VariantType.LocalizedText)
        self.add_property('ClientUserId', None, ua.VariantType.String)


class RefreshStartEvent(SystemEvent):
    """
    RefreshStartEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.RefreshStartEventType)


class RefreshEndEvent(SystemEvent):
    """
    RefreshEndEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.RefreshEndEventType)


class RefreshRequiredEvent(SystemEvent):
    """
    RefreshRequiredEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.RefreshRequiredEventType)


class AuditConditionEvent(AuditUpdateMethodEvent):
    """
    AuditConditionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionEventType)


class AuditConditionEnableEvent(AuditConditionEvent):
    """
    AuditConditionEnableEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionEnableEventType)


class AuditConditionCommentEvent(AuditConditionEvent):
    """
    AuditConditionCommentEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionCommentEventType)
        self.add_property('ConditionEventId', None, ua.VariantType.ByteString)
        self.add_property('Comment', None, ua.VariantType.LocalizedText)


class DialogCondition(Condition):
    """
    DialogCondition:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.DialogConditionType)
        self.add_property('EnabledState/Id', None, ua.VariantType.Boolean)
        self.add_variable('EnabledState', None, ua.VariantType.LocalizedText)
        self.add_property('DialogState/Id', None, ua.VariantType.Boolean)
        self.add_property('DialogState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('DialogState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('DialogState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('DialogState', None, ua.VariantType.LocalizedText)
        self.add_property('Prompt', None, ua.VariantType.LocalizedText)
        self.add_property('ResponseOptionSet', None, ua.VariantType.LocalizedText)
        self.add_property('DefaultResponse', None, ua.VariantType.Int32)
        self.add_property('OkResponse', None, ua.VariantType.Int32)
        self.add_property('CancelResponse', None, ua.VariantType.Int32)
        self.add_property('LastResponse', None, ua.VariantType.Int32)


class AcknowledgeableCondition(Condition):
    """
    AcknowledgeableCondition:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AcknowledgeableConditionType)
        self.add_property('EnabledState/Id', None, ua.VariantType.Boolean)
        self.add_variable('EnabledState', None, ua.VariantType.LocalizedText)
        self.add_property('AckedState/Id', None, ua.VariantType.Boolean)
        self.add_property('AckedState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('AckedState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('AckedState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('AckedState', None, ua.VariantType.LocalizedText)
        self.add_property('ConfirmedState/Id', None, ua.VariantType.Boolean)
        self.add_property('ConfirmedState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('ConfirmedState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('ConfirmedState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('ConfirmedState', None, ua.VariantType.LocalizedText)


class AlarmCondition(AcknowledgeableCondition):
    """
    AlarmCondition:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AlarmConditionType)
        self.add_property('EnabledState/Id', None, ua.VariantType.Boolean)
        self.add_variable('EnabledState', None, ua.VariantType.LocalizedText)
        self.add_property('ActiveState/Id', None, ua.VariantType.Boolean)
        self.add_property('ActiveState/EffectiveDisplayName', None, ua.VariantType.LocalizedText)
        self.add_property('ActiveState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('ActiveState/EffectiveTransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('ActiveState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('ActiveState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('ActiveState', None, ua.VariantType.LocalizedText)
        self.add_property('InputNode', None, ua.VariantType.NodeId)
        self.add_property('SuppressedState/Id', None, ua.VariantType.Boolean)
        self.add_property('SuppressedState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('SuppressedState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('SuppressedState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('SuppressedState', None, ua.VariantType.LocalizedText)
        self.add_property('OutOfServiceState/Id', None, ua.VariantType.Boolean)
        self.add_property('OutOfServiceState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('OutOfServiceState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('OutOfServiceState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('OutOfServiceState', None, ua.VariantType.LocalizedText)
        self.add_property('SuppressedOrShelved', None, ua.VariantType.Boolean)
        self.add_property('MaxTimeShelved', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_property('AudibleEnabled', None, ua.VariantType.Boolean)
        self.add_variable('AudibleSound', None, ua.NodeId(ua.ObjectIds.AudioDataType))
        self.add_property('SilenceState/Id', None, ua.VariantType.Boolean)
        self.add_property('SilenceState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('SilenceState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('SilenceState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('SilenceState', None, ua.VariantType.LocalizedText)
        self.add_property('OnDelay', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_property('OffDelay', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_variable('FirstInGroupFlag', None, ua.VariantType.Boolean)
        self.add_property('LatchedState/Id', None, ua.VariantType.Boolean)
        self.add_property('LatchedState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('LatchedState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('LatchedState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('LatchedState', None, ua.VariantType.LocalizedText)
        self.add_property('ReAlarmTime', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_variable('ReAlarmRepeatCount', None, ua.VariantType.Int16)


class LimitAlarm(AlarmCondition):
    """
    LimitAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.LimitAlarmType)
        self.add_property('HighHighLimit', None, ua.VariantType.Double)
        self.add_property('HighLimit', None, ua.VariantType.Double)
        self.add_property('LowLimit', None, ua.VariantType.Double)
        self.add_property('LowLowLimit', None, ua.VariantType.Double)
        self.add_property('BaseHighHighLimit', None, ua.VariantType.Double)
        self.add_property('BaseHighLimit', None, ua.VariantType.Double)
        self.add_property('BaseLowLimit', None, ua.VariantType.Double)
        self.add_property('BaseLowLowLimit', None, ua.VariantType.Double)
        self.add_property('SeverityHighHigh', None, ua.VariantType.UInt16)
        self.add_property('SeverityHigh', None, ua.VariantType.UInt16)
        self.add_property('SeverityLow', None, ua.VariantType.UInt16)
        self.add_property('SeverityLowLow', None, ua.VariantType.UInt16)
        self.add_property('HighHighDeadband', None, ua.VariantType.Double)
        self.add_property('HighDeadband', None, ua.VariantType.Double)
        self.add_property('LowDeadband', None, ua.VariantType.Double)
        self.add_property('LowLowDeadband', None, ua.VariantType.Double)


class AuditHistoryEventUpdateEvent(AuditHistoryUpdateEvent):
    """
    AuditHistoryEventUpdateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryEventUpdateEventType)
        self.add_property('UpdatedNode', None, ua.VariantType.NodeId)
        self.add_property('PerformInsertReplace', None, ua.NodeId(ua.ObjectIds.PerformUpdateType))
        self.add_property('Filter', None, ua.NodeId(ua.ObjectIds.EventFilter))
        self.add_property('NewValues', None, ua.NodeId(ua.ObjectIds.HistoryEventFieldList))
        self.add_property('OldValues', None, ua.NodeId(ua.ObjectIds.HistoryEventFieldList))


class AuditHistoryValueUpdateEvent(AuditHistoryUpdateEvent):
    """
    AuditHistoryValueUpdateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryValueUpdateEventType)
        self.add_property('UpdatedNode', None, ua.VariantType.NodeId)
        self.add_property('PerformInsertReplace', None, ua.NodeId(ua.ObjectIds.PerformUpdateType))
        self.add_property('NewValues', None, ua.NodeId(ua.ObjectIds.DataValue))
        self.add_property('OldValues', None, ua.NodeId(ua.ObjectIds.DataValue))


class AuditHistoryDeleteEvent(AuditHistoryUpdateEvent):
    """
    AuditHistoryDeleteEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryDeleteEventType)
        self.add_property('UpdatedNode', None, ua.VariantType.NodeId)


class AuditHistoryRawModifyDeleteEvent(AuditHistoryDeleteEvent):
    """
    AuditHistoryRawModifyDeleteEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryRawModifyDeleteEventType)
        self.add_property('IsDeleteModified', None, ua.VariantType.Boolean)
        self.add_property('StartTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('EndTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('OldValues', None, ua.NodeId(ua.ObjectIds.DataValue))


class AuditHistoryAtTimeDeleteEvent(AuditHistoryDeleteEvent):
    """
    AuditHistoryAtTimeDeleteEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryAtTimeDeleteEventType)
        self.add_property('ReqTimes', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('OldValues', None, ua.NodeId(ua.ObjectIds.DataValue))


class AuditHistoryEventDeleteEvent(AuditHistoryDeleteEvent):
    """
    AuditHistoryEventDeleteEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryEventDeleteEventType)
        self.add_property('EventIds', None, ua.VariantType.ByteString)
        self.add_property('OldValues', None, ua.NodeId(ua.ObjectIds.HistoryEventFieldList))


class EventQueueOverflowEvent(BaseEvent):
    """
    EventQueueOverflowEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.EventQueueOverflowEventType)


class ProgramTransitionAuditEvent(AuditUpdateStateEvent):
    """
    ProgramTransitionAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ProgramTransitionAuditEventType)
        self.add_property('Transition/Id', None, ua.VariantType.NodeId)
        self.add_variable('Transition', None, ua.VariantType.LocalizedText)


class AuditConditionRespondEvent(AuditConditionEvent):
    """
    AuditConditionRespondEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionRespondEventType)
        self.add_property('SelectedResponse', None, ua.VariantType.UInt32)


class AuditConditionAcknowledgeEvent(AuditConditionEvent):
    """
    AuditConditionAcknowledgeEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionAcknowledgeEventType)
        self.add_property('ConditionEventId', None, ua.VariantType.ByteString)
        self.add_property('Comment', None, ua.VariantType.LocalizedText)


class AuditConditionConfirmEvent(AuditConditionEvent):
    """
    AuditConditionConfirmEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionConfirmEventType)
        self.add_property('ConditionEventId', None, ua.VariantType.ByteString)
        self.add_property('Comment', None, ua.VariantType.LocalizedText)


class ExclusiveLimitAlarm(LimitAlarm):
    """
    ExclusiveLimitAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ExclusiveLimitAlarmType)
        self.add_property('ActiveState/Id', None, ua.VariantType.Boolean)
        self.add_variable('ActiveState', None, ua.VariantType.LocalizedText)


class ExclusiveLevelAlarm(ExclusiveLimitAlarm):
    """
    ExclusiveLevelAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ExclusiveLevelAlarmType)


class ExclusiveRateOfChangeAlarm(ExclusiveLimitAlarm):
    """
    ExclusiveRateOfChangeAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ExclusiveRateOfChangeAlarmType)
        self.add_property('EngineeringUnits', None, ua.NodeId(ua.ObjectIds.EUInformation))


class ExclusiveDeviationAlarm(ExclusiveLimitAlarm):
    """
    ExclusiveDeviationAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ExclusiveDeviationAlarmType)
        self.add_property('SetpointNode', None, ua.VariantType.NodeId)
        self.add_property('BaseSetpointNode', None, ua.VariantType.NodeId)


class NonExclusiveLimitAlarm(LimitAlarm):
    """
    NonExclusiveLimitAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.NonExclusiveLimitAlarmType)
        self.add_property('ActiveState/Id', None, ua.VariantType.Boolean)
        self.add_variable('ActiveState', None, ua.VariantType.LocalizedText)
        self.add_property('HighHighState/Id', None, ua.VariantType.Boolean)
        self.add_property('HighHighState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('HighHighState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('HighHighState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('HighHighState', None, ua.VariantType.LocalizedText)
        self.add_property('HighState/Id', None, ua.VariantType.Boolean)
        self.add_property('HighState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('HighState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('HighState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('HighState', None, ua.VariantType.LocalizedText)
        self.add_property('LowState/Id', None, ua.VariantType.Boolean)
        self.add_property('LowState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('LowState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('LowState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('LowState', None, ua.VariantType.LocalizedText)
        self.add_property('LowLowState/Id', None, ua.VariantType.Boolean)
        self.add_property('LowLowState/TransitionTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('LowLowState/TrueState', None, ua.VariantType.LocalizedText)
        self.add_property('LowLowState/FalseState', None, ua.VariantType.LocalizedText)
        self.add_variable('LowLowState', None, ua.VariantType.LocalizedText)


class NonExclusiveLevelAlarm(NonExclusiveLimitAlarm):
    """
    NonExclusiveLevelAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.NonExclusiveLevelAlarmType)


class NonExclusiveRateOfChangeAlarm(NonExclusiveLimitAlarm):
    """
    NonExclusiveRateOfChangeAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.NonExclusiveRateOfChangeAlarmType)
        self.add_property('EngineeringUnits', None, ua.NodeId(ua.ObjectIds.EUInformation))


class NonExclusiveDeviationAlarm(NonExclusiveLimitAlarm):
    """
    NonExclusiveDeviationAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.NonExclusiveDeviationAlarmType)
        self.add_property('SetpointNode', None, ua.VariantType.NodeId)
        self.add_property('BaseSetpointNode', None, ua.VariantType.NodeId)


class DiscreteAlarm(AlarmCondition):
    """
    DiscreteAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.DiscreteAlarmType)


class OffNormalAlarm(DiscreteAlarm):
    """
    OffNormalAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.OffNormalAlarmType)
        self.add_property('NormalState', None, ua.VariantType.NodeId)


class TripAlarm(OffNormalAlarm):
    """
    TripAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.TripAlarmType)


class AuditConditionShelvingEvent(AuditConditionEvent):
    """
    AuditConditionShelvingEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionShelvingEventType)
        self.add_property('ShelvingTime', None, ua.NodeId(ua.ObjectIds.Duration))


class ProgressEvent(BaseEvent):
    """
    ProgressEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.ProgressEventType)
        self.add_property('Context', None, ua.VariantType.Variant)
        self.add_property('Progress', None, ua.VariantType.UInt16)


class SystemStatusChangeEvent(SystemEvent):
    """
    SystemStatusChangeEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.SystemStatusChangeEventType)
        self.add_property('SystemState', None, ua.NodeId(ua.ObjectIds.ServerState))


class SystemOffNormalAlarm(OffNormalAlarm):
    """
    SystemOffNormalAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.SystemOffNormalAlarmType)


class AuditProgramTransitionEvent(AuditUpdateStateEvent):
    """
    AuditProgramTransitionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditProgramTransitionEventType)
        self.add_property('TransitionNumber', None, ua.VariantType.UInt32)


class TrustListUpdatedAuditEvent(AuditUpdateMethodEvent):
    """
    TrustListUpdatedAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.TrustListUpdatedAuditEventType)


class CertificateUpdatedAuditEvent(AuditUpdateMethodEvent):
    """
    CertificateUpdatedAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.CertificateUpdatedAuditEventType)
        self.add_property('CertificateGroup', None, ua.VariantType.NodeId)
        self.add_property('CertificateType', None, ua.VariantType.NodeId)


class CertificateExpirationAlarm(SystemOffNormalAlarm):
    """
    CertificateExpirationAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.CertificateExpirationAlarmType)
        self.add_property('ExpirationDate', None, ua.VariantType.DateTime)
        self.add_property('ExpirationLimit', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_property('CertificateType', None, ua.VariantType.NodeId)
        self.add_property('Certificate', None, ua.VariantType.ByteString)


class AuditConditionResetEvent(AuditConditionEvent):
    """
    AuditConditionResetEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionResetEventType)


class PubSubStatusEvent(SystemEvent):
    """
    PubSubStatusEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.PubSubStatusEventType)
        self.add_property('ConnectionId', None, ua.VariantType.NodeId)
        self.add_property('GroupId', None, ua.VariantType.NodeId)
        self.add_property('State', None, ua.NodeId(ua.ObjectIds.PubSubState))


class PubSubTransportLimitsExceedEvent(PubSubStatusEvent):
    """
    PubSubTransportLimitsExceedEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.PubSubTransportLimitsExceedEventType)
        self.add_property('Actual', None, ua.VariantType.UInt32)
        self.add_property('Maximum', None, ua.VariantType.UInt32)


class PubSubCommunicationFailureEvent(PubSubStatusEvent):
    """
    PubSubCommunicationFailureEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.PubSubCommunicationFailureEventType)
        self.add_property('Error', None, ua.VariantType.StatusCode)


class DiscrepancyAlarm(AlarmCondition):
    """
    DiscrepancyAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.DiscrepancyAlarmType)
        self.add_property('TargetValueNode', None, ua.VariantType.NodeId)
        self.add_property('ExpectedTime', None, ua.NodeId(ua.ObjectIds.Duration))
        self.add_property('Tolerance', None, ua.VariantType.Double)


class AuditConditionSuppressionEvent(AuditConditionEvent):
    """
    AuditConditionSuppressionEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionSuppressionEventType)


class AuditConditionSilenceEvent(AuditConditionEvent):
    """
    AuditConditionSilenceEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionSilenceEventType)


class AuditConditionOutOfServiceEvent(AuditConditionEvent):
    """
    AuditConditionOutOfServiceEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditConditionOutOfServiceEventType)


class RoleMappingRuleChangedAuditEvent(AuditUpdateMethodEvent):
    """
    RoleMappingRuleChangedAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.RoleMappingRuleChangedAuditEventType)


class KeyCredentialAuditEvent(AuditUpdateMethodEvent):
    """
    KeyCredentialAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.KeyCredentialAuditEventType)
        self.add_property('ResourceUri', None, ua.VariantType.String)


class KeyCredentialUpdatedAuditEvent(KeyCredentialAuditEvent):
    """
    KeyCredentialUpdatedAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.KeyCredentialUpdatedAuditEventType)


class KeyCredentialDeletedAuditEvent(KeyCredentialAuditEvent):
    """
    KeyCredentialDeletedAuditEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.KeyCredentialDeletedAuditEventType)
        self.add_property('ResourceUri', None, ua.VariantType.String)


class InstrumentDiagnosticAlarm(OffNormalAlarm):
    """
    InstrumentDiagnosticAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.InstrumentDiagnosticAlarmType)


class SystemDiagnosticAlarm(OffNormalAlarm):
    """
    SystemDiagnosticAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.SystemDiagnosticAlarmType)


class AuditHistoryAnnotationUpdateEvent(AuditHistoryUpdateEvent):
    """
    AuditHistoryAnnotationUpdateEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditHistoryAnnotationUpdateEventType)
        self.add_property('PerformInsertReplace', None, ua.NodeId(ua.ObjectIds.PerformUpdateType))
        self.add_property('NewValues', None, ua.NodeId(ua.ObjectIds.DataValue))
        self.add_property('OldValues', None, ua.NodeId(ua.ObjectIds.DataValue))


class TrustListOutOfDateAlarm(SystemOffNormalAlarm):
    """
    TrustListOutOfDateAlarm:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.TrustListOutOfDateAlarmType)
        self.add_property('TrustListId', None, ua.VariantType.NodeId)
        self.add_property('LastUpdateTime', None, ua.NodeId(ua.ObjectIds.UtcTime))
        self.add_property('UpdateFrequency', None, ua.NodeId(ua.ObjectIds.Duration))


class AuditClientEvent(AuditEvent):
    """
    AuditClientEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditClientEventType)
        self.add_property('ServerUri', None, ua.NodeId(ua.ObjectIds.UriString))


class AuditClientUpdateMethodResultEvent(AuditClientEvent):
    """
    AuditClientUpdateMethodResultEvent:
    """
    def __init__(self, sourcenode=None, message=None, severity=1):
        super().__init__(sourcenode, message, severity)
        self.EventType = ua.NodeId(ua.ObjectIds.AuditClientUpdateMethodResultEventType)
        self.add_property('ObjectId', None, ua.VariantType.NodeId)
        self.add_property('MethodId', None, ua.VariantType.NodeId)
        self.add_property('StatusCodeId', None, ua.VariantType.StatusCode)
        self.add_property('InputArguments', None, ua.NodeId(ua.ObjectIds.Argument))
        self.add_property('OutputArguments', None, ua.NodeId(ua.ObjectIds.Argument))


IMPLEMENTED_EVENTS = {
    ua.ObjectIds.BaseEventType: BaseEvent,
    ua.ObjectIds.AuditEventType: AuditEvent,
    ua.ObjectIds.AuditSecurityEventType: AuditSecurityEvent,
    ua.ObjectIds.AuditChannelEventType: AuditChannelEvent,
    ua.ObjectIds.AuditOpenSecureChannelEventType: AuditOpenSecureChannelEvent,
    ua.ObjectIds.AuditSessionEventType: AuditSessionEvent,
    ua.ObjectIds.AuditCreateSessionEventType: AuditCreateSessionEvent,
    ua.ObjectIds.AuditActivateSessionEventType: AuditActivateSessionEvent,
    ua.ObjectIds.AuditCancelEventType: AuditCancelEvent,
    ua.ObjectIds.AuditCertificateEventType: AuditCertificateEvent,
    ua.ObjectIds.AuditCertificateDataMismatchEventType: AuditCertificateDataMismatchEvent,
    ua.ObjectIds.AuditCertificateExpiredEventType: AuditCertificateExpiredEvent,
    ua.ObjectIds.AuditCertificateInvalidEventType: AuditCertificateInvalidEvent,
    ua.ObjectIds.AuditCertificateUntrustedEventType: AuditCertificateUntrustedEvent,
    ua.ObjectIds.AuditCertificateRevokedEventType: AuditCertificateRevokedEvent,
    ua.ObjectIds.AuditCertificateMismatchEventType: AuditCertificateMismatchEvent,
    ua.ObjectIds.AuditNodeManagementEventType: AuditNodeManagementEvent,
    ua.ObjectIds.AuditAddNodesEventType: AuditAddNodesEvent,
    ua.ObjectIds.AuditDeleteNodesEventType: AuditDeleteNodesEvent,
    ua.ObjectIds.AuditAddReferencesEventType: AuditAddReferencesEvent,
    ua.ObjectIds.AuditDeleteReferencesEventType: AuditDeleteReferencesEvent,
    ua.ObjectIds.AuditUpdateEventType: AuditUpdateEvent,
    ua.ObjectIds.AuditWriteUpdateEventType: AuditWriteUpdateEvent,
    ua.ObjectIds.AuditHistoryUpdateEventType: AuditHistoryUpdateEvent,
    ua.ObjectIds.AuditUpdateMethodEventType: AuditUpdateMethodEvent,
    ua.ObjectIds.SystemEventType: SystemEvent,
    ua.ObjectIds.DeviceFailureEventType: DeviceFailureEvent,
    ua.ObjectIds.BaseModelChangeEventType: BaseModelChangeEvent,
    ua.ObjectIds.GeneralModelChangeEventType: GeneralModelChangeEvent,
    ua.ObjectIds.TransitionEventType: TransitionEvent,
    ua.ObjectIds.AuditUpdateStateEventType: AuditUpdateStateEvent,
    ua.ObjectIds.ProgramTransitionEventType: ProgramTransitionEvent,
    ua.ObjectIds.SemanticChangeEventType: SemanticChangeEvent,
    ua.ObjectIds.AuditUrlMismatchEventType: AuditUrlMismatchEvent,
    ua.ObjectIds.ConditionType: Condition,
    ua.ObjectIds.RefreshStartEventType: RefreshStartEvent,
    ua.ObjectIds.RefreshEndEventType: RefreshEndEvent,
    ua.ObjectIds.RefreshRequiredEventType: RefreshRequiredEvent,
    ua.ObjectIds.AuditConditionEventType: AuditConditionEvent,
    ua.ObjectIds.AuditConditionEnableEventType: AuditConditionEnableEvent,
    ua.ObjectIds.AuditConditionCommentEventType: AuditConditionCommentEvent,
    ua.ObjectIds.DialogConditionType: DialogCondition,
    ua.ObjectIds.AcknowledgeableConditionType: AcknowledgeableCondition,
    ua.ObjectIds.AlarmConditionType: AlarmCondition,
    ua.ObjectIds.LimitAlarmType: LimitAlarm,
    ua.ObjectIds.AuditHistoryEventUpdateEventType: AuditHistoryEventUpdateEvent,
    ua.ObjectIds.AuditHistoryValueUpdateEventType: AuditHistoryValueUpdateEvent,
    ua.ObjectIds.AuditHistoryDeleteEventType: AuditHistoryDeleteEvent,
    ua.ObjectIds.AuditHistoryRawModifyDeleteEventType: AuditHistoryRawModifyDeleteEvent,
    ua.ObjectIds.AuditHistoryAtTimeDeleteEventType: AuditHistoryAtTimeDeleteEvent,
    ua.ObjectIds.AuditHistoryEventDeleteEventType: AuditHistoryEventDeleteEvent,
    ua.ObjectIds.EventQueueOverflowEventType: EventQueueOverflowEvent,
    ua.ObjectIds.ProgramTransitionAuditEventType: ProgramTransitionAuditEvent,
    ua.ObjectIds.AuditConditionRespondEventType: AuditConditionRespondEvent,
    ua.ObjectIds.AuditConditionAcknowledgeEventType: AuditConditionAcknowledgeEvent,
    ua.ObjectIds.AuditConditionConfirmEventType: AuditConditionConfirmEvent,
    ua.ObjectIds.ExclusiveLimitAlarmType: ExclusiveLimitAlarm,
    ua.ObjectIds.ExclusiveLevelAlarmType: ExclusiveLevelAlarm,
    ua.ObjectIds.ExclusiveRateOfChangeAlarmType: ExclusiveRateOfChangeAlarm,
    ua.ObjectIds.ExclusiveDeviationAlarmType: ExclusiveDeviationAlarm,
    ua.ObjectIds.NonExclusiveLimitAlarmType: NonExclusiveLimitAlarm,
    ua.ObjectIds.NonExclusiveLevelAlarmType: NonExclusiveLevelAlarm,
    ua.ObjectIds.NonExclusiveRateOfChangeAlarmType: NonExclusiveRateOfChangeAlarm,
    ua.ObjectIds.NonExclusiveDeviationAlarmType: NonExclusiveDeviationAlarm,
    ua.ObjectIds.DiscreteAlarmType: DiscreteAlarm,
    ua.ObjectIds.OffNormalAlarmType: OffNormalAlarm,
    ua.ObjectIds.TripAlarmType: TripAlarm,
    ua.ObjectIds.AuditConditionShelvingEventType: AuditConditionShelvingEvent,
    ua.ObjectIds.ProgressEventType: ProgressEvent,
    ua.ObjectIds.SystemStatusChangeEventType: SystemStatusChangeEvent,
    ua.ObjectIds.SystemOffNormalAlarmType: SystemOffNormalAlarm,
    ua.ObjectIds.AuditProgramTransitionEventType: AuditProgramTransitionEvent,
    ua.ObjectIds.TrustListUpdatedAuditEventType: TrustListUpdatedAuditEvent,
    ua.ObjectIds.CertificateUpdatedAuditEventType: CertificateUpdatedAuditEvent,
    ua.ObjectIds.CertificateExpirationAlarmType: CertificateExpirationAlarm,
    ua.ObjectIds.AuditConditionResetEventType: AuditConditionResetEvent,
    ua.ObjectIds.PubSubStatusEventType: PubSubStatusEvent,
    ua.ObjectIds.PubSubTransportLimitsExceedEventType: PubSubTransportLimitsExceedEvent,
    ua.ObjectIds.PubSubCommunicationFailureEventType: PubSubCommunicationFailureEvent,
    ua.ObjectIds.DiscrepancyAlarmType: DiscrepancyAlarm,
    ua.ObjectIds.AuditConditionSuppressionEventType: AuditConditionSuppressionEvent,
    ua.ObjectIds.AuditConditionSilenceEventType: AuditConditionSilenceEvent,
    ua.ObjectIds.AuditConditionOutOfServiceEventType: AuditConditionOutOfServiceEvent,
    ua.ObjectIds.RoleMappingRuleChangedAuditEventType: RoleMappingRuleChangedAuditEvent,
    ua.ObjectIds.KeyCredentialAuditEventType: KeyCredentialAuditEvent,
    ua.ObjectIds.KeyCredentialUpdatedAuditEventType: KeyCredentialUpdatedAuditEvent,
    ua.ObjectIds.KeyCredentialDeletedAuditEventType: KeyCredentialDeletedAuditEvent,
    ua.ObjectIds.InstrumentDiagnosticAlarmType: InstrumentDiagnosticAlarm,
    ua.ObjectIds.SystemDiagnosticAlarmType: SystemDiagnosticAlarm,
    ua.ObjectIds.AuditHistoryAnnotationUpdateEventType: AuditHistoryAnnotationUpdateEvent,
    ua.ObjectIds.TrustListOutOfDateAlarmType: TrustListOutOfDateAlarm,
    ua.ObjectIds.AuditClientEventType: AuditClientEvent,
    ua.ObjectIds.AuditClientUpdateMethodResultEventType: AuditClientUpdateMethodResultEvent,
    }
