--TEST--
Bug #68549 (setting timestamp around a DST transition)
--CREDITS--
Roel Harbers <roel.harbers@on2it.net>
--FILE--
<?php
$timezonesWithTimestamps = [
    'America/Los_Angeles' => [
        // LANG=en_US TZ="America/Los_Angeles" date --date=@<...>
        // forward:
        1615687199, // Sat Mar 13 17:59:59 PST 2021 (Sun Mar 14 01:59:59 UTC 2021)
        1615687200, // Sat Mar 13 18:00:00 PST 2021 (Sun Mar 14 02:00:00 UTC 2021)
        1615687201, // Sat Mar 13 18:00:01 PST 2021 (Sun Mar 14 02:00:01 UTC 2021)
        1615690799, // Sat Mar 13 18:59:59 PST 2021 (Sun Mar 14 02:59:59 UTC 2021)
        1615690800, // Sat Mar 13 19:00:00 PST 2021 (Sun Mar 14 03:00:00 UTC 2021)
        1615690801, // Sat Mar 13 19:00:01 PST 2021 (Sun Mar 14 03:00:01 UTC 2021)
        1615708799, // Sun Mar 13 23:59:59 PST 2021
        1615708800, // Sun Mar 14 00:00:00 PST 2021
        1615708801, // Sun Mar 14 00:00:01 PST 2021
        1615712399, // Sun Mar 14 00:59:59 PST 2021
        1615712400, // Sun Mar 14 01:00:00 PST 2021
        1615712401, // Sun Mar 14 01:00:01 PST 2021
        1615715999, // Sun Mar 14 01:59:59 PST 2021
        1615716000, // Sun Mar 14 03:00:00 PDT 2021
        1615716001, // Sun Mar 14 03:00:01 PDT 2021
        1615719599, // Sun Mar 14 03:59:59 PDT 2021
        1615719600, // Sun Mar 14 04:00:00 PDT 2021
        1615719601, // Sun Mar 14 04:00:01 PDT 2021
        // backward:
        1636246799, // Sat Nov  6 17:59:59 PDT 2021 (Sun Nov  7 00:59:59 UTC 2021)
        1636246800, // Sat Nov  6 18:00:00 PDT 2021 (Sun Nov  7 01:00:00 UTC 2021)
        1636246801, // Sat Nov  6 18:00:01 PDT 2021 (Sun Nov  7 01:00:01 UTC 2021)
        1636250399, // Sat Nov  6 18:59:59 PDT 2021 (Sun Nov  7 01:59:59 UTC 2021)
        1636250400, // Sat Nov  6 19:00:00 PDT 2021 (Sun Nov  7 02:00:00 UTC 2021)
        1636250401, // Sat Nov  6 19:00:01 PDT 2021 (Sun Nov  7 02:00:01 UTC 2021)
        1636268399, // Sat Nov  6 23:59:59 PDT 2021
        1636268400, // Sun Nov  7 00:00:00 PDT 2021
        1636268401, // Sun Nov  7 00:00:01 PDT 2021
        1636271999, // Sun Nov  7 00:59:59 PDT 2021
        1636272000, // Sun Nov  7 01:00:00 PDT 2021
        1636272001, // Sun Nov  7 01:00:01 PDT 2021
        1636275599, // Sun Nov  7 01:59:59 PDT 2021
        1636275600, // Sun Nov  7 01:00:00 PST 2021
        1636275601, // Sun Nov  7 01:00:01 PST 2021
        1636279199, // Sun Nov  7 01:59:59 PST 2021
        1636279200, // Sun Nov  7 02:00:00 PST 2021
        1636279201, // Sun Nov  7 02:00:01 PST 2021
    ],
    'Atlantic/Azores' => [
        // LANG=en_US TZ="Atlantic/Azores" date --date=@<...>
        // forward:
        1616889599, // Sat Mar 27 22:59:59 AZOT 2021 (Sat Mar 27 23:59:59 UTC 2021)
        1616889600, // Sat Mar 27 23:00:00 AZOT 2021 (Sun Mar 28 00:00:00 UTC 2021)
        1616889601, // Sat Mar 27 23:00:01 AZOT 2021 (Sun Mar 28 00:00:01 UTC 2021)
        1616893199, // Sat Mar 27 23:59:59 AZOT 2021 (Sun Mar 28 00:59:59 UTC 2021)
        1616893200, // Sun Mar 28 01:00:00 AZOST 2021 (Sun Mar 28 01:00:00 UTC 2021)
        1616893201, // Sun Mar 28 01:00:01 AZOST 2021 (Sun Mar 28 01:00:01 UTC 2021)
        1616896799, // Sun Mar 28 01:59:59 AZOST 2021
        1616896800, // Sun Mar 28 02:00:00 AZOST 2021
        1616896801, // Sun Mar 28 02:00:01 AZOST 2021
        // backward:
        1635638399, // Sat Oct 30 23:59:59 AZOST 2021 (Sat Oct 30 23:59:59 UTC 2021)
        1635638400, // Sun Oct 31 00:00:00 AZOST 2021 (Sun Oct 31 00:00:00 UTC 2021)
        1635638401, // Sun Oct 31 00:00:01 AZOST 2021 (Sun Oct 31 00:00:01 UTC 2021)
        1635641999, // Sun Oct 31 00:59:59 AZOST 2021 (Sun Oct 31 00:59:59 UTC 2021)
        1635642000, // Sun Oct 31 00:00:00 AZOT 2021 (Sun Oct 31 01:00:00 UTC 2021)
        1635642001, // Sun Oct 31 00:00:01 AZOT 2021 (Sun Oct 31 01:00:01 UTC 2021)
        1635645599, // Sun Oct 31 00:59:59 AZOT 2021
        1635645600, // Sun Oct 31 01:00:00 AZOT 2021
        1635645601, // Sun Oct 31 01:00:01 AZOT 2021
    ],
    'Europe/London' => [
        // LANG=en_US TZ="Europe/London" date --date=@<...>
        // forward:
        1616889599, // Sat Mar 27 23:59:59 GMT 2021
        1616889600, // Sun Mar 28 00:00:00 GMT 2021
        1616889601, // Sun Mar 28 00:00:01 GMT 2021
        1616893199, // Sun Mar 28 00:59:59 GMT 2021 (Sun Mar 28 00:59:59 UTC 2021)
        1616893200, // Sun Mar 28 02:00:00 BST 2021 (Sun Mar 28 01:00:00 UTC 2021)
        1616893201, // Sun Mar 28 02:00:01 BST 2021 (Sun Mar 28 01:00:01 UTC 2021)
        1616896799, // Sun Mar 28 02:59:59 BST 2021 (Sun Mar 28 01:59:59 UTC 2021)
        1616896800, // Sun Mar 28 03:00:00 BST 2021 (Sun Mar 28 02:00:00 UTC 2021)
        1616896801, // Sun Mar 28 03:00:01 BST 2021 (Sun Mar 28 02:00:01 UTC 2021)
        // backward:
        1635638399, // Sun Oct 31 00:59:59 BST 2021
        1635638400, // Sun Oct 31 01:00:00 BST 2021
        1635638401, // Sun Oct 31 01:00:01 BST 2021
        1635641999, // Sun Oct 31 01:59:59 BST 2021 (Sun Oct 31 00:59:59 UTC 2021)
        1635642000, // Sun Oct 31 01:00:00 GMT 2021 (Sun Oct 31 01:00:00 UTC 2021)
        1635642001, // Sun Oct 31 01:00:01 GMT 2021 (Sun Oct 31 01:00:01 UTC 2021)
        1635645599, // Sun Oct 31 01:59:59 GMT 2021 (Sun Oct 31 01:59:59 UTC 2021)
        1635645600, // Sun Oct 31 02:00:00 GMT 2021 (Sun Oct 31 02:00:00 UTC 2021)
        1635645601, // Sun Oct 31 02:00:01 GMT 2021 (Sun Oct 31 02:00:01 UTC 2021)
    ],
    'Europe/Amsterdam' => [
        // LANG=en_US TZ="Europe/Amsterdam" date --date=@<...>
        // forward:
        1616885999, // Sat Mar 27 23:59:59 CET 2021
        1616886000, // Sun Mar 28 00:00:00 CET 2021
        1616886001, // Sun Mar 28 00:00:01 CET 2021
        1616889599, // Sun Mar 28 00:59:59 CET 2021
        1616889600, // Sun Mar 28 01:00:00 CET 2021
        1616889601, // Sun Mar 28 01:00:01 CET 2021
        1616893199, // Sun Mar 28 01:59:59 CET 2021
        1616893200, // Sun Mar 28 03:00:00 CEST 2021
        1616893201, // Sun Mar 28 03:00:01 CEST 2021
        1616896799, // Sun Mar 28 03:59:59 CEST 2021 (Sun Mar 28 01:59:59 UTC 2021)
        1616896800, // Sun Mar 28 04:00:00 CEST 2021 (Sun Mar 28 02:00:00 UTC 2021)
        1616896801, // Sun Mar 28 04:00:01 CEST 2021 (Sun Mar 28 02:00:01 UTC 2021)
        1616900399, // Sun Mar 28 04:59:59 CEST 2021 (Sun Mar 28 02:59:59 UTC 2021)
        1616900400, // Sun Mar 28 05:00:00 CEST 2021 (Sun Mar 28 03:00:00 UTC 2021)
        1616900401, // Sun Mar 28 05:00:01 CEST 2021 (Sun Mar 28 03:00:01 UTC 2021)
        // backward:
        1635631199, // Sat Oct 30 23:59:59 CEST 2021
        1635631200, // Sun Oct 31 00:00:00 CEST 2021
        1635631201, // Sun Oct 31 00:00:01 CEST 2021
        1635638399, // Sun Oct 31 01:59:59 CEST 2021
        1635638400, // Sun Oct 31 02:00:00 CEST 2021
        1635638401, // Sun Oct 31 02:00:01 CEST 2021
        1635641999, // Sun Oct 31 02:59:59 CEST 2021
        1635642000, // Sun Oct 31 02:00:00 CET 2021
        1635642001, // Sun Oct 31 02:00:01 CET 2021
        1635645599, // Sun Oct 31 02:59:59 CET 2021 (Sun Oct 31 01:59:59 UTC 2021)
        1635645600, // Sun Oct 31 03:00:00 CET 2021 (Sun Oct 31 02:00:00 UTC 2021)
        1635645601, // Sun Oct 31 03:00:01 CET 2021 (Sun Oct 31 02:00:01 UTC 2021)
        1635649199, // Sun Oct 31 03:59:59 CET 2021 (Sun Oct 31 02:59:59 UTC 2021)
        1635649200, // Sun Oct 31 04:00:00 CET 2021 (Sun Oct 31 03:00:00 UTC 2021)
        1635649201, // Sun Oct 31 04:00:01 CET 2021 (Sun Oct 31 03:00:01 UTC 2021)
    ],
];
foreach ($timezonesWithTimestamps as $timezone => $timestamps) {
    foreach ($timestamps as $timestamp) {
        $tz = new DateTimeZone($timezone);
        $dt = new DateTime('now', $tz);
        $dt->setTimestamp($timestamp);
        printf("%s %d -> %d %s\n", $timezone, $timestamp, $dt->getTimestamp(), $dt->format(DateTimeInterface::ISO8601));
    }
}
?>
--EXPECT--
America/Los_Angeles 1615687199 -> 1615687199 2021-03-13T17:59:59-0800
America/Los_Angeles 1615687200 -> 1615687200 2021-03-13T18:00:00-0800
America/Los_Angeles 1615687201 -> 1615687201 2021-03-13T18:00:01-0800
America/Los_Angeles 1615690799 -> 1615690799 2021-03-13T18:59:59-0800
America/Los_Angeles 1615690800 -> 1615690800 2021-03-13T19:00:00-0800
America/Los_Angeles 1615690801 -> 1615690801 2021-03-13T19:00:01-0800
America/Los_Angeles 1615708799 -> 1615708799 2021-03-13T23:59:59-0800
America/Los_Angeles 1615708800 -> 1615708800 2021-03-14T00:00:00-0800
America/Los_Angeles 1615708801 -> 1615708801 2021-03-14T00:00:01-0800
America/Los_Angeles 1615712399 -> 1615712399 2021-03-14T00:59:59-0800
America/Los_Angeles 1615712400 -> 1615712400 2021-03-14T01:00:00-0800
America/Los_Angeles 1615712401 -> 1615712401 2021-03-14T01:00:01-0800
America/Los_Angeles 1615715999 -> 1615715999 2021-03-14T01:59:59-0800
America/Los_Angeles 1615716000 -> 1615716000 2021-03-14T03:00:00-0700
America/Los_Angeles 1615716001 -> 1615716001 2021-03-14T03:00:01-0700
America/Los_Angeles 1615719599 -> 1615719599 2021-03-14T03:59:59-0700
America/Los_Angeles 1615719600 -> 1615719600 2021-03-14T04:00:00-0700
America/Los_Angeles 1615719601 -> 1615719601 2021-03-14T04:00:01-0700
America/Los_Angeles 1636246799 -> 1636246799 2021-11-06T17:59:59-0700
America/Los_Angeles 1636246800 -> 1636246800 2021-11-06T18:00:00-0700
America/Los_Angeles 1636246801 -> 1636246801 2021-11-06T18:00:01-0700
America/Los_Angeles 1636250399 -> 1636250399 2021-11-06T18:59:59-0700
America/Los_Angeles 1636250400 -> 1636250400 2021-11-06T19:00:00-0700
America/Los_Angeles 1636250401 -> 1636250401 2021-11-06T19:00:01-0700
America/Los_Angeles 1636268399 -> 1636268399 2021-11-06T23:59:59-0700
America/Los_Angeles 1636268400 -> 1636268400 2021-11-07T00:00:00-0700
America/Los_Angeles 1636268401 -> 1636268401 2021-11-07T00:00:01-0700
America/Los_Angeles 1636271999 -> 1636271999 2021-11-07T00:59:59-0700
America/Los_Angeles 1636272000 -> 1636272000 2021-11-07T01:00:00-0700
America/Los_Angeles 1636272001 -> 1636272001 2021-11-07T01:00:01-0700
America/Los_Angeles 1636275599 -> 1636275599 2021-11-07T01:59:59-0700
America/Los_Angeles 1636275600 -> 1636275600 2021-11-07T01:00:00-0800
America/Los_Angeles 1636275601 -> 1636275601 2021-11-07T01:00:01-0800
America/Los_Angeles 1636279199 -> 1636279199 2021-11-07T01:59:59-0800
America/Los_Angeles 1636279200 -> 1636279200 2021-11-07T02:00:00-0800
America/Los_Angeles 1636279201 -> 1636279201 2021-11-07T02:00:01-0800
Atlantic/Azores 1616889599 -> 1616889599 2021-03-27T22:59:59-0100
Atlantic/Azores 1616889600 -> 1616889600 2021-03-27T23:00:00-0100
Atlantic/Azores 1616889601 -> 1616889601 2021-03-27T23:00:01-0100
Atlantic/Azores 1616893199 -> 1616893199 2021-03-27T23:59:59-0100
Atlantic/Azores 1616893200 -> 1616893200 2021-03-28T01:00:00+0000
Atlantic/Azores 1616893201 -> 1616893201 2021-03-28T01:00:01+0000
Atlantic/Azores 1616896799 -> 1616896799 2021-03-28T01:59:59+0000
Atlantic/Azores 1616896800 -> 1616896800 2021-03-28T02:00:00+0000
Atlantic/Azores 1616896801 -> 1616896801 2021-03-28T02:00:01+0000
Atlantic/Azores 1635638399 -> 1635638399 2021-10-30T23:59:59+0000
Atlantic/Azores 1635638400 -> 1635638400 2021-10-31T00:00:00+0000
Atlantic/Azores 1635638401 -> 1635638401 2021-10-31T00:00:01+0000
Atlantic/Azores 1635641999 -> 1635641999 2021-10-31T00:59:59+0000
Atlantic/Azores 1635642000 -> 1635642000 2021-10-31T00:00:00-0100
Atlantic/Azores 1635642001 -> 1635642001 2021-10-31T00:00:01-0100
Atlantic/Azores 1635645599 -> 1635645599 2021-10-31T00:59:59-0100
Atlantic/Azores 1635645600 -> 1635645600 2021-10-31T01:00:00-0100
Atlantic/Azores 1635645601 -> 1635645601 2021-10-31T01:00:01-0100
Europe/London 1616889599 -> 1616889599 2021-03-27T23:59:59+0000
Europe/London 1616889600 -> 1616889600 2021-03-28T00:00:00+0000
Europe/London 1616889601 -> 1616889601 2021-03-28T00:00:01+0000
Europe/London 1616893199 -> 1616893199 2021-03-28T00:59:59+0000
Europe/London 1616893200 -> 1616893200 2021-03-28T02:00:00+0100
Europe/London 1616893201 -> 1616893201 2021-03-28T02:00:01+0100
Europe/London 1616896799 -> 1616896799 2021-03-28T02:59:59+0100
Europe/London 1616896800 -> 1616896800 2021-03-28T03:00:00+0100
Europe/London 1616896801 -> 1616896801 2021-03-28T03:00:01+0100
Europe/London 1635638399 -> 1635638399 2021-10-31T00:59:59+0100
Europe/London 1635638400 -> 1635638400 2021-10-31T01:00:00+0100
Europe/London 1635638401 -> 1635638401 2021-10-31T01:00:01+0100
Europe/London 1635641999 -> 1635641999 2021-10-31T01:59:59+0100
Europe/London 1635642000 -> 1635642000 2021-10-31T01:00:00+0000
Europe/London 1635642001 -> 1635642001 2021-10-31T01:00:01+0000
Europe/London 1635645599 -> 1635645599 2021-10-31T01:59:59+0000
Europe/London 1635645600 -> 1635645600 2021-10-31T02:00:00+0000
Europe/London 1635645601 -> 1635645601 2021-10-31T02:00:01+0000
Europe/Amsterdam 1616885999 -> 1616885999 2021-03-27T23:59:59+0100
Europe/Amsterdam 1616886000 -> 1616886000 2021-03-28T00:00:00+0100
Europe/Amsterdam 1616886001 -> 1616886001 2021-03-28T00:00:01+0100
Europe/Amsterdam 1616889599 -> 1616889599 2021-03-28T00:59:59+0100
Europe/Amsterdam 1616889600 -> 1616889600 2021-03-28T01:00:00+0100
Europe/Amsterdam 1616889601 -> 1616889601 2021-03-28T01:00:01+0100
Europe/Amsterdam 1616893199 -> 1616893199 2021-03-28T01:59:59+0100
Europe/Amsterdam 1616893200 -> 1616893200 2021-03-28T03:00:00+0200
Europe/Amsterdam 1616893201 -> 1616893201 2021-03-28T03:00:01+0200
Europe/Amsterdam 1616896799 -> 1616896799 2021-03-28T03:59:59+0200
Europe/Amsterdam 1616896800 -> 1616896800 2021-03-28T04:00:00+0200
Europe/Amsterdam 1616896801 -> 1616896801 2021-03-28T04:00:01+0200
Europe/Amsterdam 1616900399 -> 1616900399 2021-03-28T04:59:59+0200
Europe/Amsterdam 1616900400 -> 1616900400 2021-03-28T05:00:00+0200
Europe/Amsterdam 1616900401 -> 1616900401 2021-03-28T05:00:01+0200
Europe/Amsterdam 1635631199 -> 1635631199 2021-10-30T23:59:59+0200
Europe/Amsterdam 1635631200 -> 1635631200 2021-10-31T00:00:00+0200
Europe/Amsterdam 1635631201 -> 1635631201 2021-10-31T00:00:01+0200
Europe/Amsterdam 1635638399 -> 1635638399 2021-10-31T01:59:59+0200
Europe/Amsterdam 1635638400 -> 1635638400 2021-10-31T02:00:00+0200
Europe/Amsterdam 1635638401 -> 1635638401 2021-10-31T02:00:01+0200
Europe/Amsterdam 1635641999 -> 1635641999 2021-10-31T02:59:59+0200
Europe/Amsterdam 1635642000 -> 1635642000 2021-10-31T02:00:00+0100
Europe/Amsterdam 1635642001 -> 1635642001 2021-10-31T02:00:01+0100
Europe/Amsterdam 1635645599 -> 1635645599 2021-10-31T02:59:59+0100
Europe/Amsterdam 1635645600 -> 1635645600 2021-10-31T03:00:00+0100
Europe/Amsterdam 1635645601 -> 1635645601 2021-10-31T03:00:01+0100
Europe/Amsterdam 1635649199 -> 1635649199 2021-10-31T03:59:59+0100
Europe/Amsterdam 1635649200 -> 1635649200 2021-10-31T04:00:00+0100
Europe/Amsterdam 1635649201 -> 1635649201 2021-10-31T04:00:01+0100
