// SPDX-FileCopyrightText: 2023-2025 KUNBUS GmbH
//
// SPDX-License-Identifier: GPL-2.0-or-later

import { useFeatureInstaller } from "../../common/hooks.jsx";

/**
 * Combines app metadata and installation state for a feature into a unified config object.
 *
 * @param {Object} config - Configuration options.
 * @param {string} config.name - Unique name for the app.
 * @param {string} config.displayName - Human-readable name shown in the UI.
 * @param {string[]} config.packageNames - List of packages required for installation.
 * @param {string} config.displayType - One of DISPLAY_TYPES (open/configure/install).
 * @param {Function} config.click - Function called when the app is launched.
 * @returns {Object} - App config with installer state.
 */
export const useAppConfig = ({ name, displayName, packageNames, displayType, click, helpText }) => {
    const installer = useFeatureInstaller(displayName, packageNames);
    return { name, displayName, displayType, click, installer, helpText };
};
