// SPDX-FileCopyrightText: 2023-2025 KUNBUS GmbH
//
// SPDX-License-Identifier: GPL-2.0-or-later

import React from "react";
import { useFeatureList } from "./config/featureList.jsx";
import { useFeatureStates } from "./hooks/useFeatureStates.jsx";
import { AppCard, FeatureGroupCard } from "./revpi-dashboard.components.jsx";
import { Bullseye, Page, Spinner } from "@patternfly/react-core";

import { NotificationProvider } from "../common/hooks.jsx";

export default function Application () {
    const features = useFeatureList();
    const { featureStates, availableFeatures, toggle, isLoading } = useFeatureStates(features);
    if (isLoading) {
        return (
            <Bullseye style={{ height: "100vh" }}>
                <Spinner size='xl' />
            </Bullseye>
        );
    }

    const byId = id => features.find(f => f.id === id);
    const get = ids => ids.map(byId).filter(Boolean);

    const runtime = get(["revpipyload"]);
    const system = get([
        "gui",
        "swapfile",
        "avahi",
        "ntp",
        // "var-log.mount",
        "ssh"
    ]);
    const network = get([
        // "ieee80211",
        "bluetooth",
        "external-antenna"
    ]);

    return (

        <NotificationProvider>
            <Page>
                <div
                    style={{
                        display: "grid",
                        gridTemplateColumns: "1fr 1fr",
                        gridTemplateRows: "auto auto auto",
                        gap: "1rem",
                        padding: "1rem",
                        margin: "0 auto"
                    }}
                >
                    <div style={{ gridColumn: 1, gridRow: 1 }}>
                        <AppCard />
                    </div>

                    <FeatureGroupCard
                        title='Run-time Configuration'
                        features={runtime}
                        featureStates={featureStates}
                        availableFeatures={availableFeatures}
                        toggle={toggle}
                        gridColumn='1'
                        gridRow='2'
                    />

                    <FeatureGroupCard
                        title='Network Settings'
                        features={network}
                        featureStates={featureStates}
                        availableFeatures={availableFeatures}
                        toggle={toggle}
                        gridColumn='1'
                        gridRow='3'
                    />

                    <FeatureGroupCard
                        title='System Configuration'
                        features={system}
                        featureStates={featureStates}
                        availableFeatures={availableFeatures}
                        toggle={toggle}
                        gridColumn='2'
                        gridRow='1/ span 3'
                    />
                </div>
            </Page>
        </NotificationProvider>

    );
}
