// SPDX-FileCopyrightText: 2023-2025 KUNBUS GmbH
//
// SPDX-License-Identifier: GPL-2.0-or-later

import { Card, CardBody, CardTitle, Grid, GridItem, Tooltip } from "@patternfly/react-core";
import React from "react";
import cockpit from "cockpit";
import { ConnectedIcon } from "@patternfly/react-icons";

import { UiCardTitle, UiDivider } from "../../common/ui-components.jsx";
import { WlanCountrySelect } from "../revpi-config.components.jsx";

const _ = cockpit.gettext;

export function NetworkCard ({
    getRevPiSwitch,
    getRevPiToggle
}) {
    const cardTitle = _("WLAN and BT");
    const [isWlanCountrySet, setIsWlanCountrySet] = React.useState(false);
    return (
        <Card isFullHeight name='network'>
            <CardTitle>
                <UiCardTitle>
                    <ConnectedIcon style={{ marginRight: "1rem" }} />
                    {cardTitle}
                </UiCardTitle>
                <UiDivider />
            </CardTitle>
            <CardBody>
                <Grid hasGutter>
                    <GridItem span={12}>
                        {isWlanCountrySet
                            ? (
                                getRevPiSwitch("ieee80211")
                            )
                            : (
                                <Tooltip
                                    content={_("WLAN country code must be set before activating WLAN.")}
                                    position='bottom'
                                >
                                    {getRevPiSwitch("ieee80211", { disabled: !isWlanCountrySet })}
                                </Tooltip>
                            )}
                    </GridItem>
                    <GridItem span={12}>
                        {getRevPiSwitch("bluetooth")}
                    </GridItem>
                    <GridItem span={12}>
                        {getRevPiToggle("external-antenna")}
                    </GridItem>
                    <GridItem span={12}>
                        <WlanCountrySelect
                            setIsWlanCountrySet={setIsWlanCountrySet}
                        />
                    </GridItem>
                </Grid>
            </CardBody>
        </Card>
    );
}
