<!--
SPDX-FileCopyrightText: 2023-2025 KUNBUS GmbH

SPDX-License-Identifier: GPL-2.0-or-later
-->

# Cockpit Revpi Modules

All [Cockpit](https://cockpit-project.org/) modules for RevPi devices.

# Development dependencies

On Debian/Ubuntu:

    $ sudo apt install gettext nodejs npm make

# Getting and building the source

These commands check out the source and build module into the `dist/` directory

```
git clone https://gitlab.com/revolutionpi/cockpit-revpi.git
cd starter-kit
make PACKAGE_NAME=hello-world
```

If you want to build multiple modules, you need to call `make` for each
module.
Every `make` command expects the `PACKAGE_NAME` variable to be provided.

> **Note:** On Unix systems like macOS some Tools must be overwrite with the GNU
> implementation e.g. tar --> gtar.
> If macOS is detected, the script searches for the GNU implementation
> automatically.
> If it cannot be found and error will be thrown.
> To avoid this, install `gawk` and `gtar` and make sure they are in rout $PATH

# Installing

`make install PACKAGE_NAME=hello-world` compiles and installs the package in
`/usr/local/share/cockpit/`. The convenience targets `srpm` and `rpm` build
the source and binary rpms, respectively. Both of these make use of the
`dist` target, which is used to generate the distribution tarball. In
`production` mode, source files are automatically minified and compressed.
Set `NODE_ENV=production` if you want to duplicate this behavior.

For development, you usually want to run your module straight out of the git
tree. To do that, run `make devel-install PACKAGE_NAME=hello-world`, which links
your checkout to the location were cockpit-bridge looks for packages. If you
prefer to do this manually:

```
mkdir -p ~/.local/share/cockpit
ln -s `pwd`/dist ~/.local/share/cockpit/hello-world
```

After changing the code and running `make PACKAGE_NAME=hello-world` again,
reload the Cockpit page in your browser.

You can also use
[watch mode](https://esbuild.github.io/api/#watch) to
automatically update the bundle on every code change with

    $ ./build.js -w hello-world

or

    $ make watch PACKAGE_NAME=hello-world

When developing against a virtual machine, watch mode can also automatically
upload the code changes by setting the `RSYNC` environment variable to the
remote hostname.

    $ RSYNC=c make watch PACKAGE_NAME=hello-world

When developing against a remote host as a normal user, `RSYNC_DEVEL` can be
set to upload code changes to `~/.local/share/cockpit/` instead of
`/usr/local`.

    $ RSYNC_DEVEL=example.com make watch

To "uninstall" the locally installed version, run `make devel-uninstall`, or
remove manually the symlink:

    rm ~/.local/share/cockpit/starter-kit

# Running eslint

Cockpit Revpi uses [ESLint](https://eslint.org/) to automatically check
JavaScript code style in `.js` and `.jsx` files.

eslint is executed by:

    $ npm run eslint:fix

Rules configuration can be found in the `.eslintrc.json` file.

## Running stylelint

Cockpit uses [Stylelint](https://stylelint.io/) to automatically check CSS
code style in `.css` and `scss` files.

styleint is executed by:

    $ npm run stylelint

Violations of some rules can be fixed automatically by:

    $ npm run stylelint:fix

Rules configuration can be found in the `.stylelintrc.json` file.

## Adding translations

To internationalize your plugins, follow these steps:

1) Mark texts fo translation:
    - In .html files this is done by setting translate to true i.e.
      `<div translate> My text to be translated </div>`

    - For .js and .jsx you need to import cockpits gettext and mark strings to
      translate i.e.
       ```
       import cockpit from "cockpit";
       const _ = cockpit.gettext;
       const exampleStringToTranslate = _("I want to be translated")
       ```
      or use variable strings that allow changing the position of specific words within a sentence to accommodate different languages.
      ```
      cockpit.format(_("Translation with $0"), myTextInAVariable)
      ```
    - Text inside .metinfo.xml and manifest.json is added automatically
    - Make sure you wrap your strings with double quotes, as cockpit.gettext
      does not recognize single quotes
2) Generate .pot Files:
    - Run `make pot PACKAGE_NAME=your-plugin-name` to create .pot files in your
      src/$(PACKAGE_NAME)/po folder.
      Replace your-plugin-name with the actual name of your plugin. This command
      generates template files containing the strings to be translated,
      which can be used to create language-specific .po files.
3) Working with .po files
    1) Generate new .po file:
        - Remove the content of the `src/$(PACKAGE_NAME)/po/$(PACKAGE_NAME).pot`
          that was created with the previous command from the beginning of
          the file until the first occurrence of a translation block
          recognized by the presence of a line starting with
           ```
           #: path/to/first/translation
           msgid: "your text"' 
           'msgstr: ""
           ``` 
        - Insert the following lines at the top of your
          `src/$(PACKAGE_NAME)/po/$(PACKAGE_NAME).pot` file:
          ```
          # revpi-config $(MY_LANGUAGE) translations
          #, fuzzy
          msgid ""
          msgstr ""
          "Language: $(MY_LANGUAGE)\n"
          "Content-Type: text/plain; charset=UTF-8\n"
          "Plural-Forms: nplurals=2; plural=n != 1\n"
          ```
        - Replace `$(MY_LANGUAGE)` with your language, like German (de).
        - Save the file as in your `src/$(PACKAGE_NAME)/po` folder as
          `$(MY_LANGUAGE)` .po i.e. de.po
    2) Update existing .po files:
       To update the `.po` files for all supported languages, you can simply use
       the Makefile target `make poupdate`. This target performs the following 
       steps:

        1. It automatically generates a new `.pot` file, which serves as the
           template for translations.
        2. It synchronizes the content of the `.pot` file with all existing
           `.po` files for the supported languages.

       After updating, you can check for any untranslated lines by using the  
       `make pocheck` target. This tool helps identify lines that are yet to be
       translated.

       These commands ensure that your translations remain up-to-date and no
       text is unintentionally left untranslated.
4) Translate Strings:
    - Use tools like poedit to fill the msgstr entries in the .po files. Save
      the translated file with the appropriate
      language code (e.g., de.po for German).

For comprehensive instructions on using the graphical user interface for
translation, consult the Internationalization Guide available at:
https://github.com/cockpit-project/cockpit/blob/main/doc/i18n.md.

## Customize branding

To customize the appearance, you can edit the images and branding.css file
located on your device at the following path:

```/usr/share/cockpit/branding/debian/```

Since this directory is within the system's files, automated deployment through
a makefile or similar methods isn't possible. You can either directly modify
the files in place or make changes locally and then transfer the modified
debian folder to your device manually afterward.

To restore Cockpit's default styles, you can reinstall the Cockpit webserver
using the command

```apt reinstall cockpit-ws```.

# Further reading

*

The [Starter Kit announcement](https://cockpit-project.org/blog/cockpit-starter-kit.html)
blog post explains the rationale for this project.

* [Cockpit Deployment and Developer documentation](https://cockpit-project.org/guide/latest/)
* [Make your project easily discoverable](https://cockpit-project.org/blog/making-a-cockpit-application.html)
