<!--
SPDX-FileCopyrightText: 2025 KUNBUS GmbH

SPDX-License-Identifier: GPL-2.0-or-later
-->

# Firewalld configuration files

## CODESYS Control – Firewalld Service & Profinet EtherType Rules

File: `services/revpi-codesys.xml`

This repository contains a firewalld service definition (`revpi-codesys.xml`) for **CODESYS Control for Linux ARM64 SL**.  
It defines the required TCP/UDP ports for:
- **Gateway communication**
- **OPC UA server**
- **Modbus server**
- **Runtime communication**
- **WebVisu / REST / HTTPS**
- **Profinet UDP traffic**

Additionally, Profinet and related protocols require **EtherType-based** rules (Layer 2).  
These cannot be expressed directly in a firewalld service XML and must be configured using the **direct interface**.

---

### 1. Why EtherType rules are needed

Some industrial protocols operate directly on Ethernet frames, bypassing TCP/UDP entirely.  
For this setup, you may need to allow:

| Protocol       | EtherType | Description                |
|----------------|-----------|----------------------------|
| Profinet RT    | `0x8892`  | Real-time communication    |
| LLDP           | `0x88CC`  | Link Layer Discovery       |
| ARP            | `0x0806`  | Address resolution         |

Firewalld's XML syntax does **not** support EtherType, so these rules must be added separately.

---

### 2. Adding EtherType rules

Run the following commands as **root** to permanently allow the EtherTypes via the `eb` (bridge) family:

```bash
# Profinet RT (0x8892)
firewall-cmd --permanent --direct --add-rule eb filter INPUT 0 -p 0x8892 -j ACCEPT

# LLDP (0x88CC)
firewall-cmd --permanent --direct --add-rule eb filter INPUT 0 -p 0x88cc -j ACCEPT

# ARP (0x0806)
firewall-cmd --permanent --direct --add-rule eb filter INPUT 0 -p 0x0806 -j ACCEPT
´´´

Or remove via:
```bash
# Profinet RT (0x8892)
firewall-cmd --permanent --direct --remove-rule eb filter INPUT 0 -p 0x8892 -j ACCEPT

# LLDP (0x88CC)
firewall-cmd --permanent --direct --remove-rule eb filter INPUT 0 -p 0x88cc -j ACCEPT

# ARP (0x0806)
firewall-cmd --permanent --direct --remove-rule eb filter INPUT 0 -p 0x0806 -j ACCEPT
´´´ 
