import { Role, Selector } from 'testcafe';

export const LoginPage = {
  usernameInput: Selector('#inpLoginEMail'),
  passwordInput: Selector('#inpLoginPW'),
  loginButton: Selector('#buttLogin'),
};

export const StatusPage = {
  appsTab: Selector('#navApps'),
  configTab: Selector('#navConfig'),
  servicesTab: Selector('#navServices'),
  statusTab: Selector('#navStatus'),
};

export const ServicesTabPage = {
  nodeRed: {
    disabledRadioButton: Selector('#confignoderedVal_0'),
    disabledRadioButtonLabel: Selector('[for=confignoderedVal_0]'),
    enabledRadioButton: Selector('#confignoderedVal_1'),
    enabledRadioButtonLabel: Selector('[for=confignoderedVal_1]'),
  },
  saveAllButton: Selector('#buttSaveServices'),
};

export const AppsPage = {
  nodeRedButton: Selector('#buttNodered'),
  pictoryButton: Selector('#buttPiCtory'),
};

export const NodeRedPage = {
  editor: Selector('#red-ui-editor'),
};

export const getAdminUser = (loginUrl: string, password: string) =>
  Role(loginUrl, async (t) => {
    await t
      .typeText(LoginPage.usernameInput, 'admin')
      .typeText(LoginPage.passwordInput, password)
      .click(LoginPage.loginButton);
  });
