const isDebugSet = process.env.DEBUG_JS !== undefined;
const targetUrl = process.env.TESTCAFE_TARGET_URL || "https://0.0.0.0:41443";
const targetPassword = process.env.TESTCAFE_TARGET_PASSWORD || "raspberry";

module.exports = {
  userVariables: {
    targetUrl,
    targetPassword,
  },
  src: "tests/**/*.ts",
  baseUrl: targetUrl,
  skipJsErrors: true,
  disablePageCaching: true,
  cache: false,
  testExecutionTimeout: 600000,
  // Abort testing after first error as the current state of the page is now undefined and follow-up errors may occur
  stopOnFirstFail: true,
  debugOnFail:isDebugSet,
  // disable native automation because this does not support
  // opening new browser windows which is needed for node-red
  //disableNativeAutomation: false,
  // default - can be overwritten with CLI parameters on start
  browsers: ["chromium:headless --ignore-certificate-errors"],
};
