#!/bin/bash
set -e

######
# Starts webstatus with the current local webstatus sources
# and runs the current local e2e tests against it
######

ROOT_DIR=$(git rev-parse --show-toplevel)
WEBSTATUS_DIR=$(realpath "$ROOT_DIR"/src/revpi)
TEST_DIR=$(realpath "$ROOT_DIR"/test/testcafe)

echo "Starting webstatus-testcafe container ..."
echo "Mounting webstatus from $WEBSTATUS_DIR"
echo "Mounting tests from $TEST_DIR"

docker run \
	-it \
	--rm \
	-p 42080:80 \
	-p 41080:41080 \
	-p 42443:443 \
	-p 41443:41443 \
	-v "$WEBSTATUS_DIR":/var/www/revpi \
	-v "$TEST_DIR":/opt/testcafe/ \
	-v /var/www/revpi/data \
	--name webstatus-testcafe \
	registry.gitlab.com/revolutionpi/webstatus/webstatus-testcafe-bullseye:arm64-latest \
	./docker-entrypoint.sh
