#!/bin/bash
set -e

IMAGE="$1"
DOCKERFILE="$2"
BUILD_CONTEXT="$3"

if [ -z "$IMAGE" ]; then
	echo "Docker Image name must be provided as first script argument"
	exit 1
fi

if [ -z "$DOCKERFILE" ]; then
	echo "Path to Dockerfile name must be provided as second script argument"
	exit 1
fi


if [ -z "$BUILD_CONTEXT" ]; then
	BUILD_CONTEXT=$(dirname "$DOCKERFILE")
fi

if [ ! "$CI_DEPLOY_USER" ]; then
	echo "Gitlab deploy user not set"
	exit 1
fi

if [ ! "$CI_DEPLOY_PASSWORD" ]; then
	echo "Gitlab deploy password not set"
	exit 1
fi

CI_REGISTRY="${CI_REGISTRY:-registry.gitlab.com}"
DEBIAN_RELEASE="${DEBIAN_RELEASE:-bullseye}"
SRC_ARCH="${SRC_ARCH:-arm64}"

TARGET_HOST_ARCH="${TARGET_HOST_ARCH:-arm64}"
TARGET_IMAGE="$CI_REGISTRY/revolutionpi/webstatus/webstatus-$IMAGE-$DEBIAN_RELEASE"
TARGET_IMAGE_REF="$TARGET_IMAGE:$TARGET_HOST_ARCH-latest"

COMMIT_SHA=$(git rev-parse --short HEAD)

echo "Building image: $TARGET_IMAGE_REF for $TARGET_HOST_ARCH"
echo "Using registry build cache"

CACHE_FROM="type=registry,ref=$TARGET_IMAGE:buildcache"
CACHE_TO="type=registry,ref=$TARGET_IMAGE:buildcache"

docker login -u "$CI_DEPLOY_USER" -p "$CI_DEPLOY_PASSWORD" "$CI_REGISTRY"

if ! docker buildx ls > /dev/null 2>&1; then
	echo "No current builder instance found. Creating new one ..."
	docker buildx create --use
fi

docker buildx build \
	--platform "linux/${TARGET_HOST_ARCH}" \
	--cache-from "$CACHE_FROM" \
	--cache-to "$CACHE_TO" \
	--push \
	--tag "$TARGET_IMAGE_REF" \
	--provenance=false \
	--build-arg SRC_ARCH="$SRC_ARCH" \
	--build-arg ARCH="$TARGET_HOST_ARCH" \
	--build-arg DEBIAN_RELEASE="$DEBIAN_RELEASE" \
	--build-arg COMMIT_SHA="$COMMIT_SHA" \
	--file "$DOCKERFILE" \
	"$BUILD_CONTEXT"
