<?php

// prevent direct execution!
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    exit();
}

session_start();

define ("CONST_DEBUG", false);

//error_reporting(0);

// Constants
// ERR_CODES --------------------
// SYSTEM Codes
define("CONST_ERR_SYSTEM", 9999);
define("CONST_ERR_SYSTEM_NO_WRITE_PERMISSION", 9998);
define("CONST_OK", 0);
// USER Codes
define("CONST_ERR_USER_NOT_REGISTERED", 102);
define("CONST_ERR_USER_PASSWORD_INVALID", 130);
define("CONST_ERR_NO_FREE_SPACE", 205);
// MISC Codes
define("CONST_TEST", 12345);

$returnObject = new stdClass();
$returnObject->status = 'SUCCESS';
$returnObject->errType = '0';
$returnObject->message = '';
$returnObject->data = '';

$jsonRet = "";
$json_params = file_get_contents('php://input');
$decoded_params = json_decode($json_params);

$piSerial = "/usr/sbin/piSerial";
if (!file_exists($piSerial)) {
	$piSerial = "/usr/bin/piSerial";
	if (!file_exists($piSerial)) {
		$piSerial = "/opt/KUNBUS/piSerial";
	}
}
// use sudo for ALL piSerial calls since RevPi FLAT's TPM chip requires sudo even for /usr/bin/piSerial calls ...
$piSerial = "/usr/bin/sudo ".$piSerial;

$vcgencmd = "/usr/bin/sudo /usr/bin/vcgencmd";

// Process request according to mode
if (isset($decoded_params->mode) == false || $decoded_params->mode == "") {
		$returnObject->status = '';
} else {

	if ($decoded_params->mode == "CHECK_TOKEN") {
		$ret = CheckToken();
		if($ret == true) {
			$returnObject->status = 'SUCCESS';

		} else {
			$returnObject->status = 'ERROR';
		}
	}

	elseif ($decoded_params->mode == "LOGIN") {
		$ret = Login($decoded_params->username, $decoded_params->hashcode, "");
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->message = $ret->message;
			$returnObject->data = $ret->data;
		} else {
			$returnObject->status = $ret->status;
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "LOGOUT") {
		$ret = Logout();
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->message = $ret->message;
			$returnObject->data = $ret->data;
		} else {
			$returnObject->status = $ret->status;
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "CHANGE_PASSWORD") {
		$ret = ChangePassword($decoded_params->username, $decoded_params->hashcode, $decoded_params->newHashcode, $decoded_params->removeResetPW);
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->message = $ret->message;
		} else {
			$returnObject->status = $ret->status;
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "RESET_PASSWORD") {
		$ret = ResetPassword($decoded_params->username);
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->message = $ret->message;
		} else {
			$returnObject->status = $ret->status;
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "GET_DEVICEDATA") {
		$ret = GetDeviceData($decoded_params->replPattern);
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->data = $ret->data;
		} else {
			$returnObject->status = $ret->status;
			$returnObject->message = $ret->message;
		}
	}

	// For the next functions the user must be signed in
	elseif(CheckToken() === false && !($decoded_params->mode == "GET_USERDATA" && $decoded_params->replPattern == "##REMOVE_RESET_PW##")) {
		$returnObject->status = 'ERROR';
		$returnObject->message = 'unable to show data - user not logged in!';
	}

	elseif ($decoded_params->mode == "GET_USERDATA") {
		$ret = GetUserData($decoded_params->username, $decoded_params->replPattern);
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->data = $ret->data;
		} else {
			$returnObject->status = $ret->status;
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "READ_STATUS") {
		$ret = ReadStatus();
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->data = $ret->data;
		} else {
			$returnObject->status = 'ERROR';
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "READ_CONFIG") {
		$ret = ReadConfig();
		if($ret->status == "OK") {
			$returnObject->status = 'SUCCESS';
			$returnObject->data = $ret->data;
			$returnObject->message = $ret->message;
		} else {
			$returnObject->status = 'ERROR';
			$returnObject->message = $ret->message;
		}
	}

	elseif ($decoded_params->mode == "SAVE_CONFIG") {
		// allow only if user is logged in !
		if(CheckSession($decoded_params->hashcode) == "OK") {
			$ret = SaveConfig($decoded_params->arrSaveConfig);
			if($ret->status == "OK") {
				$returnObject->status = 'SUCCESS';
				$returnObject->data = $ret->data;
				$returnObject->message = $ret->message;
			} else {
				$returnObject->status = $ret->status;
				$returnObject->message = $ret->message;
			}
		} else {
			$returnObject->status = 'ERROR';
			$returnObject->message = 'unable to save data - user not logged in!';
		}
	}
}

// we don't return anything if no mode is active!
if ($returnObject->status == '') {
	echo "";
} else {
	echo(json_encode($returnObject));
}

die;

function CheckSession($sessionId) {
	$ret = true;
	if ($_SESSION['RevPiSessionId'] != $sessionId) {
		$ret = false;
	}

	return $ret;
}

function CheckToken() {
	$ret = false;
	$retGDD = GetDeviceData('##UUID##');
	$sessionId = $_COOKIE['KUNBUS_RevPiSessionId_'.$retGDD->data->replPattern];
	if (isset($sessionId)) {
		$ret = IsJwtValid($sessionId,$_SESSION['JWT_Secret']);
	}

	return $ret;
}

function Login($username, $hashcode, $mode) {
	global $piSerial;

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();

	$retGDD = GetDeviceData('##UUID##');
	$returnObject->data->uuid = $retGDD->data->replPattern;

	// IMPORTANT: ownPW must be set when using DEBUG mode!
	if (CONST_DEBUG == false) {
		exec($piSerial.' -p',$defaultPW,$retval);
		exec('hostname',$hostname,$retval);
		$returnObject->data->hostname = $hostname[0];
	} else {
		$returnObject->data->hostname = "12345ABCDE";
	}

	if(2 == CheckFreeSpace()) {
		$returnObject->status = CONST_ERR_NO_FREE_SPACE;
		return $returnObject;
	}

	$json_logindata = file_get_contents('../data/login.json');
	$objLoginData = json_decode($json_logindata);
	if ($objLoginData->username == $username) {
		if ( 	(($objLoginData->ownPW === "") && (md5($defaultPW[0]) === $hashcode) ) ||
				(($objLoginData->ownPW != "") && ($objLoginData->ownPW === $hashcode))
			) {


			$objLoginData->lastLogin = date('Y-m-d H:i:s');
			// save to temp and rename to prevent corruption of file in case of low disk space
			file_put_contents('../data/_tmpSave', json_encode($objLoginData));
			rename ( '../data/_tmpSave' , "../data/login.json");

			$headers = array('alg'=>'HS256','typ'=>'JWT');
			$payload = array('username'=>$username, 'hashcode'=>$hashcode, 'exp'=>(time() + 60));

			// Shared secret key used for generating token
			$_SESSION['JWT_Secret'] = random_bytes(32);
			$returnObject->data->sessionId = GenerateJwt($headers, $payload, $_SESSION['JWT_Secret']);
			$_SESSION['RevPiSessionId'] = $returnObject->data->sessionId;


			$returnObject->status = "OK";
		} else {
			$returnObject->status = CONST_ERR_USER_PASSWORD_INVALID;
		}
	} else {
		$returnObject->status = CONST_ERR_USER_PASSWORD_INVALID;
	}

	return $returnObject;
}

function Logout() {
	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();

	session_destroy();

	return $returnObject;
}

function ChangePassword($username,$hashcode,$newHash,$removeResetPW) {
	global $piSerial;

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();

	if(2 == CheckFreeSpace()) {
		$returnObject->status = CONST_ERR_NO_FREE_SPACE;
		return $returnObject;
	}

	exec($piSerial.' -p',$defaultPW,$retval);
	$json_logindata = file_get_contents('../data/login.json');
	$objLoginData = json_decode($json_logindata);

	if ($objLoginData->username === $username) {
		if ($objLoginData->ownPW === "") {
			if (md5($defaultPW[0]) === $hashcode) {
				$objLoginData->ownPW = $newHash;
				$objLoginData->removeResetPW = $removeResetPW;
				// save to temp and rename to prevent corruption of file in case of low disk space
				if (file_put_contents('../data/_tmpSave', json_encode($objLoginData)) == false) {
					$returnObject->status = CONST_ERR_SYSTEM_NO_WRITE_PERMISSION;
				} else {
					rename ( '../data/_tmpSave' , "../data/login.json");
					$returnObject->status = "OK";
				}
			} else {
				$returnObject->status = CONST_ERR_USER_PASSWORD_INVALID;
			}
		} else {
			if ($objLoginData->ownPW === $hashcode) {
				$objLoginData->ownPW = $newHash;
				$objLoginData->removeResetPW = $removeResetPW;
				// save to temp and rename to prevent corruption of file in case of low disk space
				file_put_contents('../data/_tmpSave', json_encode($objLoginData));
				rename ( '../data/_tmpSave' , "../data/login.json");
				$returnObject->status = "OK";
			} else {
				$returnObject->status = CONST_ERR_USER_PASSWORD_INVALID;
			}
		}
	} else {
		$returnObject->status = CONST_ERR_USER_PASSWORD_INVALID;
	}

	return $returnObject;
}

function ResetPassword($username) {

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$json_logindata = file_get_contents('../data/login.json');
	$objLoginData = json_decode($json_logindata);

	if(2 == CheckFreeSpace()) {
		$returnObject->status = CONST_ERR_NO_FREE_SPACE;
		return $returnObject;
	}

	// reset only if option has not been disabled!
	if (!isset($objLoginData->removeResetPW) || ($objLoginData->removeResetPW == false)) {
		// save to temp and rename to prevent corruption of file in case of low disk space
		file_put_contents('../data/_tmpSave', '{"username":"admin","ownPW":"","lastLogin":""}');
		rename ( '../data/_tmpSave' , "../data/login.json");
	} else {
		$returnObject->status = 'ERROR';
		$returnObject->message = 'Function disabled by user in change password dialog';
	}
	return $returnObject;
}

function ReadStatus() {
	global $piSerial;
	global $vcgencmd;

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();

	if (CONST_DEBUG == true) {
		$returnObject->data->status00 = "DEBUG Status 00";
		$returnObject->data->status01 = "DEBUG Status 01";
		$returnObject->data->status02 = "DEBUG Status 02";
		$returnObject->data->status03 = "DEBUG Status 03";
		$returnObject->data->status04 = "DEBUG Status 04";
		$returnObject->data->status05 = "DEBUG Status 05";
		$returnObject->data->status06 = "DEBUG Status 06";
		$returnObject->data->status07 = "DEBUG Status 07";
	} else {

		exec($piSerial.' -s', $output, $retval);
		$returnObject->data->status00 = $output[0];
		unset($output);

		exec('hostname',$output,$retval);
		$hostname = strtolower($output[0]);
		$returnObject->data->status01 = $hostname;
		unset($output);

		exec('/usr/bin/uptime', $output, $retval);
		$returnObject->data->status02 = $output[0];
		unset($output);

		exec($vcgencmd.' measure_temp', $output, $retval);
		$list = explode("=", $output[0]);
		$returnObject->data->status03 = $list[1];
		unset($output);

		exec($vcgencmd.' measure_volts core', $output, $retval);
		$list = explode("=", $output[0]);
		$returnObject->data->status04 = $list[1];
		unset($output);

		$returnObject->data->status05 = GetDiskspaceReadable(disk_free_space(__DIR__));

		$tz_info = file_get_contents('/etc/timezone');
		exec('/usr/bin/date "+%F %T"',$output,$retval);
		$returnObject->data->status06 = $output[0]." (Timezone: ".trim($tz_info).")";
		unset($output);

		$returnObject->data->status07 = json_encode(get_ips());
	}

	return $returnObject;
}

function ReadConfig() {

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = array();

	// read configservices data
	$json_configServicesData = file_get_contents('../configServices.json');
	$objConfigServicesData = json_decode($json_configServicesData);

	exec('/usr/bin/sudo /usr/bin/revpi-config available downclock-cpu', $output, $retval);
	if ($output[0] == 1) {
		unset($output);
		exec('/usr/bin/sudo /usr/bin/revpi-config status downclock-cpu', $output, $retval);
		// status call gives 2 return values in $output[0], separated by blank
		$rets = explode(" ", trim($output[0]));
		$returnObject->data["configdownclock-cpu"] = $rets[1];
		$returnObject->data["configdownclock-cpupar00"] = $rets[0];
	} else {
		$returnObject->data["configdownclock-cpu"] = "";
		$returnObject->data["configdownclock-cpupar00"] = "";
	}

	unset($output); // IMPORTANT: MUST unset $output here since $output[0] has been filled by previous exec call

	$allConfig = "";
	foreach($objConfigServicesData->data as $entry) {
		if (($entry->active == true) && (($entry->type == 'config') || ($entry->type == 'service'))) {
			$allConfig = $allConfig . $entry->id . " ";
		}
	}

	exec('/usr/bin/sudo /usr/bin/revpi-config availstat ' . $allConfig, $output, $retval);

	$rets = explode(" ", trim($output[0]));
	$i = 0;
	foreach($objConfigServicesData->data as $entry) {
		if (($entry->active == true) && (($entry->type == 'config') || ($entry->type == 'service'))) {
			// IMPORTANT: jQuery can not handle IDs which contain '.' - replace it with '--'
			$returnObject->data["config" . str_replace(".","--",$entry->id)] = $rets[$i];
			$i++;
		}
	}

	return $returnObject;
}

function SaveConfig($arrSaveConfig) {
	define("CONST_MIN_CPUSPEED", 300);
	define("CONST_MAX_CPUSPEED", 1200);

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();

	$saveValdownclockcpu = -1;
	$saveValdownclockcpuPar00 = -1;

	$pattern='/[^A-Za-z0-9\-\.]/';
	foreach($arrSaveConfig as $key => $value) {
		$hlpKey = str_replace("--",".",$key);

		if(preg_match($pattern, $hlpKey) !== 0 || preg_match($pattern, $value) !== 0){
			$returnObject->status = 'ERROR';
			$returnObject->message = 'Malformed config object';
			return $returnObject;
		}
	}

	foreach($arrSaveConfig as $key => $value) {
		$hlpKey = str_replace("--",".",$key);

		if($hlpKey == 'downclock-cpu') {
			$saveValdownclockcpu = $value;
		}
		if($hlpKey == 'downclock-cpuPar00') {
			$saveValdownclockcpuPar00 = $value;
		}

		// if both downclock-cpu values have been filled, process this call
		if ($saveValdownclockcpu != -1 && $saveValdownclockcpuPar00 != -1) {
			if ($saveValdownclockcpu == 0 || ((escapeshellarg($saveValdownclockcpuPar00) >= CONST_MIN_CPUSPEED) || (escapeshellarg($saveValdownclockcpuPar00) <= CONST_MAX_CPUSPEED))) {
				$returnObject->message = '/usr/bin/sudo /usr/bin/revpi-config ' .($saveValdownclockcpu == 0 ? 'disable':'enable'). ' downclock-cpu ' . ($saveValdownclockcpu == 0 ? "" : escapeshellarg($saveValdownclockcpuPar00));
				exec('/usr/bin/sudo /usr/bin/revpi-config ' .($saveValdownclockcpu == 0 ? 'disable':'enable'). ' downclock-cpu ' . ($saveValdownclockcpu == 0 ? "" : escapeshellarg($saveValdownclockcpuPar00)), $output, $retval);
			}
			// reset
			$saveValdownclockcpu = -1;
			$saveValdownclockcpuPar00 = -1;
		} else {
			// process all normal generic parameters
			exec('/usr/bin/sudo /usr/bin/revpi-config ' .($value == 0 ? 'disable':'enable'). ' ' .escapeshellarg($hlpKey), $output, $retval);
		}

	}

	return $returnObject;
}

function GetUserData($username,$replPattern) {

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();
	$returnObject->data->lastLogin = '';

	$json_logindata = file_get_contents('../data/login.json');
	$objLoginData = json_decode($json_logindata);
	if (CheckToken() == true) {
		$returnObject->data->lastLogin = $objLoginData->lastLogin;
		// a user with a valid session must be able to reset the password to default
		$returnObject->data->removeResetPW = false;
	} else {
		// certain replPatterns need no $username!
		//
		if (trim($replPattern) == "##REMOVE_RESET_PW##") {
			if (isset($objLoginData->removeResetPW)) {
				$returnObject->data->removeResetPW = $objLoginData->removeResetPW;
			} else {
				$returnObject->data->removeResetPW = false;
			}
		} else {
			$returnObject->status = CONST_ERR_USER_PASSWORD_INVALID;
		}
	}

	return $returnObject;
}

function GetDeviceData($replPattern) {

	$returnObject = new stdClass();
	$returnObject->status = 'OK';
	$returnObject->message = '';
	$returnObject->data = new stdClass();

	$hlpRepl = $replPattern;

	if (CONST_DEBUG == false) {
		exec('hostname',$hostname,$retval);
		$hlpRepl = str_replace("##HOSTNAME##", $hostname[0], $hlpRepl);
	} else {
		$hlpRepl = str_replace("##HOSTNAME##","12345ABCDE", $hlpRepl);
	}

	// UUID can be used for cookie management, it must contain valid characters to use as keys or urls.
	$hlpRepl = str_replace("##UUID##", md5(session_id()), $hlpRepl);

	$returnObject->data->replPattern = $hlpRepl;
	return $returnObject;
}

function WriteLog($logtext) {
	file_put_contents('phplog_'.date("j.n.Y").'.txt', $logtext.PHP_EOL, FILE_APPEND);
}

function GetDiskspaceReadable($Bytes)
{
  $Type=array("", "kilo", "mega", "giga", "tera", "peta", "exa", "zetta", "yotta");
  $Index=0;
  while($Bytes>=1024)
  {
    $Bytes/=1024;
    $Index++;
  }
  return("".$Bytes." ".$Type[$Index]."bytes");
}

// Generate a JSON Web Token
function GenerateJwt($headers, $payload, $secret) {
	$headers_encoded = Base64UrlEncode(json_encode($headers));

	$payload_encoded = Base64UrlEncode(json_encode($payload));

	$signature = hash_hmac('SHA256', "$headers_encoded.$payload_encoded", $secret, true);
	$signature_encoded = Base64UrlEncode($signature);

	$jwt = "$headers_encoded.$payload_encoded.$signature_encoded";

	return $jwt;
}

function Base64UrlEncode($str) {
    return rtrim(strtr(base64_encode($str), '+/', '-_'), '=');
}

function IsJwtValid($jwt, $secret) {
	// split the jwt
	$tokenParts = explode('.', $jwt);
	$header = base64_decode($tokenParts[0]);
	$payload = base64_decode($tokenParts[1]);
	$signature_provided = $tokenParts[2];

	// check the expiration time - note this will cause an error if there is no 'exp' claim in the jwt
	$expiration = json_decode($payload)->exp;
	//IMPORTANT: 	KUNBUS currently does not check for expiration of JWT Cookie - session expiration is handled differently!
	// 				ACTIVATE THIS TO USE JWT EXPIRATION HANDLING
	$is_token_expired = FALSE; //($expiration - time()) < 0;

	// build a signature based on the header and payload using the secret
	$base64_url_header = Base64UrlEncode($header);
	$base64_url_payload = Base64UrlEncode($payload);
	$signature = hash_hmac('SHA256', $base64_url_header . "." . $base64_url_payload, $secret, true);
	$base64_url_signature = Base64UrlEncode($signature);

	// verify it matches the signature provided in the jwt
	$is_signature_valid = ($base64_url_signature === $signature_provided);

	if ($is_token_expired || !$is_signature_valid) {
		return FALSE;
	} else {
		return TRUE;
	}
}

function CheckFreeSpace() {

	$df = disk_free_space(__DIR__);

	if ($df < 2*1024*1024) {
		return 2;
	}
	if ($df < 200*1024*1024) {
		return 1;
	}
	return 0;
}

function get_ips() {
	# get all interfaces with associated ips
	$interfaces = net_get_interfaces();

	# keep only customer facing interfaces on RevPi (ethernet and wireless)
	$interfaces = array_filter($interfaces, function($interface) {
		return $interface == "eth0" || $interface == "eth1" || $interface == "wlan0";
	}, ARRAY_FILTER_USE_KEY);

	$interface_ips = array();
	foreach($interfaces as $name => $data) {
		# sort ips by family (IPv4, IPv6)
		usort($data["unicast"], function($a, $b) {
			if ($a["family"] == $b["family"]) {
				return 0;
			}
			return ($a["family"] < $b["family"]) ? -1 : 1;
		});

		foreach($data["unicast"] as $ip) {
			# skip entries without address
			if(!array_key_exists("address", $ip)) {
				continue;
			}

			$interface_ips[$name][] = $ip["address"];
		}
	}

	return $interface_ips;
}
?>
