var swtDebug = false;
var currentLang = "en";
var cookieExpireMinutes = 30;

var mapDeviceStatus = [
	[0,"CREATED"],
	[1,"REGISTERED"],
	[2,"DISABLED"]
];

var configData = "";
var userData = "";
var configServicesData = "";
var saveUUID = "";

$(function() {
	// show please wait when clicking on tabs (especially loading config can take a couple of seconds ...)
	// IMPORTANT: this only works in Firefox since IE and Chrome only refresh DOM after ajax call has finished!
	$(document).ajaxStart(function() {
		$( "#pleaseWait" ).show();
	}).ajaxStop(function() {
		$( "#pleaseWait" ).hide();
	});

	// read config file
	configData =  AjaxGetJSON("config.json", "OBJ");

	saveUUID = checkSession();
	if (saveUUID == "") {
		window.location.href = "index.html";
		return;
	}

	// refresh login cookies on load
	refreshLoginCookies(cookieExpireMinutes, saveUUID);

	$("#currentDateTime").html(getDateTime("##DD##.##MM##.##YYYY## ##HH##:##NN##:##SS##"));
	$("#lblVersion").html(configData.version);
	$("#lblCYear").html(configData.c_year);

	// create full paths
	hlpPathNodered = "https://" + window.location.hostname + configData.paths.nodered;
	hlpPathNoderedApi = "https://" + window.location.hostname + configData.paths.nodered_api;

	// generate generic table rows
	configServicesData = AjaxGetJSON("configServices.json", "OBJ");

	var hlpHTML = "";
	var rowIdent = "";
	var tblIdent = "";
	$(configServicesData.data).each(function (cnt,entry) {
		// only add active entries
		if ((entry.active == true) && ((entry.type == 'config') || (entry.type == 'service'))) {
			entry.id = entry.id.replace(/\./g,"--"); // jQuery can't handle IDs with '.';
			// could be faster with cloning; but cloning has problems with nested tables
			if (entry.type == 'config') {
				rowIdent = "CONFIG";
				tblIdent = "Config";
			} else if (entry.type == 'service') {
				hlpHTML = $('#TMPL_ROW_SERVICES').html();
				rowIdent = "SERVICES";
				tblIdent = "Services";
			} else {
				alert("ERR: Invalid data.type in configServices.json! Execution aborted!");
			}
			hlpHTML = $('#TMPL_ROW_' + rowIdent).html();
			hlpHTML = hlpHTML.replace('<tbody>','');
			hlpHTML = hlpHTML.replace('</tbody>','');
			hlpHTML = hlpHTML.replace(/##ID##/g,entry.id);
			$('#tbl' + tblIdent + ' tbody').html($('#tbl' + tblIdent + ' tbody').html() + hlpHTML);
			$('#trConfig' + entry.id).html($('#trConfig' + entry.id).html().replace('##SCREEN_TITLE##',entry.title));
			$('#trConfig' + entry.id).html($('#trConfig' + entry.id).html().replace('##HTML_TITLE##',entry.HTMLtitle));
			$('#trConfig' + entry.id).html($('#trConfig' + entry.id).html().replace('##OPTION_1##',entry.option_1));
			$('#trConfig' + entry.id).html($('#trConfig' + entry.id).html().replace('##OPTION_0##',entry.option_0));
			$('#config' + entry.id + 'Info').html(entry.info);
			$('#config' + entry.id + 'Info').addClass(entry.infoClass);
			$('#trConfig' + entry.id).show();
		}
	});

	// show / hide on start
	$("#panelDevMaint").show();
	$("#panelDevMaintMsgHeader").hide();

	// check for -PiCtory- package installed
	if (fileExists("../pictory/config.json") == false) {
		$("#buttPiCtory").hide();
		$("#apps00Info").show();
	} else {
		$("#buttPiCtory").show();
		$("#apps00Info").hide();
	}

	// load data

	// get user data
	userData = ajaxGetUserData(Cookies.get('KUNBUS_RevPiUser_' + saveUUID),"");

	// fill into HTML
	fillUser();
	fillStatus();
	//fillConfig(""); we don't need this here since on start the selecting of default tab 'tabApps' already reads config data

	// select default tab
	if ($.urlParam('tab') == 'status') {
		selectTab("tabStatus");
	} else if ($.urlParam('tab') == 'apps') {
		selectTab("tabApps");
	} else if ($.urlParam('tab') == 'config') {
		selectTab("tabConfig");
	} else if ($.urlParam('tab') == 'services') {
		selectTab("tabServices");
	} else {
		selectTab("tabApps"); // default tab if not set by url-param
	}

	$("#buttLogout").on('click', function(event) {
		event.preventDefault();
		Cookies.remove('KUNBUS_RevPiUser_' + saveUUID);
		Cookies.remove('KUNBUS_RevPiSessionId_' + saveUUID);

		retAjax = ajaxLogout();
		if (retAjax.status == "SUCCESS") {
			window.location.href = "index.html";
		}
	});

	$("#buttResetDriver").on('click', function(event) {
		event.preventDefault();
		if (confirm("Please confirm!") == true) {
				AjaxResetDriver(saveUUID);
		}
	});

	// Config Buttons
	$("#buttSaveConfig, #buttSaveServices").on('click', function(event) {
		event.preventDefault();

		var objSaveConfig = new Object;

		// saving also refreshes login cookie!
		refreshLoginCookies(cookieExpireMinutes, saveUUID);

		if (getCountChangedState() == 0) {
			alert("no changes - nothing to save ...");
			return;
		}

		var retAjax = "";
		if (($(this).attr('id') == "buttSaveConfig") || ($(this).attr('id') == "buttSaveServices")) {
			$(configServicesData.data).each(function (cnt,entry) {
				if (entry.active == true) {
					if (entry.id == "downclock-cpu") {
						if (getChangedState("config" + entry.id) != "") {
							objSaveConfig[entry.id] = getChangedState("config" + entry.id);
							objSaveConfig["downclock-cpuPar00"] = $("#configdownclock-cpuValPar00").val();
						}
					} else {
						if (($("#trConfig" + entry.id).is(":visible")) && (getChangedState("config" + entry.id) != "")) {
							objSaveConfig[entry.id] = getChangedState("config" + entry.id);
						}
					}

				}
			});
		}

		retAjax = ajaxSaveConfig(objSaveConfig, Cookies.get('KUNBUS_RevPiSessionId_' + saveUUID));
		if (retAjax.status == "SUCCESS") {
			fillConfig("SHOW_SAVED"); // read config again to reflect actual state after save!
			$("#panelDevMaintMsgHeader").html("Settings have been saved ...");
			$("#panelDevMaintMsgHeader").show();
		}
		else {
			alert("Unable to save config data - maybe session has expired!");
		}
	});

	// changed indicator for radio buttons
	var hlpSelString = "";
	$(configServicesData.data).each(function (cnt,entry) {
		if (entry.active == true) {
			hlpSelString = hlpSelString + "[name^='config" + entry.id + "'],";
		}
	});
	hlpSelString = killLastDelimiter(hlpSelString,",");

	$(hlpSelString).on('change', function() {
		var hlpRadioName = $(this).attr('id').replace('_0','').replace('_1','');
		var hlpOldId = $(this).attr('id').replace('Val','OldVal');
		hlpOldId = hlpOldId.replace('_0','').replace('_1','');
		var hlpState = $(this).attr('id').replace('Val','State');
		hlpState = hlpState.replace('_0','').replace('_1','');
		if ($("input[name='" + hlpRadioName + "']:checked").val() != parseInt($("#"+hlpOldId).val())) {
			$("#" + hlpState).html('changed');
		} else {
			$("#" + hlpState).html('');
		}
	});

	//selecting CPU rate
	$("#configdownclock-cpuValPar00").on('change', function() {
		// setting clock to default value of 1200 disables downclocking
		if ($("#configdownclock-cpuValPar00").val() == "1200") {
			$("#configdownclock-cpuVal_1").prop('checked',false);
			$("#configdownclock-cpuVal_0").prop('checked',true);
		} else {
			$("#configdownclock-cpuVal_1").prop('checked',true);
			$("#configdownclock-cpuVal_0").prop('checked',false);
		}

		if ($("#configdownclock-cpuValPar00").val() != parseInt($("#configdownclock-cpuPar00OldVal").val())) {
			$("#configdownclock-cpuPar00State").html('changed');
		} else {
			$("#configdownclock-cpuPar00State").html('');
		}
	});

	$("#buttPiCtory").on('click', function(event) {
		event.preventDefault();
		openNewUrl(configData.paths.pictory.replace("##UUID##",saveUUID));
	});

	$("#buttNodered").on('click', function(event) {
		event.preventDefault();

		// IMPORTANT
		// Node-RED service takes a couple of seconds to start; if user starts service
		// in 'Services' tab and clicks the START button in 'Apps' tab to early, he may
		// get an empty error page since Node-RED is not yet listening on port 1880
		// this check prevents this problem and offers the user a retry ...
		$.ajax({
			url: hlpPathNoderedApi,
			type: "GET",
			dataType: "json",
			timeout: 10000,
			success: function(response) { openInNewTab(hlpPathNodered); },
			error: function(xmlhttprequest, textstatus, message) {
				if(textstatus==="timeout" || textstatus==="error") {
					alert("Node-RED service not ready yet ... please retry ...");
				} else {
					console.log("Error when starting Node-RED: " + textstatus);
				}
			}
		});
	});


	$("[id^='buttResetRegistered']").on('click', function(event) {

		event.preventDefault();

		// refresh login on each action
		refreshLoginCookies(cookieExpireMinutes, saveUUID);

		// reset
		$("#panelDevMaintMsgHeader").hide();
		$("#addDeviceMessageRow").hide();

		var retAjax = ajaxResetDevice($(this).attr('id').replace('buttResetRegistered_',''));
		if (retAjax.status == "SUCCESS") {
			location.reload(true);
		}
		else {
			$("#panelDevMaintMsgHeader").html(GetErrorText(retAjax.message, currentLang, "long"))
			$("#panelDevMaintMsgHeader").show();
		}
	});

	// IMPORTANT: setting main panel visible HERE is
	// to prevent firefox browser from rendering ALL panels on load
	// BEFORE display:none has the chance to hide them ...
	$("#panelDevMaint").css('visibility','visible');

	// debug presets
	if (swtDebug == true) {
		$("#inpAddSer01").val('12345678')
		$("#inpAddSer02").val('12345678')
	}

});

// Internal functions

function checkInput(ser01, ser02, mode) {

	var checkResult = "";

	if($.trim(ser01) == "") {
		checkResult += "ERR_SER01_EMPTY" + "|";
	} else {
		if(isNaN(ser01)) {
			checkResult += "ERR_SER01_INVALID" + "|";
		}
	}
	if($.trim(ser02) == "") {
		checkResult += "ERR_SER02_EMPTY" + "|";
	} else {
		if(!isHex(ser02)) {
			checkResult += "ERR_SER02_INVALID" + "|";
		}
	}

	return checkResult;
}

function getDeviceStatus(statusNr) {
	var ret = "UNKNOWN";
	$(mapDeviceStatus).each(function (cnt,entry) {
		if (statusNr == entry[0]) {
			ret = entry[1];
		}
	});

	return ret;
}

function fillUser() {
	$("#loggedInUser").html(Cookies.get('KUNBUS_RevPiUser_' + saveUUID));
	if (userData.data.lastLogin == "") {
		$("#lastLogin").html("-");
	} else {
		$("#lastLogin").html(formatTimestamp(userData.data.lastLogin, "DE"));
		// check if system clock is set (year >= 2000) - show info in Status-tab only if not set!
		if ((parseInt(userData.data.lastLogin.substr(0,4)) < 2000)) {
			$("#trInfo01").show();
		}
		else {
			$("#trInfo01").hide();
		}
	}
}

function warnAboutNodered() {
	var input = document.getElementById("confignoderedVal_1");
	var dialog = document.getElementById("custom-confirm");
	var okBtn = document.getElementById("confirm-yes");

	if (!input || !dialog || !okBtn) return;

	// Only attach the click handler once
	if (!input.dataset.listenerAttached) {
		input.addEventListener("click", function () {
			dialog.style.display = "block";
		});
		input.dataset.listenerAttached = "true";
	}

	// Only attach dialog buttons once
	if (!dialog.dataset.listenerAttached) {
		okBtn.onclick = function () {
			dialog.style.display = "none";
		};

		dialog.dataset.listenerAttached = "true";
	}
}


function fillStatus() {
	warnAboutNodered();

	var retAjax = ajaxReadStatus();
	if(retAjax.status != "ERROR") {
		var hlpVal;
		$("#status00Val").html("&nbsp;" + retAjax.data.status00);
		$("#status01Val").html("&nbsp;" + retAjax.data.status01);
		$("#status02Val").html("&nbsp;" + $.trim(retAjax.data.status02));
		$("#status03Val").html("&nbsp;" + retAjax.data.status03);
		$("#status04Val").html("&nbsp;" + retAjax.data.status04);
		var hlpDiskSpace = retAjax.data.status05.split(" ");
		hlpVal = parseFloat(hlpDiskSpace[0]);

		$("#status05Val").html("&nbsp;" + hlpVal.toFixed(2) + " " + hlpDiskSpace[1]);
		$("#status06Val").html("&nbsp;" + retAjax.data.status06);

		const interfaces = jQuery.parseJSON(retAjax.data.status07);
		const interfaceRows = Object.entries(interfaces).map(([iface, ips]) => `
		  <tr>
		    <td class='network-interfaces__header'>
		      <b>${iface}</b>
		    </td>
		    <td>
		      ${ips.join('<br/>')}
		    </td>
		  </tr>
		`).join('')
		const html = `<table class='network-interfaces'>${interfaceRows}</table>`

		$("#status07Val").html(html);
	}
	else {
		$("#panelDevMaintMsgHeader").html(GetErrorText(retAjax.message, currentLang, "long"))
		$("#panelDevMaintMsgHeader").show();
	}
}

// helper function
function isInArray(value, array) {
  return array.indexOf(value) > -1;
}

// IMPORTANT: fillConfig handles 'Config' and 'Services' Tabs
function fillConfig(mode) {
	var CONST_MAX_CONFIG_VALUES = 13;
	var CONST_MAX_CPUSPEED = 1200;
	// config entries listed here WILL NOT BE DISPLAYED (even if they are present on device!)
	// pattern: look for 'configXX' in status.html --> XX is padded number of config entry to hide
	var arrConfigDisabled = ['remote-access-tunnel']; // hide config: 'remote access tunnel'

	$.blockUI({overlayCSS:{opacity:1.0}}); // setting opacity obviously has no effect ... ??????
	window.setTimeout(function() {

	var retAjax = ajaxReadConfig();
	if(retAjax.status != "ERROR") {

		// loop over all values
		$(configServicesData.data).each(function (cnt,entry) {
			if ((entry.active == true) && ((entry.type == 'config') || (entry.type == 'service'))) {
				if ((retAjax.data["config" + entry.id] + "" != "2") && (!isInArray(entry.id, arrConfigDisabled))) {
					$("[id^='config" + entry.id + "Val_']").prop('checked',false);

					// IMPORTANT: 	if 'revpi-config' program doesn't support a certain parameter it will return 'Usage: ...' manual info!
					// 				Therefore in this case 'retAjax.data["config" + entry.id]' will contain the string 'Usage:' which we need to test here!
					//				config/services row of unsupported feature will be created anyway but will be hidden!
					if (retAjax.data["config" + entry.id] != 'Usage:') {
						$("#config" + entry.id + "Val_" + retAjax.data["config" + entry.id]).prop('checked',true);
						$("#config" + entry.id + "OldVal").val(retAjax.data["config" + entry.id]);
						if ((mode == "SHOW_SAVED") && ($("#config" + entry.id + "State").html() == "changed")) {
							$("#config" + entry.id + "State").html(mode == 'SHOW_SAVED' ? '... saved':'');
						} else {
							$("#config" + entry.id + "State").html(""); // reset
						}
						$("#trConfig" + entry.id).show();
					} else {
						console.log("Unsupported entry in configServices.json: " + entry.id);
						$("#trConfig" + entry.id).hide();
					}
				} else {
					$("#trConfig" + entry.id).hide();
				}
			}
		});

		// handle non standard values
		// downclock cpu

		if (retAjax.data["configdownclock-cpu"] + "" != "2") {
			// CM1 has no downclock-cpu option!
			if (retAjax.data["configdownclock-cpu"] + "" != "") {
				if ((retAjax.data["configdownclock-cpupar00"] != "0") && (retAjax.data["configdownclock-cpupar00"] != "0")) {
					// downclocked value
					$("#configdownclock-cpuValPar00").val(retAjax.data["configdownclock-cpupar00"]);
				} else {
					// non-downclocked value - is always the max available value!
					$("#configdownclock-cpuValPar00").val($('#configdownclock-cpuValPar00 option:last').val());
				}
				$("#configdownclock-cpuPar00OldVal").val($("#configdownclock-cpuValPar00").val()); //store val in oldVal
				if ((mode == "SHOW_SAVED") && ($("#configdownclock-cpuPar00State").html() == "changed")) {
						$("#configdownclock-cpuPar00State").html(mode == 'SHOW_SAVED' ? '... saved':'');
						//$("#configdownclock-cpuPar00State").css('color','#00FF00');
				} else {
						$("#configdownclock-cpuPar00State").html(""); // reset
				}
			} else {
				// 	on CM1 devices downclock-cpu is not available - dal.php returns "" for retAjax.data["configdownclock-cpu"]
				//	we completely hide the table row!
				$("#trConfigdownclock-cpu").hide();
			}

		}

		// show / hide special info if nodered is active
		// and optionally enable / disable Start Button in 'Apps' Tab
		if (retAjax.data["confignodered"] + "" != "2") {
			if (retAjax.data["confignodered"] == 1) {
				$("#apps05Info").css({'display':'none'});
				$("#buttNodered").css({'display':'inline'});
			} else {
				$("#apps05Info").css({'display':'block'});
				$("#buttNodered").css({'display':'none'});
			}
		} else {
				$("#trApps05").hide();
		}

	}
	else {
		$("#panelDevMaintMsgHeader").html(GetErrorText(retAjax.message, currentLang, "long"))
		$("#panelDevMaintMsgHeader").show();
	}

	$.unblockUI();

}, 50);

}

function selectTab(tabName) {
    var i, x, tablinks;

	// check if session is still active when seleting other tab
	saveUUID = checkSession();
	if (saveUUID == "") {
		alert('Session expired ...');
		window.location.href = "index.html";
		return;
	}

	if (getCountChangedState() > 0) {
		if (confirm('You have unsaved changes! Leave / refresh tab anyway?') == false) {
			return;
		}
	}

    x = document.getElementsByClassName("tabs");
    for (i = 0; i < x.length; i++) {
        x[i].style.display = "none";
    }

	// show tab contents
    document.getElementById(tabName).style.display = "block";

	// deselect all tabs
	$(".tablink").removeClass("revpi-nav-btn active");
	$(".tablink").addClass("revpi-light");

	// select tab
	$("#" + tabName.replace("tab","nav")).removeClass("revpi-light");
	$("#" + tabName.replace("tab","nav")).addClass("revpi-nav-btn active");

	// refresh Apps on each klick on Tab!
	if (tabName == "tabApps") {
		fillConfig(""); // spider availability depends on -Services-! Must be refreshed when clicking on Apps tab
	}
	// refresh Status on each klick on Tab!
	if (tabName == "tabStatus") {
		fillStatus();
	}
	// refresh Config on each klick on Tab!
	if (tabName == "tabConfig") {
		fillConfig("");
	}
	// refresh Services on each klick on Tab!
	if (tabName == "tabServices") {
		fillConfig("");
	}

	// update date / time on tab change
	$("#currentDateTime").html(getDateTime("##DD##.##MM##.##YYYY## ##HH##:##NN##:##SS##"));

}

function getChangedState(configId) {
	var retVal = "";

	if (configId == "configdownclock-cpu") {
		if ($("#configdownclock-cpuPar00State").html() == 'changed') {
			retVal = $("input[name='" + configId + "Val']:checked").val();
		}
	} else {
		if ($("#" + configId + "State").html() == 'changed') {
			retVal = $("input[name='" + configId + "Val']:checked").val();
		}
	}

	return retVal;
}

function getCountChangedState() {
	var cntChanged = 0;
	$("span[id$='State']").each(function (cnt,entry) {
		if ($(this).html() == "changed") {
			cntChanged ++;
		}
	});
	return cntChanged;
}
