# -*- coding: utf-8 -*-
"""Test module import."""
__author__ = "Sven Sager"
__copyright__ = "Copyright (C) 2023 KUNBUS GmbH"
__license__ = "GPLv2"

import unittest


class ModuleImport(unittest.TestCase):
    def test_import(self):
        """Test the import of the module."""
        import opcua_revpi_server

        self.assertEqual(type(opcua_revpi_server.__version__), str)

        from opcua_revpi_server import ua_server

        self.assertTrue(hasattr(ua_server, "UaServer"))

        # These values are defined in RAP file of piCtory and must match SharedIos IntEnum
        self.assertEqual(2, ua_server.SharedIos.EXPORTED)
        self.assertEqual(3, ua_server.SharedIos.ALL)
