# -*- coding: utf-8 -*-
"""Helper functions for opc ua server project."""
__author__ = "Sven Sager"
__copyright__ = "Copyright (C) 2023 KUNBUS GmbH"
__license__ = "GPLv2"

from logging import getLogger

from asyncua.ua import VariantType
from revpimodio2.io import IOBase

log = getLogger(__name__)


def get_ua_datatype(modio_io: IOBase) -> VariantType:
    """Get a suitable UA data type for the passed IO."""
    byte_len = modio_io.length
    signed = modio_io._signed
    modio_value_type = type(modio_io.value)

    if modio_value_type is bool:
        return VariantType.Boolean

    if modio_value_type is float:
        # Float values has 4 bytes, double values has 8 bytes in the process image
        return VariantType.Float if byte_len == 4 else VariantType.Double

    if modio_value_type is int:
        # Convert integers depending on the byte length
        if byte_len == 1:
            return VariantType.SByte if signed else VariantType.Byte
        if byte_len == 2:
            return VariantType.Int16 if signed else VariantType.UInt16
        if byte_len == 4:
            return VariantType.Int32 if signed else VariantType.UInt32
        if byte_len == 8:
            return VariantType.Int64 if signed else VariantType.UInt64

    # The last fallback is an array of pure bytes
    return VariantType.ByteString
