# -*- coding: utf-8 -*-
"""Setup-script for OPCUA-RevPi-Server."""
__author__ = "Sven Sager"
__copyright__ = "Copyright (C) 2023 KUNBUS GmbH"
__license__ = "GPLv2"

from setuptools import find_namespace_packages, setup

from src.opcua_revpi_server import __version__

with open("README.md") as fh:
    # Load long description from readme file
    long_description = fh.read()

setup(
    name="opcua-revpi-server",
    version=__version__,

    packages=find_namespace_packages("src"),
    package_dir={'': 'src'},
    include_package_data=True,

    python_requires=">= 3.7",
    install_requires=[
        "asyncua >= 1.0.4",
        "custom-rap-installer",
        "revpimodio2 >= 2.6.0",
    ],
    entry_points={
        'console_scripts': [
            'opcua-revpi-server = opcua_revpi_server.servermanager:main',
        ],
    },

    platforms=["revolution pi"],

    url="https://revolutionpi.com/",
    license="GPLv2",
    author="Sven Sager",
    author_email="s.sager@kunbus.com",
    maintainer="KUNBUS GmbH",
    maintainer_email="support@kunbus.com",
    description="OPC UA server system for use on a Revolution Pi",
    long_description=long_description,
    long_description_content_type="text/markdown",
    keywords=["revpi", "revolution pi", "opc ua", "plc", "automation"],
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Environment :: No Input/Output (Daemon)",
        "Intended Audience :: Manufacturing",
        "License :: OSI Approved :: GNU General Public License v2 (GPLv2)",
        "Operating System :: POSIX :: Linux",
        "Topic :: System :: Operating System",
    ],
)
