# Verschlüsselung TLS nutzen

Über das Setzen der Einstellung (MEM) 'Use_TLS_encryption' auf 'Active' kann
im OPC UA RevPi Server die TLS-Verschlüsselung aktiviert werden. Durch die
Aktivierung müssen gültige Werte für 'TLS_certificate_path' und
'TLS_Key_path' gesetzt sein.

![Use_TLS_encryption](images/use_tls_encryption.png)

> Wird die Verschlüsselung verwendet, müssen sowohl für den **Server** als
> auch für den **Client** gültige Zertifikate erzeugt werden!

Für das Erzeugen von Zertifikaten kann auf allen Betriebssystemen das Tool
[XCA](https://hohnstaedt.de/xca/) verwendet werden.

## Grundeinstellungen für ein neues Zertifikat

- Nach dem Starten von XCA, muss als Erstes eine neue Datenbank erzeugt werden.
  [XCA create new database](images/xca_new_db.png)
- Im Reiter "Zertifikate" auf den Button "Neues Zertifikat" klicken. XCA
  bietet Vorlagen für "TLS_client" und "TLS_server". Wird eine Vorlage
  gewählt, muss der Button "Alles übernehmen" angeklickt werden.
- Im Reiter "Inhaber" müssen sowohl für Client, als auch für Server alle
  Werte korrekt ausgefüllt werden.
    - "Interner Name" ist ein Freitextfeld und es kann ein Ausagekräftiger
      Name verwendet werden.
    - Als Nächstes sollte man den Button "Erstelle einen neuen Schlüssel"
      klicken, welcher einen privaten Schlüssel zum Zertifikat erzeugt.
    - **WICHTIG**: Das Feld "commonName" ist der Hostname vom Client /
      Server und muss mit dem follständigen Domänennamen angegeben werden.
    - Die weiteren Felder können passend ausgefüllt werden.
    - [Have a look: Create new certificate owner](images/xca_certificate_owner.png)
- Im Reiter "Erweiterungen" muss die Laufzeit des Zertifikats definiert
  werden und der sehr wichtige "X509v3 Subject Alternative Name".
    - Der "Subject Alternative Name" muss sowohl den Eintrag "DNS", mit dem
      Hostname, der mit "commonName" übereinstimmt, als auch eine URI für
      den OPC UA Server besitzen.
    - Die genauen Werte findet man jeweils unten bei Server / Client

> Aktuell haben wir noch *keine* Prüfung der Zertifikate auf Vertrauen
> implementiert. Dadurch müssen die Zertifikate nicht von einer gemeinsamen
> Zertifizierungsstelle signiert sein. Sowohl Server als auch Client konnten
> eigene, selbst signierte, Zertifikate verwenden.

#### Hostnamen ermitteln

Der Hostname kann z.B. in einem Terminal mit `hostname -f` auf macOS und
Linux oder in der Eingabeaufforderung mit `hostname` auf Windows Systemen
ausgelesen werden.

### Server

Die Erzeugung eines Server-Zertifikats muss bestimmte Werte beinhalten, da
diese in dem OPC UA RevPi Server hinterlegt sind.

- Für ein Server-Zertifikat wird in XCA die Vorlage "TLS_server" ausgewählt
  und der Button "Alles übernehmen" geklickt.
- Im Reiter "Inhaber" werden die Werte gemäß
  [Grundeinstellungen](#grundeinstellungen-für-ein-neues-zertifikat) gesetzt.
- Im Reiter "Erweiterungen" müssen bei "X509v3 Subject Alternative Name"
  folgende Werte definiert werden:
    - DNS:revpi000000.local
    - URI:urn:revpi000000.local:opcua-revpi-server
    - [Have a look: Subject Alternative Name](images/xca_certificate_extensions.png)
    - **WICHTIG**: Beim Server-Zertifikat muss der "urn" auf
      `:opcua-revpi-server` enden!

> Sollte der Assistent bestimmte Werte nicht annehmen, kann der Text
> direkt in die Eingabezeile eingefügt
> werden `DNS:revpi00000.local, URI:urn:revpi00000.local:opcua-revpi-server`

- Diese Einstellungen werden mit "OK" bestätigt und XCA hat das Zertifikat für
  den Revolution Pi erzeugt.

Dieses Zertifikat und der dazugehörige private Schlüssel müssen in XCA nun
**jeweils** im "PEM" Format exportiert werden (nicht als "PEM + ..."). Die
beiden Dateien werden auf den Revolution Pi kopiert und in den PiCtory
Einstellungen unter "TLS_certificate_path" (Zertifikat) und "TLS_Key_path"
(Schlüssel) angegeben.

> Bei Änderung der PiCtory Konfiguration muss diese immer als
> Startkonfiguration gespeichert und der Treiber zurückgesetzt werden.

Dies ist ein Beispiel von einem Zertifikat für den Server auf dem Revolution Pi:

```
nsCertType=server
subjectAltName=DNS:revpi00000, URI:urn:revpi00000:opcua-revpi-server
extendedKeyUsage=serverAuth
keyUsage=digitalSignature, nonRepudiation, keyEncipherment, keyAgreement
subjectKeyIdentifier=hash
basicConstraints=critical,CA:FALSE
```

### Client

Auch der Client benötigt ein eigenes Zertifikat mit einem privaten Schlüssel.
Hier zeigen wir die Werte, die verwendet werden müssen, wenn man z.B. die
[Free OPC UA Client](https://github.com/FreeOpcUa/opcua-client-gui) verwendet.

- Für ein Server-Zertifikat wird in XCA die Vorlage "TLS_client" ausgewählt
  und der Button "Alles übernehmen" geklickt.
- Im Reiter "Inhaber" werden die Werte gemäß
  [Grundeinstellungen](#grundeinstellungen-für-ein-neues-zertifikat) gesetzt.
- Im Reiter "Erweiterungen" müssen bei "X509v3 Subject Alternative Name"
  folgende Werte definiert werden:
    - DNS:your-client-host-name
    - URI:urn:freeopcua:client-gui

> Der URI, die sogenannte Application ID, muss für jede Anwendung einzigartig
> sein. Empfohlen wird hier z.B. die Domäne ihrer Firma in der
> links-nach-rechts Schreibweise und ein eindeutiger Name der Anwendung
> (z. B. com.meine-firma.application_name). Die GUI 'FreeOpcUa Client' verwendet
> z.B. den Wert: 'urn:freeopcua:client-gui'.

Dies ist ein Beispiel von einem Zertifikat auf einem Computer, der über das
Netzwerk mit
dem [Free OPC UA Client](https://github.com/FreeOpcUa/opcua-client-gui) auf den
Revolution Pi zugreift:

```
nsCertType=client, email
subjectAltName=DNS:your-client-host-name, URI:urn:freeopcua:client-gui
extendedKeyUsage=clientAuth
keyUsage=digitalSignature, keyEncipherment, dataEncipherment, keyAgreement
subjectKeyIdentifier=hash
basicConstraints=critical,CA:FALSE
```
