# Beispieldateien für das Projekt

## systemd

Die Datei ["opcua-revpi-server.service"](./systemd/opcua-revpi-server.service)
zeigt ein Beispiel, wie das Unit-File für systemd aussehen könnte. Es wird die
default-Datei "/etc/default/opcua-revpi-server" eingebunden, welche
Konfigurationsvariablen für den Programmstart enthält. Die Variable
"$DAEMON_OPTS" wird bei "ExecStart" an das Programm übergeben.

Dieses Programm ist so gestaltet, dass systemd benachrichtigt wird, wenn alle
Funktionen bereit sind und zur Verfügung stehen. Durch "Type=notify" wartet
systemd auf die Benachrichtigung, bevor weitere Dienste, welche eine
Abhängigkeit auf dieses Programm haben gestartet werden. "NotifyAccess=all"
ist wichtig, da die Benachrichtigung ein Childprozess des Programms tätigt.
Durch die Angabe von "all" dürfen alle Childprozesse diese Benachrichtigung
an systemd senden.

In diesem Unit-File werden alle Log-Ausgaben durch journald emfpangen und sind
über "journalctl -u opcua-revpi-server" abrufbar.

## logrotate

Sollte das Programm so konfiguriert werden, dass es eine eigene Logdatei
für das Schreiben verwendet, kann die Beispieldatei "opcua-revpi-server"
aus dem Ordner "logrotate" in das jeweilige Konfigurationsverzeichnis
übernommen werden.

## sudoers.d

Dieser Ordner enthält die
Beispieldatei [sudoers.d/042_www-data-opcua-revpi-server-pictory](). Diese
Datei zeigt, wie das systemd Unit-File aus dem Beispiel durch Benutzer ohne
Root-Rechte aktiviert / deaktiviert werden kann (in diesem Beispiel als Benutzer
www-data). Dieser Aufruf startet / stoppt den Dienst mit aktivierung /
deaktivierung durch den Übergabeparameter "--now".
Der Parameter "--no-block" von "systmctl" wird verwendet um ein Blockieren des
"systemctl"-Befehls zu verhindern. Dieser würde, durch "Type=notify" erst
zurückkehren, wenn alle internen Funktionen vom Programm verfügbar sind (siehe
oben Beispieldatei systemd).

> Hinweis: Es muss exakt der Befehl aus der sudoers Datei vom Benutzer angegeben
> werden (mit allen Argumenten). In diesem Beispiel "/usr/bin/systemctl
> --no-block enable --now opcua-revpi-server".

Dieses Beispiel könnte z.B. in den RAP-Dateien für das virtuelle Modul als
"action" verwendet werden. PiCtory könnte dann den Dienst aktivieren /
deaktivieren, sobald ein virtuelles Modul hinzugefügt / entfernt wird.
