# OPC UA Revolution Pi Server

Wie jedes andere Modul wird auch der OPC UA Server in PiCtory konfiguriert.
Einfach im Gerätekatalog auf der linken Seite das "OPC UA Server" Modul mit
der Maus in die bestehende PiCtory-Konfiguration hineinziehen.

![PiCtory configuration](docs/images/pictory.png)

> PiCtory kann von einem Browser durch eingabe
> von 'https://revpi000000.local:41443' (000000 gegen die Seriennummer auf
> dem Gehäuse austauschen) erreicht werden.
>
> ![Serial number](docs/images/serialnumber.png)
>
> Weitere
>
Informationen [bei Kunbus](https://revolutionpi.com/tutorials/was-ist-pictory-2/pictory)

## Überblick der MEM-Werte

Über die Memories (MEM) Werte im "Value Editor" von PiCtory werden alle
Einstellungen des OPC UA Servers vorgenommen.

- Port: Port, über den der OPC UA Server erreichbar ist.
- Ein- und Ausgangsverwaltung:
    - [Shared_IOs](docs/images/shared_ios.png):
      Dank der neuen Technik "Shared IOs" können bestehende Ein- und Ausgänge
      von anderen Modulen direkt mit dem OPC UA Server verknüpft werden. Dabei
      kann ich wählen, ob ich nur exportierte Ein- und Ausgänge verwenden möchte
      oder alle verfügbaren.
    - [Output_mode](docs/images/output_mode.png):
      Die verknüpften Ausgänge können in der Standardeinstellung nur gelesen
      werden. Über den "Output_mode" kann auch eine Schreibberechtigung
      erteilt werden damit ein OPC UA Client über den OPC UA Server Ausgänge
      setzen kann.
    - Replace_IO_file:
      Siehe [Strukturierte Daten über `replace_io_file`-Datei](#strukturierte-daten-über-replaceiofile-datei):
- Verschlüsselung:
    - [Use_TLS_encryption](docs/images/use_tls_encryption.png):
      Gibt an, ob die TLS Verschlüsselung für die Serververbindung verwendet
      werden soll.
    - TLS_certificate_path: Interner Pfad zum Zertifikat im Revolution Pi
      Dateisystem, welches der Server verwendet.
    - TLS_Key_path: Interner Pfad zum privaten Schlüssel im Revolution Pi
      Dateisystem, welchen der Server verwendet.
    - **WICHTIG**:
      [Genaue Informationen zur Zertifikatserstellung](docs/encryption.md)

## Strukturierte Daten über `replace_io_file`-Datei

Die verwendete Bibliothek RevPiModIO2 bringt, für virtuelle Devices, die
Funktion für IO-Ersetzung mit. Damit können die reinen BYTEs / WORDs von den
virtuellen Devices in passende Datentypen umgewandelt werden. Müssen z.B. zwei
WORDs von einem Modbus Device in eine bestimmte Word-Order und Byte-Order
gebracht werden, um den echten Datentypen (z.B. 4-Byte Integer) zu erhalten,
kann dies in der `replace_io_file`-Datei definiert werden.
[Projekt-Dokumentation](https://revpimodio.org/doku2/#replace_io_file)

Der Pfad zu der Definitionsdatei wird in piCtory über den MEM `Replace_IO_file`
vom "OPC UA Server"-Module angegeben. Soll keine Definitionsdatei geladen
werden, lässt man das Eingabefeld einfach leer.

### Weitere Themen

- [Verschlüsselung](docs/encryption.md)
- [Beispieldateien](./data/README.md)
