# Test cases

We use the 'pytest-cov' module in the `requirements.txt`, which also creates
coverage reports.

## pictory_configs

Various PiCtory configurations for tests.

### [aio_corese_dio_mqtt.rsc](pictory_configs/aio_corese_dio_mqtt.rsc)

This configuration contains the following devices in the specified sequence: AIO, Core SE, DIO, MQTT
Client. All devices are in the PiCtory default settings.

### [broker_commands_tests.rsc](pictory_configs/broker_commands_tests.rsc)

This configuration consists of Core SE, DIO and two MQTT clients. Only the IOs O_1 and Counter_1 are
marked as exported. The two MQTT clients are configured exactly the same, differ only in the value
of Output_mode.

- Broker_address = 127.0.0.1
- Port = 51883
- Base_topic: dev/all
- Shared_IOs = Marked as exported
- Sending_behavior = Send on change
- User_name =
- Password =
- Use_TLS_encryption = Inactive
- Replace_IO_file =

These values distinguish the MQTT clients:

[Position 64](pictory_configs/broker_commands_tests.rsc#L1037):
- Output_mode = Read only

[Position 65](pictory_configs/broker_commands_tests.rsc#L1197):
- Output_mode = Read and write

### [broker_tests.rsc](pictory_configs/broker_tests.rsc)

This configuration consists of AIO, Core SE, DIO and three MQTT client devices. The MQTT clients
have different settings with which the tests can work.

For all devices, the following values are the same:

- Broker_address = 127.0.0.1
- Port = 51883
- User_name =
- Password =
- Use_TLS_encryption = Inactive
- Replace_IO_file =

These values distinguish the three MQTT clients:

[Position 64](pictory_configs/broker_tests.rsc#L1627):

- Base_topic: dev/64
- Shared_IOs = All existing
- Sending_behavior = Send every 5 seconds
- Output_mode = Read and write

[Position 65](pictory_configs/broker_tests.rsc#L1787):

- Base_topic: dev/65
- Shared_IOs = Marked as exported
- Sending_behavior = Send on change
- Output_mode = Read only

[Position 66](pictory_configs/broker_tests.rsc#L1947):

- Base_topic: dev/66
- Shared_IOs = Marked as exported
- Sending_behavior = Request with base_topic/get
- Output_mode = Read only

### [corese_mqtt_devices.rsc](pictory_configs/corese_mqtt_devices.rsc)

This configuration consists of only one Core SE and three MQTT client devices. The MQTT clients have
different settings with which the tests can work.

For all devices, the following values are the same:

- Broker_address = 127.0.0.1
- Port = 51883
- Base_topic = revpi/mqtt_client
- User_name =
- Password =
- Use_TLS_encryption = Inactive
- Replace_IO_file =

These values distinguish the three MQTT clients:

[Position 64](pictory_configs/corese_mqtt_devices.rsc#L147):

- Shared_IOs = All existing
- Sending_behavior = Send every 5 seconds
- Output_mode = Read and write

[Position 65](pictory_configs/corese_mqtt_devices.rsc#L307):

- Shared_IOs = Marked as exported
- Sending_behavior = Send on change
- Output_mode = Read only

[Position 66](pictory_configs/corese_mqtt_devices.rsc#L467):

- Shared_IOs = Marked as exported
- Sending_behavior = Request with base_topic/get
- Output_mode = Read only

### [invalid_deviceid.rsc](pictory_configs/invalid_deviceid.rsc)

This configuration has an MQTT device, which contains an invalid "Device ID" for the MQTT device.
The value is set to "20231024_0_0", which the MqttClient class cannot process.
