# -*- coding: utf-8 -*-
# SPDX-FileCopyrightText: 2024 KUNBUS GmbH <support@kunbus.com>
# SPDX-License-Identifier: GPL-2.0-or-later
"""Setup-script for MQTT-RevPi-Client."""

from setuptools import find_namespace_packages, setup

from src.mqtt_revpi_client.__about__ import __version__

with open("README.md") as fh:
    # Load long description from readme file
    long_description = fh.read()

setup(
    name="mqtt-revpi-client",
    version=__version__,
    packages=find_namespace_packages("src"),
    package_dir={"": "src"},
    include_package_data=True,
    python_requires=">= 3.7",
    install_requires=[
        "custom_rap_installer",
        "paho-mqtt >= 1.0, < 2.0.0",
        "revpimodio2 >= 2.6.0",
    ],
    entry_points={
        "console_scripts": [
            "mqtt-revpi-client = mqtt_revpi_client.clientmanager:main",
        ],
    },
    platforms=["revolution pi"],
    url="https://revolutionpi.com/",
    license="GPLv2",
    license_files=["LICENSES/*"],
    author="Sven Sager",
    author_email="s.sager@kunbus.com",
    maintainer="KUNBUS GmbH",
    maintainer_email="support@kunbus.com",
    description="MQTT client for use on a Revolution Pi",
    long_description=long_description,
    long_description_content_type="text/markdown",
    keywords=["revpi", "revolution pi", "mqtt", "plc", "automation"],
    classifiers=[
        # A list of all classifiers: https://pypi.org/pypi?%3Aaction=list_classifiers
        "Development Status :: 5 - Production/Stable",
        "Environment :: No Input/Output (Daemon)",
        "Intended Audience :: Manufacturing",
        "License :: OSI Approved :: GNU General Public License v2 or later (GPLv2+)",
        "Operating System :: POSIX :: Linux",
        "Topic :: System :: Operating System",
    ],
)
