@echo off
REM == Create ZIP Arc for Windows distribution of KUNBUS PiCtory   ==
REM == (Webserver with PHP included)                               == 
REM == IMPORTANT: this only works if called in piConfig			   ==
REM == directory of SVN trunk                                      ==
REM == ----------------------------------------------------------- ==
REM == creator: F. Bauer, KUNBUS / created: 12/2016                ==
REM == ----------------------------------------------------------- ==
REM == changelog:                                                  ==
REM == 2017/01/12 create empty -log- directory for webserver       ==
REM ==            copy customized speed.txt to webserver cfg       ==

REM Step 00: Set Variables, check paths and create temporary directory (tempdir)
SET "outputZIPfileName=pictory_1_0_instwin.zip"
SET "SevenZIPDir=C:\Programme\7-Zip"
SET "WWServerZIPPathname=I:\Images\RevPi\wwebserver_php_5445_new_cmd.zip"
SET "WWServerExtractedFilename=WWebserver with PHP 5.4.45"

if exist %SevenZIPDir%\7z.exe (
	echo 7-Zip found ...
	echo(
) else (
	echo Please set correct -SevenZIPDir- variable in -Step 00- of this batch script !
	echo Build aborted ...
	echo(
	echo(
	pause
	exit
)

if exist %WWServerZIPPathname% (
	echo WWebserver-ZIP found ...
	echo(
) else (
	echo Please set correct -WWServerZIPPathname- variable in -Step 00- of this batch script !
	echo Build aborted ...
	echo(
	echo(
	pause
	exit
)

SET "ZIPtempdir=_installwin_tmp"
md %ZIPtempdir%

REM Step 01: unpack wwserver to tempdir
%SevenZIPDir%\7z.exe x %WWServerZIPPathname% -o%ZIPtempdir% -r
xcopy %ZIPtempdir%\"%WWServerExtractedFilename%"\*.* %ZIPtempdir% /E /I
rmdir %ZIPtempdir%\"%WWServerExtractedFilename%" /S /Q

REM Step 02: create empty log dir and PiCtory webroot
md %ZIPtempdir%\log
md %ZIPtempdir%\pictory

REM Step 03: copy current PiCtory files into tempdir/wwserver/pictory
xcopy common %ZIPtempdir%\pictory\common /E /I
xcopy php %ZIPtempdir%\pictory\php /E /I
xcopy resources %ZIPtempdir%\pictory\resources /E /I

REM Step 04: create initial empty PiCtory directories
md %ZIPtempdir%\pictory\export
md %ZIPtempdir%\pictory\projects

REM Step 05: copy PiCtory root files
copy config.json %ZIPtempdir%\pictory\config.json
copy dialogs.html %ZIPtempdir%\pictory\dialogs.html
copy index.html %ZIPtempdir%\pictory\index.html
copy language.json %ZIPtempdir%\pictory\language.json

REM Step 06: copy KUNBUS version of init.txt to tempdir/wwserver/cfg 
copy installwin_ww_init.txt %ZIPtempdir%\cfg\init.txt
copy installwin_ww_speed.txt %ZIPtempdir%\cfg\speed.txt

REM Step 07: create ZIP file from tempdir
%SevenZIPDir%\7z.exe a %outputZIPfileName% %ZIPtempdir%
%SevenZIPDir%\7z.exe rn %outputZIPfileName% %ZIPtempdir% PiCtory

REM Step 08: add readme file to archive
%SevenZIPDir%\7z.exe a %outputZIPfileName% installwin_readme.txt
%SevenZIPDir%\7z.exe rn %outputZIPfileName% installwin_readme.txt readme.txt
   
REM Step 08: delete tempdir
rmdir %ZIPtempdir% /S /Q

pause
