import { Selector } from 'testcafe';
import {
  AddDeviceBase,
  AddDeviceLeft,
  AddDeviceRight,
  clickMenu,
  DeviceIds,
  Editor,
  FileMenu,
  getDeviceCatalogSelector,
  getDeviceSelector,
  ValueEditor,
} from './pictory.models';
import { reloadCurrentPage, validatePictoryStartupConfig } from './utils';

fixture(`Gateway devices`);

test('Add Core3 with EtherNet and Profinet Gateways and test ValueEditor', async (t) => {
  await AddDeviceBase(DeviceIds.Core3);
  await AddDeviceLeft(DeviceIds.Gateway_EtherNetIP);
  await AddDeviceRight(DeviceIds.Gateway_Profinet);

  // Click Gateway_EtherNetIP to open value editor
  await t.click(getDeviceSelector(DeviceIds.Gateway_EtherNetIP));

  // TODO: Testing the value editor could be extracted if used more often
  // Value Table should be visible
  await t.expect(ValueEditor.Table.exists).ok();

  // Row #1 should contain Input 1 of Gateway_EtherNetIP
  const firstInput = ValueEditor.getColumnsOfRow(0);
  await t.expect(firstInput.Type.innerText).eql('INP 1');
  //  Set custom name
  const input1Name = firstInput.Name.find('input');
  await t.expect(input1Name.value).eql('Input_1');
  await t
    .selectText(input1Name)
    .pressKey('delete')
    .typeText(input1Name, 'CustomInput1')
    .pressKey('enter');

  // Row #20 should contain Output 1 of Gateway_EtherNetIP
  const firstOutput = ValueEditor.getColumnsOfRow(20);
  // First row's label should be type OUTPUT
  await t.expect(firstOutput.Type.innerText).eql('OUT 1');
  //  Set custom name
  const output1Name = firstOutput.Name.find('input');
  await t.expect(output1Name.value).eql('Output_1');
  await t
    .selectText(output1Name)
    .pressKey('delete')
    .typeText(output1Name, 'CustomOutput1')
    .pressKey('enter');

  // Save and reload
  await clickMenu(t, FileMenu, 'SaveAsStart');
  await reloadCurrentPage(t);

  // Click Gateway_EtherNetIP to open value editor
  await t.click(getDeviceSelector(DeviceIds.Gateway_EtherNetIP));

  // Expect custom names still to be there
  await t.expect(input1Name.value).eql('CustomInput1');
  await t.expect(output1Name.value).eql('CustomOutput1');

  const result = await validatePictoryStartupConfig();
  await t.expect(result.isValid).ok(result.error);
});

test('Adding a Gateway left to Connect4 should show error message', async (t) => {
  await AddDeviceBase(DeviceIds.Connect4);

  await t.dragToElement(
    getDeviceCatalogSelector(DeviceIds.Gateway_DMX),
    Editor.DropTargets.left,
  );

  await t
    .expect(Selector('#lblDialogInfo').innerText)
    .contains('ERR_LEFT_INVALID_PRODUCTTYPE');
});
