#!/bin/bash
set -e

######
# Starts pictory with the current local pictory sources in a container
# and runs testcafe inside that container with the current local e2e tests sources against it
######

ROOT_DIR=$(git rev-parse --show-toplevel)
PICTORY_DIR=$(realpath "$ROOT_DIR"/src/pictory)
TEST_DIR=$(realpath "$ROOT_DIR"/test/testcafe)

echo "Starting pictory-testcafe container ..."
echo "Mounting pictory from $PICTORY_DIR"
echo "Mounting tests from $TEST_DIR"

docker run \
	-it \
	--rm \
	-p 41443:41443 \
	-v "$PICTORY_DIR":/var/www/revpi/pictory \
	-v "$TEST_DIR":/opt/testcafe/ \
	--name pictory-testcafe \
	registry.gitlab.com/revolutionpi/pictory/pictory-testcafe-bullseye:arm64-latest \
	./docker-entrypoint.sh
