#!/bin/bash
set -e

######
# Starts pictory with the current local pictory sources
######

ROOT_DIR=$(git rev-parse --show-toplevel)
PICTORY_DIR=$(realpath "$ROOT_DIR"/src/pictory)

echo "Starting pictory-development container ..."
echo "Mounting pictory from $PICTORY_DIR"

docker run \
	-d \
	--rm \
	-p 41443:41443 \
	-v "$PICTORY_DIR":/var/www/revpi/pictory \
	--name pictory-development \
	registry.gitlab.com/revolutionpi/pictory/pictory-testcafe-bullseye:arm64-latest \
	apache2-foreground
