// "use strict";

// SWITCHES
var swtDEBUG = false;
var swtDeviceCatalogExpanded = true;
var swtIsDirty = false;
var gblSwtLogActive = false;
var ctrlIsPressed = false;

// TIMERS
var timerAutoSave = null;

var currentLang = 'en';
var currentProjectFilename = '';
var currentExportTS = '';
var sessionExpireMin = '';

var idDeviceContextMenu;
var confirmMode = '';
var confirmResult = false;

var configData = '';
var exportData = '';
var userSettingsData = '';
var mainLayout;
var dragTableRevert;
var lastMarkedDeviceId = '';
var currentMarkedDeviceId = '';
var currentAttrDeviceId = '';
var currentRefreshedDeviceId = '';
var gblSaveMultiName = '';
var gblCntMultiName = 1;
var gblAllMulti = 0;

// config settings which may be overridden by GUI
var swtPadCore = false;

// table data storage
var tblDataStore;
var tblEditStore = [];
var extendedDataStore = [];
var currentEditData;
var markedForConnecting = ['', ''];
var connectionStore = [];
var rulesStore = [];

// file cache storage
var fileDataTypesJSON = [];
var fileGsdJSON = [];
var fileLangJSON = [];

// MISC
var cntAppendedDevices = 0; // absolute counter of all appended deviced - will never decrease!
var lastChangedInputValue = -1;
var lastChangedOutputValue = -1;
var lastChangedMemoryValue = -1;
var oldValue; // keeps old values for restoring on canceled change events
var modifyStore = [];
var modFilesStore = [];

var fileExistsRequestMethod = checkServerHEADMethod();

// RESERVED STRINGS
var attrReservedStrings = ['id']; // these string MUST not be used as attribute names!
var attrInvalidChars = ['(', ')', '.']; // these characters MUST not be contained in attribute names!

// GSD storage
var arrAttrs = [];

// SESSION specific
var revPiHostname = '';
window.isSSOHost = Cookies.get('Cockpit_SSO_Host') !== undefined;

// Text templates
var tmplEmptyDragTable = '';

// misc
var CONST_DEFAULT_MINUTES_AUTOSAVE = 15;
var CONST_MINUTES_OF_YEAR = 525600;
var CONST_MAXLEN_ATTRNAME = 30;

/* 	=====================================================================
/	jQuery ready function - will be executed after DOM is fully loaded
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
$(function() {
  // unblock UI when ajax stops
  $(document).ajaxStop($.unblockUI);
  blockUI(0);

  // IMPORTANT
  // this setTimeout contains all major functions of jquery $(function()
  // It gives -blockUI- time to render loading overlay
  setTimeout(function() {
    // read language file
    fileLangJSON = AjaxGetJSON('language.json', 'OBJ');

    // get RevPI Hostname - only used in checksession of STANDARD mode ...
    // NOTE: This is NOT the hostname but the MD5 hash of the current PHP SessionID
    // see: webstatus/src/revpi/php/dal.php#L558
    revPiHostname = getURLParameter('hn');

    // read config file
    configData = AjaxGetJSON('config.json', 'OBJ');
    if (configData.misc.userMode == 'STANDARD' && checkSession(revPiHostname) == false) {
      window.location.href = window.isSSOHost ? 'php/logout.php' : configData.paths.login;
      return;
    }

    // read userSettings file - if exists
    userSettingsData = handleUserSettings('GET');

    // read export config file
    exportData = AjaxGetJSON(configData.paths.export + 'config.json', 'OBJ');
    if (fileExists(configData.paths.export + '_userConfig.json')) {
      var hlpUserExportData = AjaxGetJSON(configData.paths.export + '_userConfig.json', 'OBJ');
      exportData.files = $.merge(exportData.files, hlpUserExportData.files);
    }

    // set sessionExpireMin according to userSettings - if any
    sessionExpireMin = configData.misc.sessionExpireMin; // get timeout from config
    if (userSettingsData != '') {
      if (userSettingsData['01'][2] == '0') {
        sessionExpireMin = CONST_MINUTES_OF_YEAR; // timeout off means: timeout 1 year!
      }
      if (userSettingsData['01'][2] == '2') {
        sessionExpireMin = userSettingsData['01'][3]; // custom setting of timeout
      }
    }
    refreshLoginCookies(sessionExpireMin, revPiHostname);

    // set config variable which may be overridden by GUI
    if (typeof configData.misc.padCore != 'undefined') {
      swtPadCore = configData.misc.padCore;
    }

    // disable standard context menu / right mouse button
    $(this).bind('contextmenu', function(e) {
      e.preventDefault();
    });

    // set default states
    displayTblEdit('HIDE');

    // load external files
    // IMPORTANT: -load- is asynchronous - manipulation of loaded
    // content must be done in callback function!
    $('#standardDialogs').load('dialogs.html', function() {
      $('#dialog_splash_txt01').html(configData.name + ' - ' + configData.version);
    });

    var dataModified = true;
    if (swtDEBUG == false) {
      // prevent exiting application (reloading, clicking on external link or changing URL)
      // without confirm!
      window.addEventListener('beforeunload', function(e) {
        // Cancel the event
        e.preventDefault();
        // Chrome requires returnValue to be set
        // do NOT trigger system confirm after we already showed own confirm box
        if (swtIsDirty == true && confirmMode == '') {
          e.returnValue = '';
        }
      });

      // hide experimental Help
      $('#menuInfo_help').hide();
    } else {
      $('#menuInfo_help').show();
    }

    // do optional work depending on config data
    if (configData.misc.userMode == 'STANDARD') {
      // 11/2017 STANDARD mode now also has saveAs and open menu options
      //$("#menuFile_saveAs").hide();
      //$("#menuFile_open").hide();
      $('#menuFile_save').hide();
    } else {
      $('#tools_resetDriver').hide();
      //$("#menuFile_clear").hide();
      $('#menuFile_divider01').hide();
      $('#menuFile_exit').hide();
    }

    if (typeof configData.misc.enableConnections != 'undefined' && configData.misc.enableConnections == false) {
      $('#menuTools_manageConnections').hide();
      $('#menuTools_divider01').hide();
    }

    // make first adjustments from config data
    $('#appTitle').html(configData.name + ' - ' + configData.version);
    $('#menu_appTitle').html(configData.name + ' - ' + configData.version + '&nbsp;&nbsp;');

    // size Slider
    $('#sizeSlider').slider({
      value: 1,
      min: 1,
      max: 5,
      max: 5,
      step: 1,
      slide: function(event, ui) {
        WriteLog(ui.value * 100);
        $('#dragTable td').css('height', ui.value * 100);
        $('[id^=\'device_\']').css('height', ui.value * 100);
      },
    });

    // settung up menu
    $('#main-menu').smartmenus({
      showTimeout: 0,
      hideTimeout: 0,
    });
    $('#main-menu').bind('click.smapi', function(e, item) {
      handleMenu(e, item);
    });

    // setting up layout
    mainLayout = $('body').layout({
      //applyDefaultStyles: true,
      minSize: 70, // ALL panes
      resizerTip: 'Change size',
      togglerTip_open: 'Close',
      togglerTip_closed: 'Open',
      stateManagement__enabled: true,
      stateManagement__autoLoad: false,
      stateManagement__autoSave: true,
      animatePaneSizing: false,
      north: {
        size: 70,
        resizable: true,
        spacing_open: 0, // disable toogle / resize
      },
      west: {
        size: 340,
        resizable: true,
        togglerTip_open: 'Hide Catalog/Datasheet',
        togglerTip_closed: 'Show Catalog/Datasheet',
      },
      east: {
        initClosed: true,
        size: 0,
        resizable: swtDEBUG == true ? true : false,
        togglerTip_open: 'Hide Help/Log',
        togglerTip_closed: 'Show Help/Log',
        spacing_open: 6, // disable toogle / resize
      },
      south: {
        size: 200,
        resizable: true,
        spacing_open: 6, // set to 0 to disable toogle / resize
        togglerTip_open: 'Hide Datatables',
        togglerTip_closed: 'Show Datatables',
      },
      //	West Sidebar options
      west__childOptions: {
        size: 0,
        minSize: 0,
        south__size: 0,
        resizable: swtDEBUG == true ? true : false,
        resizerTip: 'Change size',
        south__togglerTip_open: 'Hide Datasheet',
        south__togglerTip_closed: 'Show Datasheet',
      },
      //*	East Sidebar options
      east__childOptions: {
        minSize: 50, // ALL panes
        north__size: 100,
        south__size: 100,
        resizerTip: 'Change size',
        south__togglerTip_open: 'Hide Log',
        south__togglerTip_closed: 'Show Log',
      },
      //	South Sidebar options
      south__childOptions: {
        minSize: 50, // ALL panes
        east__size: 500,
      },

      onclose: function() {
        //alert('Pane closed ...');
      },
    });

    //
    // important to let menu in north pane overlap other panes!
    //
    mainLayout.allowOverflow('north');

    // we don't use the 'east' area at the moment!
    if (swtDEBUG == false) {
      mainLayout.disableClosable('east', true);
      mainLayout.disableResizable('east', true);
    } else {
      mainLayout.disableClosable('east', false);
      mainLayout.disableResizable('east', false);
    }

    //
    // read last saved layout state and restore
    //
    if (swtDEBUG == false) {
      window.startState = mainLayout.readState();
      mainLayout.close('east'); // force east area closed
    } else {
      mainLayout.open('east'); // force east area closed
    }

    //
    // setting up main device positioning table
    //
    $('#dragTable').dragtable({
      start: function(event, ui) {
        // store table order for possible revert
        //dragTableRevert = $("#dragTable").dragtable('order');
        //dragTableRevert = $("#dragTable").html();
        //alert($("#dragTable").html());
      },
      stop: function(event, ui) {
        WriteLog('DragTable stop: ' + ui.startIndex + '/' + ui.endIndex);
        //alert('Stop');

        // check session to prevent timeout after extensive reordering of devices
        if (checkSession(revPiHostname) == false) {
          createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
          //window.location.href = configData.paths.login;
          return false;
        }
        refreshLoginCookies(sessionExpireMin, revPiHostname);

        // if drag not possible - revert ...

        // check positional rules
        var retPositionAllowed = isPositionAllowed();
        if (retPositionAllowed != 'OK') {
          //alert(retPositionAllowed);
          createInfoDialog('Error', '<br>' + retPositionAllowed, '');
          $('#dragTable').html(dragTableRevert);
        }

        // check device relations and max devices rules etc.
        // ??????????????????????????????
        var retRules = checkRules(getDraggedDeviceId(ui.startIndex), '');
        if (retRules != 'OK') {
          //alert(GetErrorText(retRules, currentLang, "short"));
          createInfoDialog('Error', '<br>' + GetErrorText(retRules, currentLang, 'short'), '');
          $('#dragTable').html(dragTableRevert);
        }

        clearDataTable();
        expandDragTable('PAD_EDGES', 0);
        refreshDataTable();
        refreshHandlers();
        refreshDelegates();

        // reset Ctrl State to prevent triggering connection setting when dragging devices around!
        ctrlIsPressed = false;

        // simulate two clicks after dragging marked device to new position
        // to trigger marking of row in data table!
        $('#dragTable td')
          .children('img')
          .each(function() {
            if ($(this).hasClass('moduleSelected')) {
              var hlpDeviceID = $(this).attr('id');
              setTimeout(function() {
                $('#' + hlpDeviceID).trigger('click');
                $('#' + hlpDeviceID).trigger('click');
              }, 100);
            }
          });

        swtIsDirty = true;
      },
      beforeChange: function(event, ui) {
        WriteLog('DragTable beforeChange: ' + ui.startIndex + '/' + ui.endIndex);
        return true;
      },
      change: function(event, ui) {
        WriteLog('DragTable change: ' + ui.startIndex + '/' + ui.endIndex);
        return true;
      },
    });

    //
    // setting up catalog fancytree
    //
    var FT = $.ui.fancytree;
    $('#catalogTree').fancytree({
      debugLevel: 0, // 0:quiet, 1:normal, 2:debug
      extensions: ['dnd', 'edit'],
      generateIds: true,
      clickFolderMode: 3, //1:activate, 2:expand, 3:activate and expand, 4:activate (dblclick expands)
      quicksearch: true,
      //source: {url: "resources/data/catalog.json"},
      source: function(event, data) {
        // load catalog data
        //var catalogData = AjaxGetJSON("resources/data/catalog.json", "OBJ");
        var catalogData = AjaxGetJSON(configData.paths.catalog, 'OBJ');
        if (fileExists(configData.paths['catalog-custom'])) {
          catalogData = appendCatalogCustom(catalogData);
        }
        // patch data from GSD etc. into catalog data
        catalogData = patchCatalogData(catalogData);
        // remove 'Test'-Branch from Catalog if not in debug mode!
        if (swtDEBUG == false) {
          catalogData = $.grep(catalogData, function(item, index) {
            return item.title != 'Test';
          });
        }

        return catalogData;
      },
      lazyLoad: function(event, data) {
        data.result = $.ajax({
          url: 'resources/data/catalog01_lazy.json',
          dataType: 'json',
        });
      },
      createNode: function(event, data) {
        WriteLog('Tree Node Created: ' + data.node.title);
        data.node.setExpanded(true); // auto expand ALL nodes on load!
      },
      icon: function(node) {
        //return "glyphicon"; // + node.data.type;
      },
      dnd: {
        autoExpandMS: 400,
        focusOnClick: true,
        preventVoidMoves: true, // Prevent dropping nodes 'before self', etc.
        preventRecursiveMoves: true, // Prevent dropping nodes on own descendants
        draggable: {
          zIndex: 1000,
          scroll: false,
          cursor: 'crosshair',
          containment: 'parent',
          revert: 'invalid',
          appendTo: 'body',
          helper: function(event) {
            // deactivate this helper function to get the standard behavior of dragging (node title attached!)

            /*
					var $helper,
					sourceNode = $.ui.fancytree.getNode(event.target),
					$nodeTag = $(sourceNode.span);

					$helper = $("<div class='fancytree-drag-helper'><span class='fancytree-drag-helper-img' /></div>")
					.append($nodeTag.find("span.fancytree-title").clone());

					// Attach node reference to helper object
					$helper.data("ftSourceNode", sourceNode);
					// we return an unconnected element, so `draggable` will add this
					// to the parent specified as `appendTo` option

					return $helper;
					*/

            var $helper;
            var sourceNode = $.ui.fancytree.getNode(event.target),
              $nodeTag = $(sourceNode.span);
            $helper = $('<div class=\'fancytree-drag-helper\'></div>').append(
              $nodeTag.find('img.fancytree-icon').clone(),
            );
            $helper.data('ftSourceNode', sourceNode);
            return $helper;
          },
        },
        dragStart: function(node, data) {
          WriteLog('DragStart ...');
          return true;
        },
        dragEnter: function(node, data) {
          return true;
        },
        dragDrop: function(node, data) {
          // disable dragging inside tree ...
          //data.otherNode.moveTo(node, data.hitMode);
        },
        dragExpand: function(node, data) {
          // return false to prevent auto-expanding parents on hover
        },
        dragOver: function(node, data) {
        },
        dragLeave: function(node, data) {
        },
        dragStop: function(node, data) {
        },
      },
      activate: function(event, data) {
        //data.node.li
        if (data.node.folder) {
          //console.log("Folder: " + data.node.title);
        } else {
          // showDataSheet(data.node.key); datasheet no longer shown by activating device in tree; use context menu of image!
        }
        WriteLog('Tree ACTIVATE: ' + data.node.title + '/' + data.node.key);
      },
      select: function(event, data) {
        var s = data.tree.getSelectedNodes().join(', ');
        //WriteLog('Tree SELECT: ' + data.node.title);
      },
      dblclick: function(event, data) {
        //WriteLog('Tree DBLCLICK: ' + data.node.title);
      },
      keydown: function(event, data) {
        //WriteLog('Tree KEYDOWN: ' + data.node.title + "/" + event.which);
        return true;
      },
    });

    // open all nodes !
    //var catalogTreeObj = $("#catalogTree").fancytree("getTree");
    //catalogTreeObj.visit(function(node){
    //	node.setExpanded(true);
    //});

    //
    // create a context menu of catalog tree - CURRENTLY NOT USED
    $('#catalogTree').contextmenu({
      delegate: 'span.fancytree-title',
      preventContextMenuForPopup: true,
      //      menu: "#options",
      menu: [
        /* NOT YET ACTICE */
        { title: 'Open in RAP-Editor', cmd: 'openRAPedit', uiIcon: 'ui-icon-pencil' },
        { title: lookupLanguage(currentLang, 'cMenu_ShowDatasheet'), cmd: 'showDatasheet', uiIcon: 'ui-icon-document' },
        /*
			{title: "Cut", cmd: "cut", uiIcon: "ui-icon-scissors"},
			{title: "Copy", cmd: "copy", uiIcon: "ui-icon-copy"},
			{title: "Paste", cmd: "paste", uiIcon: "ui-icon-clipboard", disabled: false },
			{title: "----"},
			{title: "Edit", cmd: "edit", uiIcon: "ui-icon-pencil", disabled: true },
			{title: "Delete", cmd: "delete", uiIcon: "ui-icon-trash", disabled: true },
			{title: "More", children: [
			{title: "Sub 1", cmd: "sub1"},
			{title: "Sub 2", cmd: "sub1"}
			]}
			*/
      ],
      beforeOpen: function(event, ui) {
        // refresh session
        refreshLoginCookies(sessionExpireMin, revPiHostname);

        // makes context menu overlap layout borders!
        ui.menu.zIndex(99999);

        var node = $.ui.fancytree.getNode(ui.target);
        if (node.folder) return (false);
        //alert(node.key);

        // DISABLE Show Datasheet Option for Virtual Devices
        if (getDeviceType(node.key + '_000') == 'VIRTUAL') {
          ui.menu.find('[data-command=showDatasheet]').addClass('ui-state-disabled');
        } else {
          ui.menu.find('[data-command=showDatasheet]').removeClass('ui-state-disabled');
        }

        node.setActive();
      },
      select: function(event, ui) {
        var node = $.ui.fancytree.getNode(ui.target);
        //alert(ui.cmd + " / " + node.key);

        //createEditRAPDialog(node.key);
        //$("#dialog_editRAP").dialog('open');

        if (ui.cmd == 'showDatasheet') {
          // showDataSheet requires the FULL id of a device which includes
          // the running number at the end. This number does not exist in
          // the tree device key - so we add '_000' as a default
          showDataSheet('device_' + node.key + '_000');
        }

        if (ui.cmd == 'openRAPedit') {
          $.ajax({
            url: 'resources/js/rapEdit.js',
            async: false,
            cache: false,
            dataType: 'script',
          });
          var testRAPEdit = new rapEdit(node.key);
        }

        // access containing <li>
        WriteLog('select ' + ui.cmd + ' on ' + ui.target.closest('li').attr('id'));
      },
    });

    // IMPORTANT:
    if (swtDEBUG == false) {
      $('#catalogTree').contextmenu('showEntry', 'openRAPedit', false);
    }

    $('img.fancytree-icon').each(function() {
      if (!$(this).parent().hasClass('fancytree-icon-wrapper')) {
        $(this).wrap('<span class="fancytree-icon-wrapper"></span></span>');
      }
    });

    // Select all images with class 'fancytree-icon' and apply styles
    $('img.fancytree-icon').each(function() {
      var $this = $(this);
      if ($this[0].complete) {
        adjustIconStyle($this); // Adjust style if image is already loaded
      } else {
        $this.on('load', function() {
          adjustIconStyle($this); // Adjust style once image loads
        });
      }
    });

    // Show full size icon image on icon mouse hover
    $('.fancytree-icon-wrapper').hover(function(event) {

      // Get the original image source
      let img = $(this).find('img.fancytree-icon'); // get the image inside the wrapper
      let fullSizeSrc = img.attr('src');

      // Create an overlay div if it doesn't exist
      if ($('#image-overlay').length === 0) {
        $('body').append('<div id="image-overlay"><img src="" style="max-width: 500px; max-height: 500px;"></div>');
      }

      // Set the full-size image source
      $('#image-overlay img').attr('src', fullSizeSrc);

      // Position the overlay near the cursor
      $('#image-overlay').css({
        display: 'block',
        top: event.pageY + 10 + 'px',
        left: event.pageX + 10 + 'px',
      });
    }, function() {
      // Hide the overlay when mouse leaves
      $('#image-overlay').hide();
    });

    // Update overlay position as the mouse moves
    $('.fancytree-icon').mousemove(function(event) {
      $('#image-overlay').css({
        top: event.pageY + 10 + 'px',
        left: event.pageX + 10 + 'px',
      });
    });

    //
    // setting up droppable
    //
    $('.dropit').droppable({
      drop: function(event, ui) {
        $(this).append('<img src=\'resources/images/Raspi_100x89.jpg\' alt=\'Test\'>');

        var sourceNode = $(ui.helper).data('ftSourceNode');
        //alert("Dropped source node " + sourceNode);
      },
    });

    //
    // setting up main Data Table
    //
    $('#tblData').appendGrid({
      caption: 'Used Device Info',
      initRows: 0, // default empty row that are being generated
      hideRowNumColumn: true,
      columns: [
        {
          name: 'position',
          display: 'Pos',
          type: 'custom',
          ctrlCss: { width: '25px' },
          value: 0,
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = document.createElement('span');
            $(ctrl).attr({ id: ctrlId, name: ctrlId }).appendTo(parent);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).html();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            $('#' + ctrlId).html(value);
          },
        },
        {
          name: 'modulname',
          display: 'Device Name',
          type: 'text',
          ctrlAttr: { maxlength: 100 },
          ctrlCss: { width: '200px' },
        },
        { name: 'bmk', display: 'BMK', type: 'text', ctrlAttr: { maxlength: 100 }, ctrlCss: { width: '200px' } },
        {
          name: 'input',
          display: 'Input',
          type: 'custom',
          ctrlCss: { width: '50px' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = $('<select>', { type: 'select', id: ctrlId, name: ctrlId }).appendTo(parent);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).val();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;

            var variantsSplitL01 = getGsdData(currentRefreshedDeviceId, '##GSD_CNT_VARIANTS##').split(';');
            var variantsInput = variantsSplitL01[0].split(',');
            $('#' + ctrlId).empty();
            for (var i = 0; i < variantsInput.length; i++) {
              $('#' + ctrlId).append($('<option>').attr('value', i).text(variantsInput[i]));
            }

            setSelectByValue(ctrlId, value);
            // setting is done in loadGSDData function when output variants
            // have been determined
          },
        },
        {
          name: 'output',
          display: 'Output',
          type: 'custom',
          ctrlCss: { width: '50px' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = $('<select>', { type: 'select', id: ctrlId, name: ctrlId }).appendTo(parent);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).val();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;

            var variantsSplitL01 = getGsdData(currentRefreshedDeviceId, '##GSD_CNT_VARIANTS##').split(';');
            var variantsOutput = variantsSplitL01[1].split(',');
            $('#' + ctrlId).empty();
            for (var i = 0; i < variantsOutput.length; i++) {
              $('#' + ctrlId).append($('<option>').attr('value', i).text(variantsOutput[i]));
            }

            setSelectByValue(ctrlId, value);
            // setting is done in loadGSDData function when output variants
            // have been determined
          },
        },
        {
          name: 'comment',
          display: 'Comment',
          type: 'text',
          ctrlAttr: { maxlength: 100 },
          ctrlCss: { width: '200px' },
        },
        { name: 'deviceId', display: '', type: 'text', invisible: true },
        { name: 'deviceType', display: '', type: 'text', invisible: true },
        { name: 'GUID', display: '', type: 'text', invisible: true },
      ],
      afterRowAppended: function(caller, parentRowIndex, addedRowIndex) {
        //alert("Appended row index: " + $('#tblData').appendGrid('getUniqueIndex', addedRowIndex[0]));
      },
      hideButtons: {
        insert: true,
        remove: true,
        append: true,
        removeLast: true,
        moveUp: true,
        moveDown: true,
      },
    });


    function setDeviceHoverTooltip(selector, defaultName, description) {
      var hoverText = description ?
        description + ' - Default Name: ' + defaultName :
        'Default Name: ' + defaultName;
      $(selector).prop('title', hoverText);
    }

    //
    // setting up Value Editor Table
    //
    $('#tblEdit').appendGrid({
      caption: 'Value Editor',
      initRows: 0,
      hideRowNumColumn: true,
      columns: [
        {
          name: 'attrtype',
          display: 'Type',
          type: 'custom',
          ctrlCss: { width: '20px' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = document.createElement('span');
            $(ctrl).attr({ id: ctrlId, name: ctrlId }).appendTo(parent);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).html();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;

            // value is array index of arrAttrs store array!
            var hlpAttribute = arrAttrs[value];
            if (hlpAttribute.tags.toLowerCase().indexOf('input') > -1) {
              $('#' + ctrlId).html('INP');
            }
            if (hlpAttribute.tags.toLowerCase().indexOf('output') > -1) {
              $('#' + ctrlId).html('OUT');
            }
            if (hlpAttribute.tags.toLowerCase().indexOf('memory') > -1) {
              $('#' + ctrlId).html('MEM');
            }
          },
        },
        {
          name: 'attrname',
          display: 'Name',
          type: 'custom',
          ctrlCss: { width: '100px' },
          value: 0,
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = document.createElement('input');
            ctrl.type = 'text';
            $(ctrl).attr({ id: ctrlId, name: ctrlId }).appendTo(parent);
            // $('#' + ctrlId).prop('title', ctrl.value);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).val();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            //alert(gblAllMulti + "/" + gblCntMultiName );
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;

            // value is array index of arrAttrs store array!
            var hlpAttribute = arrAttrs[value];

            // handle multi-counter
            if (hlpAttribute.name == gblSaveMultiName) {
              gblCntMultiName++;
            } else {
              gblCntMultiName = 1;
              gblSaveMultiName = hlpAttribute.name;
            }

            // multidata optionally overwrites edit attribute
            var hlpEdit = hlpAttribute.edit;
            if (typeof hlpAttribute.multidata != 'undefined' && typeof hlpAttribute.multidata.edit != 'undefined') {
              if (
                gblCntMultiName <= hlpAttribute.multidata.edit.length &&
                hlpAttribute.multidata.edit[gblCntMultiName - 1] != ''
              ) {
                hlpEdit = hlpAttribute.multidata.edit[gblCntMultiName - 1];
              } else {
                hlpEdit = hlpAttribute.edit;
              }
            } else {
              hlpEdit = hlpAttribute.edit;
            }

            // set edit state and style
            //if (hlpAttribute.edit == 0 || hlpAttribute.edit == 1 ) {
            if (hlpEdit == 0 || hlpEdit == 1) {
              // determine color
              if (typeof hlpAttribute.colorReadOnly != 'undefined') {
                $('#' + ctrlId).css('background-color', hlpAttribute.colorReadOnly);
              } else {
                $('#' + ctrlId).css('background-color', configData.colors.colorReadOnly);
              }

              if (typeof hlpAttribute.colorTextReadOnly != 'undefined') {
                $('#' + ctrlId).css('color', hlpAttribute.colorTextReadOnly);
              } else {
                $('#' + ctrlId).css('color', configData.colors.colorTextReadOnly);
              }

              // set read only!!
              $('#' + ctrlId).prop('readonly', true);
            } else {
              // determine color
              if (typeof hlpAttribute.colorEdit != 'undefined') {
                $('#' + ctrlId).css('background-color', hlpAttribute.colorEdit);
              } else {
                $('#' + ctrlId).css('background-color', configData.colors.colorEdit);
              }

              if (typeof hlpAttribute.colorTextEdit != 'undefined') {
                $('#' + ctrlId).css('color', hlpAttribute.colorTextEdit);
              } else {
                $('#' + ctrlId).css('color', configData.colors.colorTextEdit);
              }
            }

            // set description title if exists
            if (typeof hlpAttribute.description != 'undefined') {
              $('#' + ctrlId).prop('title', hlpAttribute.description);
            }

            // handle multi-counter
            /*
					if (hlpAttribute.name == gblSaveMultiName) {
						gblCntMultiName++;
					} else {
						gblCntMultiName = 1;
						gblSaveMultiName = hlpAttribute.name;
					}
					*/

            function setTypeCounter(selector, counter) {
              var span = $(selector)
                .closest("td")
                .prev("td")
                .find("span");

              var existingText = span.text();

              span
                .css("white-space", "nowrap")   // prevent line breaks
                .text(existingText + " " + counter);  // keep a space before counter
            }

            // Fill table with content
            if (currentEditData.length == 0) {
              // If no _config.rsc stored data exists yet
              if (typeof hlpAttribute.multi != 'undefined' && hlpAttribute.multi > 1) {
                setTypeCounter('#' + ctrlId, gblCntMultiName);
                // Check if proprty muilti is set in .rap file
                if (typeof hlpAttribute.multidata != 'undefined' && typeof hlpAttribute.multidata.name != 'undefined') {
                  // Check if multidata attribute name overrides exist in .rap
                  if (
                    gblCntMultiName <= hlpAttribute.multidata.name.length &&
                    hlpAttribute.multidata.name[gblCntMultiName - 1] != ''
                  ) {
                    // Use the multidata name from .rap to override original name
                    $('#' + ctrlId).val(hlpAttribute.multidata.name[gblCntMultiName - 1]);
                    setDeviceHoverTooltip('#' + ctrlId, hlpAttribute.multidata.name[gblCntMultiName - 1], hlpAttribute.description);
                  } else {
                    // Use default naming with counter
                    $('#' + ctrlId).val(hlpAttribute.name + '_' + gblCntMultiName);
                    setDeviceHoverTooltip('#' + ctrlId, hlpAttribute.name + '_' + gblCntMultiName, hlpAttribute.description);
                  }
                } else {
                  // No multidata overrides - use default naming with counter
                  $('#' + ctrlId).val(hlpAttribute.name + '_' + gblCntMultiName);
                  setDeviceHoverTooltip('#' + ctrlId, hlpAttribute.name + '_' + gblCntMultiName, hlpAttribute.description);
                }
              } else {
                // Single instance (no multi prop in .rap) - use attribute name directly
                $('#' + ctrlId).val(hlpAttribute.name);
                setDeviceHoverTooltip('#' + ctrlId, hlpAttribute.name, hlpAttribute.description);
              }
            } else {
              // Edit data exists from _config.rsc - use stored value
              $('#' + ctrlId).val(currentEditData[gblAllMulti + gblCntMultiName - 1].attrname);
              if (typeof hlpAttribute.multi != 'undefined') {
                setTypeCounter('#' + ctrlId, gblCntMultiName);
                // For multi attributes (multi prop in .rap), use default naming for tooltip
                setDeviceHoverTooltip('#' + ctrlId, hlpAttribute.name + '_' + gblCntMultiName, hlpAttribute.description);
              } else {
                // For single instances (no multi prop in .rap), use stored name from _config.rsc as tooltip
                setDeviceHoverTooltip('#' + ctrlId, hlpAttribute.name, hlpAttribute.description);
              }
            }
          },
        },
        {
          name: 'attrvalue',
          display: 'Value',
          type: 'custom',
          ctrlCss: { width: '50px' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + '##ATTR_TYPE##_' + uniqueIndex;

            // create container span
            var ctrl = document.createElement('span');
            $(ctrl)
              .attr({ id: ctrlId.replace('##ATTR_TYPE##_', ''), name: ctrlId.replace('##ATTR_TYPE##_', '') })
              .appendTo(parent);

            // create textbox AND dropdown; show/hide is handled in setter
            // 1. textbox
            var ctrlText = document.createElement('input');
            ctrlText.type = 'text';
            $(ctrlText)
              .attr({ id: ctrlId.replace('##ATTR_TYPE##', 'text'), name: ctrlId.replace('##ATTR_TYPE##', 'text') })
              .appendTo(ctrl);

            // 2. select
            var sel = $('<select>', {
              type: 'select',
              id: ctrlId.replace('##ATTR_TYPE##', 'sel'),
              name: ctrlId.replace('##ATTR_TYPE##', 'sel'),
            }).appendTo(ctrl);

            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_text_' + uniqueIndex;
            if ($('#' + ctrlId).is(':visible')) {
              return $('#' + ctrlId).val();
            } else {
              ctrlId = idPrefix + '_' + name + '_sel_' + uniqueIndex;
              return $('#' + ctrlId).val();
            }
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + 'text_' + uniqueIndex;
            var hlpFieldType = 'text';

            // value is array index of arrAttrs store array!
            var hlpAttribute = arrAttrs[value];

            // multidata optionally overwrites value (default) attribute
            var hlpDefault = hlpAttribute.default;
            if (typeof hlpAttribute.multidata != 'undefined' && typeof hlpAttribute.multidata.default != 'undefined') {
              if (
                gblCntMultiName <= hlpAttribute.multidata.default.length &&
                hlpAttribute.multidata.default[gblCntMultiName - 1] != ''
              ) {
                hlpDefault = hlpAttribute.multidata.default[gblCntMultiName - 1];
              } else {
                hlpDefault = hlpAttribute.default;
              }
            } else {
              hlpDefault = hlpAttribute.default;
            }

            // set default value to text input field (even if it is not used!)
            if (typeof hlpAttribute.multi != 'undefined' && hlpAttribute.multi > 1) {
              if (currentEditData.length == 0) {
                $('#' + ctrlId).val(hlpDefault);
              } else {
                $('#' + ctrlId).val(currentEditData[gblAllMulti + gblCntMultiName - 1].attrvalue);
              }
            } else {
              if (currentEditData.length == 0) {
                $('#' + ctrlId).val(hlpDefault);
              } else {
                $('#' + ctrlId).val(currentEditData[gblAllMulti + gblCntMultiName - 1].attrvalue);
              }
            }

            // determine range
            // Case 01 ... range empty -> type specification applies (datatypes.json); generate text field
            if ($.trim(hlpAttribute.range) == '' || Object.keys(hlpAttribute.range).length === 0) {
              var hlpDataType = getDataType(hlpAttribute.type);
              hlpFieldType = 'text';
              $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).prop(
                'title',
                'enter ' + hlpDataType.attr[3] + '-' + hlpDataType.attr[4],
              );
            } else {
              // Case 02 ... range type 'list' -> generate dropdown with given range values
              ctrlId = idPrefix + '_' + name + '_sel_' + uniqueIndex;
              if (hlpAttribute.range.type.toLowerCase() == 'list') {
                hlpFieldType = 'sel';
                //$("#" + ctrlId).append($("<option>").attr('value',-1).text("please select"));
                $(hlpAttribute.range.values).each(function(i, item) {
                  if (item.toString().indexOf('|') > -1) {
                    var arrRangeSplit = item.split('|');
                    arrRangeSplit[0] = arrRangeSplit[0].replace(handleEscStr('ESC', ','), ',');
                    $('#' + ctrlId).append($('<option>').attr('value', arrRangeSplit[1]).text(arrRangeSplit[0]));
                  } else {
                    item = item.replace(handleEscStr('ESC', ','), ',');
                    $('#' + ctrlId).append($('<option>').attr('value', i).text(item));
                  }
                });
              }
              // Case 03 ... range type 'loop' -> generate dropdown from start/end/step values
              if (hlpAttribute.range.type.toLowerCase() == 'loop') {
                hlpFieldType = 'sel';
                //$("#" + ctrlId).append($("<option>").attr('value',-1).text("please select"));
                var hlpCnt = 0;
                for (
                  var i = hlpAttribute.range.values[0];
                  i <= hlpAttribute.range.values[1];
                  i += hlpAttribute.range.values[2]
                ) {
                  $('#' + ctrlId).append($('<option>').attr('value', hlpCnt).text(i));
                  hlpCnt++;
                }
              }
              // Case 04 ... tooltip_loop
              if (hlpAttribute.range.type.toLowerCase() == 'tooltip_loop') {
                hlpFieldType = 'text';
                var hlpTitle = '';
                if (hlpAttribute.type == 'BOOL') {
                  hlpTitle = 'enter 0 for FALSE and 1 for TRUE';
                } else {
                  hlpTitle =
                    'enter ' +
                    hlpAttribute.range.values[0] +
                    '-' +
                    hlpAttribute.range.values[1] +
                    ' in steps of ' +
                    hlpAttribute.range.values[2];
                }
                $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).prop('title', hlpTitle);
              }

              // set value of dropdown - ONLY if visible field is of type 'sel'
              if (hlpFieldType == 'sel') {
                if (typeof hlpAttribute.multi != 'undefined' && hlpAttribute.multi > 1) {
                  if (currentEditData.length == 0) {
                    setSelectByValue(ctrlId, hlpDefault);
                  } else {
                    setSelectByValue(ctrlId, currentEditData[gblAllMulti + gblCntMultiName - 1].attrvalue);
                  }
                } else {
                  if (currentEditData.length == 0) {
                    setSelectByValue(ctrlId, hlpDefault);
                  } else {
                    setSelectByValue(ctrlId, currentEditData[gblAllMulti + gblCntMultiName - 1].attrvalue);
                  }
                }
              }
            }

            // if value is read-only, show text field
            if (hlpAttribute.edit == 0 || hlpAttribute.edit == 2 || hlpAttribute.edit == 4) {
              $('#' + idPrefix + '_' + name + '_' + 'sel_' + uniqueIndex).hide();
              //$('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).attr({ style: "background:#FF0000" });

              if (typeof hlpAttribute.colorReadOnly != 'undefined') {
                $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                  'background-color',
                  hlpAttribute.colorReadOnly,
                );
              } else {
                $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                  'background-color',
                  configData.colors.colorReadOnly,
                );
              }

              if (typeof hlpAttribute.colorTextReadOnly != 'undefined') {
                $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                  'color',
                  hlpAttribute.colorTextReadOnly,
                );
              } else {
                $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                  'color',
                  configData.colors.colorTextReadOnly,
                );
              }

              $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).prop('readonly', true);
            } else {
              // hide unused control type
              if (hlpFieldType == 'text') {
                $('#' + idPrefix + '_' + name + '_' + 'sel_' + uniqueIndex).hide();

                if (typeof hlpAttribute.colorEdit != 'undefined') {
                  $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                    'background-color',
                    hlpAttribute.colorEdit,
                  );
                } else {
                  $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                    'background-color',
                    configData.colors.colorEdit,
                  );
                }

                if (typeof hlpAttribute.colorTextEdit != 'undefined') {
                  $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css('color', hlpAttribute.colorTextEdit);
                } else {
                  $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).css(
                    'color',
                    configData.colors.colorTextEdit,
                  );
                }
              } else {
                $('#' + idPrefix + '_' + name + '_' + 'text_' + uniqueIndex).hide();
              }
            }
          },
        },
        {
          name: 'attrunit',
          display: 'Unit',
          type: 'custom',
          ctrlCss: { width: '20px' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = document.createElement('span');
            $(ctrl).attr({ id: ctrlId, name: ctrlId }).appendTo(parent);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).html();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;

            // value is array index of arrAttrs store array!
            var hlpAttribute = arrAttrs[value];

            // set Unit to Type if unit not in RAP
            if (typeof hlpAttribute.unit != 'undefined' && hlpAttribute.unit != '') {
              $('#' + ctrlId).html(hlpAttribute.unit);
            } else {
              $('#' + ctrlId).html(hlpAttribute.type);
            }
          },
        },
        {
          name: 'attrGSDcomment',
          display: 'Comment',
          type: 'custom',
          ctrlCss: { width: '80px' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = document.createElement('input');
            ctrl.type = 'text';
            $(ctrl).attr({ id: ctrlId, name: ctrlId }).appendTo(parent);
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).val();
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var hlpAttribute = arrAttrs[value];

            // multidata optionally overwrites value (default) attribute
            var hlpComment = typeof hlpAttribute.comment != 'undefined' ? hlpAttribute.comment : '';
            if (typeof hlpAttribute.multidata != 'undefined' && typeof hlpAttribute.multidata.comment != 'undefined') {
              if (
                gblCntMultiName <= hlpAttribute.multidata.comment.length &&
                hlpAttribute.multidata.comment[gblCntMultiName - 1] != ''
              ) {
                hlpComment = hlpAttribute.multidata.comment[gblCntMultiName - 1];
              } else {
                hlpComment = hlpAttribute.comment;
              }
            } else {
              hlpComment = hlpAttribute.comment;
            }

            // set comment as title if exists (to show long comments as tooltip)
            // ToDo: set title also for user comments - not only for comments from RAP file
            if (hlpComment != '') {
              $('#' + ctrlId).prop('title', hlpComment);
            }

            if (currentEditData.length == 0) {
              if (hlpComment != '') {
                $('#' + ctrlId).val(hlpComment);
              }
            } else {
              $('#' + ctrlId).val(currentEditData[gblAllMulti + gblCntMultiName - 1].attrGSDcomment);
            }
          },
        },
        {
          name: 'attrexport',
          display: 'Export',
          /*
				displayTooltip: {
                    items: 'td',
                    content: 'ALL, NONE or INVERT with right mouse button',
					position: { my: "center", at: "top center" }
				},
				*/

          type: 'custom',
          ctrlCss: { width: '25px' },
          displayCss: { 'text-align': 'center' },
          customBuilder: function(parent, idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            var ctrl = document.createElement('input');
            ctrl.type = 'checkbox';
            $(ctrl).attr({ id: ctrlId, name: ctrlId }).appendTo(parent);
            $(ctrl).parent().css({ 'text-align': 'center' }); // center checkbox in cell
            return ctrl;
          },
          customGetter: function(idPrefix, name, uniqueIndex) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;
            return $('#' + ctrlId).prop('checked');
          },
          customSetter: function(idPrefix, name, uniqueIndex, value) {
            var ctrlId = idPrefix + '_' + name + '_' + uniqueIndex;

            // value is array index of arrAttrs store array!
            var hlpAttribute = arrAttrs[value];

            // set value
            var hlpBoolValue = true;
            if (typeof hlpAttribute.export != 'undefined' && hlpAttribute.export == false) {
              hlpBoolValue = false;
            }

            if (currentEditData.length == 0) {
              $('#' + ctrlId).prop('checked', hlpBoolValue);
            } else {
              $('#' + ctrlId).prop('checked', currentEditData[gblAllMulti + gblCntMultiName - 1].attrexport);
            }
          },
        },
        { name: 'attrindex', display: '', type: 'text', invisible: true },
        { name: 'attrhidden', display: '', type: 'text', invisible: true },
        { name: 'attrGSDname', display: '', type: 'text', invisible: true },
        { name: 'attrGSDtype', display: '', type: 'text', invisible: true },
        { name: 'attrGSDrangeValue', display: '', type: 'text', invisible: true },
        { name: 'attrGSDrangeType', display: '', type: 'text', invisible: true },
        { name: 'attrGSDtags', display: '', type: 'text', invisible: true },
        { name: 'attrGSDmaxsize', display: '', type: 'text', invisible: true },
        { name: 'attrGSDoffset', display: '', type: 'text', invisible: true },
        { name: 'attrGSDmulti', display: '', type: 'text', invisible: true },
        { name: 'attrmulticount', display: '', type: 'text', invisible: true },
      ],
      hideButtons: {
        insert: true,
        remove: true,
        append: true,
        removeLast: true,
        moveUp: true,
        moveDown: true,
      },
    });

    // store and fill initial text templates -
    tmplEmptyDragTable = $('#dragTable').html();

    //
    // Initial function calls
    //

    // set default language
    currentLang = configData.misc.languageDefault.toLowerCase();
    refreshLanguage();

    // set intial project info
    setProjectInfo(lookupLanguage(currentLang, 'lblProjectInfo02'), lookupLanguage(currentLang, 'lblProjectInfo04'));

    // activate autosafe
    var hlpAutosaveMin = getAutosaveMin();
    if (hlpAutosaveMin != 0) {
      timerAutoSave = setInterval(function() {
        doAutoSave();
      }, hlpAutosaveMin * 60000); // min --> milliseconds
    }

    // start Action handling (create compare file projects/.tmpLastProjectDevices.json)
    AjaxRunActions(false, true, false); //Parameters: NO reset, DO start, NO show response

    // establish all handlers that need to be refreshed
    refreshHandlers();
    // render Datatable
    refreshDataTable();
    // create Delegates
    createDelegates();
    // establish delegates
    refreshDelegates();

    //
    // prevent dragtable images from being dragged
    //
    $(document).on('dragstart', 'img', function(event) {
      event.preventDefault();
    });

    // set initial display size
    $('#selDisplaySize').val('300'); // native size of images!

    // Helper functions
    /*
	function confirmExitIfModified() {
		// don't trigger browser-internal confirm on events with
		// own confirm dialog
		if ((swtIsDirty == true) && (confirmMode == "")) {
			return "";
		} else {
			confirmMode = "";
		}
	}
	*/

    // Test functions
    // currently not used
    function getVersionList(inpType) {
      var retOptions;
      var tmplOptions = '<option value=\'##VAL##\'>##TEXT##</option>';

      var arr1 = [
        { val: 1, text: 'One' },
        { val: 2, text: 'Two' },
        { val: 3, text: 'Three' },
      ];

      var arr2 = [
        { val: 1, text: 'A' },
        { val: 2, text: 'B' },
        { val: 3, text: 'C' },
      ];

      var arr = inpType == 'tblData_version_1' ? arr1 : arr2;

      $(arr).each(function() {
        retOptions += tmplOptions;
        retOptions = retOptions.replace('##VAL##', this.val);
        retOptions = retOptions.replace('##TEXT##', this.text);
      });

      return retOptions;
    }

    //
    // Trapping ENTER button
    // TODO: handle this if cursor is on specific elements!
    $(document).keypress(function(e) {
      if (e.which == 13) {
        //alert('Pressed ENTER button!');
      }
    });

    // loading Start config
    // if (configData.misc.userMode == 'STANDARD') {
    // :
    // we now load the Start config in STANDARD mode also ... ???
    if (1 == 1) {
      if (fileExists(configData.paths.projects + '_config.rsc') == false) {
        WriteLog('no start config: _config.rsc ');
      }

      cntAppendedDevices = 0;
      var projectData = AjaxGetJSON(configData.paths.projects + '_config.rsc', 'OBJ');

      if (projectData != 'ERR_NO_DATA') {
        if (typeof projectData.App.version != 'undefined' && checkRSCversion(projectData.App.version) == false) {
          // InfoDialog is not yet available here - so we use alert instead!
          alert(GetErrorText('ERR_PROJECT_FILE_NEWER', currentLang, 'short'));
          return;
        }
      }

      // reset dragtable to empty
      resetAll();

      if (projectData != 'ERR_NO_DATA') {
        $(projectData.Devices).each(function(cntDevices, deviceItem) {
          appendDevice(deviceItem);
          currentMarkedDeviceId = deviceItem.id;
          cntAppendedDevices++;
        });
      }

      // this restores rules of devices and checks them AFTER ALL devices have been appended
      var cntRulesErrors = 0;
      $(projectData.Devices).each(function(cntDevices, deviceItem) {
        var retRules = checkRules(deviceItem.id, '');
        if (retRules != 'OK') {
          alert(GetErrorText(retRules, currentLang, 'short'));
          cntRulesErrors++;
        }
      });

      if (cntRulesErrors > 0) {
        alert('=IMPORTANT= Project file violates at least one rule and may be unusable!');
      }

      expandDragTable('PAD_EDGES', 0);
      refreshDataTable();
      refreshHandlers();
      refreshDelegates();

      setMarkedDevice(currentMarkedDeviceId); // mark last device
      setProjectInfo('config', getProjectFileLastSaved('_config', 'd.m.Y H:i:s'));

      // connection data
      connectionStore = []; // reset!

      if (projectData != 'ERR_NO_DATA') {
        setTimeout(function() {
          // do this in timeout to synchronize with loading of EditStore-Data
          // without timeout, EditStore-Data is not yet available at this point!
          $(projectData.Connections).each(function(cntConn, connItem) {
            handleConnections(
              '',
              connItem.srcGUID,
              connItem.destGUID,
              connItem.srcInpVariant + '|' + connItem.srcOutVariant,
              connItem.destInpVariant + '|' + connItem.destOutVariant,
              connItem.srcRAPname + '-$-' + connItem.srcMulticount,
              connItem.destRAPname + '-$-' + connItem.destMulticount,
              'ADD',
            );
          });
        }, 1);

        // set language
        if (typeof projectData.App.language != 'undefined') {
          currentLang = projectData.App.language;
          refreshLanguage();
        }

        // set layout
        window.startState = projectData.App.layout;
        mainLayout.loadState(startState, { animateLoad: true });
      }

      mainLayout.close('east'); // force east area closed!
    }

    // show all GUI parts that where hidden in index.html with display:none
    // because they would otherwise show up while blockUI is showing its loading overlay!
    $('#main-menu').show();
    $('#layout_center').show();
    $('#layout_west').show();
    $('#layoutTest').show();
    $('#layoutHelp').show();
    $('#layoutLog').show();

    // version checking - if PiCtory has been updated lately, we display
    // an alert window, that the user needs to clear his browser cache!
    var hlpCookieLastPiCtoryVersion = Cookies.get('KUNBUS_RevPiLastPiCtoryVersion');
    if ((typeof hlpCookieLastPiCtoryVersion != 'undefined') && (hlpCookieLastPiCtoryVersion != configData.version)) {

      var infoTextHTML = '<span style=\'color:#ff0000; font-size:large\'>-PiCtory- has been updated since last usage<br><strong>PLEASE CLEAR YOUR BROWSER CACHE!</strong></span>' +
        '<br>&nbsp;<br>' +
        '<span style=\'font-size:small\'>Find more detailed info about cache clearing here:<br>' +
        '<b><a href=\'https://en.wikipedia.org/wiki/Wikipedia:Bypass_your_cache\' target=\'_blank\'>https://en.wikipedia.org/wiki/Wikipedia:Bypass_your_cache</a></b></span>';

      // Important: we need to call this dialog with a short timeout to let the browser have
      // all initial paintings done. If we DON'T do this, the dialog will not appear!
      setTimeout(function() {
        createInfoDialog('Important', infoTextHTML, '{"width":700, "height":250}');
      }, 500);

    }

    // write new version to cookie
    Cookies.set('KUNBUS_RevPiLastPiCtoryVersion', configData.version, { expires: new Date('2038-01-19T04:14:07'), secure: true });

    // remove Cache cookie; cookie forces no-cache on reload via menu
    Cookies.remove('KUNBUS_PiCtory_Cache');
  }, 500); // end of setTimeout(function(){
});
// end of $(function() ...

// -----------------------------------------------------------------
// GLOBAL FUNCTIONS
// functions in global scope to allow calls from external .js files
// -----------------------------------------------------------------
/* 	=====================================================================
/	reset function to call when new project is to be started
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function resetAll() {
  cntAppendedDevices = 0;
  clearDragTable();
  clearDataTable();
  clearEditTable();
  clearStoreTables('');
  rulesStore = [];
  modifyStore = [];
  refreshHandlers();
  refreshDelegates();
}

/* 	=====================================================================
/	central refresh of all delegates for dynamically created DOM elements
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/

// Function to universally adjust icon styles based on original size
function adjustIconStyle($img) {
  // Get the natural (original) width/height of the image
  var originalWidth = $img[0].naturalWidth;
  var originalHeight = $img[0].naturalHeight;

  // Scale so that the icon is 24px tall
  var scale = 24 / originalHeight;
  var scaledWidth = originalWidth * scale;   // new width

  // We want icon width + left margin + right margin = 44px total
  var totalWidth = 44;
  var marginSize = (totalWidth - scaledWidth) / 2;

  // Enforce a minimum margin to avoid negatives (e.g., 3px)
  marginSize = Math.max(marginSize, 3);

  // Apply the calculated size and margins
  $img.css({
    'width': scaledWidth + 'px',
    'height': '24px',
    'margin-left': marginSize + 'px',
    'margin-right': marginSize + 'px',
  });
}

function refreshDelegates() {
  // change cursor to pointer (hand) on every droptable header
  $('th[data-header]').css('cursor', 'pointer');
  $('th[data-header]').prop('title', 'click and drag to move column ...');

  // capture Ctrl Key
  $(document).unbind('keydown');
  $(document).keydown(function(event) {
    if (event.which == '17') {
      ctrlIsPressed = true;
    }
  });
  $(document).unbind('keyup');
  $(document).keyup(function() {
    ctrlIsPressed = false;
  });

  // set isDirty delegate for all input fields
  $(':input').change(function() {
    if (!swtIsDirty) {
      swtIsDirty = true;
      //WriteLog('IsDirty set!');
    }
  });

  // DataTable
  //

  $('[id^=\'tblData_Row\']').off();
  /* activate this to have a visible hover effect on tblData row
	$("[id^='tblData_Row']").hover(function(e) {
		e.preventDefault();
		e.stopPropagation();

		$(this).children("td").each(function() {
			$(this).toggleClass('ui-widget-content');
			$(this).toggleClass('ui-state-focus');
		});
	});
	*/

  // toggle row on click - unmark all other rows when row marked
  $('[id^=\'tblData_Row\']').on('click', function(e) {
    WriteLog('Row_Click: ' + $(this).attr('id'));

    // no prevents - or checkboxes will not work!
    //e.preventDefault();
    e.stopPropagation();

    // do final validation of all attributes of device
    // validation code contained in optional .val file!
    var retValidateAllAttr = validateAllAttr();
    if (retValidateAllAttr != 'OK') {
      //alert(retValidateAllAttr);
      createInfoDialog('Error', '<br>' + retValidateAllAttr, '');
      return false;
    }

    // deselect all other rows!
    var tmpId = $(this).attr('id');
    $('[id^=\'tblData_Row_\']').each(function() {
      if (tmpId != $(this).attr('id')) {
        $(this)
          .children('td')
          .each(function() {
            $(this).removeClass('ui-widget-content');
            $(this).removeClass('ui-state-error');
          });
      }
    });

    // toggle clicked row
    var rowMarked = false;
    $(this)
      .children('td')
      .each(function() {
        $(this).toggleClass('ui-widget-content');
        $(this).toggleClass('ui-state-error');
        rowMarked = $(this).hasClass('ui-state-error');
      });

    // mark device in workarea - only if click didn't UNmark row
    var hlpDeviceId = $('#tblData').appendGrid('getCtrlValue', 'deviceId', $(this).index());
    $('[id^=\'device_\']').each(function() {
      $(this).removeClass('moduleSelected');
    });

    if (rowMarked == true) {
      $('#' + hlpDeviceId).addClass('moduleSelected');

      // load values into value editor table!
      //alert("row marked:" + hlpDeviceId);
      currentMarkedDeviceId = hlpDeviceId;

      // UI blocking & loader overlay
      blockUI(1);

      setTimeout(function() {
        loadValues(currentMarkedDeviceId, '');
      }, 55);
    } else {
      // but remember that device was marked and store data
      handleTableData('tblEdit', hlpDeviceId, 'STORE');
      // hide Value Table if no device is marked ...
      displayTblEdit('HIDE');
    }
  });

  // Validation events!

  // tblData
  // validate fields on blur

  // setting handlers to off prevents registering multiple handlers!
  $('[id^=\'tblData_modulname\']').off();
  $('[id^=\'tblData_bmk\']').off();
  $('[id^=\'tblData_comment\']').off();
  $('[id^=\'tblData_input\']').off();
  $('[id^=\'tblData_output\']').off();

  $('input[id^=\'tblData_\']').on('click', function(e) {
    // IMPORTANT: this prevents rows from being marked/unmarked by simply clicking on contained input fields!
    e.preventDefault();
    e.stopPropagation();
  });
  $('select[id^=\'tblData_\']').on('click', function(e) {
    // IMPORTANT: this prevents rows from being marked/unmarked by simply clicking on contained select fields!
    e.preventDefault();
    e.stopPropagation();
  });

  $('[id^=\'tblData_modulname\'], [id^=\'tblData_bmk\'], [id^=\'tblData_comment\']').on('focus', function(e) {
    oldValue = $(this).val();
    e.preventDefault();
    e.stopPropagation();
    //WriteLog("marked device: " + currentMarkedDeviceId + "/" + getRowIndexOfDevice(currentMarkedDeviceId) + "/" + getUniqueIndexOfDevice(currentMarkedDeviceId));
    //trigger only if row is not yet marked!
    if (!$(this).parent().hasClass('ui-state-error')) {
      $(this).parent().trigger('click');
    }
  });

  $('[id^=\'tblData_modulname\'], [id^=\'tblData_bmk\'], [id^=\'tblData_comment\']').on('change', function(e) {
    // IMPORTANT
    // this change event is called twice: for the -tblData_modulname_...- input fields
    // and for their containing -tblData_modulname_td_...- table cells
    // Validation must only be called for input field!!

    if ($(this).attr('id').indexOf('_td_') == -1) {
      var retValidateTable = validateTable($(this).attr('id'));
      if (retValidateTable != 'OK') {
        //alert(retValidateTable);
        createInfoDialog('Error', '<br>' + retValidateTable, '');
        var hlpId = $(this).attr('id');
        setTimeout(function() {
          $('#' + hlpId).focus();
        }, 0);
        $(this).val(oldValue);
      } else {
        handleTableData('tblData', '', 'STORE');
      }
    }
  });

  $('[id^=\'tblData_input\'], [id^=\'tblData_output\']').on('focus', function(e) {
    if ($(this).attr('id').indexOf('_td_') == -1) {
      oldValue = $(this).val();
      e.preventDefault();
      e.stopPropagation();
      if (!$(this).parent().hasClass('ui-state-error')) {
        $(this).parent().trigger('click');
      }
    }
  });

  $('[id^=\'tblData_input\'], [id^=\'tblData_output\']').on('change', function(e) {
    if ($(this).attr('id').indexOf('_td_') == -1) {
      // check if connections have been set - show warning, that changing variant
      // will remove all connections of referenced device!
      var hlpGUID = getDataStoreData(
        $('#tblData').appendGrid('getCtrlValue', 'deviceId', getRowIndexOfControl($(this).attr('id'), 'tblData')),
        '##GUID##',
      );
      if (
        handleConnections('', hlpGUID, '', '', '', '', '', 'EXISTS') == true ||
        handleConnections('', '', hlpGUID, '', '', '', '', 'EXISTS') == true
      ) {
        if (confirm('Connections from and to this device will be removed - please confirm!') == false) {
          setSelectByValue($(this).attr('id'), oldValue);
          return;
        } else {
          handleConnections('', hlpGUID, '', '', '', '', '', 'REMOVE');
          handleConnections('', '', hlpGUID, '', '', '', '', 'REMOVE');
        }
      }

      var retValidateTable = validateTable($(this).attr('id'));
      if (retValidateTable != 'OK') {
        //alert(retValidateTable);
        createInfoDialog('Error', '<br>' + retValidateTable, '');
      } else {
        var hlpRowIndex = getRowIndexOfControl($(this).attr('id'), 'tblData');
        var hlpDeviceId = $('#tblData').appendGrid('getCtrlValue', 'deviceId', hlpRowIndex);

        // Sync IO if rules apply
        var swtRuleApplied = false;
        var posLastDelim = getPosDelimiter($(this).attr('id'), '_', 'LAST');
        var setIO = -1;
        if ($(this).attr('id').indexOf('_input_') > -1) {
          setIO = getRule(hlpDeviceId, 'IO', $(this).val(), '');
          if (setIO > -1) {
            setSelectByValue(
              'tblData_output_' +
              $(this)
                .attr('id')
                .substr(posLastDelim + 1),
              setIO,
            );
            swtRuleApplied = true;
          }
        }

        if ($(this).attr('id').indexOf('_output_') > -1) {
          setIO = getRule(hlpDeviceId, 'IO', '', $(this).val());
          if (setIO > -1 && swtRuleApplied == false) {
            setSelectByValue(
              'tblData_input_' +
              $(this)
                .attr('id')
                .substr(posLastDelim + 1),
              setIO,
            );
          }
        }

        handleTableData('tblData', '', 'STORE');

        loadValues($('#tblData').appendGrid('getCtrlValue', 'deviceId', hlpRowIndex), '');
      }
    }
  });

  // tblEdit
  // validate fields on change
  $(
    '[id^=\'tblEdit_attrname\'],[id^=\'tblEdit_attrvalue_text\'],[id^=\'tblEdit_attrvalue_sel\'],[id^=\'tblEdit_attrGSDcomment\']',
  ).on('focus', function(e) {
    oldValue = $(this).val();
  });

  $(
    '[id^=\'tblEdit_attrname\'],[id^=\'tblEdit_attrvalue_text\'],[id^=\'tblEdit_attrvalue_sel\'],[id^=\'tblEdit_attrGSDcomment\'],[id^=\'tblEdit_attrexport\']',
  ).on('change', function(e) {
    var invalidChars = ['\'', '"'];

    // IMPORTANT
    // this change event is called twice: for the -tblData_modulname_...- input fields
    // and for their containing -tblData_modulname_td_...- table cells
    // Validation must only be called for input field!!
    if ($(this).attr('id').indexOf('_td_') == -1) {
      // existing Dest connections must be removed if user sets 'export' flag on value!
      if ($(this).attr('id').indexOf('tblEdit_attrexport') != -1 && $(this).prop('checked') == true) {
        var hlpAttrname = $('#tblEdit').appendGrid(
          'getCtrlValue',
          'attrname',
          getRowIndexOfControl($(this).attr('id'), 'tblEdit'),
        );
        if (handleConnections('', '', '', '', '', '', hlpAttrname, 'EXISTS') == true) {
          if (confirm('Connections from and to this device will be removed - please confirm!') == false) {
            $(this).prop('checked', false);
            return;
          } else {
            handleConnections('', '', '', '', '', '', hlpAttrname, 'REMOVE');
          }
        }
      }

      // prevent input of special characters like ' and "
      // before even trying to do additional validation
      if (
        $(this).attr('id').indexOf('tblEdit_attrname') > -1 ||
        $(this).attr('id').indexOf('tblEdit_attrGSDcomment') > -1 ||
        $(this).attr('id').indexOf('tblEdit_attrvalue_text') > -1
      ) {
        //loop over invalid characters ...
        var errFound = false;
        var hlpId = $(this).attr('id');
        $.each(invalidChars, function(i, item) {
          if (
            $('#' + hlpId)
              .val()
              .indexOf(item) > -1
          ) {
            //alert(GetErrorText("ERR_CHAR_NOT_ALLOWED", currentLang, "short"));
            createInfoDialog('Error', '<br>' + GetErrorText('ERR_CHAR_NOT_ALLOWED', currentLang, 'short'), '');
            $('#' + hlpId).val(oldValue);
            setTimeout(function() {
              $('#' + hlpId).focus();
            }, 0);
            errFound = true;
            return false;
          }
        });
        if (errFound == true) {
          return;
        }
      }

      // trim text input fields before validation
      // ONLY for non STRING types (strings may possibly begin with blanks ...)
      var attrIndex = $('#tblEdit').appendGrid(
        'getCtrlValue',
        'attrindex',
        getRowIndexOfControl($(this).attr('id'), 'tblEdit'),
      );
      var hlpAttribute = arrAttrs[attrIndex];
      if (
        $(this).attr('id').indexOf('tblEdit_attrname') > -1 ||
        $(this).attr('id').indexOf('tblEdit_attrGSDcomment') > -1 ||
        ($(this).attr('id').indexOf('tblEdit_attrvalue_text') > -1 && hlpAttribute.type != 'STRING')
      ) {
        $(this).val($.trim($(this).val()));
      }

      var retValidateTable = validateTable($(this).attr('id'));
      if (retValidateTable != 'OK') {
        //alert(retValidateTable);
        createInfoDialog('Error', '<br>' + retValidateTable, '');
        var hlpId = $(this).attr('id');
        setTimeout(function() {
          $('#' + hlpId).focus();
        }, 0);
        // IMPORTANT: 	this is a workaround for firefox bug
        //				Firefox is unable to handle oldValue of dropdwon correctly
        //				after alert has been shown; oldValue is overwritten
        //				by new value already for unknown reason; so if both
        //				values are the same after alert, we set dropdown back
        //				to 0 value ... this may not always be correct but is better
        // 				than keeping the oldValue that caused the error!
        if (hlpId.indexOf('tblEdit_attrvalue_sel') > -1) {
          // for dropdowns only
          if ($(this).val() == oldValue) {
            $(this).val(0);
          } else {
            $(this).val(oldValue);
          }
        } else {
          // for normal input fields
          $(this).val(oldValue);
        }
      } else {
        handleTableData('tblEdit', currentMarkedDeviceId, 'STORE');
      }
    }
  });

  // Devices in workarea
  //

  // toggle mark on click - unmark all other devices
  $('[id^=\'device_\']').off();
  $('[id^=\'device_\']').on('click', function(e) {
    e.preventDefault();
    e.stopPropagation();

    // do final validation of all attributes of device
    // validation code contained in optional .val file!
    var retValidateAllAttr = validateAllAttr();
    if (retValidateAllAttr != 'OK') {
      //alert(retValidateAllAttr);
      createInfoDialog('Error', '<br>' + retValidateAllAttr, '');
      return false;
    }

    // RETURN if Ctrl-Button ist pressed -> clicking done to manage connections!
    // only if enabled in config!
    if (typeof configData.misc.enableConnections != 'undefined' && configData.misc.enableConnections == true) {
      if (ctrlIsPressed == true) {
        if (handleMarkForConnecting(getDataStoreData($(this).attr('id'), '##GUID##')) == true) {
          fillDialog_connection(markedForConnecting[0], markedForConnecting[1]);
          createConnectionDialog('');
        }
        return;
      }
    }

    var clickedDeviceId = $(this).attr('id');

    // unmark all other devices!
    var tmpId = $(this).attr('id');
    $('[id^=\'device_\']').each(function() {
      if (tmpId != $(this).attr('id')) {
        $(this).removeClass('moduleSelected');
      }
    });
    // toggle clicked device
    $(this).toggleClass('moduleSelected');

    // mark row in dataTable
    var tblColumnId = getContainingTableColumn($(this).attr('id'), 'IGNORE_UNUSED');
    var hlpUniqueIndex = $('#tblData').appendGrid('getUniqueIndex', tblColumnId);
    // unmark all rows
    $('[id^=\'tblData_Row_\']').each(function() {
      $(this)
        .children('td')
        .each(function() {
          $(this).removeClass('ui-widget-content');
          $(this).removeClass('ui-state-error');
        });
    });

    // mark matching row - only if click didn't UNmark device!
    if ($(this).hasClass('moduleSelected')) {
      $('#tblData_Row_' + hlpUniqueIndex)
        .children('td')
        .each(function() {
          $(this).addClass('ui-widget-content');
          $(this).addClass('ui-state-error');
        });

      //alert("device marked: " + clickedDeviceId);

      // load values into value editor table!
      currentMarkedDeviceId = clickedDeviceId;
      //alert(markedDeviceId);

      // UI blocking & loader overlay
      blockUI(2);

      setTimeout(function() {
        loadValues(currentMarkedDeviceId, '');
      }, 55);
    } else {
      // remember that device was marked and store data
      handleTableData('tblEdit', clickedDeviceId, 'STORE');
      // hide Value Table if no device is marked ...
      displayTblEdit('HIDE');
      currentMarkedDeviceId = '';
    }
  });
}

/* 	=====================================================================
/	combined refresh of all handler functions
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function refreshHandlers() {
  createDroppables();
  createContextMenues();
}

/* 	=====================================================================
/	make dragtable cells droppable
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function createDroppables() {
  $('.dropCell').droppable({
    drop: function(event, ui) {
      // check session to prevent timeout after extensive adding of devices
      if (checkSession(revPiHostname) == false) {
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
        //window.location.href = configData.paths.login;
        return;
      }
      refreshLoginCookies(sessionExpireMin, revPiHostname);

      if (typeof $(ui.helper).data('ftSourceNode') != 'undefined') {
        var nodeKey = $(ui.helper).data('ftSourceNode').key;
      } else {
        return false;
      }

      var appendedDeviceId = appendDeviceGUI(nodeKey, $(this), true);
    },
  });
}

/* 	=====================================================================
/	create context menus for images in dragtable cells
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function createContextMenues() {
  $('body').contextmenu({
    delegate: '[id^=\'device_\']',
    preventContextMenuForPopup: true,
    menu: [
      {
        title: lookupLanguage(currentLang, 'cMenu_InsertColumnLeft'),
        cmd: 'insert_left',
        uiIcon: 'ui-icon-arrowthickstop-1-w',
      },
      {
        title: lookupLanguage(currentLang, 'cMenu_InsertColumnRight'),
        cmd: 'insert_right',
        uiIcon: 'ui-icon-arrowthickstop-1-e',
      },
      {
        title: lookupLanguage(currentLang, 'cMenu_ResetData'),
        cmd: 'reset_data',
        uiIcon: 'ui-icon-arrowreturnthick-1-w',
      },
      { title: lookupLanguage(currentLang, 'cMenu_Delete'), cmd: 'delete', uiIcon: 'ui-icon-trash' },
      // ACTIVATE IF DRIVER CAN HANDLE INACTIVE DEVICES
      //{title: lookupLanguage(currentLang, "cMenu_ToggleStatusSetInactive"), cmd: "toggle_status", uiIcon: "ui-icon-check"},
      { title: lookupLanguage(currentLang, 'cMenu_ShowDatasheet'), cmd: 'show_datasheet', uiIcon: 'ui-icon-document' },
      {
        title: lookupLanguage(currentLang, 'cMenu_ExtendedData'),
        cmd: 'show_extendedData',
        uiIcon: 'ui-icon-document',
      },
    ],
    beforeOpen: function(event, ui) {
      // check session on each attempt to open context menu
      if (configData.misc.userMode == 'STANDARD') {
        if (checkSession(revPiHostname) == false) {
          createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
          //window.location.href = configData.paths.login;
          return;
        }
        refreshLoginCookies(sessionExpireMin, revPiHostname);
      }

      // disable 'delete' and 'toggle_status' options on BASE devices!
      if (getDeviceType(ui.target.attr('id').replace('device_', '')) == 'BASE') {
        $('body').contextmenu('enableEntry', 'delete', false);
        $('body').contextmenu('enableEntry', 'toggle_status', false);
      } else {
        $('body').contextmenu('enableEntry', 'delete', true);
        $('body').contextmenu('enableEntry', 'toggle_status', true);
      }

      // toggle 'toggle_status' title
      if ($('#' + ui.target.attr('id')).css('opacity') == 0.3) {
        $('body').contextmenu('setEntry', 'toggle_status', {
          title: lookupLanguage(currentLang, 'cMenu_ToggleStatusSetActive'),
          uiIcon: 'ui-icon-check',
        });
      } else {
        $('body').contextmenu('setEntry', 'toggle_status', {
          title: lookupLanguage(currentLang, 'cMenu_ToggleStatusSetInactive'),
          uiIcon: 'ui-icon-check',
        });
      }

      // disable extended Data Editor for devices withoud e.d.
      var extConfig = getExtendedConfig(getGsdData(ui.target.attr('id'), '##GSD_PRODUCTTYPE##'));
      var pathnameExt = 'err_no_ext.err';
      if (extConfig != '') {
        pathnameExt = 'resources/data/extensions/' + extConfig.dialog + '.js';
        if (fileExists(pathnameExt) == true) {
          $('body').contextmenu('enableEntry', 'show_extendedData', true);
        } else {
          //alert("ERROR: Extension dialog missing ("+ extConfig.dialog +")");
          createInfoDialog('Error', '<br>' + 'Extension dialog missing (' + extConfig.dialog + ')', '');
          $('body').contextmenu('enableEntry', 'show_extendedData', false);
        }
      } else {
        $('body').contextmenu('enableEntry', 'show_extendedData', false);
      }

      /*
			var pathnameExt = configData.paths.gsd.replace("##DEVICE_ID##",parseDeviceId(ui.target.attr('id'),"##ID_VERSION##")).replace(".rap",".ext");
			if (fileExists(pathnameExt) == true) {
				$('body').contextmenu("enableEntry", "show_extendedData", true);
			} else {
				$('body').contextmenu("enableEntry", "show_extendedData", false);
			}
			*/

      // disable certain options not appropriate for VIRTUAL devices
      if (getDeviceType(ui.target.attr('id').replace('device_', '')) == 'VIRTUAL') {
        $('body').contextmenu('enableEntry', 'insert_left', false);
        $('body').contextmenu('enableEntry', 'insert_right', false);
        $('body').contextmenu('enableEntry', 'show_datasheet', false);
      } else {
        $('body').contextmenu('enableEntry', 'insert_left', true);
        $('body').contextmenu('enableEntry', 'insert_right', true);
        $('body').contextmenu('enableEntry', 'show_datasheet', true);
      }

      //WriteLog(ui.target.attr('id'));
    },
    select: function(event, ui) {
      idDeviceContextMenu = ui.target.attr('id');

      if (ui.cmd == 'toggle_status') {
        if ($('#' + idDeviceContextMenu).css('opacity') == 0.3) {
          $('#' + idDeviceContextMenu).css('opacity', 1);
        } else {
          $('#' + idDeviceContextMenu).css('opacity', 0.3);
        }

        $('body').contextmenu('close');
      }

      if (ui.cmd == 'delete') {
        var saveTable = $('#dragTable').html();

        var tblColumnId = getContainingTableColumn(ui.target.attr('id'), '');
        $('#dragTable tr')
          .find('td:eq(' + tblColumnId + '),th:eq(' + tblColumnId + ')')
          .remove();

        // handling of virtual devices - if last v.d. has been removed, remove gap also!
        if ($('.isVirtual').length == 0) {
          $('.virtualGapHeader').remove();
          $('.virtualGap').remove();
        }

        var retPositionAllowed = isPositionAllowed();
        if (retPositionAllowed != 'OK') {
          //alert(retPositionAllowed);
          createInfoDialog('Error', '<br>' + retPositionAllowed, '');
          // revert table to saved state
          $('#dragTable').html(saveTable);
        }

        // check device relations and max devices rules etc.
        // ??????????????????????????????
        var retRules = checkRules(ui.target.attr('id'), tblColumnId);
        if (retRules != 'OK') {
          //alert(GetErrorText(retRules, currentLang, "short"));
          createInfoDialog('Error', '<br>' + GetErrorText(retRules, currentLang, 'short'), '');
          $('#dragTable').html(saveTable);
        }

        removeFromEditStore(ui.target.attr('id'));
        handleExtendedDataStore(ui.target.attr('id'), 'REMOVE');
        rulesStore = handleRulesStore(ui.target.attr('id'), 'REMOVE');
        handleModifyStore(ui.target.attr('id').replace('device_', ''), 'REMOVE');

        clearDataTable();
        refreshDataTable();
        refreshHandlers();
        refreshDelegates();

        // set marked device to base after delete! DOESN'T WORK ???
        //setMarkedDevice(getBaseDeviceId());

        // so we don't mark anything after delete ...
        displayTblEdit('HIDE');
        currentMarkedDeviceId = '';
      }

      if (ui.cmd == 'reset_data') {
        confirmMode = 'RESET_DATA';
        createConfirmDialog(confirmMode);
        $('#dialog_confirm').dialog('open');
      }

      if (ui.cmd == 'insert_left') {
        expandDragTable('INSERT_LEFT', getContainingTableColumn(ui.target.attr('id'), ''));
        clearDataTable();
        refreshDataTable();
        refreshHandlers();
        refreshDelegates();
      }

      if (ui.cmd == 'insert_right') {
        expandDragTable('INSERT_RIGHT', getContainingTableColumn(ui.target.attr('id'), ''));
        clearDataTable();
        refreshDataTable();
        refreshHandlers();
        refreshDelegates();
      }

      if (ui.cmd == 'show_datasheet') {
        showDataSheet(ui.target.attr('id'));
      }

      if (ui.cmd == 'show_extendedData') {
        // check if session is still active to prevent large e.d. editing
        // and drop out of session immediately on save ...
        if (configData.misc.userMode == 'STANDARD') {
          if (checkSession(revPiHostname) == false) {
            //alert("Session expired ...");
            createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
            //window.location.href = configData.paths.login;
            return;
          }
          refreshLoginCookies(sessionExpireMin, revPiHostname);
        }

        blockUI(4);
        var hlpProductType = getGsdData(ui.target.attr('id'), '##GSD_PRODUCTTYPE##');

        // IMPORTANT:
        // if device with extended data has been saved to .RSC file without ever filling data
        // into ext-dialog popup window, on loading the .RSC file there don't exist any
        // data for this device in 'extend' section ----> no entry will be will created in
        // extendedDataStore for this device on loading!
        // In this case an empty entry is created on the first attempt to open the ext dialog
        if (handleExtendedDataStore(ui.target.attr('id'), 'GET_ENTRY') == '') {
          var hlpProductType = getGsdData(ui.target.attr('id'), '##GSD_PRODUCTTYPE##');
          var extConfig = getExtendedConfig(hlpProductType);
          var pathnameExt = 'err_no_ext.err';
          if (extConfig != '') {
            pathnameExt = 'resources/data/extensions/' + extConfig.dialog + '.js';
            var hlpDeviceId = ui.target.attr('id');
            if (fileExists(pathnameExt) == true) {
              // read with ajax async:false since getScript is always async
              $.ajax({
                url: pathnameExt,
                async: false,
                cache: true,
                dataType: 'script',
              });
              extendedDataStore.push(new extendedData(hlpDeviceId, createGUID(), hlpProductType));
            } else {
              //alert("ERROR: Extension dialog missing ("+ extConfig.dialog +")");
              createInfoDialog('Error', '<br>' + 'Extension dialog missing (' + extConfig.dialog + ')', '');
            }
          }
        }

        handleExtendedDataStore(ui.target.attr('id'), 'GET_ENTRY').loadDialog();
      }

      WriteLog('select ' + ui.cmd + ' on ' + ui.target.attr('id'));
    },
  });

  // create new instance of contextmenu widget to add a second c.m. to the same element (body)
  $.widget('moogle.contextmenu2', $.moogle.contextmenu, {});
  $('body').contextmenu2({
    delegate: '#tblEdit_attrexport_td_head',
    preventContextMenuForPopup: true,
    menu: [
      { title: lookupLanguage(currentLang, 'cMenuExport_MarkAll'), cmd: 'mark_all', uiIcon: 'ui-icon-check' },
      { title: lookupLanguage(currentLang, 'cMenuExport_MarkNone'), cmd: 'mark_none', uiIcon: 'ui-icon-trash' },
      {
        title: lookupLanguage(currentLang, 'cMenuExport_MarkInvert'),
        cmd: 'mark_invert',
        uiIcon: 'ui-icon-transfer-e-w',
      },
    ],
    select: function(event, ui) {
      if (ui.cmd == 'mark_all') {
        $('[id^=\'tblEdit_attrexport_\']').prop('checked', true);
      }
      if (ui.cmd == 'mark_none') {
        $('[id^=\'tblEdit_attrexport_\']').prop('checked', false);
      }
      if (ui.cmd == 'mark_invert') {
        $('[id^=\'tblEdit_attrexport_\']').trigger('click');
      }

      handleTableData('tblEdit', currentMarkedDeviceId, 'STORE');
    },
  });
}

/* 	=====================================================================
/	clear store tables
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function clearStoreTables(tableName) {
  if (tableName == '') {
    tblDataStore = [];
    tblEditStore = [];
    extendedDataStore = [];
  }
  if (tableName == 'tblDataStore') {
    tblDataStore = [];
  }
  if (tableName == 'tblEditStore') {
    tblEditStore = [];
  }
  if (tableName == 'extendedDataStore') {
    extendedDataStore = [];
  }
}

/* 	=====================================================================
/	clear drag table
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function clearDragTable() {
  $('#dragTable').html(tmplEmptyDragTable);
}

/* 	=====================================================================
/	clear data table by looping and removing entries
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function clearDataTable() {
  // store table data for re-population
  handleTableData('tblData', '', 'STORE'); // why is this necessary ... ?

  var cntRows = $('#tblData').appendGrid('getRowCount');
  for (var i = cntRows - 1; i >= 0; i--) {
    $('#tblData').appendGrid('removeRow', i);
  }
}

/* 	=====================================================================
/	clear edit table by looping an removing entries
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function clearEditTable() {
  var cntRows = $('#tblEdit').appendGrid('getRowCount');
  for (var i = cntRows - 1; i >= 0; i--) {
    $('#tblEdit').appendGrid('removeRow', i);
  }
}

/* 	=====================================================================
/	refresh data table - either from storage or by initializing
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function refreshDataTable() {
  var cntCol = 0;
  var arrPositions = getPositions();

  // store current table for possible revert!
  dragTableRevert = $('#dragTable').html();

  $('#dragTable td')
    .children('img')
    .each(function() {
      var hlpId = '"' + parseDeviceId($(this).attr('id'), '##ID_VERSION##') + '"';
      var storedRowData = handleTableData('tblData', $(this).attr('id'), 'GETENTRY');

      currentRefreshedDeviceId = $(this).attr('id');

      if (storedRowData[0]) {
        // restore
        //alert('Restore ...' + hlpId + "/" + storedRowData[0].input + "/" + storedRowData[0].output);
        $('#tblData').appendGrid('appendRow', [
          {
            position: arrPositions[cntCol],
            modulname: storedRowData[0].modulname,
            bmk: storedRowData[0].bmk,
            input: storedRowData[0].input,
            output: storedRowData[0].output,
            comment: storedRowData[0].comment,
            deviceId: $(this).attr('id'),
            deviceType: storedRowData[0].deviceType,
            GUID: storedRowData[0].GUID,
          },
        ]);
      } else {
        // initialize
        var hlpTitle = GetJSONData('CATALOG', '', '.key:val(' + hlpId + ') ~ .title');
        var hlpDeviceType = getGsdData($(this).attr('id'), '##GSD_DEVICETYPE##');
        var hlpInputDefaultVariant = getGsdData($(this).attr('id'), '##GSD_INPUTDEFAULTVARIANT##');
        var hlpOutputDefaultVariant = getGsdData($(this).attr('id'), '##GSD_OUTPUTDEFAULTVARIANT##');
        var hlpComment = getGsdData($(this).attr('id'), '##GSD_DEVICESCREENCOMMENT##');
        var hlpGUID = createGUID();
        $('#tblData').appendGrid('appendRow', [
          {
            position: arrPositions[cntCol],
            modulname: hlpTitle,
            bmk: hlpTitle,
            input: hlpInputDefaultVariant,
            output: hlpOutputDefaultVariant,
            comment: hlpComment != '##GSD_DEVICESCREENCOMMENT##' ? hlpComment : '',
            deviceId: $(this).attr('id'),
            deviceType: hlpDeviceType,
            GUID: hlpGUID,
          },
        ]);

        // read .ext file if exists
        //var pathnameExt = configData.paths.gsd.replace("##DEVICE_ID##",parseDeviceId($(this).attr('id'),"##ID_VERSION##")).replace(".rap",".ext");

        var hlpProductType = getGsdData($(this).attr('id'), '##GSD_PRODUCTTYPE##');
        var extConfig = getExtendedConfig(hlpProductType);
        var pathnameExt = 'err_no_ext.err';
        if (extConfig != '') {
          pathnameExt = 'resources/data/extensions/' + extConfig.dialog + '.js';
          var hlpDeviceId = $(this).attr('id');
          if (fileExists(pathnameExt) == true) {
            $.getScript(pathnameExt, function() {
              extendedDataStore.push(new extendedData(hlpDeviceId, hlpGUID, hlpProductType));
              //extendedDataStore[0].loadDialog(); <-- show dialog immediately; not needed at the moment ...
            });
          } else {
            //alert("ERROR: Extension dialog missing ("+ extConfig.dialog +")");
            createInfoDialog('Error', '<br>' + 'Extension dialog missing (' + extConfig.dialog + ')', '');
          }
        }
      }

      cntCol++;
    });

  // push refreshed table into storage
  handleTableData('tblData', '', 'STORE'); // ???????????????

  refreshColumnHeaders(arrPositions);

  // hide insert button
  $('[id^="tblData_Insert"]').hide();

  // hide index columns
  $('.ui-widget-header.first').hide();
  $('.ui-widget-content.first').hide();

  // if only one device is present, select device and table row!
  /* currently not active
	if (cntCol == 1) {
		$( "img[id^='device_']" ).addClass("moduleSelected");
	}
	*/
}

/* 	=====================================================================
/	convencience function for accessing catalog tree entries
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function getNodeData(treeId, nodeId, dataField) {
  var node = '';
  if (nodeId == '') {
    node = $('#' + treeId).fancytree('getActiveNode');
  } else {
    node = $('#' + treeId).fancytree('getNodeByKey', nodeId);
  }
  return node.data[dataField];
}

/* 	=====================================================================
/	write messages into log area
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function WriteLog(logEntry) {
  var d = new Date();
  var datestring =
    pad(d.getDate(), 2) +
    '.' +
    pad(d.getMonth() + 1, 2) +
    '.' +
    d.getFullYear() +
    ' ' +
    pad(d.getHours(), 2) +
    ':' +
    pad(d.getMinutes(), 2) +
    ':' +
    pad(d.getSeconds(), 2);

  if (gblSwtLogActive == false) {
    return;
  }

  $('#logText').html('<br>' + datestring + ' ' + logEntry + $('#logText').html());
}

/* 	=====================================================================
/	check if device can be placed here - depends on device type!
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function isPositionAllowed() {
  var deviceImages = document.getElementsByClassName('deviceImage');
  var cntBaseDevices = 0;
  var cntLeftEdgeDevices = 0;
  var cntLeftDevices = 0;
  var cntRightDevices = 0;
  var cntRightEdgeDevices = 0;
  var leftEdgeDeviceType = '';
  var rightEdgeDeviceType = '';
  var hlpId = '';
  var posBaseDevice = -1;
  var posFirstVirtualDevice = -1;
  var swtRealDeviceAfterVirtual = false;

  // counting ...
  cntBaseDevices = 0;
  for (var i = 0; i < deviceImages.length; ++i) {
    hlpId = deviceImages[i].id.replace('device_', '');
    if (i == 0) {
      leftEdgeDeviceType = getDeviceType(hlpId);
    }
    if (i == deviceImages.length - 1) {
      rightEdgeDeviceType = getDeviceType(hlpId);
    }
    if (getDeviceType(hlpId) == 'BASE') {
      $('#' + deviceImages[i].id).addClass('isBase');
      posBaseDevice = i;
      cntBaseDevices++;
    }
    if (getDeviceType(hlpId) == 'EDGE') {
      // if posBaseDevice has not yet been determined,
      // the EDGE device MUST be left of BASE!
      if (posBaseDevice == -1) {
        $('#' + deviceImages[i].id).addClass('isLeft');
        cntLeftEdgeDevices++;
      } else {
        $('#' + deviceImages[i].id).addClass('isRight');
        cntRightEdgeDevices++;
      }
    }
    if (getDeviceType(hlpId) == 'LEFT_EDGE') {
      $('#' + deviceImages[i].id).addClass('isLeft');
      cntLeftEdgeDevices++;
    }
    if (getDeviceType(hlpId) == 'LEFT') {
      $('#' + deviceImages[i].id).addClass('isLeft');
      cntLeftDevices++;
    }
    if (getDeviceType(hlpId) == 'RIGHT') {
      $('#' + deviceImages[i].id).addClass('isRight');
      cntRightDevices++;
    }
    if (getDeviceType(hlpId) == 'RIGHT_EDGE') {
      $('#' + deviceImages[i].id).addClass('isRight');
      cntRightEdgeDevices++;
    }

    // special handling of VIRTUAL devices!
    if (getDeviceType(hlpId) == 'VIRTUAL') {
      $('#' + deviceImages[i].id).addClass('isVirtual');
      if (posFirstVirtualDevice == -1) {
        posFirstVirtualDevice = i;
      }
      //return "OK" ??????????????????
    }

    // if LEFT_RIGHT devicetype --> determine position class through
    // relative position to base device
    if (getDeviceType(hlpId) == 'LEFT_RIGHT' || getDeviceType(hlpId) == 'RIGHT_LEFT') {
      // first remove existing position classes (in case device was dragged from left to right or vice versa)
      $('#' + deviceImages[i].id).removeClass('isLeft');
      $('#' + deviceImages[i].id).removeClass('isRight');
      // positioned left of BASE
      if (posBaseDevice == -1) {
        $('#' + deviceImages[i].id).addClass('isLeft');
        cntLeftDevices++;
      }
      // positioned right of BASE
      if (i > posBaseDevice && posBaseDevice > -1) {
        $('#' + deviceImages[i].id).addClass('isRight');
        cntRightDevices++;
      }
    }
  }

  // Rule 00
  // there must always be ONE base device!
  if (cntBaseDevices == 0) {
    return GetErrorText('ERR_BASE_MANDATORY', currentLang, 'short');
  }

  // Rule 01
  // base device must be the first to be placed
  if (countDevices('REAL') == 1) {
    var hlpDeviceType = getDeviceType(deviceImages[0].id.replace('device_', ''));
    if (hlpDeviceType != 'BASE' && hlpDeviceType != 'VIRTUAL') {
      return GetErrorText('ERR_POSITION_BASE_FIRST', currentLang, 'short');
    }
  }

  // Rule 02
  // only ONE base device is allowed
  if (cntBaseDevices > 1) {
    return GetErrorText('ERR_POSITION_BASE_SINGLE', currentLang, 'short');
  }

  // Rule 03
  // check invalid left / right positions
  cntBaseDevices = 0;
  for (i = 0; i < deviceImages.length; ++i) {
    hlpId = deviceImages[i].id.replace('device_', '');
    if (getDeviceType(hlpId) == 'BASE') {
      cntBaseDevices++;
    }
    if ((getDeviceType(hlpId) == 'LEFT' || getDeviceType(hlpId) == 'LEFT_EDGE') && cntBaseDevices > 0) {
      return GetErrorText('ERR_POSITION_LEFT', currentLang, 'short');
      //return "ERR_03a: invalid positioning of left-sided device";
    }
    if ((getDeviceType(hlpId) == 'RIGHT' || getDeviceType(hlpId) == 'RIGHT_EDGE') && cntBaseDevices == 0) {
      return GetErrorText('ERR_POSITION_RIGHT', currentLang, 'short');
      //return "ERR_03b: invalid positioning of right-sided device";
    }
    if (getDeviceType(hlpId) == 'LEFT_EDGE' && cntLeftEdgeDevices > 1) {
      return GetErrorText('ERR_POSITION_LEFT_EDGE_SINGLE', currentLang, 'short');
      //return "ERR_03c: only one left-edge device allowed";
    }
    if (getDeviceType(hlpId) == 'LEFT_EDGE' && leftEdgeDeviceType != 'LEFT_EDGE') {
      return GetErrorText('ERR_POSITION_LEFT_EDGE', currentLang, 'short');
      //return "ERR_03d: invalid position of left-edge device";
    }
    if (getDeviceType(hlpId) == 'RIGHT_EDGE' && rightEdgeDeviceType != 'RIGHT_EDGE') {
      return GetErrorText('ERR_POSITION_RIGHT_EDGE', currentLang, 'short');
      //return "ERR_03e: invalid position of right-edge device";
    }
    if (getDeviceType(hlpId) == 'RIGHT_EDGE' && cntRightEdgeDevices > 1) {
      return GetErrorText('ERR_POSITION_RIGHT_EDGE_SINGLE', currentLang, 'short');
      //return "ERR_03f: only one right-edge device allowed";
    }
    if (getDeviceType(hlpId) == 'EDGE') {
      if (i != 0) {
        if (getContainingTableColumn(deviceImages[i].id, '') != getLastRealColumn('USED_ONLY')) {
          return GetErrorText('ERR_POSITION_EDGE', currentLang, 'short');
          //return "ERR_03g: invalid position of edge device";
        }
      }
    }
    if (getDeviceType(hlpId) == 'EDGE' && cntLeftEdgeDevices + cntRightEdgeDevices > 2) {
      return GetErrorText('ERR_POSITION_EDGE_TWO', currentLang, 'short');
      //return "ERR_03h: only two edge devices allowed";
    }
  }

  // Rule 04
  // check max count of device type
  if (cntLeftDevices > configData.deviceLimits.maxLeft) {
    return GetErrorText('ERR_MAX_LEFT', currentLang, 'short');
    //return "ERR_04a: too much left-sided devices";
  }
  if (cntRightDevices > configData.deviceLimits.maxRight) {
    return GetErrorText('ERR_MAX_RIGHT', currentLang, 'short');
    //return "ERR_04b: too much right-sided devices";
  }

  // Rule 05
  // no putting REAL devices after / between VIRTUAL devices
  // HANDLED IN CREATEDROPPABLES !

  return 'OK';
}

/* 	=====================================================================
/	get dragtable column of last real device
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function getLastRealColumn(mode) {
  var retPos = 0;

  if (mode == 'USED_ONLY') {
    $('#dragTable td')
      .children('img')
      .each(function() {
        if (getDeviceType($(this).attr('id').replace('device_', '')) != 'VIRTUAL') {
          retPos = getContainingTableColumn($(this).attr('id'), '');
        }
      });
  } else {
    $('#dragTable td').each(function() {
      if (!$(this).hasClass('virtualGap') && !$(this).hasClass('virtualDevice')) {
        retPos++;
      }
    });

    retPos -= 1;
  }

  return retPos;
}

/* 	=====================================================================
/	count placed devices
/ 	TODO: possibly change this to count dataTable entries instead of dragTable images?
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function countDevices(mode) {
  var retCnt = 0;

  // jQuery counting causes recursion error in FF!
  //$("[id^='device_").each( function () {
  //	retCnt++;
  //});

  if (mode == 'ALL') {
    // counting with pure JS ...
    var arr = document.getElementsByClassName('deviceImage');
    retCnt = arr.length;
  }

  if (mode == 'REAL') {
    $('#dragTable td')
      .children('img')
      .each(function() {
        if (getDeviceType($(this).attr('id').replace('device_', '')) != 'VIRTUAL') {
          retCnt++;
        }
      });
  }

  if (mode == 'VIRTUAL') {
    $('#dragTable td')
      .children('img')
      .each(function() {
        if (getDeviceType($(this).attr('id').replace('device_', '')) == 'VIRTUAL') {
          retCnt++;
        }
      });
  }

  // special - 	if mode starts with 'device_', find number of all devices whose ids
  //				contain the following device id parts
  if (mode.substr(0, 7) == 'device_') {
    var hlpSearch = mode.replace('device_', '');
    retCnt = $('img[id*=' + hlpSearch + ']').length;
  }
  return retCnt;
}

/* 	=====================================================================
/	count unused columns (columns where no device has been placed yet)
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function countUnusedColumns(countToColumn) {
  var retVal = 0;
  var cntCol = 0;
  $('#dragTable tr')
    .eq(1)
    .find('td')
    .each(function() {
      if (cntCol == countToColumn) {
        return false;
      }
      cntCol++;

      if ($(this).find('img').length == 0) {
        retVal++;
      }
    });
  return retVal;
}

/* 	=====================================================================
/	count all drag table columns (including unused cols)
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function countDragTableColumns() {
  return $('#dragTable').find('tr:first th').length;
}

/* 	=====================================================================
/	to allow multiple instances of same device type we need to number them
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function getNextDeviceInstanceNr(deviceId) {
  var hlpInstanceNr = 0;
  var retInstanceNr = 0;
  $('[id^=\'device_' + deviceId + '\']').each(function() {
    hlpInstanceNr = parseInt(
      $(this)
        .attr('id')
        .replace('device_' + deviceId + '_', ''),
    );
    if (hlpInstanceNr > retInstanceNr) {
      retInstanceNr = hlpInstanceNr;
    }
  });

  retInstanceNr++;
  return retInstanceNr;
}

/* 	=====================================================================
/	get data of GSD file (optionally patched into string pattern)
/  	Two modes: 	if strTemplate has ##...## form, a string result
/				is passed back
/				if strTemplate is WITHOUT ##...## marks, the result
/				can have any value - be also a JSON object or array
/ 	TODO: cache reading of GSD file to enhance performance of:
/	- dragging devices from catalog to workspace
/  	- changing positions of devices in dragtable
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function getGsdData(deviceId, strTemplate) {
  var retMode = strTemplate.indexOf('##') > -1 ? 'STRING' : 'ANY';
  var dataGSD = '';
  var retTemplate = strTemplate;
  var retValue = '';
  var hlpDeviceId;
  var pathnameGSD = ''; //configData.paths.gsd.replace("##DEVICE_ID##",deviceId);
  var hlpReplacement = '-';
  var posLastDelimiter = -1;

  // create GSD-deviceId from long instance deviceId
  hlpDeviceId = deviceId;
  if (deviceId.indexOf('device_') > -1) {
    hlpDeviceId = parseDeviceId(hlpDeviceId, '##ID_VERSION##');
  }

  pathnameGSD = configData.paths.gsd.replace('##DEVICE_ID##', hlpDeviceId);
  dataGSD = AjaxGetJSON(pathnameGSD, 'OBJ');
  if (dataGSD == 'ERR_NO_DATA') {
    //alert("getGsdData - unable to read file:" + pathnameGSD);
    createInfoDialog('Error', '<br>' + 'getGsdData - unable to read file:' + pathnameGSD, '');
    return dataGSD;
  }

  if (typeof dataGSD.comment != 'undefined') {
    retTemplate = retTemplate.replace('##GSD_COMMENT##', dataGSD.comment);
  }

  if (typeof dataGSD.icon_pathname != 'undefined') {
    retTemplate = retTemplate.replace('##GSD_ICON_PATHNAME##', configData.paths.icons + deviceId);
  }

  if (typeof dataGSD.devicetype != 'undefined') {
    retTemplate = retTemplate.replace('##GSD_DEVICETYPE##', dataGSD.devicetype.toUpperCase());
  }

  if (typeof dataGSD.screencomment != 'undefined') {
    retTemplate = retTemplate.replace('##GSD_DEVICESCREENCOMMENT##', dataGSD.screencomment);
  }

  if (typeof dataGSD.producttype != 'undefined') {
    retTemplate = retTemplate.replace('##GSD_PRODUCTTYPE##', dataGSD.producttype);
  }

  if (typeof dataGSD.datasheeturl != 'undefined') {
    retTemplate = retTemplate.replace('##GSD_DATASHEETURL##', dataGSD.datasheeturl);
  }

  //
  // performance consuming replacements - evaluate only if replacement target exists
  //
  if (retTemplate.indexOf('##GSD_IO_RULES##') > -1) {
    var retString = '';

    if (typeof dataGSD.rules != 'undefined') {
      if (typeof dataGSD.rules.IO != 'undefined') {
        $(dataGSD.rules.IO).each(function(rulesCnt, ruleItem) {
          if (typeof ruleItem.sync != 'undefined') {
            retString += ruleItem.sync[0] + ',' + ruleItem.sync[1] + ';';
          }
        });

        if (retString != '') {
          retString = killLastDelimiter(retString, ';');
        }
      }
    }

    retTemplate = retTemplate.replace('##GSD_IO_RULES##', retString);
  }

  if (retTemplate.indexOf('##GSD_INPUTDEFAULTVARIANT##') > -1) {
    var swtFound = false;
    if (typeof dataGSD.input.variants != 'undefined') {
      $(dataGSD.input.variants).each(function(variantCnt, variantItem) {
        if (variantItem.isDefault == true) {
          retTemplate = retTemplate.replace('##GSD_INPUTDEFAULTVARIANT##', variantCnt);
          swtFound = true;
        }
      });
    }

    if (swtFound == false) {
      retTemplate = retTemplate.replace('##GSD_INPUTDEFAULTVARIANT##', 0);
    }
  }

  if (retTemplate.indexOf('##GSD_OUTPUTDEFAULTVARIANT##') > -1) {
    var swtFound = false;
    if (typeof dataGSD.output.variants != 'undefined') {
      $(dataGSD.output.variants).each(function(variantCnt, variantItem) {
        if (variantItem.isDefault == true) {
          retTemplate = retTemplate.replace('##GSD_OUTPUTDEFAULTVARIANT##', variantCnt);
          swtFound = true;
        }
      });
    }

    if (swtFound == false) {
      retTemplate = retTemplate.replace('##GSD_OUTPUTDEFAULTVARIANT##', 0);
    }
  }

  if (retTemplate.indexOf('##GSD_CNT_VARIANTS##') > -1) {
    var hlpRet = '';

    // IMPORTANT: 	don't count attributes with edit mode "4" (hidden);
    //				counter only reflects visible attributes

    // INPUT
    var cntVariant = 0;
    if (typeof dataGSD.input.variants != 'undefined') {
      $(dataGSD.input.variants).each(function(variantCnt, variantItem) {
        cntVariant = 0;
        $(variantItem.data).each(function(variantDataCnt, variantDataItem) {
          if (
            (typeof variantDataItem.active == 'undefined' || variantDataItem.active == true) &&
            variantDataItem.edit != '4'
          ) {
            if (typeof variantDataItem.multi != 'undefined') {
              cntVariant += variantDataItem.multi;
            } else {
              cntVariant += 1;
            }
          }
        });
        hlpRet = hlpRet + (cntVariant + '') + ',';
      });
      hlpRet = killLastDelimiter(hlpRet, ',');
    } else {
      $(dataGSD.input).each(function(inputCnt, inputItem) {
        if ((typeof inputItem.active == 'undefined' || inputItem.active == true) && inputItem.edit != '4') {
          if (typeof inputItem.multi != 'undefined') {
            cntVariant += inputItem.multi;
          } else {
            cntVariant += 1;
          }
        }
      });
      hlpRet = cntVariant + '';
    }

    hlpRet = hlpRet + ';';

    // OUTPUT
    cntVariant = 0;
    if (typeof dataGSD.output.variants != 'undefined') {
      var cntVariant = 0;
      $(dataGSD.output.variants).each(function(variantCnt, variantItem) {
        cntVariant = 0;
        $(variantItem.data).each(function(variantDataCnt, variantDataItem) {
          if (
            (typeof variantDataItem.active == 'undefined' || variantDataItem.active == true) &&
            variantDataItem.edit != '4'
          ) {
            if (typeof variantDataItem.multi != 'undefined') {
              cntVariant += variantDataItem.multi;
            } else {
              cntVariant += 1;
            }
          }
        });
        hlpRet = hlpRet + (cntVariant + '') + ',';
      });
      hlpRet = killLastDelimiter(hlpRet, ',');
    } else {
      $(dataGSD.output).each(function(outputCnt, outputItem) {
        if ((typeof outputItem.active == 'undefined' || outputItem.active == true) && outputItem.edit != '4') {
          if (typeof outputItem.multi != 'undefined') {
            cntVariant += outputItem.multi;
          } else {
            cntVariant += 1;
          }
        }
      });
      hlpRet = hlpRet + (cntVariant + '');
    }

    hlpRet = killLastDelimiter(hlpRet, ';');
    retTemplate = retTemplate.replace('##GSD_CNT_VARIANTS##', hlpRet);
  }

  // non-string return values!
  if (retTemplate.indexOf('GSD_DEVICE_REQUIRED_RULES') > -1) {
    if (typeof dataGSD.rules != 'undefined') {
      if (typeof dataGSD.rules.DEVICE_REQUIRED != 'undefined') {
        retValue = dataGSD.rules.DEVICE_REQUIRED;
      }
    }
  }

  if (retTemplate.indexOf('GSD_DEVICE_EXCLUDED_RULES') > -1) {
    if (typeof dataGSD.rules != 'undefined') {
      if (typeof dataGSD.rules.DEVICE_EXCLUDED != 'undefined') {
        retValue = dataGSD.rules.DEVICE_EXCLUDED;
      }
    }
  }

  if (retTemplate.indexOf('GSD_DEVICE_LIMITED_RULES') > -1) {
    if (typeof dataGSD.rules != 'undefined') {
      if (typeof dataGSD.rules.DEVICE_LIMITED != 'undefined') {
        retValue = dataGSD.rules.DEVICE_LIMITED;
      }
    }
  }

  if (retTemplate.indexOf('GSD_DEVICE_FILTERED_RULES') > -1) {
    if (typeof dataGSD.rules != 'undefined') {
      if (typeof dataGSD.rules.DEVICE_FILTERED != 'undefined') {
        retValue = dataGSD.rules.DEVICE_FILTERED;
      }
    }
  }

  if (retTemplate.indexOf('GSD_DEVICE_POSITIONING_RULES') > -1) {
    if (typeof dataGSD.rules != 'undefined') {
      if (typeof dataGSD.rules.DEVICE_POSITIONING != 'undefined') {
        retValue = dataGSD.rules.DEVICE_POSITIONING;
      }
    }
  }

  if (retMode == 'STRING') {
    return retTemplate;
  } else {
    return retValue;
  }
}

/* 	=====================================================================
/	extract necessary parts of device id to replacement template
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function parseDeviceId(fullDeviceId, strTemplate) {
  fullDeviceId = fullDeviceId.replace('device_', '');

  var retTemplate = strTemplate;
  var posFirstDelimiter = fullDeviceId.indexOf('_');
  var posLastDelimiter = -1;

  if (posFirstDelimiter == -1) {
    posFirstDelimiter = fullDeviceId.length;
  }
  for (var i = 0; i < fullDeviceId.length; i++) {
    if (fullDeviceId.substr(i, 1) == '_') {
      posLastDelimiter = i;
    }
  }

  if (strTemplate == 'TEST') {
    //alert(fullDeviceId.substr(0,posLastDelimiter));
    createInfoDialog('Error', '<br>' + fullDeviceId.substr(0, posLastDelimiter), '');
  }

  retTemplate = retTemplate.replace('##ID##', fullDeviceId.substr(0, posFirstDelimiter));
  retTemplate = retTemplate.replace('##ID_VERSION##', fullDeviceId.substr(0, posLastDelimiter));
  retTemplate = retTemplate.replace('##INSTANCE##', fullDeviceId.substr(fullDeviceId.length - 3));
  return retTemplate;
}

/* 	=====================================================================
/	shortcut function for getting device type string from GSD file
/	TODO: replace calls to this with direct getGsdData-call
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function getDeviceType(deviceId) {
  return getGsdData('device_' + deviceId, '##GSD_DEVICETYPE##');
}

function getDatasheetURL(deviceId) {
  return getGsdData('device_' + deviceId, '##GSD_DATASHEETURL##');
}

/* 	=====================================================================
/	collect functions that affect the dragtable here ...
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function handleDragTable() {
  // rule 01
  // if there is only one image in the table, it must be a base device
  // --> expand: add left and right column
  if ($('[id^=\'device_\']').length == 1 && countDragTableColumns() == 1) {
    expandDragTable('ADD_LEFT', 0);
    expandDragTable('ADD_RIGHT', 0);
  }

  // rule 02
  // virtual devices get sorted to the right 'virtual' area
  var hlpDeviceType = '';
  $('#dragTable td')
    .children('img')
    .each(function() {
      hlpDeviceType = getDeviceType($(this).attr('id').replace('device_', ''));
      if (hlpDeviceType == 'VIRTUAL') {
        if ($(this).closest('td').hasClass('virtualDevice') == false) {
          expandDragTable('ADD_VIRTUAL', '');
          moveToVirtual($(this));
        }
      }
    });

  clearDataTable();
  refreshDataTable();
}

/* 	=====================================================================
/	add dynamic data to catalog entries
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function patchCatalogData(catalogData) {
  // level 01 - folder loop
  $.each(catalogData, function() {
    //alert(this.key);
    // handle folder data on this level ...

    // level 02 - device loop
    $.each(this.children, function() {
      //alert(this.key);
      // handle device data on this level ...

      // check for png and jpg icons
      var foundFileType = '';
      if (fileExists(configData.paths.icons + parseDeviceId(this.key, '##ID##') + '.png') == true) {
        foundFileType = '.png';
      } else {
        if (fileExists(configData.paths.icons + parseDeviceId(this.key, '##ID##') + '.jpg') == true) {
          foundFileType = '.jpg';
        }
      }

      if (foundFileType != '') {
        this.icon = this.icon.replace(
          '##GSD_ICON_PATHNAME##',
          configData.paths.icons + parseDeviceId(this.key, '##ID##') + foundFileType,
        );
      }
    });
  });

  return catalogData;
}

/* 	=====================================================================
/ Load the catalog-custom.json file and apply any device that is not part of catalog.json. This is a way for the user to append custom devices.
/ It must keep any entry from the catalog.json. Custom devices are only loaded when their id does not exist on the catalog.json.
*/

function getCatalogKeys(catalogData) {
  var catalogKeys = [];
  for (var folder of catalogData) {
    for (var child of folder.children) {
      catalogKeys.push(child.key);
    }
  }
  return catalogKeys;
}

function appendCatalogCustom(catalogData) {
  // fetch catalog-custom.json
  try {
    var catalogCustomData = AjaxGetJSON(configData.paths['catalog-custom'], 'OBJ');
    var catalogKeys = getCatalogKeys(catalogData);
    if (catalogCustomData !== 'ERR_NO_DATA') {
      for (var customFolder of catalogCustomData) {
        for (var child of customFolder.children) {
          // does key exist?
          if (!catalogKeys.includes(child.key)) {
            // has folder already been created?
            if (!catalogData.some((el) => el.key === customFolder.key)) {
              // create folder
              catalogData.push({ ...customFolder, children: [] });
            }
            // append new device/module
            var catalogItem = catalogData.find((item) => item.key === customFolder.key);
            catalogItem.children.push(child);
          }
        }
      }
    }
  } catch (err) {
    console.error(err);
  }
  return catalogData;
}

/* 	=====================================================================
/	typical expansion actions of dragtable
/	TODO: 	possibly integrate this with handleDragTable-function
/			and also add 'reduction' (delete etc.) actions
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function expandDragTable(mode, colPos) {
  // table headers created empty - label will be set by - refreshColumnHeaders - function
  if (mode == 'ADD_LEFT') {
    $('#dragTable tr:first').prepend('<th data-header=\'new_left\'></th>');
    $('#dragTable tr:gt(0)').prepend('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
  }

  if (mode == 'ADD_RIGHT') {
    $('#dragTable tr:first').append('<th data-header=\'new_right\'></th>');
    $('#dragTable tr:gt(0)').append('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
  }

  if (mode == 'INSERT_LEFT') {
    $('#dragTable tr:first').find('th').eq(colPos).before('<th data-header=\'new\'></th>');
    $('#dragTable tr:gt(0)').find('td').eq(colPos).before('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
  }

  if (mode == 'INSERT_RIGHT') {
    $('#dragTable tr:first').find('th').eq(colPos).after('<th data-header=\'new\'></th>');
    $('#dragTable tr:gt(0)').find('td').eq(colPos).after('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
  }

  if (mode == 'ADD_VIRTUAL') {
    // if first virtual, add gap columns first ...
    if ($('.virtualDevice').length == 0) {
      $('#dragTable tr:first').append(
        '<th data-header=\'new_right\' class=\'virtualGapHeader\' style=\'background: none; border-top: none !important;\'></th>',
      );
      $('#dragTable tr:gt(0)').append(
        '<td class=\'virtualGap\' style=\'width:50px; height:50px; background:none; border-top:none !important; border-bottom:none !important;\'></td>',
      );
    }

    // pointer-events:none disables dragTable-dragging on virtual devices!!
    $('#dragTable tr:first').append(
      '<th data-header=\'new_right\' style=\'background:#aaaaaa; color:#000000; pointer-events:none\'>virtual</th>',
    );
    $('#dragTable tr:gt(0)').append('<td class=\'dropCell virtualDevice\' style=\'width:50px; height:50px\'></td>');
  }

  // create empty slots around core module - IF they don't exist already!
  if (mode == 'PAD_CORE' && swtPadCore == true) {
    var coreId = $('[id*=\'RevPiCore\']').attr('id');
    var coreColPos = getContainingTableColumn(coreId, '');

    var retIsLeftColUsed = isColumnUsed(coreColPos - 1);
    var retIsRightColUsed = isColumnUsed(coreColPos + 1);

    // add to left
    if (retIsLeftColUsed == true) {
      $('#dragTable tr:first').find('th').eq(coreColPos).before('<th data-header=\'new\'></th>');
      $('#dragTable tr:gt(0)')
        .find('td')
        .eq(coreColPos)
        .before('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
    }

    // add to right
    if (retIsRightColUsed == true) {
      $('#dragTable tr:first').find('th').eq(coreColPos).after('<th data-header=\'new\'></th>');
      $('#dragTable tr:gt(0)')
        .find('td')
        .eq(coreColPos)
        .after('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
    }
  }

  // create empty slots on outer edges
  if (mode == 'PAD_EDGES') {
    var retIsLeftColUsed = isColumnUsed(0);
    var retIsRightColUsed = isColumnUsed(getLastRealColumn(''));

    // add to left
    if (retIsLeftColUsed == true) {
      $('#dragTable tr:first').find('th').eq(0).before('<th data-header=\'new\'></th>');
      $('#dragTable tr:gt(0)').find('td').eq(0).before('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
    }

    // add to left
    if (retIsRightColUsed == true) {
      $('#dragTable tr:first').find('th').eq(getLastRealColumn()).after('<th data-header=\'new\'></th>');
      $('#dragTable tr:gt(0)')
        .find('td')
        .eq(getLastRealColumn())
        .after('<td class=\'dropCell\' style=\'width:50px; height:50px\'></td>');
    }
  }

  // calculate index of edge columns
  let left_edge = 0;
  let right_edge = getLastRealColumn('');

  $('#dragTable tr:gt(0)')
    .find('td')
    .each(function(index) {
      if (index > right_edge) {
        // ignore virtual devices
        return;
      }

      if (index == left_edge || index == right_edge) {
        // add edge class to the outer columns
        $(this).addClass('edge');
      } else {
        // remove edge class from every other column
        $(this).removeClass('edge');
      }
    });
}

function getContainingTableColumn(idDeviceImage, mode) {
  var hlpIndex = $('#' + idDeviceImage)
    .parent()
    .index();
  if (mode == 'IGNORE_UNUSED') {
    hlpIndex -= countUnusedColumns(hlpIndex);
  }
  return hlpIndex;
}

function handleMenu(e, item) {
  if (typeof item == 'undefined') {
    return;
  }

  if (configData.misc.userMode == 'STANDARD') {
    if (checkSession(revPiHostname) == false) {
      //alert("Session expired ...");
      createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      //window.location.href = configData.paths.login;
      return;
    }
    refreshLoginCookies(sessionExpireMin, revPiHostname);
  }

  if (item.id == 'file_new') {
    var hlpDate = new Date();
    var cookieExpire = new Date(new Date().getTime() + 1 * 60 * 1000); // expire after one minute
    Cookies.set('KUNBUS_PiCtory_Cache', hlpDate, { expires: cookieExpire, secure: true });
    location.reload(true);
    //resetAll(); ?????
  }

  if (item.id == 'file_clear') {
    if (swtIsDirty == true) {
      confirmMode = 'CLEAR';
      createConfirmDialog(confirmMode);
      $('#dialog_confirm').dialog('open');
    } else {
      resetAll();
    }
  }

  if (item.id == 'file_open') {
    fillDialog_project('OPEN');
    createProjectDialog('OPEN');

    // OK button in open dialog not needed
    $('#okDialogSaveProject').hide();
    // Override Buttons not needed ...
    $('[id^=\'dlgSaveProjectRepl_\']').hide();

    /* TEST Mode
		confirmMode = "OPEN_PROJECT";
		if (swtIsDirty == true) {
			createConfirmDialog(confirmMode); // will be opened automatically after creation
		} else {
			confirmResult = true;
			processConfirm();
		}
		*/
  }

  if (item.id == 'file_save') {
    // don't save empty workspace
    if (tblDataStore.length == 0) {
      createInfoDialog('Info', '<br>nothing to save ...', '{"autoClose":1000}');
      return;
    }

    if (configData.misc.userMode == 'STANDARD') {
      currentProjectFilename = '_config';
    }

    if ($.trim(currentProjectFilename) != '') {
      var exportConfigData = getExportConfigData('project.json');
      currentExportTS = getCurrentTS('YmdHis');
      var retDoExport = doExport(
        'project.json',
        currentProjectFilename + '.' + exportConfigData.filetype,
        false,
        false,
      );
      // do optional autoExport
      if (typeof configData.misc.autoExport != 'undefined' && configData.misc.autoExport == true) {
        var arrAutoExportDefault = [];
        var arrAutoExportFilenameNoSuffix = [];
        var arrGetActiveAutoExport = getActiveAutoExport();
        arrAutoExportDefault = arrGetActiveAutoExport[0];
        arrAutoExportFilenameNoSuffix = arrGetActiveAutoExport[1];

        $.each(arrAutoExportDefault, function(index, filename) {
          exportConfigData = getExportConfigData(filename);
          retDoExport = doExport(
            filename,
            '../export/' + arrAutoExportFilenameNoSuffix[index] + '.' + exportConfigData.filetype,
            true,
            false,
          );
        });

        /*
				exportConfigData = getExportConfigData(configData.misc.autoExportDefault);
				retDoExport = doExport(configData.misc.autoExportDefault, "../export/" + configData.misc.autoExportFilenameNoSuffix + "." + exportConfigData.filetype, true, false);
				*/
      }
      // delete '_' from filename for displaying in case of STANDARD userMode setting filename to '_config'
      setProjectInfo(
        currentProjectFilename.replace('_', ''),
        getProjectFileLastSaved(currentProjectFilename, 'd.m.Y H:i:s'),
      );
      swtIsDirty = false;

      createInfoDialog('', '<br>Project saved...', '{"autoClose":1000}');
    } else {
      fillDialog_project('SAVE');
      createProjectDialog('SAVE');

      // hide delete button of current project
      $('#dlgSaveProjectDel_' + currentProjectFilename).hide();
      // open buttons not needed ...
      $('[id^=\'dlgSaveProjectOpen_\']').hide();

      // diable OK button on start - gets enabled if filename was entered
      $('#okDialogSaveProject').button('option', 'disabled', true);
    }
  }

  if (item.id == 'file_saveAs') {
    // don't save empty workspace
    if (tblDataStore.length == 0) {
      createInfoDialog('', '<br>nothing to save ...', '{"autoClose":1000}');
      return;
    }

    fillDialog_project('SAVE');
    createProjectDialog('SAVE');

    // hide delete button of current project
    $('#dlgSaveProjectDel_' + currentProjectFilename).hide();
    // open buttons not needed ...
    $('[id^=\'dlgSaveProjectOpen_\']').hide();

    // diable OK button on start - gets enabled if filename was entered
    $('#okDialogSaveProject').button('option', 'disabled', true);
  }

  if (item.id == 'file_saveAsStart') {
    if (saveAsStart() == 0) {
      AjaxRunActions(false, false, false); //NO reset, NO start, NO show response
      createInfoDialog('', '<br>Project saved...', '{"autoClose":1000}');
    } else {
      createInfoDialog('Error', '<br>Unable to save project file...', '');
    }
  }

  if (item.id == 'file_export') {
    // load export pattern data
    // 2017/11 is now being globaly loaded on startup
    //var exportData = AjaxGetJSON(configData.paths.export + "config.json", "OBJ");
    //exportData.files = sortJSON(exportData.files, "order");

    var rowTemplate =
      '<tr>' +
      '<td><b>##SCREENNAME##</b></td>' +
      '<td>##DESCRIPTION##</td>' +
      '<td>##FILENAME## <span style=\'color:#ff0000\'>##MISSING##</span></b></td>' +
      '<td align=\'center\'><input type=\'radio\' id=\'rdoExport\' name=\'rdoExport\' value=\'##VALUE##\' ##DEFAULT##></td>' +
      '</tr>';
    var rowTemplateWork = '';
    $('#tblExportData tbody').empty();
    $.each(exportData.files, function() {
      if (this.active == true) {
        rowTemplateWork = rowTemplate;
        rowTemplateWork = rowTemplateWork.replace('##SCREENNAME##', this.screenname);
        rowTemplateWork = rowTemplateWork.replace('##DESCRIPTION##', this.description);
        rowTemplateWork = rowTemplateWork.replace('##FILENAME##', this.filename);
        rowTemplateWork = rowTemplateWork.replace('##VALUE##', this.filename.replace('.json', ''));

        if (fileExists('resources/data/patterns/export/' + this.filename)) {
          rowTemplateWork = rowTemplateWork.replace('##MISSING##', '');
        } else {
          rowTemplateWork = rowTemplateWork.replace('##MISSING##', '(FILE MISSING!)');
        }

        if (configData.misc.exportDefault == this.filename) {
          rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', 'checked');
        } else {
          rowTemplateWork = rowTemplateWork.replace('##DEFAULT##', '');
        }

        // append row to table
        $('#tblExportData tbody').append(rowTemplateWork);
      }
    });

    // prepare dialog HTML (perform replacements etc.)

    $('#dialog_export').html($('#dialog_export').html().replace('##TBL_EXPORT_DATA_TH01##', 'Title'));
    $('#dialog_export').html($('#dialog_export').html().replace('##TBL_EXPORT_DATA_TH02##', 'Description'));
    $('#dialog_export').html($('#dialog_export').html().replace('##TBL_EXPORT_DATA_TH03##', 'Template'));
    $('#dialog_export').html($('#dialog_export').html().replace('##TBL_EXPORT_DATA_TH04##', 'export'));

    // show dialog
    $('#dialog_export').dialog({
      width: 550,
      modal: true,
      show: { effect: 'blind', duration: 200 },
      buttons: [
        {
          text: 'Ok',
          icons: {
            primary: 'ui-icon-heart',
          },
          click: function() {
            var swtShowOnly = false;
            if ($('input[name=\'rdoExportMode\']:checked').val() == 'show') {
              $('#txtExportFilename').val('_temp');
              swtShowOnly = true;
            }

            if ($.trim($('#txtExportFilename').val()) == '') {
              $('#lblExportMessage').html('Please enter filename');
            } else {
              if ($.trim($('#txtExportFilename').val().indexOf('.')) > -1) {
                $('#lblExportMessage').html('Don\'t enter file extension - it is set by template!');
              } else {
                $(this).dialog('close');

                var exportConfigData = getExportConfigData($('#rdoExport:checked').val() + '.json');
                currentExportTS = getCurrentTS('YmdHis');
                var retDoExport = doExport(
                  $('#rdoExport:checked').val() + '.json',
                  '../export/' + $('#txtExportFilename').val() + '.' + exportConfigData.filetype,
                  false,
                  swtShowOnly,
                );
                if (retDoExport != 'OK') {
                  $('#lblExportMessage').html(retDoExport);
                }
              }
            }
          },
        },
        {
          text: 'Cancel',
          icons: {
            primary: 'ui-icon-closethick',
          },
          click: function() {
            $(this).dialog('close');
          },
        },
      ],
    });

    // reset message
    $('#lblExportMessage').html('');

    // set download mode as default
    $('#rdoExportModeDownload').prop('checked', true);
    $('#spnExportFilename').show();

    // hide filename on 'show' mode
    $('input[type=radio][name=rdoExportMode]').off();
    $('input[type=radio][name=rdoExportMode]').on('change', function(e) {
      if ($(this).attr('id') == 'rdoExportModeShow') {
        $('#spnExportFilename').hide();
      } else {
        $('#spnExportFilename').show();
      }
    });

    //get checked
    //alert($("input:radio[name='rdoExport']:checked").val());
  }

  if (item.id == 'file_exit') {
    if (swtIsDirty == true) {
      confirmMode = 'EXIT';
      createConfirmDialog(confirmMode);
      $('#dialog_confirm').dialog('open');
    } else {
      // check for SSO
      window.location.href = window.isSSOHost ? 'php/logout.php' : configData.paths.login;
    }
  }

  if (item.id == 'tools_manageConnections') {
    if (markedForConnecting[0] != '' && markedForConnecting[1] != '') {
      fillDialog_connection(markedForConnecting[0], markedForConnecting[1]);
    } else {
      if (tblDataStore.length > 0) {
        if (tblDataStore.length == 1) {
          fillDialog_connection(
            getDataStoreData(tblDataStore[0].deviceId, '##GUID##'),
            getDataStoreData(tblDataStore[0].deviceId, '##GUID##'),
          );
        } else {
          fillDialog_connection(
            getDataStoreData(tblDataStore[0].deviceId, '##GUID##'),
            getDataStoreData(tblDataStore[1].deviceId, '##GUID##'),
          );
        }
      } else {
        //alert("ERR_NO_DEVICES_FOR_CONNECTING");
        createInfoDialog('Error', '<br>' + 'no devices for connecting', '');
        return;
      }
    }

    createConnectionDialog('');
  }

  if (item.id == 'tools_resetActions') {
    if (saveAsStart() == 0) {
      AjaxRunActions(true, false, true); //Parameters: NO reset, NO start, DO show response
    } else {
      createInfoDialog('Error', '<br>Unable to save project file...', '');
    }
  }

  if (item.id == 'tools_resetLayout') {
    mainLayout.sizePane('north', configData.layout.north);
    mainLayout.sizePane('south', configData.layout.south);
    mainLayout.south.children.layout1.sizePane('east', configData.layout.south_east);
    mainLayout.sizePane('east', configData.layout.east);
    mainLayout.east.children.layout1.sizePane('north', configData.layout.east_north);
    mainLayout.east.children.layout1.sizePane('south', configData.layout.east_south);
    mainLayout.sizePane('west', configData.layout.west);
    mainLayout.west.children.layout1.sizePane('south', configData.layout.west_south);

    if (configData.layout.east_closed == true) {
      mainLayout.close('east');
    }
  }

  if (item.id == 'tools_resetDriver') {
    confirmMode = 'RESET_DRIVER';
    createConfirmDialog(confirmMode);
    $('#dialog_confirm').dialog('open');
  }

  if (item.id.substr(0, 18) == 'tools_setLanguage_') {
    currentLang = item.id.substr(18).toLowerCase();
    refreshLanguage();
  }

  if (item.id == 'tools_userSettings') {
    createUserSettingsDialog();
    $('#dialog_userSettings').dialog('open');
  }

  if (item.id == 'info_about') {
    $('#dialog_splash').dialog({
      width: 500,
      modal: true,
      title: 'About ...',
      show: { effect: 'blind', duration: 200 },
      buttons: [
        {
          text: 'Ok',
          icons: {
            primary: 'ui-icon-heart',
          },
          click: function() {
            $(this).dialog('close');
          },
        },
      ],
    });
  }

  if (item.id == 'info_help') {
    showHelpDialog('');
  }

  //return false;
}

function validateTable(idBlurredField) {
  var retVal = 'OK';
  var posFirstDelimiter = idBlurredField.indexOf('_');
  var posNameDelimiter = -1;
  var posDelimiter = idBlurredField.indexOf('_');
  var fieldName = '';
  var fieldIndex = -1;
  var rowIndex = -1;
  var attrIndex = -1;
  var hlpAttribute;
  var hlpChangedAttrname = '';

  posNameDelimiter = getPosDelimiter(idBlurredField, '_', 2);
  fieldName = idBlurredField.substr(posFirstDelimiter + 1, posNameDelimiter - posFirstDelimiter - 1);

  // validate tblData
  if (idBlurredField.substr(0, 7) == 'tblData') {
    fieldIndex = idBlurredField.substr(posNameDelimiter + 1);
    rowIndex = $('#tblData').appendGrid('getRowIndex', fieldIndex);

    // Error 01 - Devicename must not be empty
    if (idBlurredField.indexOf('modulname') > -1) {
      if ($.trim($('#tblData').appendGrid('getCtrlValue', fieldName, rowIndex)) == '') {
        retVal = GetErrorText('ERR_NAME_IS_EMPTY', currentLang, 'short');
      }
    }

    // Error 02 - BMK must not be empty
    if (idBlurredField.indexOf('bmk') > -1) {
      if ($.trim($('#tblData').appendGrid('getCtrlValue', fieldName, rowIndex)) == '') {
        retVal = GetErrorText('ERR_BMK_IS_EMPTY', currentLang, 'short');
      }
    }

    WriteLog(
      'To Validate: ' +
      rowIndex +
      '/' +
      idBlurredField +
      '/' +
      $('#tblData').appendGrid('getCtrlValue', fieldName, rowIndex),
    );
  }

  // validate tblEdit
  if (idBlurredField.substr(0, 7) == 'tblEdit') {
    // refresh cookie when user jumps changes values --> he is still working
    if (configData.misc.userMode == 'STANDARD') {
      if (checkSession(revPiHostname) == false) {
        //alert("Session expired ...");
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
        return 'OK'; // IMPORTANT: return OK here to prevent second opening of InfoDialog with 'Error' mode!
      }
      refreshLoginCookies(sessionExpireMin, revPiHostname);
    }

    fieldIndex = idBlurredField.substr(getPosDelimiter(idBlurredField, '_', 'LAST') + 1);
    rowIndex = $('#tblEdit').appendGrid('getRowIndex', fieldIndex);
    attrIndex = $('#tblEdit').appendGrid('getCtrlValue', 'attrindex', rowIndex);
    hlpAttribute = arrAttrs[attrIndex];

    //if (hlpAttribute.range != "") {
    //	WriteLog(hlpAttribute.range.values);
    //}

    // NAMES
    if (idBlurredField.indexOf('_attrname_') > -1) {
      hlpChangedAttrname = $('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex);

      if ($.trim($('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex), attrReservedStrings) == '') {
        retVal = GetErrorText('ERR_NAME_IS_EMPTY', currentLang, 'short');
      }

      if (retVal == 'OK' && $('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex).indexOf(' ') > -1) {
        retVal = GetErrorText('ERR_NAME_NO_BLANKS_ALLOWED', currentLang, 'short');
      }

      if (
        retVal == 'OK' &&
        $.inArray($('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex), attrReservedStrings) > -1
      ) {
        retVal = GetErrorText('ERR_NAME_IS_RESERVED', currentLang, 'short');
      }

      if (
        retVal == 'OK' &&
        !isAttrNameUnique(currentMarkedDeviceId, $('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex))
      ) {
        retVal = GetErrorText('ERR_NAME_NOT_UNIQUE', currentLang, 'short');
      }

      if (
        retVal == 'OK' &&
        $('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex).length > CONST_MAXLEN_ATTRNAME
      ) {
        retVal = GetErrorText('ERR_NAME_TO_LONG (MAX: ' + CONST_MAXLEN_ATTRNAME + ')', currentLang, 'short');
      }

      var foundReservedChar = '';
      if (retVal == 'OK') {
        $(attrInvalidChars).each(function(cntChars, charItem) {
          if ($('#tblEdit').appendGrid('getCtrlValue', 'attrname', rowIndex).indexOf(charItem) > -1) {
            foundReservedChar = charItem;
            retVal = GetErrorText('ERR_NAME_INVALID_CHARACTER', currentLang, 'short') + ': ' + charItem;
            return false;
          }
        });
      }
    } else if (idBlurredField.indexOf('_attrvalue_text_') > -1) {
      // VALUES: validate Text input fields only!
      //rowIndex = $('#tblEdit').appendGrid('getRowIndex', fieldIndex);
      var hlpRangeValues;
      var hlpRangeType;
      var hlpDataType = getDataType(hlpAttribute.type);

      if (hlpAttribute.type == 'STRING') {
        hlpRangeValues = [hlpAttribute.maxsize];
        hlpRangeType = 'string';
      } else {
        if (hlpAttribute.range == '') {
          //hlpDataType = getDataType(hlpAttribute.type);
          hlpRangeValues = hlpDataType.attr;
          hlpRangeType = '';
        } else {
          hlpRangeValues = hlpAttribute.range.values;
          hlpRangeType = hlpAttribute.range.type;
        }
      }

      if (
        isValueInRange(
          $('#tblEdit').appendGrid('getCtrlValue', fieldName, rowIndex),
          hlpRangeValues,
          hlpRangeType,
          hlpDataType,
        ) == false
      ) {
        //setTimeout(function() { $("#" +idBlurredField).focus() }, 500); // focus doesn't work if its called immediately!
        retVal = GetErrorText('ERR_VALUE_OUT_OF_RANGE', currentLang, 'short');
      }
      WriteLog(
        'To Validate: ' +
        rowIndex +
        '/' +
        idBlurredField +
        '/' +
        $('#tblEdit').appendGrid('getCtrlValue', fieldName, rowIndex),
      );
    } else {
      WriteLog('Validation of select value of field: ' + idBlurredField);
      // put future validation of select box values here !
    }

    // Extended Validation with .val file - ONLY if there are no previous errors!
    if (retVal == 'OK') {
      var valPathname = configData.paths.gsd.replace(
        '##DEVICE_ID##',
        parseDeviceId(currentMarkedDeviceId, '##ID_VERSION##'),
      );
      valPathname = valPathname.replace('.rap', '.val');
      var extVal = '';
      if (fileExists(valPathname) == true) {
        // load validation script with direct ajax call to allow synchronous mode; $.getScript is always async.
        // val files can be loaded from cache; they never change
        $.ajax({
          url: valPathname,
          async: false,
          cache: true,
          dataType: 'script',
        });

        var hlpRowIndex = getRowIndexOfDevice(currentMarkedDeviceId);
        var hlpInpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
        var hlpOutVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);
        var valueBlurredField = $('#tblEdit').appendGrid('getCtrlValue', fieldName, rowIndex);

        // extendedValidation is currently optional even if .val file exists ...
        if (typeof extendedValidation === 'function') {
          extVal = new extendedValidation(
            currentMarkedDeviceId,
            hlpInpVariant,
            hlpOutVariant,
            idBlurredField,
            valueBlurredField,
            hlpAttribute,
          );
          var retValidate = extVal.validate();
          if (retValidate != 'OK') {
            retVal = GetErrorText(retValidate, currentLang, 'short');
          }
        }
      }
    }
  }

  if (retVal == 'OK') {
    var extendedDataStoreEntry = handleExtendedDataStore(currentMarkedDeviceId, 'GET_ENTRY');
    if (extendedDataStoreEntry != '') {
      extendedDataStoreEntry.updateChangedAttrnames(hlpChangedAttrname, oldValue);
    }
  }

  return retVal;
}

/*
	supported values:
		- decimal (Standard)
		- BIN (starts with 0b or -0b)
		- HEX (starts with 0x or -0x)
		- OCT (starts with 0 or -0 and has no decimal point!)
*/
function isValueInRange(strValue, jsonRange, rangeType, dataType) {
  var value = null;

  if (rangeType.toLowerCase() == 'string') {
    if (strValue.length <= jsonRange[0]) {
      return true;
    }
  }

  // STEP 01 - check if value is number
  //
  // negative bin numbers (e.g. -0b11) are not recognized as numbers!
  if (strValue.length > 1 && strValue.substr(0, 1) == '-') {
    if (isNaN(strValue.replace('-', ''))) {
      return false;
    }
  } else if (isNaN(strValue)) {
    return false;
  }

  // STEP 02 - convert different number systems to decimal
  //
  // convert hex to decimal
  if (strValue.length > 2 && (strValue.substr(0, 2) == '0x' || strValue.substr(0, 3) == '-0x')) {
    value = parseInt(strValue, 16).toString();
  } else if (strValue.length > 2 && (strValue.substr(0, 2) == '0b' || strValue.substr(0, 3) == '-0b')) {
    // convert bin to decimal
    value = parseInt(strValue.replace('0b', '').replace('-0b', ''), 2).toString();
    //if (strValue.substr(0,3) == "-0b") {
    //	value = value * -1;
    //}
  } else if (
    strValue.length > 1 &&
    (strValue.substr(0, 1) == '0' || strValue.substr(0, 2) == '-0') &&
    strValue.indexOf('.') == -1
  ) {
    // convert oct to decimal;
    value = parseInt(strValue, 8).toString();
  } else {
    value = parseFloat(strValue).toString();
  }

  // STEP 03: check whether value is in range

  // SPECIAL CASE: check range taken von datatypes.json
  if (rangeType.toLowerCase() == '') {
    if (parseFloat(value) >= jsonRange[3] && parseFloat(value) <= jsonRange[4]) {
      return true;
    }
  }

  if (rangeType.toLowerCase() == 'tooltip_list') {
    $(jsonRange).each(function(i, item) {
      if (value == item) {
        return true;
      }
    });
  }

  if (rangeType.toLowerCase() == 'tooltip_loop') {
    // SPECIAL CASE:
    // if range runs over integer values and increment is 1
    // we do not loop but check directly whether value is
    // contained in range; this prevents 'hanging' in loop when
    // ranges is between extremely large integer numbers
    if (jsonRange[2] == 1 && jsonRange[0].toString().indexOf('.') == -1) {
      if (parseFloat(value) >= jsonRange[0] && parseFloat(value) <= jsonRange[1]) {
        return true;
      }
    } else {
      for (var i = jsonRange[0]; i <= jsonRange[1]; i = i + jsonRange[2]) {
        if (parseFloat(value) == i.toFixed(4)) {
          return true;
        }
      }
    }
  }

  return false;
}

function getPositions() {
  var hlpBaseId = $('img[class*=\'isBase\']').attr('id');
  var posBase = getContainingTableColumn(hlpBaseId);
  //var cntDevices = countDevices();
  var arrRetPositions = [];

  var cntLeft = $('img[class*=\'isLeft\']').length;
  var cntRight = $('img[class*=\'isRight\']').length;
  var cntVirtual = $('img[class*=\'isVirtual\']').length;

  // new calculation 30 31 0 32 33
  for (var i = 32 - cntLeft; i < 32; i++) {
    arrRetPositions.push(i);
  }
  arrRetPositions.push(0);
  for (var i = 32; i < 32 + cntRight; i++) {
    arrRetPositions.push(i);
  }
  for (var i = 1; i <= cntVirtual; i++) {
    arrRetPositions.push(i + 63);
  }

  return arrRetPositions;
}

function refreshColumnHeaders(arrPositions) {
  var cntPositions = 0;
  var cntColumns = 0;
  $('#dragTable tr:first')
    .find('th')
    .each(function() {
      //$(this).attr('data-header', arrPositions[cntPositions]);
      //WriteLog("xxx:" + cntPositions + "/" + isColumnUsed(cntPositions));

      // IMPORTANT: isColumnUsed only checks slots of REAL devices
      // will return -false- for VIRTUAL devices!
      if (isColumnUsed(cntColumns)) {
        // device set
        $(this).html(arrPositions[cntPositions]);
        cntPositions++;
      } else {
        // unused slot
        // if td is virtualDevice
        if (
          $('#dragTable tr')
            .eq(1)
            .find('td:eq(' + cntColumns + ')')
            .hasClass('virtualDevice') == true
        ) {
          $(this).html(arrPositions[cntPositions]);
          cntPositions++;
        } else {
          if (
            $('#dragTable tr')
              .eq(1)
              .find('td:eq(' + cntColumns + ')')
              .hasClass('virtualGap') == true
          ) {
            $(this).html('');
          } else {
            $(this).html('&#11015;');
          }
        }
      }
      cntColumns++;
    });
}

function isColumnUsed(colIndex) {
  var retVal = false;

  if (colIndex >= 0) {
    $('#dragTable tr')
      .eq(1)
      .find('td:has(img)')
      .each(function() {
        var imgId = $(this).find('img').attr('id');
        if (getDeviceType(imgId.replace('device_', '')) != 'VIRTUAL') {
          if (colIndex == getContainingTableColumn(imgId)) {
            retVal = true;
          }
        }
      });
  } else {
    retVal = 'ERROR';
  }

  return retVal;
}

function loadRAPincludes(fileGsdJSON) {
  if (typeof fileGsdJSON['input']['include'] != 'undefined') {
    var fileIncludeJSON = AjaxGetJSON(fileGsdJSON['input']['include'], 'OBJ');
    fileGsdJSON['input'] = fileIncludeJSON;
  }

  if (typeof fileGsdJSON['output']['include'] != 'undefined') {
    var fileIncludeJSON = AjaxGetJSON(fileGsdJSON['output']['include'], 'OBJ');
    fileGsdJSON['input'] = fileIncludeJSON;
  }

  if (typeof fileGsdJSON['memory']['include'] != 'undefined') {
    var fileIncludeJSON = AjaxGetJSON(fileGsdJSON['memory']['include'], 'OBJ');
    fileGsdJSON['input'] = fileIncludeJSON;
  }

  return fileGsdJSON;
}

function parseGSD(jsonGSD) {
  // Example for mandatoryFieldsInput
  // "xxx" 					--> field xxx is mandatory but can be empty
  // "xxx|NOT_EMPTY" 			--> field xxx is optional, but if it exists, it MUST NOT be empty
  // "xxx","xxx|NOT_EMPTY" 	--> field xxx is mandatory, AND it MUST NOT be empty

  var retErrors = '';
  var mandatoryErrors = '';
  var boolErrors = '';
  var typeErrors = '';
  var allAttr = [jsonGSD.input, jsonGSD.output, jsonGSD.memory];

  var mandatoryFields = ['id', 'version', 'size', 'devicetype'];
  var mandatoryFieldsInput = [
    'name',
    'type',
    'offset',
    'range',
    'range|NOT_EMPTY',
    'edit',
    'edit|NOT_EMPTY',
    'tags',
    'tags|NOT_EMPTY',
  ];

  var typesFields = {
    name: 'string',
    type: 'string',
    offset: 'number',
    default: 'string',
    unit: 'string',
    tags: 'string',
    edit: 'string',
    order: 'number',
    description: 'string',
    comment: 'string',
    active: 'boolean',
    export: 'boolean',
    multi: 'number',
    'range.type': 'string',
  };
  var hlpSplit = [];

  // Check 01 - mandatory fields on device level
  for (var i = 0; i < mandatoryFields.length; i++) {
    if (typeof jsonGSD[mandatoryFields[i]] == 'undefined' || jsonGSD[mandatoryFields[i]] == '') {
      mandatoryErrors += mandatoryFields[i] + ',';
    }
  }

  // Check 02 - mandatory fields on input level
  /*
	var hlpAttrTypeName = ["input","output","memory"];
	for (var i=0; i<mandatoryFieldsInput.length; i++) {
		// loop over input / output / memory level
		$.each(allAttr, function(cntAttrType,itemAttrType) {
			$.each(itemAttrType, function(cntInp,itemInp) {
				hlpSplit = mandatoryFieldsInput[i].split("|");
				//console.log(hlpSplit[0] + ": " + checkJSONdatatype(itemInp[hlpSplit[0]],""));
				if ((hlpSplit.length == 1) && (typeof(itemInp[mandatoryFieldsInput[i]]) == 'undefined')) {
					mandatoryErrors += hlpAttrTypeName[cntAttrType] + "[" + cntInp +"]" + "..." + mandatoryFieldsInput[i] + ",";
				} else {
					if ((hlpSplit.length == 2) && (hlpSplit[1] == "NOT_EMPTY")) {
						if(typeof(itemInp[hlpSplit[0]]) !== 'undefined') {
							if ((itemInp[hlpSplit[0]] == "") || $.isEmptyObject(itemInp[hlpSplit[0]])) {
								mandatoryErrors += hlpAttrTypeName[cntAttrType] + "[" + cntInp +"]" + "..." + hlpSplit[0] + ",";
							}
						}
					}
				}
			});
		});
	}
	*/

  if (mandatoryErrors != '') {
    retErrors += 'Fields missing or invalid: ' + mandatoryErrors;
  }

  //var hlpArr = [
  //	jsonGSD['input'],jsonGSD['output'],jsonGSD['memory']
  //];

  var hlpArr = [];
  var hlpName = '';
  if (typeof jsonGSD['input'].variants == 'undefined') {
    hlpArr.push(jsonGSD['input']);
  } else {
    /* ToDo: not working yet - must take variant rules into account!
		$.each(jsonGSD['input'].variants, function(variantsIndex,variant) {
			$.each(variant.data, function(variantsDataIndex,variantData) {
				hlpName = variantData.name + "_INPUT_" + variant.id;
			});
			hlpArr.push(hlpName);
		});
		*/
  }

  if (typeof jsonGSD['output'].variants == 'undefined') {
    hlpArr.push(jsonGSD['output']);
  } else {
    /* ToDo: not working yet - must take variant rules into account!
		$.each(jsonGSD['output'].variants, function(variantsIndex,variant) {
			$.each(variant.data, function(variantsDataIndex,variantData) {
				hlpName = variantData.name + "_OUTPUT_" + variant.id;
			});
			hlpArr.push(hlpName);
		});
		*/
  }

  // no variants for memory exist - just add the memory block as is
  hlpArr.push(jsonGSD['memory']);

  // Loop over all fields for individual checks
  //
  var remainder;
  var currentType;
  $.each(hlpArr, function(attrsIndex, attrs) {
    if (attrs.length > 0) {
      $.each(attrs, function(attrIndex, attr) {
        // Check 03 - BOOL fields must have multi:8 !!!
        if (attr.type.toUpperCase() == 'BOOL') {
          if (typeof attr.multi != 'undefined') {
            remainder = (attr.multi % 8) / 100;
            if (!(remainder === 0)) {
              boolErrors += attr.name + ',';
            }
          }
        }

        // check 04 - check JSON field types
        // loop over attr fields and check type
        for (var attrFieldKey in attr) {
          if ($.type(attr[attrFieldKey]) == 'object') {
            for (var attrFieldKeyL2 in attr[attrFieldKey]) {
              if (typeof typesFields[attrFieldKey + '.' + attrFieldKeyL2] !== 'undefined') {
                if (
                  checkJSONdatatype(
                    attr[attrFieldKey][attrFieldKeyL2],
                    typesFields[attrFieldKey + '.' + attrFieldKeyL2],
                  ) == false
                ) {
                  typeErrors +=
                    attrFieldKey +
                    '.' +
                    attrFieldKeyL2 +
                    ' (expected:' +
                    typesFields[attrFieldKey + '.' + attrFieldKeyL2] +
                    ')' +
                    ',';
                }
              }
            }
          } else {
            if (typeof typesFields[attrFieldKey] !== 'undefined') {
              if (checkJSONdatatype(attr[attrFieldKey], typesFields[attrFieldKey]) == false) {
                typeErrors += attrFieldKey + ' (expected:' + typesFields[attrFieldKey] + ')' + ',';
              }
            }
          }
        }
      });
    }
  });
  if (boolErrors != '') {
    retErrors += 'BOOL fields must have multiple of 8: ' + boolErrors;
  }
  if (typeErrors != '') {
    retErrors += 'Fields have invalid types: ' + typeErrors;
  }

  // Check 05 - field names must be unique !!!
  // IMPORTANT: doesn't work for variants yet !!
  var arrAttrNames = [];
  var cntAttrName = '';
  $.each(hlpArr, function(attrsIndex, attrs) {
    if (attrs.length > 0) {
      $.each(attrs, function(attrIndex, attr) {
        cntAttrName = getCntAttrName(arrAttrNames, attr.name);
        arrAttrNames.push(attr.name);
        if (cntAttrName > 0) {
          retErrors += ' field name not unique: ' + attr.name;
        }
      });
    }
  });

  // Check 06 - check whether offsets are without gaps!
  //
  // TODO - TODO - TODO
  //

  retErrors = killLastDelimiter(retErrors, ',');
  return retErrors;
}

function handleTableData(tableName, id, mode) {
  // id can be rowId or deviceId !

  var hlpRet = '';
  var hlpRowId = '';
  var hlpDeviceId = '';

  if (tableName == 'tblEdit') {
    // STEP 00: get Variants
    var inpVariant = 0;
    var outVariant = 0;
    var hlpDeviceIdAndVariants = id.split(',');
    // Case 01: id only contains deviceID
    if (hlpDeviceIdAndVariants.length == 1) {
      var hlpRowIndex = getRowIndexOfDevice(id);
      inpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
      outVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);
    } else {
      inpVariant = hlpDeviceIdAndVariants[1];
      outVariant = hlpDeviceIdAndVariants[2];
    }

    hlpDeviceId = hlpDeviceIdAndVariants[0];
  } else {
    hlpDeviceId = id;
  }

  if (mode == 'STORE') {
    if (tableName == 'tblData') {
      tblDataStore = $('#tblData').appendGrid('getAllValue');
    }
    if (tableName == 'tblEdit') {
      /*
			// STEP 00: get Variants
			var inpVariant = 0;
			var outVariant = 0;
			var hlpDeviceIdAndVariants = id.split(",");
			// Case 01: id only contains deviceID
			if (hlpDeviceIdAndVariants.length == 1) {
			var hlpRowIndex = getRowIndexOfDevice(id);
			inpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
			outVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);
			} else {
				inpVariant = hlpDeviceIdAndVariants[1];
				outVariant = hlpDeviceIdAndVariants[2];
			}
			*/

      // STEP 01: delete entry if it already exists
      removeFromEditStore(hlpDeviceId);

      // STEP 02: insert new values
      var deviceObj = new Object();
      deviceObj.id = hlpDeviceId;
      deviceObj.inpVariant = inpVariant;
      deviceObj.outVariant = outVariant;
      deviceObj.data = $('#tblEdit').appendGrid('getAllValue');
      tblEditStore.push(deviceObj);

      //WriteLog("tblEdit-data stored of device: " + id + "/" + inpVariant + "/" + outVariant);
    }
  }

  if (mode == 'GETALL') {
    if (tableName == 'tblEdit') {
      var retData = [];

      // OLD method
      //var hlpSelector = ".id:val(" + "\"" + id + "\""	+ ") ~ .data";
      //hlpData = JSONSelect.match(hlpSelector,  tblEditStore);

      //var hlpRowIndex = getRowIndexOfDevice(id);
      //var inpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
      //var outVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);
      $.each(tblEditStore, function(cntEntries, entry) {
        if (entry.id == hlpDeviceId && entry.inpVariant == inpVariant && entry.outVariant == outVariant) {
          retData = entry.data;
        }
      });

      return retData;

      //return hlpData; .... OLD method
    }
  }

  /*
	if (mode == "GETENTRY") {
		var hlpDeviceIdString = "";
		if (tableName == "tblData") {
			hlpDeviceIdString = "\"" + hlpDeviceId + "\"";
			hlpRet = JSONSelect.match(":has(:root > .deviceId:val(" + hlpDeviceIdString + "))",  tblDataStore);
		}
		if (tableName == "tblEdit") {
			hlpDeviceIdString = "\"" + hlpDeviceId + "\"";
			hlpRet = JSONSelect.match(":has(:root > .id:val(" + hlpDeviceIdString + "))",  tblEditStore);
		}
	}
	*/

  if (mode == 'GETENTRY') {
    var hlpDeviceIdString = '';
    if (tableName == 'tblData') {
      hlpDeviceIdString = '"' + hlpDeviceId + '"';
      hlpRet = JSONSelect.match(':has(:root > .deviceId:val(' + hlpDeviceIdString + '))', tblDataStore);
    }
    if (tableName == 'tblEdit') {
      $.each(tblEditStore, function(cntEntries, entry) {
        if (entry.id == hlpDeviceId && entry.inpVariant == inpVariant && entry.outVariant == outVariant) {
          hlpRet = entry;
        }
      });
    }
  }

  return hlpRet;
}

function loadValues(deviceId, mode) {
  //displayTblEdit("HIDE");

  // refresh cookie when user jumps to different device --> he is still working
  if (configData.misc.userMode == 'STANDARD') {
    if (checkSession(revPiHostname) == false) {
      //alert("Session expired ...");
      createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      //window.location.href = configData.paths.login;
      return;
    }
    refreshLoginCookies(sessionExpireMin, revPiHostname);
  }

  loadGSDData(deviceId);
  refreshDelegates();

  handleTableData('tblData', '', 'STORE');
  handleTableData('tblEdit', deviceId, 'STORE');

  // hide all rows with 'hidden' edit state (4)
  $('[id^=\'tblEdit_attrhidden_\']').each(function() {
    if ($(this).attr('id').indexOf('_head') == -1 && $(this).attr('id').indexOf('_td') == -1) {
      var posDelimiter = getPosDelimiter($(this).attr('id'), '_', 'LAST');
      var fieldIndex = $(this)
        .attr('id')
        .substr(posDelimiter + 1);
      var hlpIndex = $('#tblEdit').appendGrid('getRowIndex', fieldIndex);
      if ($('#tblEdit').appendGrid('getCtrlValue', 'attrhidden', hlpIndex) == 'true') {
        var $tr = $(this).closest('tr');
        //IMPORTANT: Doesn't work here since hidden fields with 'hide' will not be
        //handled correctly on Export an saving to STORE
        //$tr.hide();
        $tr.css('display', 'none');
      }
    }
  });

  // make names unique - only for normal adding of devices;
  // not necessary when project file is loaded via appendDevice
  // since all attrs MUST be unique already!
  // THIS IS A PERFOMANCE OPTIMIZING MEASURE TO MAKE LOADING OF LARGE .RSC FILES FASTER!
  if (mode != 'LOAD_FAST') {
    makeAttrNamesUnique(deviceId);
  }

  if (handleModifyStore(deviceId.replace('device_', ''), 'GET') == false) {
    modifyAttr(deviceId);
  }

  //displayTblEdit("SHOW");
}

function loadGSDData(deviceId) {
  var gsdDeviceId = getGsdDeviceId(deviceId);
  var pathnameGSD = configData.paths.gsd.replace('##DEVICE_ID##', gsdDeviceId);

  currentAttrDeviceId = deviceId; // global variable to access deviceId when filling tblEdit

  // RAP files are no longer checked with -fileExists- before loading
  // to increase perfomance when client side caching is not working!
  fileGsdJSON = AjaxGetJSON(pathnameGSD, 'OBJ');

  // process optional includes
  fileGsdJSON = loadRAPincludes(fileGsdJSON);

  // parse GSD data
  var retParse = parseGSD(fileGsdJSON);
  if (retParse != '') {
    //alert("ERROR(s) in RAP file: " + pathnameGSD + " ... " + retParse);
    createInfoDialog('Error', '<br>' + 'ERROR(s) in RAP file: ' + pathnameGSD + ' ... ' + retParse, '');
    return;
  }

  clearEditTable();

  // Loop over INPUT / OUTPUT / MEMORY attributes
  arrAttrs.length = 0;
  // Two versions - flat / with variants

  // INPUT
  var cntVariants = 0;
  var cntInput = 0;
  var currentSelectedVariant = -1;
  //if (fileGsdJSON.input.length > 0) {
  if (typeof fileGsdJSON.input.variants == 'undefined') {
    $.each(fileGsdJSON.input, function(i, item) {
      if (typeof item.active == 'undefined' || item.active == true) {
        arrAttrs.push(item);
        if (typeof item.multi != 'undefined') {
          cntInput += item.multi;
        } else {
          cntInput++;
        }
      }
    });
  } else {
    $.each(fileGsdJSON.input.variants, function(cntVariants, variant) {
      $.each(variant.data, function(cntData, data) {
        // only consider active input entries
        if (typeof data.active == 'undefined' || data.active == true) {
          if (
            cntVariants == parseInt($('#tblData').appendGrid('getCtrlValue', 'input', getRowIndexOfDevice(deviceId)))
          ) {
            arrAttrs.push(data);
          }

          // handle multi
          if (typeof data.multi != 'undefined') {
            cntInput += data.multi;
          } else {
            cntInput++;
          }
        }
      });

      cntInput = 0;
      cntVariants++; // increment here to set counter parallel to array index (starting with 0)
    });

    lastChangedInputValue = -1;
  }
  //}

  // OUTPUT
  cntVariants = 0;
  var cntOutput = 0;
  currentSelectedVariant = -1;
  //if (fileGsdJSON.output.length > 0) {
  if (typeof fileGsdJSON.output.variants == 'undefined') {
    $.each(fileGsdJSON.output, function(i, item) {
      if (typeof item.active == 'undefined' || item.active == true) {
        arrAttrs.push(item);
        if (typeof item.multi != 'undefined') {
          cntOutput += item.multi;
        } else {
          cntOutput++;
        }
      }
    });
  } else {
    $.each(fileGsdJSON.output.variants, function(cntVariants, variant) {
      $.each(variant.data, function(cntData, data) {
        // only consider active output entries
        if (typeof data.active == 'undefined' || data.active == true) {
          if (
            cntVariants == parseInt($('#tblData').appendGrid('getCtrlValue', 'output', getRowIndexOfDevice(deviceId)))
          ) {
            arrAttrs.push(data);
          }

          // handle multi
          if (typeof data.multi != 'undefined') {
            cntOutput += data.multi;
          } else {
            cntOutput++;
          }
        }
      });

      cntOutput = 0;
      cntVariants++; // increment here to set counter parallel to array index (starting with 0)
    });
    lastChangedOutputValue = -1;
  }
  //}

  // MEMORY
  // IMPORTANT: 	currently (08/2016) there is no option to change variants of memory attributes in the GUI
  //				DON'T USE VARIANTS FOR MEMORY ATTRIBUTES!
  cntVariants = 0;
  var cntMemory = 0;
  currentSelectedVariant = -1;
  if (fileGsdJSON.memory.length > 0) {
    if (typeof fileGsdJSON.memory.variants == 'undefined') {
      $.each(fileGsdJSON.memory, function(i, item) {
        if (typeof item.active == 'undefined' || item.active == true) {
          arrAttrs.push(item);
          if (typeof item.multi != 'undefined') {
            cntMemory += item.multi;
          } else {
            cntMemory++;
          }
        }
      });
    } else {
      $.each(fileGsdJSON.memory.variants, function(cntVariants, variant) {
        $.each(variant.data, function(cntData, data) {
          // only consider active memory entries
          if (typeof data.active == 'undefined' || data.active == true) {
            if (
              cntVariants == parseInt($('#tblData').appendGrid('getCtrlValue', 'memory', getRowIndexOfDevice(deviceId)))
            ) {
              arrAttrs.push(data);
            }

            // handle multi
            if (typeof data.multi != 'undefined') {
              cntMemory += data.multi;
            } else {
              cntMemory++;
            }
          }
        });

        cntMemory = 0;
        cntVariants++; // increment here to set counter parallel to array index (starting with 0)
      });
      lastChangedMemoryValue = -1;
    }
  }

  /* MEMORY
	$.each(fileGsdJSON.memory, function(i, item) {
		if (typeof(item.active) == 'undefined' || item.active == true ) {
			arrAttrs.push(item);
		}
	});
	*/

  // re-order attributes
  arrAttrs = sortJSON(arrAttrs, 'order');

  // create -appendRow- commands
  // IMPORTANT: attrvalue is not actual value but array index of attribute
  //WriteLog('START LOAD VALUES TABLE');
  displayTblEdit('HIDE'); // hide table - better performance!

  currentEditData = handleTableData('tblEdit', deviceId, 'GETALL'); // IMPORTANT: this is used in tblEdit setters!!
  gblAllMulti = 0;
  gblSaveMultiName = '';

  //WriteLog("EDIT fill START");
  $.each(arrAttrs, function(cntItems, item) {
    var cntMulti = 1;
    gblCntMultiName = 1;
    if (typeof item.multi != 'undefined') {
      cntMulti = item.multi;
      //gblCntMultiName = 1;
      //gblAllMulti += item.multi;
    } else {
      //gblCntMultiName = 1;
      //gblAllMulti += 1;

      // IMPORTANT: set multi to 8 for BOOL values
      // if not present in RAP file
      if (item.type == 'BOOL') {
        cntMulti = 8;
        arrAttrs[cntItems].multi = 8;
      }
    }

    // if we already loop over the arrAttrs, we can do some cleaning work here before populating edit table
    // 1. trimming, 2. replace not allowed characters in names
    item.name = $.trim(item.name);
    item.name = replaceSpecialChars(item.name);
    // optional translate
    if (item.name.substr(0, 5) == 'lang_') {
      item.name = TextTranslate(fileGsdJSON.lang, currentLang, item.name.replace('lang_', '##LANG_') + '##');
    }

    // escape commas in range.values strings
    $.each(item.range.values, function(cntValues, itemValue) {
      if (typeof itemValue == 'string') {
        item.range.values[cntValues] = item.range.values[cntValues].replace(',', handleEscStr('ESC', ','));
      }
    });

    var hlpEdit = item.edit;
    for (var i = 1; i <= cntMulti; i++) {
      // multidata optionally overwrites edit attribute
      // IMPORTANT: here only edit 4 (hidden) is evaluated to -true- for hiding of row
      if (typeof item.multidata != 'undefined' && typeof item.multidata.edit != 'undefined') {
        if (i <= item.multidata.edit.length && item.multidata.edit[i - 1] != '') {
          hlpEdit = item.multidata.edit[i - 1];
        } else {
          hlpEdit = item.edit;
        }
      } else {
        hlpEdit = item.edit;
      }

      $('#tblEdit').appendGrid('appendRow', [
        {
          attrtype: cntItems,
          attrname: cntItems,
          attrvalue: cntItems,
          attrunit: cntItems,
          attrexport: cntItems,
          attrindex: cntItems,
          attrGSDname: item.name,
          attrGSDtype: item.type,
          attrGSDtags: item.tags.toLowerCase(),
          attrGSDrangeValue: item.range.values,
          attrGSDrangeType: item.range.type,
          attrGSDmaxsize: typeof item.maxsize == 'undefined' ? 0 : item.maxsize,
          attrGSDoffset: typeof item.offset == 'undefined' ? 'ERR_NO_OFFSET' : item.offset,
          attrGSDcomment: cntItems,
          attrGSDmulti: typeof item.multi == 'undefined' ? 1 : item.multi,
          attrhidden: hlpEdit == 4 ? 'true' : 'false',
          attrmulticount: i,
        },
      ]);
      //$('#tblEdit').appendGrid('appendRow', [{'attrtype': cntItems, 'attrname': cntItems, 'attrvalue': cntItems, 'attrunit': cntItems, 'attrexport': cntItems, 'attrindex': cntItems, 'attrGSDname': item.name, 'attrGSDtype': item.type, 'attrGSDtags': item.tags.toLowerCase(), 'attrGSDrangeValue': item.range.values, 'attrGSDrangeType': item.range.type, 'attrGSDmaxsize': typeof(item.maxsize) == "undefined" ? 0 : item.maxsize, 'attrGSDoffset': typeof(item.offset) == "undefined" ? 'ERR_NO_OFFSET' : item.offset, 'attrGSDcomment': cntItems, 'attrGSDmulti': typeof(item.multi) == "undefined" ? 1 : item.multi, 'attrhidden': item.edit == 4 ? "true":"false", 'attrmulticount':i}]);
    }

    if (typeof item.multi != 'undefined') {
      gblAllMulti += item.multi;
    } else {
      gblAllMulti += 1;
    }
  });

  //WriteLog("EDIT fill END");

  // NOW show edit table!
  displayTblEdit('SHOW');
  //WriteLog('END LOAD VALUES TABLE');
}

function processConfirm() {
  if (confirmMode == 'CLEAR') {
    if (confirmResult == true) {
      resetAll();
    }
  }

  if (confirmMode == 'EXIT') {
    if (confirmResult == true) {
      window.location.href = window.isSSOHost ? 'php/logout.php' : configData.paths.login;
    }
  }

  if (confirmMode == 'RESET_DATA') {
    if (confirmResult == true) {
      removeFromEditStore(idDeviceContextMenu);
      loadGSDData(idDeviceContextMenu);
      refreshDelegates();
    }
  }

  if (confirmMode == 'OPEN_PROJECT') {
    if (confirmResult == true) {
      var projectData = AjaxGetJSON(configData.paths.projects + currentProjectFilename + '.rsc', 'OBJ');
      if (typeof projectData.App.version != 'undefined' && checkRSCversion(projectData.App.version) == false) {
        //alert('Project file has been created with newer version of PiCtory - loading not possible!');
        createInfoDialog(
          'Error',
          '<br>' + 'Project file has been created with newer version of PiCtory - loading not possible!',
          '',
        );
        return;
      }

      // reset dragtable to empty
      resetAll();

      blockUI(5);

      // device data
      cntAppendedDevices = 0;
      $(projectData.Devices).each(function(cntDevices, deviceItem) {
        appendDevice(deviceItem);
        currentMarkedDeviceId = deviceItem.id;
        cntAppendedDevices++;
      });

      // this restores rules of devices and checks them AFTER ALL devices have been appended
      var cntRulesErrors = 0;
      $(projectData.Devices).each(function(cntDevices, deviceItem) {
        var retRules = checkRules(deviceItem.id, '');
        if (retRules != 'OK') {
          alert(GetErrorText(retRules, currentLang, 'short'));
          cntRulesErrors++;
        }
      });

      if (cntRulesErrors > 0) {
        alert('=IMPORTANT= Project file violates at least one rule and may be unusable!');
      }

      expandDragTable('PAD_EDGES', 0);
      refreshDataTable();
      refreshHandlers();
      refreshDelegates();

      setMarkedDevice(currentMarkedDeviceId); // mark last device
      setProjectInfo(currentProjectFilename, getProjectFileLastSaved(currentProjectFilename, 'd.m.Y H:i:s'));

      // connection data
      connectionStore = []; // reset!
      setTimeout(function() {
        // do this in timeout to synchronize with loading of EditStore-Data
        // without timeout, EditStore-Data is not yet available at this point!
        $(projectData.Connections).each(function(cntConn, connItem) {
          handleConnections(
            '',
            connItem.srcGUID,
            connItem.destGUID,
            connItem.srcInpVariant + '|' + connItem.srcOutVariant,
            connItem.destInpVariant + '|' + connItem.destOutVariant,
            connItem.srcRAPname + '-$-' + connItem.srcMulticount,
            connItem.destRAPname + '-$-' + connItem.destMulticount,
            'ADD',
          );
        });
      }, 1);

      // set language
      if (typeof projectData.App.language != 'undefined') {
        currentLang = projectData.App.language;
        refreshLanguage();
      }

      // set layout
      window.startState = projectData.App.layout;
      mainLayout.loadState(startState, { animateLoad: true });

      // resize display
      resizeDisplay();

      // reset dirty flag
      swtIsDirty = false;
    }
  }

  if (confirmMode == 'RESET_DRIVER') {
    if (confirmResult == true) {
      // IMPORTANT SECURITY MEASURE:
      // resetdriver not gets path from php internal config
      // no longer needed to provide path als parameter!
      AjaxResetDriver('');
    }
  }
}

function removeFromEditStore(deviceId) {
  var ids = JSONSelect.match('.id', tblEditStore);
  var inpVariants = JSONSelect.match('.inpVariant', tblEditStore);
  var outVariants = JSONSelect.match('.outVariant', tblEditStore);

  var hlpRowIndex = getRowIndexOfDevice(deviceId);
  var inpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
  var outVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);

  for (var i = 0; i < ids.length; i++) {
    if (ids[i] == deviceId && inpVariants[i] == inpVariant && outVariants[i] == outVariant) {
      tblEditStore.splice(i, 1);
    }
  }
}

function getGsdDeviceId(deviceId) {
  var retValue = deviceId;
  var posDelimiter;

  retValue = retValue.replace('device_', '');
  posDelimiter = getPosDelimiter(retValue, '_', 'LAST');
  retValue = retValue.substr(0, retValue.length - (retValue.length - posDelimiter));

  return retValue;
}

function getDataType(type) {
  var jsonRet = '';

  if (fileDataTypesJSON.length == 0) {
    fileDataTypesJSON = AjaxGetJSON('resources/data/validation/datatypes.json', 'OBJ');
  }

  $(fileDataTypesJSON.datatypes).each(function() {
    if ($(this)[0].name == type) {
      jsonRet = this;
      return false;
    }
  });
  return jsonRet;
}

function isAttrNameUnique(deviceId, attrName) {
  var hlpRet = true;
  $(tblEditStore).each(function(cntStoreItems, storeItem) {
    //if (storeItem.id == deviceId) {
    $(storeItem.data).each(function(cntDataItems, dataItem) {
      if ($.trim(dataItem.attrname) == $.trim(attrName)) {
        hlpRet = false;
        return false;
      }
    });
    //}
  });
  return hlpRet;
}

function displayTblEdit(mode) {
  if (mode == 'HIDE') {
    $('#tblEdit').css('visibility', 'hidden');
    $('#tblEditBanner').css('visibility', 'visible');
    $('#tblEditBanner').insertBefore($('#tblEdit'));
    //$("#tblEdit").hide();
    //$("#tblEditBanner").show();
  }
  if (mode == 'SHOW') {
    $('#tblEditBanner').css('visibility', 'hidden');
    $('#tblEdit').css('visibility', 'visible');
    $('#tblEditBanner').insertAfter($('#tblEdit'));
    //$("#tblEditBanner").hide();
    //$("#tblEdit").show();
  }
}

function getUniqueIndexOfDevice(deviceId) {
  var cntRows = $('#tblData').appendGrid('getRowCount');
  for (var i = 0; i < cntRows; i++) {
    var hlpDeviceId = $('#tblData').appendGrid('getCtrlValue', 'deviceId', i);
    if (hlpDeviceId == deviceId) {
      return $('#tblData').appendGrid('getUniqueIndex', i);
    }
  }

  return -1;
}

function getRowIndexOfDevice(deviceId) {
  var cntRows = $('#tblData').appendGrid('getRowCount');
  for (var i = 0; i < cntRows; i++) {
    var hlpDeviceId = $('#tblData').appendGrid('getCtrlValue', 'deviceId', i);
    if (hlpDeviceId == deviceId) {
      return i;
    }
  }

  return -1;
}

function getRowIndexOfControl(controlId, table) {
  var hlpPosDelimiter = getPosDelimiter(controlId, '_', 'LAST');
  var hlpRowIndex = $('#' + table).appendGrid('getRowIndex', controlId.substr(hlpPosDelimiter + 1));

  if (hlpRowIndex != null) {
    return hlpRowIndex;
  }

  return -1;
}

function doAutoSave() {
  var hlpProjectName = '';

  if (swtIsDirty == false) {
    return; // NO AUTOSAVE IF NOTHING HAS BEEN CHANGED ...
  }

  if ($('#lblProjectInfo02').html() == 'config') {
    hlpProjectName = '_config';
  } else {
    hlpProjectName = $('#lblProjectInfo02').html();
  }

  doExport('project.json', $.trim(hlpProjectName) + '.rsc', false, false);
  swtIsDirty = false;
  setProjectInfo(
    $.trim(hlpProjectName).replace('_', ''),
    getProjectFileLastSaved($.trim(hlpProjectName), 'd.m.Y H:i:s') + ' (autosaved)',
  );
}

function doExport(filenameExportPattern, filenameExportFile, swtAutoExport, swtShowOnly) {
  var hlpRet = 'OK';

  var editData = [];
  var arrAttrNames = [];

  var app_work = '';
  var summary_work = '';
  var device_work = '';
  var device_out = '';
  var attr_work = '';
  var attr_out = '';
  var connection_work = '';
  var connection_out = '';
  var cntDevices = 0;
  var cntAttr = 0;
  var hlpAttrLen = 0;
  var cntAttrInpLen = 0;
  var cntAttrOutLen = 0;
  var cntAttrMemLen = 0;
  var deviceInpStartOffset = -1;
  var deviceOutStartOffset = -1;
  var deviceMemStartOffset = -1;
  var cntDeviceAttrInpLen = 0;
  var cntDeviceAttrOutLen = 0;
  var cntDeviceAttrMemLen = 0;
  var cntOrder = 0;
  var hlpTags = '';
  var cntMultiName = 1;
  var saveMultiName = '';
  var saveOffset = -1;
  var saveGSDname = '';
  var cntBool = 0; // BOOL counter starts with open to 0
  var cntBool_A = 0;
  var hlpAttrOffset = 0;
  var hlpAttrOffset2 = 0;
  var hlpDeviceOffset = 0;
  var saveFullOffset = 0;
  var sumAttrLenOfDevice = 0;
  var saveLastType = '';
  var saveLastName = '';
  var swtStartOffsetVirtual = false;
  var bitOverflow = 0;

  // Load export pattern
  var exportPatterns = AjaxGetJSON(configData.paths.export + filenameExportPattern, 'OBJ');
  if (exportPatterns == 'ERR_NO_DATA') {
    // JSON of pattern was invalid!
    return;
  }

  var final_work = exportPatterns.final;

  // asign optional parts
  if (typeof exportPatterns.app != 'undefined') {
    app_work = exportPatterns.app;
    app_work = app_work.replace('##APP_NAME##', configData.name);
    app_work = app_work.replace('##APP_VERSION##', configData.version);
    app_work = app_work.replace('##APP_SAVETS##', currentExportTS);
    app_work = app_work.replace('##APP_LANGUAGE##', currentLang);
    app_work = app_work.replace('##APP_LAYOUT##', JSON.stringify(mainLayout.readState()));
  }

  if (typeof exportPatterns.summary != 'undefined') {
    summary_work = exportPatterns.summary;
  }

  // Loop Level 01 - over devices
  $(tblDataStore).each(function(cntDeviceData, deviceDataItem) {
    cntDevices++;
    saveGSDname = '';
    cntOrder = 0; // reset order - is internal to each device!
    cntMultiName = 1; // reset counter of multis per device
    hlpAttrLen = 0;
    hlpAttrOffset = 0;

    deviceInpStartOffset = -1; // reset device internal start offsets
    deviceOutStartOffset = -1;
    deviceMemStartOffset = -1;

    cntDeviceAttrInpLen = 0; // reset device internal len counters
    cntDeviceAttrOutLen = 0;
    cntDeviceAttrMemLen = 0;

    //if ((getDeviceType(deviceDataItem.deviceId.replace("device_","")) == "VIRTUAL") && (swtStartOffsetVirtual == false)) {
    //	hlpDeviceOffset = configData.misc.startOffsetVirtual;
    //	swtStartOffsetVirtual = true;
    //}

    if (typeof exportPatterns.device != 'undefined') {
      device_work = exportPatterns.device;
      device_work = device_work.replace(/##CATALOG_NR##/g, parseDeviceId(deviceDataItem.deviceId, '##ID##'));
      device_work = device_work.replace(/##DEVICE_GUID##/g, deviceDataItem.GUID);
      device_work = device_work.replace(/##DEVICE_ID##/g, deviceDataItem.deviceId);
      device_work = device_work.replace(/##DEVICE_TYPE##/g, deviceDataItem.deviceType);
      device_work = device_work.replace(
        /##DEVICE_PRODUCTTYPE##/g,
        getGsdData(deviceDataItem.deviceId, '##GSD_PRODUCTTYPE##'),
      );
      device_work = device_work.replace(/##DEVICE_POSITION##/g, deviceDataItem.position);
      device_work = device_work.replace(/##DEVICE_NAME##/g, deviceDataItem.modulname);
      device_work = device_work.replace(/##DEVICE_BMK##/g, deviceDataItem.bmk);
      device_work = device_work.replace(/##DEVICE_INPVARIANT##/g, deviceDataItem.input);
      device_work = device_work.replace(/##DEVICE_OUTVARIANT##/g, deviceDataItem.output);
      device_work = device_work.replace(/##DEVICE_OFFSET##/g, hlpDeviceOffset);
      device_work = device_work.replace(/##DEVICE_COMMENT##/g, deviceDataItem.comment);

      if (getDeviceState(deviceDataItem.deviceId) == 'active') {
        device_work = device_work.replace(/##DEVICE_ACTIVE##/g, 'true');
      } else {
        device_work = device_work.replace(/##DEVICE_ACTIVE##/g, 'false');
      }
    }

    editData = handleTableData(
      'tblEdit',
      deviceDataItem.deviceId + ',' + deviceDataItem.input + ',' + deviceDataItem.output,
      'GETALL',
    );
    // Loop Level 02 - over edit data (attr fields of device)
    attr_inp = '';
    attr_out = '';
    attr_mem = '';
    attr_cnt_inp = 0;
    attr_cnt_out = 0;
    attr_cnt_mem = 0;

    sumAttrLenOfDevice = 0;
    $(editData).each(function(cntAttr, attrItem) {
      hlpTags = attrItem.attrGSDtags;

      //ALL DEVICES ARE USED FOR OFFSET CALCULATION - EVEN IF THEY DON'T EXPORT ANY VALUES
      //if ((attrItem.attrexport == true) || (filenameExportPattern == "project.json")) {

      attr_work = '';
      if (hlpTags.indexOf('input') > -1) {
        attr_work = typeof exportPatterns.attr_inp != 'undefined' ? exportPatterns.attr_inp : '';
        attr_work = attr_work.replace('##ATTR_COUNT##', attr_cnt_inp);
        attr_cnt_inp++;
      }
      if (hlpTags.indexOf('output') > -1) {
        attr_work = typeof exportPatterns.attr_out != 'undefined' ? exportPatterns.attr_out : '';
        attr_work = attr_work.replace('##ATTR_COUNT##', attr_cnt_out);
        attr_cnt_out++;
      }
      if (hlpTags.indexOf('memory') > -1) {
        attr_work = typeof exportPatterns.attr_mem != 'undefined' ? exportPatterns.attr_mem : '';
        attr_work = attr_work.replace('##ATTR_COUNT##', attr_cnt_mem);
        attr_cnt_mem++;
      }

      // handle BOOL level counter
      if (attrItem.attrGSDtype.toUpperCase() == 'BOOL') {
        if (saveGSDname == attrItem.attrGSDname) {
          cntBool++;
          cntBool_A++;
        } else {
          saveGSDname = attrItem.attrGSDname;
          cntBool = 0; // BOOL counter starts with increment to 0
          cntBool_A = 0;
          bitOverflow = 0;
        }

        attr_work = attr_work.replace('##BITSEP##', '.');
        attr_work = attr_work.replace('##ATTR_BIT##', cntBool);
        // alternative Bit target: forces .0 Bit value for non BOOL values
        attr_work = attr_work.replace(/##ATTR_BIT_ZERO##/g, cntBool);

        // special handling of alternative BIT export
        // -cntBool_A- counter runs from 0-7 only, starts over at 0 but increments byte offset counter
        if (cntBool_A == 8) {
          cntBool_A = 0;
          bitOverflow++;
        }
        attr_work = attr_work.replace('##ATTR_BIT_A##', cntBool_A);
      }

      // calculate bit/byte length
      if (attrItem.attrGSDtype == 'STRING') {
        hlpAttrLen = attrItem.attrGSDmaxsize * 8; // maxsize is given in Bytes
      } else {
        if (attrItem.attrGSDtype == 'BOOL') {
          //hlpAttrLen = 0;
          hlpAttrLen = parseInt(getDataType(attrItem.attrGSDtype).attr[fileDataTypesJSON.constants.BITLEN]);
          //hlpAttrLen = 8;
        } else {
          // all types except STRING and BOOL
          hlpAttrLen = parseInt(getDataType(attrItem.attrGSDtype).attr[fileDataTypesJSON.constants.BITLEN]);
        }
      }

      attr_work = attr_work.replace('##ATTR_BITLEN##', hlpAttrLen);
      attr_work = attr_work.replace('##ATTR_NAME##', attrItem.attrname);

      // ToDo: If type is dropdown: get actual value from GSD file!
      if (attrItem.attrGSDrangeType == 'list' || attrItem.attrGSDrangeType == 'loop') {
        if (attrItem.attrGSDtype == 'STRING') {
          attr_work = attr_work.replace(
            '##ATTR_VALUE##',
            'X!X!X' +
            getValueFromRange(attrItem.attrvalue, attrItem.attrGSDrangeValue, attrItem.attrGSDrangeType) +
            'X!X!X',
          );
        } else {
          attr_work = attr_work.replace(
            '##ATTR_VALUE##',
            getValueFromRange(attrItem.attrvalue, attrItem.attrGSDrangeValue, attrItem.attrGSDrangeType),
          );
        }
      } else {
        if (attrItem.attrGSDtype == 'STRING') {
          attr_work = attr_work.replace('##ATTR_VALUE##', 'X!X!X' + attrItem.attrvalue + 'X!X!X');
        } else {
          attr_work = attr_work.replace('##ATTR_VALUE##', attrItem.attrvalue);
        }
      }

      attr_work = attr_work.replace(
        '##ATTR_IEC_TYPE##',
        getDataType(attrItem.attrGSDtype).attr[fileDataTypesJSON.constants.STNAME],
      );

      sumAttrLenOfDevice += hlpAttrLen / 8;

      // basic offset is no longer being calculated but taken from GSD file
      // calculation is done only for multis
      if (attrItem.attrGSDname == saveMultiName) {
        cntMultiName++;
      } else {
        cntMultiName = 1;
        saveMultiName = attrItem.attrGSDname;
      }

      //check if offset was in GSD - otherwise export Error-STRING
      if (isNaN(attrItem.attrGSDoffset)) {
        attr_work = attr_work.replace('##ATTR_OFFSET##', attrItem.attrGSDoffset);
      } else {
        // offsets are 0 at start!
        // on each new multi-start offset is taken directly from RAP file (and added to device-offset)
        if (cntMultiName == 1) {
          attr_work = attr_work.replace('##FULL_OFFSET##', hlpDeviceOffset + parseInt(attrItem.attrGSDoffset));
          attr_work = attr_work.replace('##FULL_OFFSET_A##', hlpDeviceOffset + parseInt(attrItem.attrGSDoffset));
          saveFullOffset = hlpDeviceOffset + parseInt(attrItem.attrGSDoffset);
        } else {
          attr_work = attr_work.replace('##FULL_OFFSET##', hlpDeviceOffset + hlpAttrOffset);
          attr_work = attr_work.replace('##FULL_OFFSET_A##', hlpDeviceOffset + hlpAttrOffset + bitOverflow);
          saveFullOffset = hlpDeviceOffset + hlpAttrOffset;
        }

        // ABSOLUTE OFFSETS FROM RAP FILE FOR RSC-FILE OUTPUT!
        if (attrItem.attrGSDtype.toUpperCase() == 'BOOL') {
          attr_work = attr_work.replace('##ATTR_OFFSET##', parseInt(attrItem.attrGSDoffset));
        } else {
          attr_work = attr_work.replace(
            '##ATTR_OFFSET##',
            parseInt(attrItem.attrGSDoffset) + parseInt((cntMultiName - 1) * (hlpAttrLen / 8)),
          );
        }

        // === START: MAIN OFFSET CALCULATION LOGIC ===
        var TESTCASE = '';
        if (attrItem.attrGSDtype.toUpperCase() == 'BOOL') {
          if (cntBool == attrItem.attrGSDmulti - 1) {
            hlpAttrOffset = parseInt(attrItem.attrGSDoffset) + parseInt(cntMultiName * (hlpAttrLen / 8));
          } else {
            hlpAttrOffset = parseInt(attrItem.attrGSDoffset);
          }
        } else {
          hlpAttrOffset = parseInt(attrItem.attrGSDoffset) + parseInt(cntMultiName * (hlpAttrLen / 8));
        }

        // === ENDE: MAIN OFFSET CALCULATION LOGIC ===

        saveLastType = attrItem.attrGSDtype.toUpperCase();
        saveLastName = attrItem.attrGSDname;
        saveLastMulti = attrItem.attrGSDmulti;
      }

      // if the bit targets are still HERE, they have not been used by BOOL type and can be removed
      // BUT: SPECIAL HANDLING OF BIT-TYPE ##ATTR_BIT_ZERO##
      if (attrItem.attrGSDtype != 'BOOL') {
        // if ##ATTR_BIT_ZERO## is used, non BOOL data types create 0 as Bit value!
        // IMPORTANT: preserve ##BITSEP## only if ##ATTR_BIT_ZERO## is present
        if (attr_work.indexOf('##ATTR_BIT_ZERO##') > -1) {
          attr_work = attr_work.replace('##BITSEP##', '.');
          attr_work = attr_work.replace(/##ATTR_BIT_ZERO##/g, '0');
        }
      }

      // ordinary removing of Bit values for non Bool types
      attr_work = attr_work.replace(/##BITSEP##/g, '');
      attr_work = attr_work.replace(/##ATTR_BIT##/g, '');
      attr_work = attr_work.replace(/##ATTR_BIT_A##/g, '');
      attr_work = attr_work.replace(/##ATTR_BIT_ZERO##/g, '');

      // export field is only interesting in project save files since normal export formats won't include attrs with export == false!
      attr_work = attr_work.replace('##ATTR_EXPORT##', attrItem.attrexport);
      attr_work = attr_work.replace('##ATTR_ST_TYPE##', attrItem.attrGSDtype);
      if ($.trim(attrItem.attrGSDcomment) != '') {
        attr_work = attr_work.replace('##ATTR_COMMENT##', attrItem.attrGSDcomment);
      } else {
        attr_work = attr_work.replace('##ATTR_COMMENT##', ''); // no comment!
      }
      // cntOrder must be padded since sortJSON will otherwise create wrong
      // sort order (e.g. '10' will be ordered befor '2')
      attr_work = attr_work.replace('##ATTR_ORDER##', pad(cntOrder, 4));

      // use device count to qualify same variable names in different devices!
      attr_work = attr_work.replace(/##DEVICE_COUNT##/g, cntDevices);

      // VALUES ARE EXPORTED IF EXPORT FLAG IS SET -OR- WHEN PROJECT FILE IS SAVED!
      if (attrItem.attrexport == true || filenameExportPattern == 'project.json') {
        if (hlpTags.indexOf('input') > -1) {
          attr_inp += attr_work;
        }
        if (hlpTags.indexOf('output') > -1) {
          attr_out += attr_work;
        }
        if (hlpTags.indexOf('memory') > -1) {
          attr_mem += attr_work;
        }
      }

      cntOrder++;
      //			}
      //			else {
      //				// no code here !?
      //			}

      // count inp/out/mem length seperately
      if (hlpTags.indexOf('input') > -1) {
        cntAttrInpLen += hlpAttrLen / 8;
        if (deviceInpStartOffset == -1) {
          deviceInpStartOffset = hlpDeviceOffset;
        }
        cntDeviceAttrInpLen += hlpAttrLen / 8; // count Inp-Len for device only
      }
      if (hlpTags.indexOf('output') > -1) {
        cntAttrOutLen += hlpAttrLen / 8;
        if (deviceOutStartOffset == -1) {
          deviceOutStartOffset = saveFullOffset;
        }
        cntDeviceAttrOutLen += hlpAttrLen / 8; // count Out-Len for device only
      }
      if (hlpTags.indexOf('memory') > -1) {
        cntAttrMemLen += hlpAttrLen / 8;
        if (deviceMemStartOffset == -1) {
          deviceMemStartOffset = saveFullOffset;
        }
        cntDeviceAttrMemLen += hlpAttrLen / 8; // count Mem-Len for device only
      }
    }); // END edit data loop

    hlpDeviceOffset += sumAttrLenOfDevice;

    // Offset / Len counters per device and attr type
    device_work = device_work.replace(/##DEVICE_INPOFFSET##/g, deviceInpStartOffset);
    device_work = device_work.replace(/##DEVICE_OUTOFFSET##/g, deviceOutStartOffset);
    device_work = device_work.replace(/##DEVICE_MEMOFFSET##/g, deviceMemStartOffset);

    device_work = device_work.replace(/##DEVICE_INPTOTAL##/g, cntDeviceAttrInpLen);
    device_work = device_work.replace(/##DEVICE_OUTTOTAL##/g, cntDeviceAttrOutLen);
    device_work = device_work.replace(/##DEVICE_MEMTOTAL##/g, cntDeviceAttrMemLen);

    // fill attr parts into device part
    device_work = device_work.replace('##DEVICE_ATTRINP##', killLastDelimiter(attr_inp, ','));
    device_work = device_work.replace('##DEVICE_ATTROUT##', killLastDelimiter(attr_out, ','));
    device_work = device_work.replace('##DEVICE_ATTRMEM##', killLastDelimiter(attr_mem, ','));

    var hlpExtendedData = handleExtendedDataStore(deviceDataItem.deviceId, 'GET_DATA');
    if (hlpExtendedData == '') {
      device_work = device_work.replace('##DEVICE_ATTREXTEND##', '{}');
    } else {
      device_work = device_work.replace('##DEVICE_ATTREXTEND##', killLastDelimiter(hlpExtendedData, ','));
    }

    device_out += device_work;
  });

  $(connectionStore).each(function(cntConnections, connectionItem) {
    if (typeof exportPatterns.connection != 'undefined') {
      var hlpSplitVariants = [];
      connection_work = exportPatterns.connection;

      hlpSplitVariants = connectionItem.sourceVariants.split('|');
      connection_work = connection_work.replace('##CONN_SOURCEDEV_GUID##', connectionItem.sourceGUID);
      connection_work = connection_work.replace('##CONN_SOURCEDEV_INPVARIANT##', hlpSplitVariants[0]);
      connection_work = connection_work.replace('##CONN_SOURCEDEV_OUTVARIANT##', hlpSplitVariants[1]);
      connection_work = connection_work.replace('##CONN_SOURCEVAL_ATTRNAME##', connectionItem.sourceValAttrname);
      connection_work = connection_work.replace('##CONN_SOURCEVAL_GSDNAME##', connectionItem.sourceValGSDname);
      connection_work = connection_work.replace('##CONN_SOURCEVAL_MULTI##', connectionItem.sourceValMulti);

      hlpSplitVariants = connectionItem.destVariants.split('|');
      connection_work = connection_work.replace('##CONN_DESTDEV_GUID##', connectionItem.destGUID);
      connection_work = connection_work.replace('##CONN_DESTDEV_INPVARIANT##', hlpSplitVariants[0]);
      connection_work = connection_work.replace('##CONN_DESTDEV_OUTVARIANT##', hlpSplitVariants[1]);
      connection_work = connection_work.replace('##CONN_DESTVAL_ATTRNAME##', connectionItem.destValAttrname);
      connection_work = connection_work.replace('##CONN_DESTVAL_GSDNAME##', connectionItem.destValGSDname);
      connection_work = connection_work.replace('##CONN_DESTVAL_MULTI##', connectionItem.destValMulti);

      connection_out += connection_work;
    }
  });

  summary_work = summary_work.replace('##SUMMARY_INPTOTAL##', cntAttrInpLen);
  summary_work = summary_work.replace('##SUMMARY_OUTTOTAL##', cntAttrOutLen);
  summary_work = summary_work.replace('##SUMMARY_MEMTOTAL##', cntAttrMemLen);

  // put all major parts into final master
  final_work = final_work.replace('##FINAL_APP##', app_work);
  final_work = final_work.replace('##FINAL_SUMMARY##', summary_work);
  final_work = final_work.replace('##FINAL_DEVICES##', killLastDelimiter(device_out, ','));
  final_work = final_work.replace('##FINAL_CONNECTIONS##', killLastDelimiter(connection_out, ','));
  //final_work = final_work.replace("##FINAL_EXTDATA##", $('form#frmExtendedData95').serializeJSON());

  // replace all %% with { and !! with } and ' with " and X!X!X with ' to get valid JSON
  final_work = final_work.replace(/%%/g, '{');
  final_work = final_work.replace(/!!/g, '}');
  final_work = final_work.replace(/'/g, '"');
  final_work = final_work.replace(/X!X!X/g, '\''); // ToDo: check why this was necessary; can destroy .RSC file!

  // special handling: remove second level single quotation which occurs in project.json EXPORT
  final_work = final_work.replace(/"'/g, '"');
  final_work = final_work.replace(/'"/g, '"');

  // replace CRLF and TAB for output as readable text file
  final_work = final_work.replace(/##CRLF##/g, '\r\n');
  final_work = final_work.replace(/##TAB##/g, '\t');

  // replace special SYS targets
  final_work = final_work.replace(/##PROJECT_TS##/g, currentExportTS);

  if (filenameExportFile != '') {
    // FIRST DELETE ALL EXISTING EXPORT FILES IN STANDARD MODE
    // there should always only exist the LAST exported file
    if (configData.misc.userMode == 'STANDARD') {
      var exportFilesCSV = handleFileList(getFileList('export/'), '##FILENAME##');
      var arrExportFiles = exportFilesCSV.split(';');

      // IMPORTANT: if autoexport is active - DON'T delete autoexported file(s) here!
      // IMPORTANT: since 11/2017 there can exist MULIPLE autoexported files!
      var filenameAutoExport = '';
      if (typeof configData.misc.autoExport != 'undefined' && configData.misc.autoExport == true) {
        var arrAutoExportDefault = [];
        var arrAutoExportFilenameNoSuffix = [];
        var arrGetActiveAutoExport = getActiveAutoExport();
        var arrFilenameAutoExport = [];
        arrAutoExportDefault = arrGetActiveAutoExport[0];
        arrAutoExportFilenameNoSuffix = arrGetActiveAutoExport[1];

        $.each(arrAutoExportDefault, function(index, filename) {
          exportConfigData = getExportConfigData(filename);
          arrFilenameAutoExport.push(arrAutoExportFilenameNoSuffix[index] + '.' + exportConfigData.filetype);
        });
      }

      $.each(arrExportFiles, function(itemCnt, item) {
        if ($.inArray(item, arrFilenameAutoExport) == -1) {
          AjaxDeleteFile('\'' + '../export/' + item + '\'');
        }
      });
    }
    var ckUser = 'KUNBUS_RevPiUser_' + revPiHostname;
    var ckSessionId = 'KUNBUS_RevPiSessionId_' + revPiHostname;
    $.ajax({
      async: false,
      url:
        'php/saveProject.php?fn=' +
        filenameExportFile +
        '&RevPiSessionId=' +
        Cookies.get(ckSessionId) +
        '&fixupConfig=true',
      type: 'POST',
      data: final_work,
      processData: false,
      dataType: 'text',
      contentType: 'application/json; charset=utf-8',
      success: function(response) {
        hlpRet = response;
        if (hlpRet == 'PHP_SESSION_INVALID') {
          // if no valid server session can be found, remove client cookies also
          Cookies.remove(ckUser);
          Cookies.remove(ckSessionId);
          createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
        }
      },
    });
  }

  // do this only for projects and normal exports, NOT for autoexport!
  if (swtAutoExport != true) {
    // force download export file!
    if (filenameExportFile.indexOf('/export/') > -1) {
      if (swtShowOnly == false) {
        // force download to new browser window to avoid conflict
        // with -onbeforeunload- setting
        // window will automatically close
        window.open(
          'php/downloadFile.php?fn=' +
          filenameExportFile +
          '&RevPiSessionId=' +
          Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname),
          '_blank',
        );
      } else {
        // no download - only show in dialog window ...
        $('#taShowExport').load('export/' + filenameExportFile, function() {
          //$("#divDataSheet").html(getGsdData(device,$("#divDataSheet").html()));
          $('#dialog_showExport').dialog({
            width: 500,
            modal: true,
            title: 'Export File',
            show: { effect: 'blind', duration: 200 },
            buttons: [
              {
                text: 'Ok',
                icons: {
                  primary: 'ui-icon-heart',
                },
                click: function() {
                  $(this).dialog('close');
                },
              },
            ],
          });
        });
      }
    }
  }

  /* make attrname unique in tblEdit also (depends on config switch!)
	NO LONGER NEEDED
	if (configData.misc.makeAttrnamesUniqueOnExport == true) {
		makeAttrNamesUnique();
		loadValues(currentMarkedDeviceId);
	}
	*/

  return hlpRet;
}

// IMPORTANT: range is supposed to have text string format!
function getValueFromRange(position, range, rangeType) {
  var retValue = 'NOT SELECTED';
  var hlpRange = range.split(',');
  var hlpSplit = [];
  var cntRange = 0;
  var i = 0;

  // IMPORTANT: 	original method used POSITION (index) to get range entry
  //				this is no longer necessary - stored value IS already actual value to export!
  //				--> we can return 'position' immediately as value
  if (rangeType == 'list') {
    retValue = position;
  }

  /* ORIGINAL METHOD
	if (rangeType == "list") {
		if (parseInt(position) > -1) {
			if (hlpRange[parseInt(position)].toString().indexOf("|") > -1) {
				hlpSplit = hlpRange[parseInt(position)].split("|");
				if (hlpSplit.length == 1) {
					retValue = hlpSplit[0];
				} else {
					retValue = hlpSplit[1];
				}
			} else {
				retValue = hlpRange[parseInt(position)];
			}
		}
	}
	*/

  if (rangeType == 'loop') {
    for (i = parseFloat(hlpRange[0]); i <= parseFloat(hlpRange[1]); i += parseFloat(hlpRange[2])) {
      if (parseInt(position) == cntRange) {
        retValue = i;
      }
      cntRange++;
    }
  }

  return retValue;
}

// IMPORTANT: range is supposed to have text string format!
function getRangeFromValue(value, range, rangeType) {
  var retIndex = -1;
  var hlpRange = range.split(',');
  var hlpSplit = [];
  var cntRange = 0;
  var i = 0;

  if (rangeType == 'list') {
    $(hlpRange).each(function(cnt, item) {
      hlpSplit = item.split('|');

      if (hlpSplit.length == 1) {
        if (value == hlpSplit[0]) {
          retIndex = cnt;
        }
      } else {
        if (value == hlpSplit[1]) {
          retIndex = cnt;
        }
      }
    });
  }

  if (rangeType == 'loop') {
    for (i = parseFloat(hlpRange[0]); i <= parseFloat(hlpRange[1]); i += parseFloat(hlpRange[2])) {
      if (value == i) {
        retIndex = cntRange;
      }
      cntRange++;
    }
  }

  return retIndex;
}

function getDeviceValues(deviceId) {
  var retValues = '';

  $(tblEditStore).each(function(cntStoreItems, storeItem) {
    if (storeItem.id == deviceId) {
      $(storeItem.data).each(function(cntDataItems, dataItem) {
        retValues += dataItem.attrname + ';';
      });
    }
  });

  retValues = killLastDelimiter(retValues, ';');
}

function setDeviceValue(deviceId, inpVariant, outVariant, attrGSDname, value) {
  $(tblEditStore).each(function(cntStoreItems, storeItem) {
    if (storeItem.id == deviceId && storeItem.inpVariant == inpVariant && storeItem.outVariant == outVariant) {
      $(storeItem.data).each(function(cntDataItems, dataItem) {
        if (dataItem.attrGSDname == attrGSDname) {
          dataItem.attrvalue = value;
        }
      });
    }
  });
}

function findDeviceValue(deviceIdContains, attrGSDname, value) {
  var retArray = [];

  // if no filter for 'deviceIdContains' is given, search for '_' since EVERY deviceID contain '_'
  var hlpDeviceIdContains = deviceIdContains == '' ? '_' : deviceIdContains;

  $(tblEditStore).each(function(cntStoreItems, storeItem) {
    if (storeItem.id.indexOf(hlpDeviceIdContains) > -1) {
      $(storeItem.data).each(function(cntDataItems, dataItem) {
        if (dataItem.attrGSDname == attrGSDname) {
          if ((value != '' && value == dataItem.attrvalue) || value == '') {
            var retArrayParts = [storeItem.id, dataItem.attrGSDname, dataItem.attrvalue];
            retArray.push(retArrayParts);
          }
        }
      });
    }
  });

  return retArray;
}

function getFileList(dirPath) {
  var hlpRet = '';
  var data =
    '{\'dir\': \'' + dirPath + '\',\'RevPiSessionId\': \'' + Cookies.get('KUNBUS_RevPiSessionId_' + revPiHostname) + '\'}';
  data = data.replace(/'/g, '"');

  $.ajax({
    async: false,
    url: 'php/getFileList.php',
    type: 'POST',
    data: data,
    processData: false,
    dataType: 'text',
    contentType: 'application/json; charset=utf-8',
    success: function(response) {
      hlpRet = response;
      if (hlpRet == 'PHP_SESSION_INVALID') {
        // if no valid server session can be found, remove client cookies also
        Cookies.remove('KUNBUS_RevPiUser_' + revPiHostname);
        Cookies.remove('KUNBUS_RevPiSessionId_' + revPiHostname);
        createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
      }
    },
  });

  return killLastDelimiter(hlpRet, ';');
}

// formatPattern follows PHP format characters: Y|m|d|H|i|s
function getCurrentTS(formatPattern) {
  var hlpRet = formatPattern;
  var d = new Date();
  var d_Y = d.getFullYear();
  var d_m = pad(d.getMonth() + 1, 2);
  var d_d = pad(d.getDate(), 2);
  var d_H = pad(d.getHours(), 2);
  var d_i = pad(d.getMinutes(), 2);
  var d_s = pad(d.getSeconds(), 2);

  hlpRet = hlpRet.replace('Y', d_Y);
  hlpRet = hlpRet.replace('m', d_m);
  hlpRet = hlpRet.replace('d', d_d);
  hlpRet = hlpRet.replace('H', d_H);
  hlpRet = hlpRet.replace('i', d_i);
  hlpRet = hlpRet.replace('s', d_s);

  return hlpRet;
}

// formatPattern follows PHP format characters: Y|m|d|H|i|s
function getProjectFileLastSaved(projectname, formatPattern) {
  var hlpRet = formatPattern;
  var projectFilesCSV = getFileList('projects/'); //getProjectFiles();
  var arrL01 = projectFilesCSV.split(';');
  var arrL02 = [];
  var arrL03 = [];
  $.each(arrL01, function(itemCnt, item) {
    arrL02 = item.split(',');
    if (arrL02[0] == projectname + '.rsc') {
      arrL03 = arrL02[1].split('|');
      hlpRet = hlpRet.replace('Y', arrL03[0]);
      hlpRet = hlpRet.replace('m', arrL03[1]);
      hlpRet = hlpRet.replace('d', arrL03[2]);
      hlpRet = hlpRet.replace('H', arrL03[3]);
      hlpRet = hlpRet.replace('i', arrL03[4]);
      hlpRet = hlpRet.replace('s', arrL03[5]);
    }
  });

  return hlpRet;
}

function fillDialog_connection(sourceGUID, destGUID) {
  var hlpSelectedSource;
  var hlpSelectedDest;
  var selectedSourceObj;
  var selectedDestObj;
  var arrDeviceSD = ['Source', 'Dest'];
  var selTemplate = '<option value=\'##DEVICEID##\' ##SELECTED##>##MODULNAME## (##POSITION##)</option>';
  var selTemplateWork = '';
  var selTemplateWorkSource = '';
  var selTemplateWorkDest = '';
  var rowTemplate01 = '<tr><td><input type=\'radio\' name=\'rdoDevice##DEVICE_S_D##\'></td><td>##ATTRNAME##</td></tr>';
  var rowTemplateWork = '';
  var deviceValues = '';

  $('#selDevSource').empty();
  $('#selDevDest').empty();

  // get devices
  $(tblDataStore).each(function(cntDeviceData, deviceDataItem) {
    if (cntDeviceData == 0) {
      hlpSelectedSource = deviceDataItem.deviceId;
      hlpSelectedDest = deviceDataItem.deviceId;
      selectedSourceObj = deviceDataItem;
      selectedDestObj = deviceDataItem;
    }

    selTemplateWork = selTemplate;
    selTemplateWork = selTemplateWork.replace('##DEVICEID##', deviceDataItem.GUID);
    selTemplateWork = selTemplateWork.replace('##MODULNAME##', deviceDataItem.modulname);
    selTemplateWork = selTemplateWork.replace('##POSITION##', deviceDataItem.position);
    if (sourceGUID == deviceDataItem.GUID) {
      selTemplateWorkSource = selTemplateWork.replace('##SELECTED##', 'selected');
      hlpSelectedSource = deviceDataItem.deviceId;
      selectedSourceObj = deviceDataItem;
    } else {
      selTemplateWorkSource = selTemplateWork.replace('##SELECTED##', '');
    }
    if (destGUID == deviceDataItem.GUID) {
      selTemplateWorkDest = selTemplateWork.replace('##SELECTED##', 'selected');
      hlpSelectedDest = deviceDataItem.deviceId;
      selectedDestObj = deviceDataItem;
    } else {
      selTemplateWorkDest = selTemplateWork.replace('##SELECTED##', '');
    }

    $('#selDevSource').append(selTemplateWorkSource);
    $('#selDevDest').append(selTemplateWorkDest);
  });

  $('#tblDeviceSource tbody').empty();
  $('#tblDeviceDest tbody').empty();
  $('#tblConnections tbody').empty();

  // fill device values tables
  refreshConnDeviceValues(hlpSelectedSource, 'Source');
  refreshConnDeviceValues(hlpSelectedDest, 'Dest');

  // fill connection table
  refreshConnTable(
    $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
    $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
  );

  // Event handler
  $('#chkShowAllConn').off();
  $('#chkShowAllConn').on('change', function(e) {
    refreshConnTable(
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
    );
  });

  $('#selConnSortOrder').off();
  $('#selConnSortOrder').on('change', function(e) {
    refreshConnTable(
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
    );
  });

  $('#selDevSource').off();
  $('#selDevSource').on('change', function(e) {
    //refreshConnDeviceValues($(this).val(), "Source");
    refreshConnDeviceValues(getDataStoreData($(this).val(), '##DEVICEID##'), 'Source');
    markedForConnecting[0] = $(this).val();
    refreshMarkForConnecting();
    refreshConnTable(
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
    );
  });
  $('#selDevDest').off();
  $('#selDevDest').on('change', function(e) {
    //refreshConnDeviceValues($(this).val(), "Dest");
    refreshConnDeviceValues(getDataStoreData($(this).val(), '##DEVICEID##'), 'Dest');
    markedForConnecting[1] = $(this).val();
    refreshMarkForConnecting();
    refreshConnTable(
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
    );
  });

  $('#btnSetConnection').off();
  $('#btnSetConnection').on('click', function(e) {
    if ($('input[name=\'rdoDeviceSource\']:checked').val() && $('input[name=\'rdoDeviceDest\']:checked').val()) {
      if (
        $('input[name=\'rdoDeviceSource\']:checked').attr('hlpAttrType') ==
        $('input[name=\'rdoDeviceDest\']:checked').attr('hlpAttrType')
      ) {
        handleConnections(
          '',
          $('#selDevSource').val(),
          $('#selDevDest').val(),
          selectedSourceObj.input + '|' + selectedSourceObj.output,
          selectedDestObj.input + '|' + selectedDestObj.output,
          $('input[name=\'rdoDeviceSource\']:checked').val(),
          $('input[name=\'rdoDeviceDest\']:checked').val(),
          'ADD',
        );
        refreshConnTable(
          $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
          $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
        );

        // refresh dest table to reflect that dest value is no longer availabe for connection!
        refreshConnDeviceValues(getDataStoreData($('#selDevDest').val(), '##DEVICEID##'), 'Dest');
      } else {
        //alert("Types of values must match to create connection!");
        createInfoDialog('Error', '<br>' + 'Types of values must match to create connection!', '');
      }
    } else {
      //alert("Please select Source AND Destination value!");
      createInfoDialog('Error', '<br>' + 'Please select Source AND Destination value!', '');
    }
  });

  $('#btnRemoveConnection').off();
  $('#btnRemoveConnection').on('click', function(e) {
    $('input[name=\'chkConnections\']').each(function() {
      if (this.checked) {
        handleConnections($(this).val(), '', '', '', '', '', '', 'REMOVE');
      }
    });
    refreshConnTable(
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevSource').val(),
      $('#chkShowAllConn').prop('checked') == true ? '' : $('#selDevDest').val(),
    );

    // refresh dest table to reflect that dest value is availabe for connection again!
    refreshConnDeviceValues(getDataStoreData($('#selDevDest').val(), '##DEVICEID##'), 'Dest');
  });
}

function refreshConnTable(sourceGUID, destGUID) {
  var headTemplate = '<tr><th>&nbsp;</th><th>Source</th><th>&nbsp;</th><th>Destination</th><th>&nbsp;</th></tr>';
  var rowTemplate =
    '<tr><td><input type=\'checkbox\' name=\'chkConnections\' value=\'##ID##\'></td><td>##SOURCEDEV##</td><td>##SOURCEVAL##</td><td>##DESTDEV##</td><td>##DESTVAL##</td></tr>';
  var rowTemplateWork = '';
  var hlpAttrData = '';
  var hlpSplitVariants = [];
  var arrHlpSort = [];
  var cntVisibleConns = 0;

  $('#tblConnections thead').empty();
  $('#tblConnections tbody').empty();
  $('#tblConnections thead').append(headTemplate);

  $('#lblInfoConnections').html();

  /*
	$(connectionStore).each(function(cnt, item) {

		if (((sourceGUID == "") || (sourceGUID == item.sourceGUID)) &&
			((destGUID == "") || (destGUID == item.destGUID))
			) {
				cntVisibleConns++;
				rowTemplateWork = rowTemplate;
				rowTemplateWork = rowTemplateWork.replace("##ID##",item.id);
				rowTemplateWork = rowTemplateWork.replace("##SOURCEDEV##",getDataStoreData(item.sourceGUID,"##MODULNAME##") + " (" + getDataStoreData(item.sourceGUID,"##POSITION##") + ")");
				rowTemplateWork = rowTemplateWork.replace("##DESTDEV##",getDataStoreData(item.destGUID,"##MODULNAME##") + " (" + getDataStoreData(item.destGUID,"##POSITION##") + ")");

				hlpSplitVariants = item.sourceVariants.split("|");
				hlpAttrData = getEditStoreData(getDataStoreData(item.sourceGUID,"##DEVICEID##"), hlpSplitVariants[0], hlpSplitVariants[1],item.sourceValGSDname, item.sourceValMulti);
				rowTemplateWork = rowTemplateWork.replace("##SOURCEVAL##",hlpAttrData.attrname);

				hlpSplitVariants = item.destVariants.split("|");
				hlpAttrData = getEditStoreData(getDataStoreData(item.destGUID,"##DEVICEID##"), hlpSplitVariants[0], hlpSplitVariants[1],item.destValGSDname, item.destValMulti);
				rowTemplateWork = rowTemplateWork.replace("##DESTVAL##",hlpAttrData.attrname);

				$('#tblConnections tbody').append(rowTemplateWork);
		}

	});
	*/

  $(connectionStore).each(function(cnt, item) {
    if ((sourceGUID == '' || sourceGUID == item.sourceGUID) && (destGUID == '' || destGUID == item.destGUID)) {
      cntVisibleConns++;
      arrHlpSort.push(item);
    }
  });

  // apply sorting and fill table
  arrHlpSort = sortJSON(arrHlpSort, $('#selConnSortOrder').val());

  $(arrHlpSort).each(function(cnt, item) {
    rowTemplateWork = rowTemplate;
    rowTemplateWork = rowTemplateWork.replace('##ID##', item.id);
    rowTemplateWork = rowTemplateWork.replace(
      '##SOURCEDEV##',
      getDataStoreData(item.sourceGUID, '##MODULNAME##') +
      ' (' +
      getDataStoreData(item.sourceGUID, '##POSITION##') +
      ')',
    );
    rowTemplateWork = rowTemplateWork.replace(
      '##DESTDEV##',
      getDataStoreData(item.destGUID, '##MODULNAME##') + ' (' + getDataStoreData(item.destGUID, '##POSITION##') + ')',
    );

    hlpSplitVariants = item.sourceVariants.split('|');
    hlpAttrData = getEditStoreData(
      getDataStoreData(item.sourceGUID, '##DEVICEID##'),
      hlpSplitVariants[0],
      hlpSplitVariants[1],
      item.sourceValGSDname,
      item.sourceValMulti,
    );
    rowTemplateWork = rowTemplateWork.replace('##SOURCEVAL##', hlpAttrData.attrname);

    hlpSplitVariants = item.destVariants.split('|');
    hlpAttrData = getEditStoreData(
      getDataStoreData(item.destGUID, '##DEVICEID##'),
      hlpSplitVariants[0],
      hlpSplitVariants[1],
      item.destValGSDname,
      item.destValMulti,
    );
    rowTemplateWork = rowTemplateWork.replace('##DESTVAL##', hlpAttrData.attrname);

    $('#tblConnections tbody').append(rowTemplateWork);
  });

  // hide connections table if no conns are visible
  if (cntVisibleConns == 0) {
    if (connectionStore.length > 0) {
      $('#lblInfoConnections').html(connectionStore.length + ' connection(s) set (filtered)');
    } else {
      $('#lblInfoConnections').html('no connections set');
    }
    $('#tblConnections').hide();
  } else {
    $('#lblInfoConnections').html(
      cntVisibleConns.toString() +
      ' connection(s) shown (' +
      (connectionStore.length - cntVisibleConns).toString() +
      ' filtered)',
    );
    $('#tblConnections').show();
  }

  $('#lblInfoConnections').html('-- ' + $('#lblInfoConnections').html() + ' --');
}

function refreshConnDeviceValues(deviceId, SourceDest) {
  // IMPORTANT: cant use -$- separator sind in id - not compatible with jQuery!
  var headTemplate = '<tr><th>&nbsp;</th><th>Name</th><th>Type</th></tr>';
  var rowTemplate =
    '<tr><td><input type=\'radio\' name=\'rdoDevice##SOURCEDEST##\' id=\'##ATTRGSDNAME##-xxx-##ATTRMULTICOUNT##\' value=\'##ATTRGSDNAME##-$-##ATTRMULTICOUNT##\' hlpAttrType=\'##ATTRTYPE##\'></td><td id=\'##ATTRGSDNAME##-xxx-##ATTRMULTICOUNT##_tdname\'>##ATTRNAME##</td><td id=\'##ATTRGSDNAME##-xxx-##ATTRMULTICOUNT##_tdtype\'>##ATTRTYPE##</td></tr>';
  var rowTemplateWork = '';
  var hlpAttrType = SourceDest == 'Source' ? 'INP' : 'OUT';

  $('#tblDevice' + SourceDest + ' tbody').empty();
  $('#tblDevice' + SourceDest + ' thead').empty();
  $('#tblDevice' + SourceDest + ' thead').append(headTemplate);

  $(tblEditStore).each(function(cntStoreItems, storeItem) {
    if (storeItem.id == deviceId) {
      $(storeItem.data).each(function(cntDataItems, dataItem) {
        // only add values which match these criteria:
        // 1. correct attrType (Source: only INP / Dest: only OUT)
        // 2. no hidden values!
        // 3. don't add Dest values which already have a export-flag set!
        if (dataItem.attrtype == hlpAttrType && dataItem.attrhidden == 'false') {
          if (SourceDest == 'Source' || (SourceDest == 'Dest' && dataItem.attrexport == false)) {
            rowTemplateWork = rowTemplate;
            rowTemplateWork = rowTemplateWork.replace('##SOURCEDEST##', SourceDest);
            rowTemplateWork = rowTemplateWork.replace(/##ATTRGSDNAME##/g, dataItem.attrGSDname);
            rowTemplateWork = rowTemplateWork.replace(/##ATTRMULTICOUNT##/g, dataItem.attrmulticount);
            rowTemplateWork = rowTemplateWork.replace('##ATTRNAME##', dataItem.attrname);
            rowTemplateWork = rowTemplateWork.replace(/##ATTRTYPE##/g, dataItem.attrGSDtype);
            $('#tblDevice' + SourceDest + ' tbody').append(rowTemplateWork);

            // determine if destination has already been connected and disable it for connecting
            if (SourceDest == 'Dest') {
              if (isConnDestUsed(dataItem.attrGSDname, dataItem.attrmulticount) == true) {
                $('#' + dataItem.attrGSDname + '-xxx-' + dataItem.attrmulticount).hide();
                $('#' + dataItem.attrGSDname + '-xxx-' + dataItem.attrmulticount + '_tdname').css('color', 'grey');
                $('#' + dataItem.attrGSDname + '-xxx-' + dataItem.attrmulticount + '_tdtype').css('color', 'grey');
              } else {
                $('#' + dataItem.attrGSDname + '-xxx-' + dataItem.attrmulticount).show();
              }
            }
          }
        }
      });
    }
  });
}

function isConnDestUsed(attrGSDname, attrmulticount) {
  var hlpRet = false;
  $(connectionStore).each(function(cnt, item) {
    if (item.destValGSDname == attrGSDname && item.destValMulti == attrmulticount) {
      hlpRet = true;
      return false;
    }
  });

  return hlpRet;
}

function fillDialog_project(mode) {
  if (mode == 'OPEN') {
    $('#dvEnterProjectName').hide();
  } else {
    $('#dvEnterProjectName').show();
  }

  $('#dialog_project').html($('#dialog_project').html().replace('##TBL_PROJECT_FILES_TH01##', 'project name'));
  $('#dialog_project').html($('#dialog_project').html().replace('##TBL_PROJECT_FILES_TH02##', 'last modified'));
  $('#dialog_project').html($('#dialog_project').html().replace('##TBL_PROJECT_FILES_TH03##', 'functions'));

  var rowTemplate =
    '<tr>' +
    '<td><b>##FILENAME##</b></td>' +
    '<td width=\'10%\' align=\'center\'>##LASTMODIFIED##</td>' +
    '<td width=\'10%\'>' +
    '<button id=\'##OPEN_BUTTON_ID##\' type=\'button\' class=\'ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary\' role=\'button\'><span class=\'ui-button-icon-primary ui-icon ui-icon-pencil\'></span><span class=\'ui-button-text\'>Open</span></button>' +
    '<button id=\'##REPL_BUTTON_ID##\' type=\'button\' class=\'ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary\' role=\'button\'><span class=\'ui-button-icon-primary ui-icon ui-icon-refresh\'></span><span class=\'ui-button-text\'>Override</span></button>' +
    '</td>' +
    '<td width=\'10%\'>' +
    '<button id=\'##DEL_BUTTON_ID##\' type=\'button\' class=\'ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary\' role=\'button\'><span class=\'ui-button-icon-primary ui-icon ui-icon-trash\'></span><span class=\'ui-button-text\'>Delete</span></button>' +
    '</td>' +
    '</tr>';
  var rowTemplateWork = '';
  $('#tblProjectFiles tbody').empty();

  var projectFilesCSV = getFileList('projects/'); //getProjectFiles();

  var arrL01 = projectFilesCSV.split(';');
  var arrL02 = [];
  var arrL03 = [];
  $.each(arrL01, function(itemCnt, item) {
    rowTemplateWork = rowTemplate;
    arrL02 = item.split(',');
    //exclude files starting with underscore and only use RSC files
    if (arrL02[0].substr(0, 1) != '_' && arrL02[0].substr(arrL02[0].length - 4) == '.rsc') {
      rowTemplateWork = rowTemplateWork.replace('##FILENAME##', arrL02[0].replace('.rsc', ''));
      arrL03 = arrL02[1].split('|');
      rowTemplateWork = rowTemplateWork.replace(
        '##LASTMODIFIED##',
        arrL03[2] + '.' + arrL03[1] + '.' + arrL03[0] + '  ' + arrL03[3] + ':' + arrL03[4] + ':' + arrL03[5],
      );
      rowTemplateWork = rowTemplateWork.replace(
        '##OPEN_BUTTON_ID##',
        'dlgSaveProjectOpen_' + arrL02[0].replace('.rsc', ''),
      );
      rowTemplateWork = rowTemplateWork.replace(
        '##REPL_BUTTON_ID##',
        'dlgSaveProjectRepl_' + arrL02[0].replace('.rsc', ''),
      );
      rowTemplateWork = rowTemplateWork.replace(
        '##DEL_BUTTON_ID##',
        'dlgSaveProjectDel_' + arrL02[0].replace('.rsc', ''),
      );
      // append row to table
      $('#tblProjectFiles tbody').append(rowTemplateWork);
    }
  });

  // create button delegates
  $('[id^=\'dlgSaveProjectOpen_\']').off();
  $('[id^=\'dlgSaveProjectRepl_\']').off();
  $('[id^=\'dlgSaveProjectDel_\']').off();

  $('[id^=\'dlgSaveProjectOpen_\']').on('click', function(e) {
    var posUnderline = getPosDelimiter($(this).attr('id'), '_', 1);
    $('#dialog_project').dialog('close');

    currentProjectFilename = $(this)
      .attr('id')
      .substr(posUnderline + 1);
    confirmMode = 'OPEN_PROJECT';
    if (swtIsDirty == true) {
      createConfirmDialog(confirmMode); // will be opened automatically after creation
    } else {
      confirmResult = true;
      processConfirm();
    }
  });

  $('[id^=\'dlgSaveProjectRepl_\']').on('click', function(e) {
    var posUnderline = getPosDelimiter($(this).attr('id'), '_', 1);
    currentExportTS = getCurrentTS('YmdHis');
    var retDoExport = doExport(
      'project.json',
      $(this)
        .attr('id')
        .substr(posUnderline + 1) + '.rsc',
      false,
      false,
    );
    // do autoExport
    if (typeof configData.misc.autoExport != 'undefined' && configData.misc.autoExport == true) {
      var arrAutoExportDefault = [];
      var arrAutoExportFilenameNoSuffix = [];
      var arrGetActiveAutoExport = getActiveAutoExport();
      arrAutoExportDefault = arrGetActiveAutoExport[0];
      arrAutoExportFilenameNoSuffix = arrGetActiveAutoExport[1];

      $.each(arrAutoExportDefault, function(index, filename) {
        var exportConfigData = getExportConfigData(filename);
        var retDoExport = doExport(
          filename,
          '../export/' + arrAutoExportFilenameNoSuffix[index] + '.' + exportConfigData.filetype,
          true,
          false,
        );
      });
    }

    $('#dialog_project').dialog('close');
    // set project info
    setProjectInfo(
      $(this)
        .attr('id')
        .substr(posUnderline + 1)
        .replace('.rsc', ''),
      getProjectFileLastSaved(
        $(this)
          .attr('id')
          .substr(posUnderline + 1),
        'd.m.Y H:i:s',
      ),
    );

    currentProjectFilename = $(this)
      .attr('id')
      .substr(posUnderline + 1)
      .replace('.rsc', '');
    swtIsDirty = false;

    createInfoDialog('', '<br>Project saved...', '{"autoClose":1000}');
  });

  $('[id^=\'dlgSaveProjectDel_\']').on('click', function(e) {
    var posUnderline = getPosDelimiter($(this).attr('id'), '_', 1);
    AjaxDeleteFile(
      '\'../projects/' +
      $(this)
        .attr('id')
        .substr(posUnderline + 1) +
      '.rsc' +
      '\'',
    );
    fillDialog_project(mode);
  });

  // set delegate for filename input field
  $('#txtInputFilename').off();
  // disable OK button if filename is empty
  $('#txtInputFilename').on('keyup', function(e) {
    if ($('#txtInputFilename').val().length > 0) {
      $('#okDialogSaveProject').button('option', 'disabled', false);
    } else {
      $('#okDialogSaveProject').button('option', 'disabled', true);
    }
  });
  // click OK button on enter filename
  $('#txtInputFilename').keypress(function(e) {
    var key = e.which;
    if (key == 13) {
      // enter key code
      $('#okDialogSaveProject').trigger('click');
      return false;
    }
  });
}

function appendDeviceGUI(nodeKey, objDropCell, activate) {
  var retNewDeviceId = '';

  var savePreviousDeviceId = '';
  var replacedTblColumnId = '';

  var saveTable = $('#dragTable').html();
  var nextDeviceInstanceNr = getNextDeviceInstanceNr(nodeKey);

  // IMPORTANT: 	if RAP file is not valid we can't get the device type!
  // 				processing MUST end here!
  if (getDeviceType(nodeKey + '_' + pad(nextDeviceInstanceNr, 3)) == 'ERR_NO_DATA') {
    createInfoDialog('Error', '<br>ERROR in RAP file: ' + GetErrorText('ERR_NO_DATA', currentLang, 'short'), '');
    return;
  }

  // IMPORTANT: special handling of dropping VIRTUAL devices
  // If a VIRTUAL DEVICE is dropped on a already present REAL device
  // the image of the virtual device is repositioned to a virtual slot!
  // So we only clear the table cells if we drop REAL devices!
  if (getDeviceType(nodeKey + '_' + pad(nextDeviceInstanceNr, 3)) != 'VIRTUAL') {
    if (objDropCell.hasClass('virtualDevice') == true) {
      //alert("Unable to put REAL device into VIRTUAL slot!");
      createInfoDialog('Error', '<br>' + GetErrorText('ERR_DEVICE_REAL_VIRTUAL', currentLang, 'short'), '');
      return;
    }

    // save id of device if drop is on already used cell - for removing previous device from tblEditStore
    if (typeof objDropCell.children('img').attr('id') != 'undefined') {
      savePreviousDeviceId = objDropCell.children('img').attr('id');
      replacedTblColumnId = getContainingTableColumn(savePreviousDeviceId, '');
    }

    // clear table cell for REAL devices
    objDropCell.html('');
  } else {
    // also clear table cell if VIRTUAL device replaces VIRTUAL device
    var hlpImage = objDropCell.find('img');
    if (hlpImage.length > 0) {
      if (getDeviceType(hlpImage.attr('id').replace('device_', '')) == 'VIRTUAL') {
        savePreviousDeviceId = hlpImage.attr('id'); // save for removing previous device from tblEditStore
        replacedTblColumnId = getContainingTableColumn(savePreviousDeviceId, '');
        objDropCell.html('');
      }
    }
  }

  var pathnameDeviceImage = getAvailableDeviceImage(nodeKey, 'GET_PATHNAME');
  if (pathnameDeviceImage != '') {
    tmpId = 'id=\'device_' + nodeKey + '_' + pad(nextDeviceInstanceNr, 3) + '\'';
    retNewDeviceId = 'device_' + nodeKey + '_' + pad(nextDeviceInstanceNr, 3);

    objDropCell.append(
      '<img class=\'deviceImage moduleUnSelected\' draggable=\'false\' ' +
      tmpId +
      ' src=\'' +
      pathnameDeviceImage +
      '\'>',
    );

    // check if positioning is valid - AFTER insert
    var retPositionAllowed = isPositionAllowed();
    if (retPositionAllowed != 'OK') {
      //alert(retPositionAllowed);
      createInfoDialog('Error', '<br>' + retPositionAllowed, '');
      // revert table to saved state
      $('#dragTable').html(saveTable);
      // if rules have been added remove from rulesStore
      rulesStore = handleRulesStore('device_' + nodeKey + '_' + pad(nextDeviceInstanceNr, 3), 'REMOVE');
      refreshHandlers();
      refreshDelegates();
      return false;
    }

    // check device relations and max devices rules etc.
    // IMPORTANT: we now check rules of ALL devices if a new device has been placed!
    // (formerly we only checked rules of newly placed device)
    var swtRuleViolated = false;
    $('#dragTable td')
      .children('img')
      .each(function() {
        var retRules = checkRules($(this).attr('id'), replacedTblColumnId != '' ? replacedTblColumnId : '');
        if (retRules != 'OK') {
          createInfoDialog('Error', '<br>' + GetErrorText(retRules, currentLang, 'short'), '');
          $('#dragTable').html(saveTable);
          rulesStore = handleRulesStore($(this).attr('id'), 'REMOVE');
          refreshHandlers();
          refreshDelegates();
          swtRuleViolated = true;
          return false;
        }
      });
    // has any rule been violated?
    if (swtRuleViolated == true) {
      return false;
    }

    // remove entry from tblEditStore if drop is on already used cell and also remove rules of replaced device
    if (savePreviousDeviceId != '') {
      removeFromEditStore(savePreviousDeviceId);
      rulesStore = handleRulesStore(savePreviousDeviceId, 'REMOVE');
    }
    expandDragTable('PAD_EDGES', 0);
    handleDragTable();
    createContextMenues();
    refreshHandlers();
    refreshDelegates();
    resizeDisplay();

    //WriteLog('Dragged ... before click ');

    // UI blocking & loader overlay
    blockUI(3);

    // reset Ctrl State to prevent triggering connection setting when dragging devices from catalog!
    ctrlIsPressed = false;

    // activate dragged device by simulating click!
    if (activate == true) {
      setTimeout(function() {
        $('#device_' + nodeKey + '_' + pad(nextDeviceInstanceNr, 3)).trigger('click');
      }, 1);
    } else {
      // load values without activating -
      // necessary for programmatically adding devices when tblEdit values must be
      // set after addding (e.g. adding after scan for modbus devices)
      loadValues(retNewDeviceId, '');
    }

    cntAppendedDevices++;

    swtIsDirty = true;
  } else {
    // no image for this device!
    objDropCell.append('Image not available ...');
  }

  return retNewDeviceId;
}

function appendDevice(deviceObj) {
  var pathnameDeviceImage = '';
  var hlpGUID = '';

  if (typeof deviceObj.GUID != 'undefined' && deviceObj.GUID != '') {
    hlpGUID = deviceObj.GUID;
  } else {
    hlpGUID = createGUID();
  }

  var objTableDataStore = {
    deviceId: deviceObj.id,
    deviceType: deviceObj.type,
    position: deviceObj.position,
    modulname: deviceObj.name,
    bmk: deviceObj.bmk,
    input: deviceObj.inpVariant + '',
    output: deviceObj.outVariant + '',
    comment: deviceObj.comment,
    GUID: hlpGUID,
  };

  // restore data tblDataStore
  tblDataStore.push(objTableDataStore);

  // Append DragTable column and insert image
  if (deviceObj.type == 'VIRTUAL') {
    expandDragTable('ADD_VIRTUAL', 0);
  } else {
    if ($('[id^=\'device_\']').length > 0) {
      expandDragTable('ADD_RIGHT', 0);
    }
  }

  var pathnameDeviceImage = getAvailableDeviceImage(deviceObj.id, 'GET_PATHNAME');
  if (pathnameDeviceImage == '') {
    pathnameDeviceImage = 'resources/images/devices/image_not_found.png';
  }

  $('#dragTable tr:last')
    .find('td:last')
    .append(
      '<img class=\'deviceImage moduleUnSelected\' draggable=\'false\' id=\'' +
      deviceObj.id +
      '\' src=\'' +
      pathnameDeviceImage +
      '\'>',
    );

  isPositionAllowed(); // adds position classes etc.

  setTimeout(function() {
    //$("#" + deviceObj.id).trigger( "click" );
    // load GSD data
    loadValues(deviceObj.id, 'LOAD_FAST');

    //restore attr data from project file into tblEditStore
    var arrObjAttr = [];
    $.each(deviceObj.inp, function(attrCnt, attrItem) {
      arrObjAttr.push(attrItem);
    });
    $.each(deviceObj.out, function(attrCnt, attrItem) {
      arrObjAttr.push(attrItem);
    });
    $.each(deviceObj.mem, function(attrCnt, attrItem) {
      arrObjAttr.push(attrItem);
    });

    // reorder attrs to reflect original sort order of GSD
    arrObjAttr = sortJSON(arrObjAttr, 5);

    // fill attr values into edit table ...
    var cntTblEditStore = 0;
    $.each(arrObjAttr, function(attrCnt, attrItem) {
      // find matching tblEditStore entry - since
      $.each(tblEditStore, function(cnt, item) {
        if (item.id == deviceObj.id) {
          // IMPORTANT: this check is needed to allow loading of
          // old .RSC files which contain values which may no longer
          // exist in current RAP files. This can e.g. happen if
          // the 'multi' entry of a value has been decreased to correct
          // an error, like in ModbusRTUMaster_20180122_1_1.rap

          if (typeof item.data[attrCnt] != 'undefined') {
            item.data[attrCnt].attrname = attrItem[0];

            // if value is dropdown, determine dropdwon index from actual value
            //if (item.data[attrCnt].attrGSDrangeType == 'list' || item.data[attrCnt].attrGSDrangeType == 'loop') {
            if (item.data[attrCnt].attrGSDrangeType == 'loop') {
              item.data[attrCnt].attrvalue = getRangeFromValue(
                attrItem[1],
                item.data[attrCnt].attrGSDrangeValue,
                item.data[attrCnt].attrGSDrangeType,
              );
            } else {
              item.data[attrCnt].attrvalue = attrItem[1];
            }

            item.data[attrCnt].attrexport = attrItem[4];
            item.data[attrCnt].attrGSDcomment = attrItem[6];
          }
        }
      });
    });

    var i = 1;

    // refresh edit table from tblEditStore
    loadValues(deviceObj.id, 'LOAD_FAST');

    // fill extended data (if exists) into extendedDataStore
    if (jQuery.isEmptyObject(deviceObj.extend) == false) {
      loadExtendedData(deviceObj.id, deviceObj.extend);
    }

    // simulate click on device
    //$("#" + deviceObj.id).trigger( "click" );

    $.unblockUI;

    return 'OK';
  }, 1);
}

function getRule(deviceId, mode, strInpValue, strOutValue) {
  var retSetValue;

  // handle dependencies of inputs / outputs settings
  if (mode == 'IO') {
    retSetValue = -1;
    var gsdIORules = getGsdData(deviceId, '##GSD_IO_RULES##');
    if (gsdIORules != '') {
      var arrSplitL01 = gsdIORules.split(';');
      var arrSplitL02 = [];
      $.each(arrSplitL01, function(arrCnt, arrItem) {
        arrSplitL02 = arrItem.split(',');
        if (strInpValue == arrSplitL02[0]) {
          retSetValue = parseInt(arrSplitL02[1]);
        }

        if (strOutValue == arrSplitL02[1]) {
          retSetValue = parseInt(arrSplitL02[0]);
        }
      });
    }

    return retSetValue;
  }

  // handle dependency of device A to device B
  // device B (e.g. core special type) must be present in config before device A can be placed
  if (mode == 'DEVICE_REQUIRED') {
    var retRequiredDevices = [];
    retRequiredDevices = getGsdData(deviceId, 'GSD_DEVICE_REQUIRED_RULES');
    return retRequiredDevices;
  }

  // prevents incompatible device placing
  // if device A is present, device B can't be placed
  if (mode == 'DEVICE_EXCLUDED') {
    var retExcludedDevices = [];
    retExcludedDevices = getGsdData(deviceId, 'GSD_DEVICE_EXCLUDED_RULES');
    return retExcludedDevices;
  }

  // limits number of certain device types
  // device A can only be placed n times
  if (mode == 'DEVICE_LIMITED') {
    var retLimitedDevices = '';
    retLimitedDevices = getGsdData(deviceId, 'GSD_DEVICE_LIMITED_RULES');
    return retLimitedDevices;
  }

  // constrains positioning of other devices
  // relative to THIS device (e.g. device can only be placed to the LEFT of THIS device)
  if (mode == 'DEVICE_POSITIONING') {
    return getGsdData(deviceId, 'GSD_DEVICE_POSITIONING_RULES');
  }
}

// IMPORTANT:
// if this function is called on delete of a device, -deletedColumnId- must contain
// the columnId where the device image WAS before it has been deleted
function checkRules(deviceId, deletedColumnId) {
  // rule types which get inserted into rulesStore
  // IMPORTANT: 	only DEVICE_POSITIONING is put into rulesStore at the moment since
  //				this is only rule type which needs to be checked on each moving of devices
  //var arrRuleTypes = ["DEVICE_REQUIRED","DEVICE_EXCLUDED","DEVICE_LIMITED","DEVICE_POSITIONING"];
  var arrRuleTypes = ['DEVICE_POSITIONING'];
  var retErr = '';

  // CHECK LEVEL 01
  // these checks are made against rules in RAP file of newly inserted device

  // check required
  var retRequiredDevices = getRule(deviceId, 'DEVICE_REQUIRED', '', '');
  if (retRequiredDevices != '') {
    $.each(retRequiredDevices, function(cnt, item) {
      if ($(item).length == 0) {
        retErr = 'ERR_REQUIRED_DEVICE_NOT_PRESENT: ' + item;
      }
    });
  }

  // check excluded
  var retExcludedDevices = getRule(deviceId, 'DEVICE_EXCLUDED', '', '');
  if (retExcludedDevices != '') {
    $.each(retExcludedDevices, function(cnt, item) {
      if ($(item).length > 0) {
        retErr = 'ERR_EXCLUDED_DEVICE_PRESENT: ' + item;
      }
    });
  }

  // check limited
  var retLimitedDevices = getRule(deviceId, 'DEVICE_LIMITED', '', '');
  if (retLimitedDevices != '') {
    if ($(retLimitedDevices[0].match).length > retLimitedDevices[0].max) {
      retErr = 'ERR_DEVICE_LIMITED_TO_MAX: ' + retLimitedDevices[0].max;
    }
  }

  // CHECK LEVEL 02 - rules are being inserted in rulesStore
  // IMPORTANT: 	this does not only check rules of currently placed device but also
  //				possible positioning rules of previously placed devices
  //				to prevent invalid positioning relative to already present devices

  $.each(arrRuleTypes, function(cntRuleTypes, ruleTypesEntry) {
    var ruleExists = false;
    $.each(rulesStore, function(cntRulesStore, rulesStoreEntry) {
      if (rulesStoreEntry.deviceId == deviceId && rulesStoreEntry.ruleMode == ruleTypesEntry) {
        ruleExists = true;
      }
    });

    // 2. request and insert POSITIONING rules for device only if not already present
    //
    if (ruleExists == false) {
      var rulesStoreObj = new Object();
      var retPositioningDevices = getRule(deviceId, ruleTypesEntry, '', '');
      if (retPositioningDevices != '') {
        rulesStoreObj.deviceId = deviceId;
        rulesStoreObj.ruleMode = ruleTypesEntry;
        rulesStoreObj.rulesPositioning = retPositioningDevices;
        rulesStore.push(rulesStoreObj);
      }
    }
  });

  // 3. check against rules if exist
  var columnOfDevice = '';
  $.each(rulesStore, function(cntRulesStore, rulesStoreEntry) {
    //if (deletedColumnId == "") {
    columnOfDevice = getContainingTableColumn(rulesStoreEntry.deviceId, '');
    //} else {
    //	columnOfDevice = deletedColumnId;
    //}

    if (rulesStoreEntry.ruleMode == 'DEVICE_POSITIONING' && columnOfDevice >= 0) {
      $.each(rulesStoreEntry.rulesPositioning, function(cntRules, rulesEntry) {
        if (typeof rulesEntry.mode != 'undefined' && rulesEntry.mode == 'FILTER') {
          // first we count all devices to LEFT or RIGHT resp. of device with FILTER rule ...
          var cntFilterDevices = 0;
          var arrFilterDevices = [];
          //experimental
          var arrFilterDevicesLEFT = [];
          var arrFilterDevicesRIGHT = [];

          if (typeof rulesEntry.position != 'undefined') {
            $('#dragTable td')
              .children('img')
              .each(function() {
                if (rulesEntry.position == 'LEFT') {
                  if (getContainingTableColumn($(this).attr('id'), '') < columnOfDevice) {
                    arrFilterDevices.push($(this).attr('id'));
                    arrFilterDevicesLEFT.push($(this).attr('id'));
                    cntFilterDevices++;
                  }
                }

                if (rulesEntry.position == 'RIGHT') {
                  if (getContainingTableColumn($(this).attr('id'), '') > columnOfDevice) {
                    // we ignore virtual devices on 'RIGHT' rules
                    if (!$(this).hasClass('isVirtual')) {
                      arrFilterDevices.push($(this).attr('id'));
                      arrFilterDevicesRIGHT.push($(this).attr('id'));
                      cntFilterDevices++;
                    }
                  }
                }
              });
          }

          // second we check against 'producttype' of filter rule ...
          var invalidEntryFound = false;
          if (typeof rulesEntry.producttype != 'undefined') {
            //experimental
            var hlpArrFilterDevices = [];
            if (rulesEntry.position == 'LEFT') {
              hlpArrFilterDevices = arrFilterDevicesLEFT;
            }
            if (rulesEntry.position == 'RIGHT') {
              hlpArrFilterDevices = arrFilterDevicesRIGHT;
            }

            var hlpProductType = '';
            $.each(hlpArrFilterDevices, function(index, filterDeviceId) {
              hlpProductType = getGsdData(filterDeviceId, '##GSD_PRODUCTTYPE##');
              // Don't check againt OWN productType!
              if (hlpProductType != getGsdData(rulesStoreEntry.deviceId, '##GSD_PRODUCTTYPE##')) {
                if ($.inArray(parseInt(hlpProductType), rulesEntry.producttype) == -1) {
                  invalidEntryFound = true;
                }
              }
            });
          }

          if (invalidEntryFound == true) {
            retErr = GetErrorText('ERR_' + rulesEntry.position + '_INVALID_PRODUCTTYPE', currentLang, 'short');
            if (rulesEntry.hasOwnProperty('productname')) {
              retErr = retErr + ' (allowed: ' + rulesEntry.productname.join(', ') + ')';
            } else {
              retErr = retErr + ' (allowed: ' + rulesEntry.producttype.join(', ') + ')';
            }
          }
        }

        if (
          rulesEntry == 'ONLY_LEFT' ||
          (typeof rulesEntry.position != 'undefined' && rulesEntry.position == 'ONLY_LEFT')
        ) {
          $('#dragTable td')
            .children('img')
            .each(function() {
              if ($(this).hasClass('isVirtual')) {
                // we ignore VIRTUALs
              } else {
                if (columnOfDevice > -1 && columnOfDevice < getContainingTableColumn($(this).attr('id'), '')) {
                  retErr =
                    GetErrorText('ERR_ONLY_LEFT_DEVICES_ALLOWED', currentLang, 'short') +
                    ' (RAP rule of device: ' +
                    rulesStoreEntry.deviceId.replace('device_', '') +
                    ' violated)';
                } else {
                  // position is correct - optionally test against producttype
                  // DO NOT test against own productType of device that contained rule
                  /*
								NOT ACTIVE YET
								if ((typeof(rulesEntry.producttype) != "undefined") && ($(this).attr('id') != rulesStoreEntry.deviceId)) {
									var hlpProductType = getGsdData($(this).attr('id'), "##GSD_PRODUCTTYPE##");
									if ($.inArray(parseInt(hlpProductType), rulesEntry.producttype) == -1) {
										retErr = GetErrorText("ERR_LEFT_INVALID_PRODUCTTYPE", currentLang, "short");
									}
								}
								*/
                }
              }
            });
        }

        if (
          rulesEntry == 'ONLY_RIGHT' ||
          (typeof rulesEntry.position != 'undefined' && rulesEntry.position == 'ONLY_RIGHT')
        ) {
          $('#dragTable td')
            .children('img')
            .each(function() {
              if ($(this).hasClass('isVirtual')) {
                // we ignore VIRTUALs
              } else {
                if (columnOfDevice > -1 && columnOfDevice > getContainingTableColumn($(this).attr('id'), '')) {
                  retErr =
                    GetErrorText('ERR_ONLY_RIGHT_DEVICES_ALLOWED', currentLang, 'short') +
                    ' (RAP rule of device ' +
                    rulesStoreEntry.deviceId.replace('device_', '') +
                    ' violated)';
                } else {
                  // position is correct - optionally test against producttype
                  // DO NOT test against own productType of device that contained rule
                  /*
								NOT ACTIVE YET
								if ((typeof(rulesEntry.producttype) != "undefined") && ($(this).attr('id') != rulesStoreEntry.deviceId)) {
									var hlpProductType = getGsdData($(this).attr('id'), "##GSD_PRODUCTTYPE##");
									if ($.inArray(parseInt(hlpProductType), rulesEntry.producttype) == -1) {
										retErr = GetErrorText("ERR_RIGHT_INVALID_PRODUCTTYPE", currentLang, "short");
									}
								}
								*/
                }
              }
            });
        }

        if (
          rulesEntry == 'ONLY_VIRT' ||
          (typeof rulesEntry.position != 'undefined' && rulesEntry.position == 'ONLY_VIRT')
        ) {
          $('#dragTable td')
            .children('img')
            .each(function() {
              if ($(this).hasClass('isVirtual')) {
                // we ignore VIRTUALs
              } else {
                if (columnOfDevice > -1 && columnOfDevice !== getContainingTableColumn($(this).attr('id'), '')) {
                  retErr =
                    GetErrorText('ERR_ONLY_VIRT_DEVICES_ALLOWED', currentLang, 'short') +
                    ' (RAP rule of device ' +
                    rulesStoreEntry.deviceId.replace('device_', '') +
                    ' violated)';
                }
              }
            });
        }
      });
    }
  });

  return retErr == '' ? 'OK' : retErr;
}

function handleRulesStore(deviceId, mode) {
  var ret = rulesStore;
  if (mode == 'REMOVE') {
    ret = $.grep(ret, function(e) {
      return e.deviceId != deviceId;
    });
  }

  return ret;
}

function handleModifyStore(deviceId, mode) {
  retVal = '';

  if (mode == 'GET') {
    if ($.inArray(deviceId, modifyStore) == -1) {
      retVal = false;
    } else {
      retVal = true;
    }
  }

  if (mode == 'INSERT') {
    // Remember devices which already habe been modified
    if ($.inArray(deviceId, modifyStore) == -1) {
      modifyStore.push(deviceId);
    }
  }

  if (mode == 'REMOVE') {
    modifyStore = $.grep(modifyStore, function(value) {
      //return value.substr(0,value.length - 4) != deviceId.substr(0,deviceId.length - 4);
      return value != deviceId;
    });
  }

  return retVal;
}

function refreshLanguage() {
  //var hlpJSON = AjaxGetJSON("language.json", "OBJ");
  var hlpJSON = fileLangJSON;

  // change pure HTML
  var hlpText = '';
  $(hlpJSON.elements.HTML).each(function(cntElements, itemElement) {
    hlpText = 'ERR_NO_LANG';
    if (typeof hlpJSON.lang[currentLang][itemElement] != 'undefined') {
      hlpText = hlpJSON.lang[currentLang][itemElement];
      if (itemElement == 'file_exit' && isSSOHost) {
        hlpText = hlpJSON.lang[currentLang]['file_logout'];
      }
    }

    $('#' + itemElement).html(hlpText);
  });

  // regenerate context menus with update language
  createContextMenues();

  // make conditional changes

  // 1. don't touch project name / last save if no longer initial values
  if ($('#lblProjectInfo02').html().indexOf('[') > -1) {
    setProjectInfo(lookupLanguage(currentLang, 'lblProjectInfo02'), lookupLanguage(currentLang, 'lblProjectInfo04'));
  }
}

function lookupLanguage(lang, key) {
  //var hlpJSON = AjaxGetJSON("language.json", "OBJ");
  var hlpJSON = fileLangJSON;
  return hlpJSON.lang[lang][key];
}

function setProjectInfo(strProjectName, strProjectLastSaved) {
  $('#lblProjectInfo02').html(strProjectName);
  $('#lblProjectInfo04').html(strProjectLastSaved);
}

function getAvailableDeviceImage(deviceId, mode) {
  var retPathName = '';
  var foundFileType = '';
  var nameFormat = '';

  // Test FULL name ID_DATE_V1_V2
  if (fileExists(configData.paths.icons + parseDeviceId(deviceId, '##ID_VERSION##') + '.png') == true) {
    retPathName = configData.paths.icons + parseDeviceId(deviceId, '##ID_VERSION##') + '.png';
    foundFileType = '.png';
    nameFormat = 'FULL';
  } else {
    if (fileExists(configData.paths.icons + parseDeviceId(deviceId, '##ID_VERSION##') + '.jpg') == true) {
      retPathName = configData.paths.icons + parseDeviceId(deviceId, '##ID_VERSION##') + '.jpg';
      foundFileType = '.jpg';
      nameFormat = 'FULL';
    }
  }

  if (foundFileType == '') {
    // test SHORT name ID
    if (fileExists(configData.paths.icons + parseDeviceId(deviceId, '##ID##') + '.png') == true) {
      retPathName = configData.paths.icons + parseDeviceId(deviceId, '##ID##') + '.png';
      foundFileType = '.png';
      nameFormat = 'SHORT';
    } else {
      if (fileExists(configData.paths.icons + parseDeviceId(deviceId, '##ID##') + '.jpg') == true) {
        retPathName = configData.paths.icons + parseDeviceId(deviceId, '##ID##') + '.jpg';
        foundFileType = '.jpg';
        nameFormat = 'SHORT';
      }
    }
  }

  if (foundFileType != '') {
    if (mode == 'GET_PATHNAME') {
      return retPathName;
    }

    if (mode == 'GET_INFO') {
      return foundFileType + '|' + nameFormat;
    }

    return '';
  } else {
    return '';
  }
}

/* 	=====================================================================
/	validate all attributes of device on blur of device
/	by:
/		- clicking on other device image
/		- clicking on other device row
/		- unmarking current device image or row by click (no device selected)
/
/	Creator: Frank Bauer
/	Changes: -
/
/	(c) KUNBUS GmbH, 2016
*/
function validateAllAttr() {
  /*
	$.each(tblEditStore, function(cntEntries, entry) {
		alert(entry.id);
	});
	*/

  var retVal = 'OK';

  if (currentMarkedDeviceId == '') {
    return retVal;
  }

  var valPathname = configData.paths.gsd.replace(
    '##DEVICE_ID##',
    parseDeviceId(currentMarkedDeviceId, '##ID_VERSION##'),
  );
  valPathname = valPathname.replace('.rap', '.val');
  var finalVal = '';
  if (fileExists(valPathname) == true) {
    // load validation script with direct ajax call to allow synchronous mode; $.getScript is always async.
    // val files can be loaded from cache; they never change
    $.ajax({
      url: valPathname,
      async: false,
      cache: true,
      dataType: 'script',
    });

    var hlpRowIndex = getRowIndexOfDevice(currentMarkedDeviceId);
    var hlpInpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
    var hlpOutVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);

    // finalValidation is currently optional even if .val file exists ...
    if (typeof finalValidation === 'function') {
      finalVal = new finalValidation(currentMarkedDeviceId, hlpInpVariant, hlpOutVariant);
      var retValidate = finalVal.validate();
      if (retValidate != 'OK') {
        retVal = GetErrorText(retValidate, currentLang, 'short');
      }
    }
  }

  return retVal;
}

function getCntAttrName(arrAttrnames, attrName) {
  var retCnt = 0;
  $.each(arrAttrnames, function(cnt, item) {
    if (attrName == item) {
      retCnt++;
    }
  });
  return retCnt;
}

function getCntAttrNameInEditStore(attrName) {
  var retCnt = 0;

  $.each(tblEditStore, function(cntEntries, entry) {
    $.each(entry.data, function(cntData, data) {
      if (data['attrname'] == attrName) {
        retCnt++;
      }
    });
  });

  return retCnt;
}

function resizeDisplay() {
  var newSize = $('#selDisplaySize').val();
  $('#dragTable td').css('height', newSize);
  $('[id^=\'device_\']').css('height', newSize);
}

function getExportConfigData(filename) {
  var retEntry = '';
  // 2017/11 - is now being globaly loaded on startup
  //var exportData = AjaxGetJSON(configData.paths.export + "config.json", "OBJ");
  $.each(exportData.files, function(cnt, entry) {
    if (entry.filename == filename) {
      retEntry = entry;
    }
  });

  return retEntry;
}

function makeAttrNamesUnique(deviceId) {
  var swtAttrChanged = true;
  var cntRetries = 0;

  // get new inserted tblEdit device data (that may have conflicts with existing names)
  var hlpRowIndex = getRowIndexOfDevice(currentMarkedDeviceId);
  var hlpInpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
  var hlpOutVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);
  var tblEditEntry = handleTableData('tblEdit', deviceId + ',' + hlpInpVariant + ',' + hlpOutVariant, 'GETENTRY');

  // loop01 - over new device data
  while (swtAttrChanged == true) {
    swtAttrChanged = false;
    $.each(tblEditEntry.data, function(cntDataEntries, dataEntry) {
      if (getCntAttrNameInEditStore(dataEntry.attrname) > 1) {
        if (cntRetries > 0) {
          // remove _i entered by user before adding _i with counter
          if (dataEntry.attrname.substr(dataEntry.attrname.length - 4, 2) == '_i') {
            dataEntry.attrname = dataEntry.attrname.substr(0, dataEntry.attrname.length - 4);
          }
        }

        dataEntry.attrname = dataEntry.attrname + '_i' + pad(cntAppendedDevices + cntRetries, 2);

        // set name directly in input field in tblEdit --> no need to reload (better perfomance!)
        $('input[id^=tblEdit_attrname]:eq(' + cntDataEntries + ')').val(dataEntry.attrname);
        swtAttrChanged = true;
      }
    });
    cntRetries++;
  }
}

function modifyAttr(deviceId) {
  var modFilename = getMatchingModFile(parseDeviceId(deviceId.replace('device_', ''), '##ID_VERSION##'));
  if (modFilename != '') {
    var valPathname = configData.paths.gsd.replace('##DEVICE_ID##', modFilename).replace('.rap', '');
    // load modification script with direct ajax call to allow synchronous mode; $.getScript is always async.
    // mod files can be loaded from cache; they never change
    $.ajax({
      url: valPathname,
      async: false,
      cache: true,
      dataType: 'script',
    });

    var hlpRowIndex = getRowIndexOfDevice(deviceId);
    var hlpInpVariant = $('#tblData').appendGrid('getCtrlValue', 'input', hlpRowIndex);
    var hlpOutVariant = $('#tblData').appendGrid('getCtrlValue', 'output', hlpRowIndex);

    if (typeof modifyAttributes === 'function') {
      modAttr = new modifyAttributes(deviceId.replace('device_', ''), hlpInpVariant, hlpOutVariant);
      var retModify = modAttr.modify();
      if (retModify == 'OK') {
        handleModifyStore(deviceId.replace('device_', ''), 'INSERT'); // mark modified device to prevent multiple modifications	of same device
      }
    }
  }
}

function getMatchingModFile(deviceId) {
  var retFilename = '';

  // populate modFilesStore only once in each session!
  if ($.isEmptyObject(modFilesStore)) {
    var rapFilesCSV = handleFileList(getFileList('resources/data/rap/'), '##FILENAME##');
    var arrRapFiles = rapFilesCSV.split(';');
    $.each(arrRapFiles, function(cntFiles, entryFilename) {
      if (entryFilename.substr(entryFilename.length - 4) == '.mod') {
        modFilesStore.push(entryFilename);
      }
    });
  }

  // IMPORTANT: if multiple .mod files match, only the FIRST one is returned!
  var FnWithoutExt = '';
  $.each(modFilesStore, function(cntFiles, entryModFilename) {
    FnWithoutExt = entryModFilename.replace('.mod', '');
    if (deviceId.substr(0, FnWithoutExt.length) == FnWithoutExt) {
      retFilename = entryModFilename;
      return false;
    }
  });

  return retFilename;
}

function moveToVirtual(image) {
  // find first empty virtual column
  $('#dragTable tr')
    .eq(1)
    .find('td')
    .each(function() {
      if ($(this).hasClass('virtualDevice') == true) {
        if ($('img', this).length <= 0) {
          image.clone().appendTo(this);
          image.remove();
        }
      }
    });

  // find all immages of virtual devices that are not positioned in virtual column
  // normally the should only be ONE image!
  //$("#dragTable td").children('img').each(function(){
  //	if ($(this).hasClass('isVirtual')) {
  //		alert($(this).attr('id'));
  //	}
  //});
}

function setMarkedDevice(deviceId) {
  $('#' + deviceId).addClass('moduleSelected'); // IMPORTANT!
  setTimeout(function() {
    $('#' + deviceId).trigger('click');
    $('#' + deviceId).trigger('click');
  }, 100);

  /* doesn't work ???
	$("#tblData tr:last").children("td").each(function() {
		$(this).addClass('ui-widget-content');
		$(this).addClass('ui-state-error');
	});
	*/
}

function getBaseDeviceId() {
  var retId = '';

  $('#dragTable td')
    .children('img')
    .each(function() {
      if (getDeviceType($(this).attr('id').replace('device_', '')) == 'BASE') {
        retId = $(this).attr('id');
      }
    });

  return retId;
}

function createGUID() {
  function s4() {
    return Math.floor((1 + Math.random()) * 0x10000)
      .toString(16)
      .substring(1);
  }

  return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

function handleMarkForConnecting(deviceGUID) {
  var retReadyForConnecting = false;

  // do we have an empty slot?
  if (markedForConnecting[0] == '' || markedForConnecting[1] == '') {
    if (markedForConnecting[0] == '') {
      if (markedForConnecting[1] != deviceGUID) {
        markedForConnecting[0] = deviceGUID;
      } else {
        markedForConnecting[1] = '';
      }
    } else {
      if (markedForConnecting[0] != deviceGUID) {
        markedForConnecting[1] = deviceGUID;
      } else {
        markedForConnecting[0] = '';
      }
    }
  } else {
    // both slots are taken - remove if device already present!
    if (markedForConnecting[0] == deviceGUID) {
      markedForConnecting[0] = '';
    }
    if (markedForConnecting[1] == deviceGUID) {
      markedForConnecting[1] = '';
    }
  }

  refreshMarkForConnecting();

  // check if both are filled
  if (markedForConnecting[0] != '' && markedForConnecting[1] != '') {
    retReadyForConnecting = true;
  } else {
    retReadyForConnecting = false;
  }

  return retReadyForConnecting;
}

function refreshMarkForConnecting() {
  $('#devicesMarkedForConnecting').html('');
  if (markedForConnecting[0] != '' || markedForConnecting[1] != '') {
    var hlpModulname0 = '';
    var hlpPosition0 = '';
    var hlpModulname1 = '';
    var hlpPosition1 = '';
    if (markedForConnecting[0] != '') {
      hlpModulname0 = getDataStoreData(markedForConnecting[0], '##MODULNAME##');
      hlpPosition0 = ' (' + getDataStoreData(markedForConnecting[0], '##POSITION##') + ')';
    }
    if (markedForConnecting[1] != '') {
      hlpModulname1 = getDataStoreData(markedForConnecting[1], '##MODULNAME##');
      hlpPosition1 = ' (' + getDataStoreData(markedForConnecting[1], '##POSITION##') + ')';
    }

    $('#devicesMarkedForConnecting').html(
      '= Marked for Connecting =<br>Source: <strong>' +
      hlpModulname0 +
      hlpPosition0 +
      '</strong><br>Destination: <strong>' +
      hlpModulname1 +
      hlpPosition1 +
      '</strong>',
    );
  }
}

function handleConnections(id, sourceGUID, destGUID, sourceVariants, destVariants, sourceVal, destVal, mode) {
  var nextId = -1; // we'll set the first id to 0
  var hlpValsSplit = [];
  var hlpEditStoreData = [];
  var hlpVariantsSplit = [];

  if (mode == 'ADD') {
    var connObj = new Object();

    connObj.id = id != '' ? id : handleConnections('', '', '', '', '', '', '', 'GET_NEXT_ID');
    connObj.sourceGUID = sourceGUID;
    connObj.destGUID = destGUID;
    connObj.sourceModulname = getDataStoreData(sourceGUID, '##MODULNAME##');
    connObj.destModulname = getDataStoreData(destGUID, '##MODULNAME##');

    hlpValsSplit = sourceVal.split('-$-');
    connObj.sourceValGSDname = hlpValsSplit[0];
    connObj.sourceValMulti = hlpValsSplit[1];
    hlpVariantsSplit = sourceVariants.split('|');
    hlpEditStoreData = getEditStoreData(
      getDataStoreData(sourceGUID, '##DEVICEID##'),
      hlpVariantsSplit[0],
      hlpVariantsSplit[1],
      hlpValsSplit[0],
      hlpValsSplit[1],
    );
    connObj.sourceValAttrname = hlpEditStoreData.attrname;

    hlpValsSplit = destVal.split('-$-');
    connObj.destValGSDname = hlpValsSplit[0];
    connObj.destValMulti = hlpValsSplit[1];
    hlpVariantsSplit = destVariants.split('|');
    hlpEditStoreData = getEditStoreData(
      getDataStoreData(destGUID, '##DEVICEID##'),
      hlpVariantsSplit[0],
      hlpVariantsSplit[1],
      hlpValsSplit[0],
      hlpValsSplit[1],
    );
    connObj.destValAttrname = hlpEditStoreData.attrname;

    connObj.sourceVariants = sourceVariants;
    connObj.destVariants = destVariants;
    connectionStore.push(connObj);
  }

  // IMPORTANT:
  // in REMOVE and EXISTS mode, sourcVal and destVal must contain attrname, NOT GSDname!
  if (mode == 'REMOVE') {
    connectionStore = $.map(connectionStore, function(item, index) {
      if (
        (id == '' || item.id == id) &&
        (sourceGUID == '' || item.sourceGUID == sourceGUID) &&
        (destGUID == '' || item.destGUID == destGUID) &&
        (sourceVal == '' || item.sourceValAttrname == sourceVal) &&
        (destVal == '' || item.destValAttrname == destVal)
      )
        return null;

      return item;
    });
  }

  if (mode == 'EXISTS') {
    var swtFound = false;
    $(connectionStore).each(function(cnt, item) {
      if (
        (id == '' || item.id == id) &&
        (sourceGUID == '' || item.sourceGUID == sourceGUID) &&
        (destGUID == '' || item.destGUID == destGUID) &&
        (sourceVal == '' || item.sourceValAttrname == sourceVal) &&
        (destVal == '' || item.destValAttrname == destVal)
      )
        swtFound = true;
    });

    return swtFound;
  }

  if (mode == 'GET_NEXT_ID') {
    $(connectionStore).each(function(cnt, item) {
      nextId = item.id;
    });
    return nextId + 1;
  }
}

// IMPORTANT:
// id can be GUID or deviceId -
// function returns complete device object if retPattern is ""
function getDataStoreData(id, retPattern) {
  retDeviceData = '';
  workRetPattern = retPattern;

  $(tblDataStore).each(function(cnt, item) {
    if (id == item.GUID || id == item.deviceId) {
      retDeviceData = item;
    }
  });

  if (retDeviceData != '') {
    if (retPattern == '') {
      return retDeviceData;
    } else {
      workRetPattern = workRetPattern.replace('##GUID##', retDeviceData.GUID);
      workRetPattern = workRetPattern.replace('##BMK##', retDeviceData.bmk);
      workRetPattern = workRetPattern.replace('##COMMENT##', retDeviceData.comment);
      workRetPattern = workRetPattern.replace('##DEVICEID##', retDeviceData.deviceId);
      workRetPattern = workRetPattern.replace('##DEVICETYPE##', retDeviceData.deviceType);
      workRetPattern = workRetPattern.replace('##INPUT##', retDeviceData.input);
      workRetPattern = workRetPattern.replace('##MODULNAME##', retDeviceData.modulname);
      workRetPattern = workRetPattern.replace('##OUTPUT##', retDeviceData.output);
      workRetPattern = workRetPattern.replace('##POSITION##', retDeviceData.position);
      return workRetPattern;
    }
  } else {
    return 'ERR_DEVICE_NOT_FOUND';
  }
}

function getEditStoreData(deviceId, inpVariant, outVariant, attrGSDname, attrmulticount) {
  var retData = '';

  $(tblEditStore).each(function(cntDevice, itemDevice) {
    if (deviceId == itemDevice.id && inpVariant == itemDevice.inpVariant && outVariant == itemDevice.outVariant) {
      $(itemDevice.data).each(function(cntData, itemData) {
        if (attrGSDname == itemData.attrGSDname && attrmulticount == itemData.attrmulticount) {
          retData = itemData;
        }
      });
    }
  });

  return retData;
}

function checkRSCversion(version) {
  var rscVersion = version.split('.');
  var configVersion = configData.version.split('.');
  var rscVersionAll = [0, 0, 0];
  var configVersionAll = [0, 0, 0];

  for (i = 0; i < rscVersion.length; i++) {
    rscVersionAll[i] = parseInt(rscVersion[i]);
  }
  for (i = 0; i < configVersion.length; i++) {
    configVersionAll[i] = parseInt(configVersion[i]);
  }

  for (i = 0; i < 3; i++) {
    if (configVersionAll[i] > rscVersionAll[i]) {
      return true; // 2 > 1
    } else if (configVersionAll[i] < rscVersionAll[i]) {
      return false; // 1 < 2
    }
  }

  return true;
}

/*
function getExtendedDataEditor(productType) {

	var retEditor = "";

	$(configData.deviceExtendedData).each(function(cnt, item) {
		if (item.producttype == productType) {
			retEditor = item.editor;
		}
	});

	return retEditor;
}
*/

function handleExtendedDataStore(deviceId, mode) {
  var ret = '';
  var deviceIdVersion = parseDeviceId(deviceId, '##ID_VERSION##');
  var objJSON = '';

  if (mode == 'GET_ENTRY') {
    $(extendedDataStore).each(function(cnt, item) {
      if (item.id == deviceId) {
        ret = extendedDataStore[cnt];
      }
    });

    return ret;
  }

  if (mode == 'GET_FORMDATA') {
    return $('form#frm_' + deviceIdVersion).serializeJSON();
  }

  if (mode == 'GET_DATA') {
    $(extendedDataStore).each(function(cnt, item) {
      if (item.id == deviceId) {
        ret = item.data;
      }
    });

    return ret;
  }

  if (mode == 'FILL') {
    $(extendedDataStore).each(function(cntStore, itemStore) {
      if (itemStore.id == deviceId) {
        if (itemStore.data != '') {
          objJSON = jQuery.parseJSON(itemStore.data);
          for (var key in objJSON.data) {
            $('#' + key).val(objJSON.data[key]);
          }
        }
      }
    });
  }

  if (mode == 'REMOVE') {
    $(extendedDataStore).each(function(cnt, item) {
      if (item.id == deviceId) {
        extendedDataStore.splice(cnt, 1);
      }
    });
  }

  var x = 1;
}

function loadExtendedData(deviceId, data) {
  var hlpProductType = getGsdData(deviceId, '##GSD_PRODUCTTYPE##');
  var extConfig = getExtendedConfig(hlpProductType);
  var pathnameExt = 'err_no_ext.err';
  if (extConfig != '') {
    var pathnameExt = 'resources/data/extensions/' + extConfig.dialog + '.js';
    if (fileExists(pathnameExt) == true) {
      $.getScript(pathnameExt, function() {
        var objExtData = new extendedData(deviceId, '', hlpProductType);
        objExtData.data = JSON.stringify(data);
        extendedDataStore.push(objExtData);
      });
    } else {
      //alert("ERROR: Extension dialog missing ("+ extConfig.dialog +")");
      createInfoDialog('Error', '<br>' + 'Extension dialog missing (' + extConfig.dialog + ')', '');
    }
  } else {
    //alert("ERROR: Extension dialog missing ("+ extConfig.dialog +")");
    createInfoDialog('Error', '<br>' + 'Extension dialog missing (' + extConfig.dialog + ')', '');
  }
}

function getExtendedConfig(productType) {
  var retExtData = '';

  $(configData.extendedData).each(function(cntExtData, itemExtData) {
    if (itemExtData.productType == parseInt(productType)) {
      retExtData = itemExtData;
    }
  });

  return retExtData;
}

function handleFileList(fileList, replPattern) {
  // fileList (e.g. of export dir.) can be empty on new installation
  if (fileList == '') {
    return '';
  }

  var retString = '';
  var arrL01 = fileList.split(';');
  var arrL02 = [];
  var arrL03 = [];
  $.each(arrL01, function(itemCnt, item) {
    arrL02 = item.split(',');
    arrL03 = arrL02[1].split('|');

    if (replPattern.indexOf('##FILENAME##') > -1) {
      retString = retString + replPattern.replace('##FILENAME##', arrL02[0]) + ';';
    }
  });

  retString = killLastDelimiter(retString, ';');
  return retString;
}

var datasheet_default_url = 'https://revolutionpi.com/$LANG$/tutorials/downloads#technischedatenblaetter';

function showDataSheet(device) {
  let deviceId = device.replace('device_', '');
  let datasheet_url = getDatasheetURL(deviceId);

  if (datasheet_url === '##GSD_DATASHEETURL##') {
    // fallback to default datasheet url
    datasheet_url = window.pictory.datasheet_url ?? datasheet_default_url;
  }

  let datasheet_lang = currentLang.toLocaleLowerCase() == 'de' ? 'de' : 'en';
  datasheet_url = datasheet_url.replace('$LANG$', datasheet_lang);

  window.open(datasheet_url);
}

function showHelpDialog(pathnameContent) {
  if (pathnameContent != '') {
    $('#dialog_help').load(pathnameContent, function() {
      // optionally process loaded html here ...
    });
  }

  $('#dialog_help').dialog({
    width: 800,
    height: 600,
    modal: true,
    title: lookupLanguage(currentLang, 'info_help'),
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function() {
          $(this).dialog('close');
        },
      },
    ],
  });
}

function blockUI(mode) {
  // never block if session has already expired!
  // exception: mode = 0 is Start-Mode; we block here even if session has not been established yet!
  if (mode > 0 && checkSession(revPiHostname) == false) {
    createInfoDialog('Timeout', '<br>' + 'Session expired ...', '');
    return;
  }

  $.blockUI({
    message:
      '<h2 style="font-family:UbuntuBol, sans-serif;"><img alt="loading" src="resources/images/loading.svg"><br>LOADING...</h2>',
    fadeIn: 0,
    overlayCSS: { backgroundColor: '#FFFFFF', opacity: 0.6, cursor: 'wait' },
    css: {
      width: '30%',
      top: '40%',
      left: '35%',
      color: '#000',
      textAlign: 'center',
      border: '3px solid #aaa',
      opacity: 1.0,
      backgroundColor: '#fff',
    },
  });
}

function setDeviceState(deviceId, state) {
  $('#' + deviceId).css('opacity', 0.3);
  if ((state = 'active')) {
    $('#' + deviceId).css('opacity', 1.0);
  }
}

function getDeviceState(deviceId) {
  var ret = 'inactive';
  if ($('#' + deviceId).css('opacity') == 1.0) {
    ret = 'active';
  }
  return ret;
}

function getDraggedDeviceId(tableColumnIndex) {
  var retDeviceID = '';
  $('#dragTable td').each(function(i, item) {
    if (i == tableColumnIndex) {
      retDeviceID = $(this).children('img').attr('id');
    }
  });
  return retDeviceID;
}

function handleUserSettings(mode) {
  var ret = '';

  if (mode == 'GET') {
    if (fileExists(configData.paths.projects + '_userSettings.json') == true) {
      ret = AjaxGetJSON(configData.paths.projects + '_userSettings.json', 'OBJ');
    }
  }

  return ret;
}

// function gets autoexport settings
// a) from [ROOT]/config.json if userSettings["02"].mode is "0" (--> Standard setting)
// b) from userSettings["02"].set array if userSettings["02"].mode is "1" (--> Custom setting)
function getActiveAutoExport() {
  var arrRetActiveAutoExport = [];
  var arrAutoExportDefault = [];
  var arrAutoExportFilenameNoSuffix = [];

  if (userSettingsData['02'].mode == '0') {
    // IMPORTANT: autoexport settings in config.json have no 'active' flag
    // their existence alone means they are 'active'

    if ($.isArray(configData.misc.autoExportDefault)) {
      arrAutoExportDefault = configData.misc.autoExportDefault;
      arrAutoExportFilenameNoSuffix = configData.misc.autoExportFilenameNoSuffix;
    } else {
      arrAutoExportDefault.push(configData.misc.autoExportDefault);
      arrAutoExportFilenameNoSuffix.push(configData.misc.autoExportFilenameNoSuffix);
    }
  }

  if (userSettingsData['02'].mode == '1') {
    $.each(userSettingsData['02'].set, function(index, set) {
      // only get active autoexport entries
      if (set[2] == true) {
        arrAutoExportDefault.push(set[0]);
        arrAutoExportFilenameNoSuffix.push(set[1]);
      }
    });
  }

  arrRetActiveAutoExport.push(arrAutoExportDefault);
  arrRetActiveAutoExport.push(arrAutoExportFilenameNoSuffix);

  return arrRetActiveAutoExport;
}

function saveAsStart() {

  currentExportTS = getCurrentTS('YmdHis');
  var fileLastSavedBefore = getProjectFileLastSaved('_config', 'd.m.Y H:i:s');
  var retDoExport = doExport('project.json', '_config.rsc', false, false);

  // do autoExport
  if (typeof configData.misc.autoExport != 'undefined' && configData.misc.autoExport == true) {
    var arrAutoExportDefault = [];
    var arrAutoExportFilenameNoSuffix = [];
    var arrGetActiveAutoExport = getActiveAutoExport();
    arrAutoExportDefault = arrGetActiveAutoExport[0];
    arrAutoExportFilenameNoSuffix = arrGetActiveAutoExport[1];

    $.each(arrAutoExportDefault, function(index, filename) {
      var exportConfigData = getExportConfigData(filename);
      var retDoExport = doExport(
        filename,
        '../export/' + arrAutoExportFilenameNoSuffix[index] + '.' + exportConfigData.filetype,
        true,
        false,
      );
    });
  }

  // TEST - uncomment to trigger file saveAsStart
  // fileLastSavedBefore = getProjectFileLastSaved('_config', 'd.m.Y H:i:s');
  // TEST

  if (fileLastSavedBefore == getProjectFileLastSaved('_config', 'd.m.Y H:i:s')) {
    return 1;
  } else {
    setProjectInfo('config', getProjectFileLastSaved('_config', 'd.m.Y H:i:s'));
    swtIsDirty = false;
    return 0;
  }
}

function getAutosaveMin() {
  ret = 0;
  if ('04' in userSettingsData) {
    // do we have autosave data in userSettings?
    if (userSettingsData['04'][2] == '0') {
      ret = 0; // off
    }
    if (userSettingsData['04'][2] == '1') {
      ret = CONST_DEFAULT_MINUTES_AUTOSAVE; // standard
    }
    if (userSettingsData['04'][2] == '2') {
      ret = parseInt(userSettingsData['04'][3]); // custom
    }
  } else {
    // no data in usersettings yet - look into global config.json
    if (configData.misc.autoSave != 0 && configData.misc.autoSave != false) {
      ret = CONST_DEFAULT_MINUTES_AUTOSAVE; // 0/false means Off - everything else will be overwritten by default minutes
    }
  }

  return ret;
}
