var extendedData = function (id, GUID, productType) {
  this.CONST_PRODUCTTYPE_REVPI7 = 24583;
  this.CONST_MAXROWS = 32; // max. 32 actions allowed

  this.html = 'ext_revpiseven.html';
  this.id = id;
  this.idVersion = parseDeviceId(this.id, '##ID_VERSION##');
  this.productType = productType;
  this.data = '';
  this.oldValue = ''; // to restore values when validation fails

  /* Arrays for dropdown population */
  // Data Direction
  //
  // entry[0] ... Screenname
  // entry[1] ... Value
  // entry[2] ... Default value
  // entry[3]	... active
  this.arrDataDirection = [
    ['read', 0, true, true],
    ['write', 1, false, true],
  ];

  // Memory Area
  //
  // entry[0] ... Screenname
  // entry[1] ... Value
  // entry[2] ... Default value
  // entry[3]	... active
  this.arrMemoryArea = [
    ['I  (0x81)', 0x81, false, true],
    ['Q  (0x82)', 0x82, false, true],
    ['M  (0x83)', 0x83, true, true],
    ['DB (0x84)', 0x84, false, true],
    ['CT (0x1C)', 0x1c, false, true],
    ['TM (0x1D)', 0x1d, false, true],
  ];
};

extendedData.prototype.loadDialog = function () {
  var me = this;
  if ($('#dialog_' + me.idVersion).length == 0) {
    $('#extendedDialogs').append(
      $('<div>').load('resources/data/extensions/' + me.html, function () {
        $('#extendedDialogs').html(
          $('#extendedDialogs')
            .html()
            .replace(/##DEVICE_IDVERSION##/g, me.idVersion),
        );
        me.createDialog();
        me.showDialog();
        //handleExtendedDataStore(me.id, "FILL");
        me.refreshDelegates();
      }),
    );
  } else {
    /* this -else- should not be necessary since dialog is being destroyed on closing! */
    me.createDialog();
    me.showDialog();
    handleExtendedDataStore(me.id, 'FILL');
    me.refreshDelegates();
  }
};

extendedData.prototype.createDialog = function () {
  var me = this;
  var objJSON = '';
  var swtRowsLoaded = false;

  $(extendedDataStore).each(function (cntStore, itemStore) {
    if (itemStore.id == me.id) {
      if (itemStore.data != '') {
        objJSON = jQuery.parseJSON(itemStore.data);

        //debugger;
        $.each(objJSON.data, function (index, value) {
          var hlpNum = 0;
          if (index.substr(0, 8) == 'ActionId') {
            hlpNum = parseInt(index.substr(9, 2));
            me.handleTableRows('ADD_ROW', hlpNum, '');
            swtRowsLoaded = true;
          }
        });
      }
    }
  });

  // if no rows were loaded, add one empty row
  if (swtRowsLoaded == false) {
    me.handleTableRows('ADD_ROW', 0, '');
  } else {
    // can't use this to set Quantity of Registers read-only
    // is too slow!!
    //$("[id^='FunctionCode_']").trigger('change');
    me.afterDialogLoad();
  }

  // adapt dialog, depending on productType or other criteria
  // if extension is used for multiple types
  /*
	if (me.productType == me.CONST_PRODUCTTYPE_???) {
		// dummy
	} else {
		// dummy
	}
	*/
};

extendedData.prototype.afterDialogLoad = function () {
  var hlpId = '';
  // set Quantity of Registers readOnly for WRITE_SINGLE_REGISTER function
  $("[id^='FunctionCode_']").each(function (cntRows, row) {
    if ($(this).find('option:selected').text() == 'WRITE_SINGLE_REGISTER') {
      hlpId = $(this).attr('id').replace('FunctionCode_', 'QuantityOfRegisters_');
      $('#' + hlpId).prop('readonly', true);
      $('#' + hlpId).css('background-color', 'transparent');
      $('#' + hlpId).prop('title', 'not used in this function!');
    }
  });
};

extendedData.prototype.showDialog = function () {
  var me = this;
  $('#dialog_' + me.idVersion).dialog({
    width: 1024,
    height: 610,
    modal: true,
    resizable: false,
    closeOnEscape: false,
    title: me.id.replace('device_', '') + ' Extended Data',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          var retValidate = me.validate('');
          if (retValidate == true) {
            me.getDeviceValues();
            me.data = me.modifyFormData(handleExtendedDataStore(me.id, 'GET_FORMDATA'));
            $(this).dialog('close');
            // IMPORTANT: remove dialog here to create EMPTY dialog for each
            // new instance without having the need to clear existing controls first!
            $('#dialog_' + me.idVersion).remove();
          } else {
            setTimeout(function () {
              $('#' + retValidate).focus();
            }, 0);
          }
        },
      },
      {
        text: 'Cancel',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
          // IMPORTANT: remove dialog here to create EMPTY dialog for each
          // new instance without having the need to clear existing controls first!
          $('#dialog_' + me.idVersion).remove();
        },
      },
    ],
  });

  // code for manipulating dialog after showing
  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
};

extendedData.prototype.populateDropdowns = function (rowId, whichDropdowns) {
  var me = this;
  var currentArray;
  var currentSelector;
  var currentSel = '';
  var currentSelVal = '';
  var hlpRowId = '';
  var defaultVal;

  if (rowId != '') {
    hlpRowId = pad(rowId, 2);
  }

  // Dropdowns with standard behaviour

  // Data Direction
  if (
    whichDropdowns == 'ALL' ||
    whichDropdowns.indexOf('DATA_DIRECTION') != -1 ||
    whichDropdowns.indexOf('MEMORY_AREA') != -1
  ) {
    //debugger;

    if (whichDropdowns.indexOf('DATA_DIRECTION') != -1) {
      currentSelector = "[id^='DataDirection_";
      currentArray = me.arrDataDirection;
    }
    if (whichDropdowns.indexOf('MEMORY_AREA') != -1) {
      currentSelector = "[id^='MemoryArea_";
      currentArray = me.arrMemoryArea;
    }

    $(currentSelector + hlpRowId + "'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
      currentSel = $(this);
      currentSelVal = null;
      if ($(currentSel).val() != null) {
        currentSelVal = $(currentSel).val();
      }
      currentSel.empty();
      $(currentArray).each(function (cntEntries, itemEntry) {
        if (itemEntry[2] == true) {
          defaultVal = itemEntry[1];
        }
        if (itemEntry[3] == true) {
          $(currentSel).append($('<option></option>').val(itemEntry[1]).html(itemEntry[0]));
        }
      });

      // restore previously selected option
      if (currentSelVal != null) {
        $(currentSel).val(currentSelVal);
      } else {
        $(currentSel).val(defaultVal);
      }
    });
  }

  // Device Values
  // load attrnames depending on function code
  // Rule 01: READ codes --> values beginning with 'Input' / WRITE codes --> values beginning with 'Output'
  if (whichDropdowns == 'ALL' || whichDropdowns.indexOf('DEVICE_VALUE') != -1) {
    var hlpDataDirectionName = $("[id^='DataDirection_" + hlpRowId + "'][id$='" + me.idVersion + "']")
      .find('option:selected')
      .text();
    var hlpNameFilter = '';
    var hlpTypeFilter = '';
    var hlpGSDTypeFilter = ''; // we don't filter for GSD type in this extension!

    if (hlpDataDirectionName.indexOf('read') == 0) {
      hlpNameFilter = 'Input';
    }
    if (hlpDataDirectionName.indexOf('write') == 0) {
      hlpNameFilter = 'Output';
    }

    // IMPORTANT - only populate value dropdown when data direction has been selected -> filters have been set!
    if (hlpNameFilter != '') {
      var hlpAttrnames = [];
      var arrSplitAttrNames = [];
      var currentSel = '';

      $("[id^='DeviceValue_" + hlpRowId + "'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
        currentSel = $(this);

        currentSelVal = $(currentSel).val() == null ? 0 : $(currentSel).val();
        currentSel.empty();

        hlpAttrnames = me.getDeviceAttr(hlpNameFilter, hlpTypeFilter, hlpGSDTypeFilter, '', $(currentSel).val());

        $(currentSel).append($('<option></option>').val(0).html('please select ...'));
        $(hlpAttrnames).each(function (cntAttrnames, attrname) {
          arrSplitAttrNames = attrname.split('|');
          // restore previously selected option IF it is still present in the dropdown options
          // (may no longer be present if function code type has changed!)
          if (arrSplitAttrNames[0] == currentSelVal) {
            $(currentSel).append(
              $('<option></option>').val(arrSplitAttrNames[0]).html(arrSplitAttrNames[0]).attr('selected', 'selected'),
            );
          } else {
            $(currentSel).append($('<option></option>').val(arrSplitAttrNames[0]).html(arrSplitAttrNames[0]));
          }
        });
      });
    } else {
      // clear value dropdown if no function has been selected ...
      $("[id^='DeviceValue_" + hlpRowId + "'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
        $(this).empty();
      });
    }
  }
};

extendedData.prototype.getNextRowNum = function () {
  var retNum = 0;

  //debugger;
  $("[id^='ActionId_']").each(function (cntActionIds, actionId) {
    retNum = parseInt($(this).attr('id').substr(9, 2));
  });

  retNum = retNum + 1;
  return retNum;
};

extendedData.prototype.renumberActionIds = function () {
  var me = this;

  var cntRows = $('#tbl_A_' + me.idVersion + ' tr').length - 1; // decrement since length also counts header rows!
  var hlpCnt = 1;

  $("[id^='ActionId_']").each(function (cnt, item) {
    $('#' + $(this).attr('id')).val(hlpCnt);

    //$().html(hlpCnt);
    hlpCnt++;
  });
};

extendedData.prototype.refreshMasks = function () {
  var me = this;

  $("[id^='DB_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='DB_'][id$='" + me.idVersion + "']").mask('00000');

  $("[id^='Start_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='Start_'][id$='" + me.idVersion + "']").mask('00000');

  $("[id^='Size_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='Size_'][id$='" + me.idVersion + "']").mask('00000');

  $("[id^='Cycle_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='Cycle_'][id$='" + me.idVersion + "']").mask('00000');
};

extendedData.prototype.refreshDelegates = function () {
  var me = this;
  var arrRowNumbers = [];

  // buttons
  $('#btnAddRow_' + me.idVersion).off();
  $('#btnAddRow_' + me.idVersion).on('click', function (e) {
    // number of table rows must be reduced by two since table contains invisible tmpl-row
    if (me.CONST_MAXROWS == $('#tbl_A_' + me.idVersion + ' tr').length - 2) {
      alert('Max of rows reached ...');
      return;
    }

    me.handleTableRows('ADD_ROW', 0, '');
    // scroll table to bottom to prevent buttons from disappearing when dailog window is filled
    $('#dialog_' + me.idVersion).animate({ scrollTop: $('#dialog_' + me.idVersion).prop('scrollHeight') });
  });

  $('#btnRemoveRows_' + me.idVersion).off();
  $('#btnRemoveRows_' + me.idVersion).on('click', function (e) {
    arrRowNumbers = [];
    $("[id^='chkRow'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
      if ($(this).prop('checked') == true) {
        arrRowNumbers.push(parseInt($(this).attr('id').substr(7, 2)));
      }
    });

    //debugger;
    $(arrRowNumbers).each(function (cntRowNum, rowNum) {
      me.handleTableRows('REMOVE_ROW', rowNum, '');
    });

    if (me.validate('') != true) {
      // just re-validate to get numbering of error messages right after removing of rows
    }
  });

  // Input fields

  $("[id^='DB_'][id$='" + me.idVersion + "']").off();
  $("[id^='DB_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='DB_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
    }
  });

  $("[id^='Start_'][id$='" + me.idVersion + "']").off();
  $("[id^='Start_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='Start_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
    }
  });

  $("[id^='Size_'][id$='" + me.idVersion + "']").off();
  $("[id^='Size_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='Size_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
    }
  });

  $("[id^='Cycle_'][id$='" + me.idVersion + "']").off();
  $("[id^='Cycle_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='Cycle_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
    }
  });

  // dropdowns
  //
  // Data direction
  $("[id^='DataDirection_'][id$='" + me.idVersion + "']").off();
  $("[id^='DataDirection_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='DataDirection_'][id$='" + me.idVersion + "']").on('change', function (e) {
    var hlpRowId = me.handleTableRows('GET_ROWID', 0, $(this).attr('id'));

    /*disable input of Quantity of Registers for SINGLE function
		var hlpFunctionCodeName = $(this).find('option:selected').text();
		var hlpRowId = me.handleTableRows("GET_ROWID", 0, $(this).attr('id'));
		if (hlpFunctionCodeName == "WRITE_SINGLE_REGISTER") {
			$('#QuantityOfRegisters_' + pad(hlpRowId,2) + "_" + me.idVersion).prop('readonly', true);
			$('#QuantityOfRegisters_' + pad(hlpRowId,2) + "_" + me.idVersion).css('background-color', 'transparent');
			$('#QuantityOfRegisters_' + pad(hlpRowId,2) + "_" + me.idVersion).prop('title', 'not used in this function!');
		} else {
			$('#QuantityOfRegisters_' + pad(hlpRowId,2) + "_" + me.idVersion).prop('readonly', false);
			$('#QuantityOfRegisters_' + pad(hlpRowId,2) + "_" + me.idVersion).css('background-color', 'white');
			$('#QuantityOfRegisters_' + pad(hlpRowId,2) + "_" + me.idVersion).prop('title', '');
		}

		*/

    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    } else {
      //me.populateDropdowns(hlpRowId,"ALL");
    }

    me.populateDropdowns(hlpRowId, 'DEVICE_VALUE');
  });

  // Device Values
  $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").off();
  $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").on('change', function (e) {
    var hlpRowId = me.handleTableRows('GET_ROWID', '', $(this).attr('id'));
    var hlpRowId2 = '';
    $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
      hlpRowId2 = me.handleTableRows('GET_ROWID', '', $(this).attr('id'));
      // don't refresh dropdown that caused refresh of all other dropdowns!
      if (hlpRowId != hlpRowId2) {
        me.populateDropdowns(hlpRowId2, 'DEVICE_VALUE');
      }
    });

    if (me.validate('') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
    }
  });
};

extendedData.prototype.getDeviceValues = function () {
  var me = this;

  // fill ModbusActionStatus
  $("[id^='ModbusActionStatus_'][id$='" + me.idVersion + "']").each(function (cntMAS, itemMAS) {
    var this_control = $(this);
    $(tblEditStore).each(function (cntStoreItems, storeItem) {
      if (storeItem.id == me.id) {
        $(storeItem.data).each(function (cntDataItems, dataItem) {
          if (dataItem.attrGSDname == 'Modbus_Action_Status' && parseInt(dataItem.attrmulticount) == cntMAS + 1) {
            this_control.val(dataItem.attrname);
            return false;
          }
        });
      }
    });
  });

  // fill ActionStatusReset
  $("[id^='ActionStatusReset_'][id$='" + me.idVersion + "']").each(function (cntASR, itemASR) {
    var this_control = $(this);
    $(tblEditStore).each(function (cntStoreItems, storeItem) {
      if (storeItem.id == me.id) {
        $(storeItem.data).each(function (cntDataItems, dataItem) {
          if (dataItem.attrGSDname == 'Action_Status_Reset' && parseInt(dataItem.attrmulticount) == cntASR + 1) {
            this_control.val(dataItem.attrname);
            return false;
          }
        });
      }
    });
  });

  // fill ModbusMasterStatus &  MasterStatusReset
  $(tblEditStore).each(function (cntStoreItems, storeItem) {
    if (storeItem.id == me.id) {
      $(storeItem.data).each(function (cntDataItems, dataItem) {
        if (dataItem.attrGSDname == 'Modbus_Master_Status') {
          $("[id^='hid_ModbusMasterStatus_'][id$='" + me.idVersion + "']").val(dataItem.attrname);
        }
        if (dataItem.attrGSDname == 'Master_Status_Reset') {
          $("[id^='hid_MasterStatusReset_'][id$='" + me.idVersion + "']").val(dataItem.attrname);
        }
      });
    }
  });
};

// IMPORTANT: this function is intended to handles special cases where
// form data can not be 1:1 used in extended data for export!
// - not used in modbus currently -
extendedData.prototype.modifyFormData = function (formData) {
  return formData;
};

// MISC helper functions
//
extendedData.prototype.handleTableRows = function (mode, rowNum, controlId) {
  var me = this;
  var hlpSplit = [];

  // entry[0] ... Name of Control
  // entry[1] ... generate 'name' attribute -> determines whether control will be saved to RSC file!
  var arrControls = [
    ['ActionId', true],
    ['DataDirection', true],
    ['MemoryArea', true],
    ['DB', true],
    ['Start', true],
    ['Size', true],
    ['Cycle', true],
    ['DeviceValue', true],
  ];

  if (mode == 'ADD_ROW') {
    //debugger;
    var nextRowNum = me.getNextRowNum();
    var rowNumToAdd = rowNum == 0 ? nextRowNum : rowNum;

    // row level
    $('#tbl_A_' + me.idVersion + ' tbody').append($('#tmpl_row_' + me.idVersion).clone());
    $('#tbl_A_' + me.idVersion + ' tr:last').attr('id', 'row_' + pad(rowNumToAdd, 2) + '_' + me.idVersion);

    // row marker (will not be saved)
    $('#tbl_A_' + me.idVersion + ' tr:last')
      .find('#tmpl_chkRow_' + me.idVersion)
      .attr('id', 'chkRow_' + pad(rowNumToAdd, 2) + '_' + me.idVersion);

    $(arrControls).each(function (cntControls, itemControl) {
      $('#tbl_A_' + me.idVersion + ' tr:last')
        .find('#tmpl_' + itemControl[0] + '_' + me.idVersion)
        .attr('id', itemControl[0] + '_' + pad(rowNumToAdd, 2) + '_' + me.idVersion);

      // generate 'name' HTML attr?
      if (itemControl[1] == true) {
        $('#tbl_A_' + me.idVersion + ' tr:last')
          .find('#' + itemControl[0] + '_' + pad(rowNumToAdd, 2) + '_' + me.idVersion)
          .attr('name', 'data[' + itemControl[0] + '_' + pad(rowNumToAdd, 2) + '_' + me.idVersion + ']');
      }
    });

    // show dialog
    $('#tbl_A_' + me.idVersion + ' tr:last').show();

    // set init values depending on productype
    if (me.productType == me.CONST_PRODUCTTYPE_MODBUS_TCP) {
      $('#SlaveAddress_' + pad(rowNumToAdd, 2) + '_' + me.idVersion).val('255');
    } else {
      $('#SlaveAddress_' + pad(rowNumToAdd, 2) + '_' + me.idVersion).val('1');
    }

    // -Device Values- depend on selected values of -Data Direction-
    //	--> we need to populate and load data in two steps!!

    me.populateDropdowns(rowNumToAdd, 'DATA_DIRECTION');
    me.populateDropdowns(rowNumToAdd, 'MEMORY_AREA');
    handleExtendedDataStore(me.id, 'FILL');
    me.populateDropdowns(rowNumToAdd, 'DEVICE_VALUE');
    handleExtendedDataStore(me.id, 'FILL');

    me.renumberActionIds();
    me.refreshDelegates();
    setTimeout(function () {
      me.refreshMasks();
    }, 10); // unknown why this only works when delayed ...
    //me.validate();

    // decrement rowcount by 2 - don't count table header and invisible template row!
    $('#hid_tbl_A_rowcount').val($('#tbl_A_' + me.idVersion + ' tr').length - 2);
  }

  if (mode == 'REMOVE_ROW') {
    $('#row_' + pad(rowNum, 2) + '_' + me.idVersion).remove();

    me.renumberActionIds();

    // decrement rowcount by 2 - don't count table header and invisible template row!
    $('#hid_tbl_A_rowcount').val($('#tbl_A_' + me.idVersion + ' tr').length - 2);
  }

  if (mode == 'GET_ROWID') {
    hlpSplit = controlId.split('_');
    return parseInt(hlpSplit[1]);
  }
};

// returns attrname AND attrGSDname (with multi-count if multi > 1)
extendedData.prototype.getDeviceAttr = function (
  nameFilter,
  typeFilter,
  GSDtypeFilter,
  bitSizeFilter,
  dontExcludeUsed,
) {
  var me = this;
  var arrAttrnames = [];
  var hlpDataType = '';

  $(tblEditStore).each(function (cntStoreItems, storeItem) {
    if (storeItem.id == me.id) {
      $(storeItem.data).each(function (cntDataItems, dataItem) {
        // check if attr has already been used!
        var swtAlreadyUsed = false;
        /* IMPORTANT: DISABLED TO INCREASE PERFORMANCE
				$("[id^='DeviceValue_'][id$='" + me.idVersion +"']").each(function(cntRows, row) {
					if((dataItem.attrname == $(this).val()) && (dataItem.attrname != dontExcludeUsed)) {
						swtAlreadyUsed = true;
					}
				});
				*/

        // don't add attrs that have already been used!
        if (swtAlreadyUsed == false) {
          // get bit size only if filter is set
          if (bitSizeFilter != 0) {
            hlpDataType = getDataType(dataItem.attrGSDtype);
          }

          if (
            (nameFilter == '' || dataItem.attrGSDname.substr(0, nameFilter.length) == nameFilter) &&
            (typeFilter == '' || dataItem.attrtype.split(" ")[0] == typeFilter) &&
            (GSDtypeFilter == '' || dataItem.attrGSDtype == GSDtypeFilter) &&
            (bitSizeFilter == '' || hlpDataType.attr[fileDataTypesJSON.constants.BITLEN] == bitSizeFilter)
          ) {
            // don't add hidden attrs!
            if (dataItem.attrhidden == 'false') {
              arrAttrnames.push(
                dataItem.attrname +
                  '|' +
                  dataItem.attrGSDname +
                  (dataItem.attrGSDmulti > 1 ? '_' + dataItem.attrmulticount : ''),
              );
            }
          }
        }
      });
    }
  });

  return arrAttrnames;
};

// STANDARD functions
//
extendedData.prototype.handleMessage = function (mode, txtMessage) {
  var me = this;

  if (mode == 'SHOW') {
    $('#' + 'lbl_tbl_A_msg_' + me.idVersion).html(txtMessage + '<p>');
    $('#' + 'lbl_tbl_A_msg_' + me.idVersion).show();
  }

  if (mode == 'HIDE') {
    $('#' + 'lbl_tbl_A_msg_' + me.idVersion).hide();
  }
};

extendedData.prototype.validate = function (mode) {
  var me = this;
  var errText = '';
  var errControlId = '';
  var hlpRowId = 0;
  var hlpValue = null;
  var hlpDDmode = null;
  var hlpDataDirectionName = '';

  //debugger;

  // reset old error message
  me.handleMessage('HIDE', '');

  // Check 01 - Cycle
  $("[id^='Cycle_'][id$='" + me.idVersion + "']").each(function (cntC, itemC) {
    hlpRowId = me.handleTableRows('GET_ROWID', 0, $(this).attr('id'));
    hlpRowId = pad(hlpRowId, 2);
    hlpDataDirectionName = $("[id^='DataDirection_" + hlpRowId + "'][id$='" + me.idVersion + "']")
      .find('option:selected')
      .text();

    //debugger;

    if ($('#' + itemC.id).val() == '') {
      errText = errText + 'Action Id: ' + parseInt(cntC + 1) + ' / ERR_EXT_01: Cycle time is empty<br>';
      errControlId = itemC.id;
    }

    hlpValue = parseInt($('#' + itemC.id).val());
    if (hlpValue < 100) {
      // 0 allowed when direction is 'write'
      if (hlpDataDirectionName == 'read' || (hlpDataDirectionName == 'write' && hlpValue > 0)) {
        errText =
          errText +
          'Action Id: ' +
          parseInt(cntC + 1) +
          ' / ERR_EXT_01: Cycle time to low (0 allowed in -write- mode)<br>';
        errControlId = itemC.id;
      }
    }
  });

  // Check 02 - DB
  $("[id^='DB_'][id$='" + me.idVersion + "']").each(function (cnt, item) {
    if ($('#' + item.id).val() == '') {
      errText = errText + 'Action Id: ' + parseInt(cnt + 1) + ' / ERR_EXT_02: DB# is empty<br>';
      errControlId = item.id;
    }
    if (parseInt($('#' + item.id).val()) < 0 || parseInt($('#' + item.id).val()) > 65535) {
      errText = errText + 'Action Id: ' + parseInt(cnt + 1) + ' / ERR_EXT_02: DB# out of Range (0-65535)<br>';
      errControlId = item.id;
    }
  });

  // Check 03 - Start
  $("[id^='Start_'][id$='" + me.idVersion + "']").each(function (cnt, item) {
    if ($('#' + item.id).val() == '') {
      errText = errText + 'Action Id: ' + parseInt(cnt + 1) + ' / ERR_EXT_03: Start is empty<br>';
      errControlId = item.id;
    }
    if (parseInt($('#' + item.id).val()) < 0 || parseInt($('#' + item.id).val()) > 65535) {
      errText = errText + 'Action Id: ' + parseInt(cnt + 1) + ' / ERR_EXT_03: Start out of Range (0-65535)<br>';
      errControlId = item.id;
    }
  });

  // Check 03 - Size
  $("[id^='Size_'][id$='" + me.idVersion + "']").each(function (cnt, item) {
    if ($('#' + item.id).val() == '') {
      errText = errText + 'Action Id: ' + parseInt(cnt + 1) + ' / ERR_EXT_04: Size is empty<br>';
      errControlId = item.id;
    }
    if (parseInt($('#' + item.id).val()) < 0 || parseInt($('#' + item.id).val()) > 65536) {
      errText = errText + 'Action Id: ' + parseInt(cnt + 1) + ' / ERR_EXT_04: Size out of Range (0-65536)<br>';
      errControlId = item.id;
    }
  });

  // Check 06 - DeviceValue
  if (mode != 'NO_DV') {
    $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").each(function (cntDV, itemDV) {
      if ($('#' + itemDV.id).val() == 0) {
        errText = errText + 'Action Id: ' + parseInt(cntDV + 1) + ' / ERR_EXT_05: Please select Device Value!<br>';
        errControlId = itemDV.id;
      }
    });
  }

  if (errText != '') {
    me.handleMessage('SHOW', errText);
    return errControlId;
  } else {
    return true;
  }
};

// this function MUST exist in every ext_????.js file since it
// is being called on every changing of an attribute name in the value editor of PiCtory!
// (but function can be empty!)
extendedData.prototype.updateChangedAttrnames = function (newName, oldName) {
  var me = this;
  // data is empty if dialog has not yet been closed with 'OK'
  // no need to update ...
  if (me.data == '') {
    return;
  }

  var objJSON = jQuery.parseJSON(me.data);
  var swtChanged = false;

  jQuery.each(objJSON.data, function (name, value) {
    if (value == oldName) {
      objJSON.data[name] = newName;
      swtChanged = true;
    }
  });

  if ((swtChanged = true)) {
    me.data = JSON.stringify(objJSON);
  }
};

extendedData.prototype.test = function () {
  var me = this;
  //alert('TEST XXX');
  // put test code here
};
