var extendedData = function (id, GUID, productType) {
  this.CONST_PRODUCTTYPE_MODBUS_TCP = 24579;
  this.CONST_PRODUCTTYPE_MODBUS_RTU = 24580;
  this.MAX_REGISTER_SIZE_PER_ACTION = 256; // max register size for each modbus device action configured in pictory

  this.html = 'ext_modbus.html';
  this.id = id;
  this.idVersion = parseDeviceId(this.id, '##ID_VERSION##');
  this.GUID = GUID; // we don't need the GUID at the moment
  this.productType = productType;
  this.data = '';
  this.oldValue = ''; // to restore values when validation fails
  this.onLoad = true;

  this.arrMap = [];

  /* TEST
	this.arrMap = [
		["txt001","I",1],
		["txt002","I",2],
		["txt001","I",3],
		["DeviceValue_01_" + this.idVersion ,"I",4]
	];
	*/

  // FunctionCodes
  //
  // entry[0] ... Screenname of Code
  // entry[1] ... Value of Code
  // entry[2]	... Bitsize of code
  // entry[3]	... active
  this.arrFunctionCodes = [
    ['please select ...', 0, 0, true],
    ['READ_COILS', 1, 1, true],
    ['READ_DISCRETE_INPUTS', 2, 1, true],
    ['READ_HOLDING_REGISTERS', 3, 16, true],
    ['READ_INPUT_REGISTERS', 4, 16, true],
    ['WRITE_SINGLE_COIL', 5, 1, true],
    ['WRITE_SINGLE_REGISTER', 6, 16, true],
    ['READ_EXCEPTION_STATUS', 7, 1, false],
    ['WRITE_MULTIPLE_COILS', 15, 1, true],
    ['WRITE_MULTIPLE_REGISTERS', 16, 16, true],
    ['REPORT_SLAVE_ID', 17, 1, false],
    ['WRITE_MASK_REGISTER', 22, 1, false],
    ['WRITE_MASK_REGISTER', 23, 1, false],
  ];

  this.cntModbusActionStatus = 0;
};

extendedData.prototype.loadDialog = function () {
  var me = this;
  me.onLoad = true;
  if ($('#dialog_' + me.idVersion).length == 0) {
    $('#extendedDialogs').append(
      $('<div>').load('resources/data/extensions/' + me.html, function () {
        $('#extendedDialogs').html(
          $('#extendedDialogs')
            .html()
            .replace(/##DEVICE_IDVERSION##/g, me.idVersion),
        );
        me.createDialog();
        me.showDialog();
        //handleExtendedDataStore(me.id, "FILL");
        me.refreshDelegates();
        me.onLoad = false; // '.load' function is async - onLoad switch needs to be here, not at end of loadDialog
      }),
    );
  } else {
    /* this -else- should not be necessary since dialog is being destroyed on closing! */
    me.createDialog();
    me.showDialog();
    handleExtendedDataStore(me.id, 'FILL');
    me.refreshDelegates();
  }
};

extendedData.prototype.createDialog = function () {
  var me = this;
  var objJSON = '';
  var swtRowsLoaded = false;

  $(extendedDataStore).each(function (cntStore, itemStore) {
    if (itemStore.id == me.id) {
      if (itemStore.data != '') {
        objJSON = jQuery.parseJSON(itemStore.data);

        //debugger;
        $.each(objJSON.data, function (index, value) {
          var hlpNum = 0;
          if (index.substr(0, 8) == 'ActionId') {
            hlpNum = parseInt(index.substr(9, 2));
            me.handleTableRows('ADD_ROW', hlpNum, '');
            swtRowsLoaded = true;
          }
        });

        /*
				for (var i=1; i <= objJSON.deviceMisc.tbl_A_rowcount; i++) {
					me.handleTableRows("ADD_ROW",0, "");
					swtRowsLoaded = true;
				}
				*/
      }
    }
  });

  // if no rows were loaded, add one empty row
  if (swtRowsLoaded == false) {
    me.handleTableRows('ADD_ROW', 0, '');
  } else {
    // can't use this to set Quantity of Registers read-only
    // is too slow!!
    //$("[id^='FunctionCode_']").trigger('change');
    me.afterDialogLoad();
  }

  // adapt dialog, depending on productType or other criteria
  if (me.productType == me.CONST_PRODUCTTYPE_MODBUS_RTU) {
    $('.col_tbl_A_SlaveIP_' + me.idVersion).hide();
    $('.col_tbl_A_SlavePort_' + me.idVersion).hide();
  } else {
    $('.col_tbl_A_SlaveIP_' + me.idVersion).hide();
    $('.col_tbl_A_SlavePort_' + me.idVersion).hide();
    // table header caption change in TCP version Slave Addr. ---> Unit ID
    $('#thSlaveAddr').html('Unit ID');
    // no longer needed - both modbus types have identical data
    //$(".col_tbl_A_SlaveAddress_" + me.idVersion).hide();
  }
};

extendedData.prototype.afterDialogLoad = function () {
  var hlpId = '';
  // set Quantity of Registers readOnly for WRITE_SINGLE_REGISTER function
  $("[id^='FunctionCode_']").each(function (cntRows, row) {
    if ($(this).find('option:selected').text() == 'WRITE_SINGLE_REGISTER') {
      hlpId = $(this).attr('id').replace('FunctionCode_', 'QuantityOfRegisters_');
      $('#' + hlpId).prop('readonly', true);
      $('#' + hlpId).css('background-color', 'transparent');
      $('#' + hlpId).prop('title', 'not used in this function!');
    }
  });
};

extendedData.prototype.showDialog = function () {
  var me = this;
  $('#dialog_' + me.idVersion).dialog({
    width: 1024,
    height: 610,
    modal: true,
    resizable: false,
    closeOnEscape: false,
    title: me.id.replace('device_', '') + ' Extended Data',
    show: { effect: 'blind', duration: 200 },
    buttons: [
      {
        text: 'Ok',
        icons: {
          primary: 'ui-icon-heart',
        },
        click: function () {
          var retValidate = me.validate('');
          if (retValidate == true) {
            me.getDeviceValues();
            me.data = me.modifyFormData(handleExtendedDataStore(me.id, 'GET_FORMDATA'));
            me.mapAttributes(); // will do nothing currently since no mapping exists in arrMap
            $(this).dialog('close');
            // IMPORTANT: remove dialog here to create EMPTY dialog for each
            // new instance without having the need to clear existing controls first!
            $('#dialog_' + me.idVersion).remove();
            swtIsDirty = true; // handle ALL savings of E.D. as 'dirty'
          } else {
            setTimeout(function () {
              $('#' + retValidate).focus();
            }, 0);
          }
        },
      },
      {
        text: 'Cancel',
        icons: {
          primary: 'ui-icon-closethick',
        },
        click: function () {
          $(this).dialog('close');
          // IMPORTANT: remove dialog here to create EMPTY dialog for each
          // new instance without having the need to clear existing controls first!
          $('#dialog_' + me.idVersion).remove();
        },
      },
    ],
  });

  // code for manipulating dialog after showing
  $('.ui-dialog-titlebar-close').hide(); // hide close x icon
};

extendedData.prototype.populateDropdowns = function (rowId, whichDropdowns) {
  var me = this;
  var currentSel = '';
  var currentSelVal = '';
  var hlpRowId = '';

  if (rowId != '') {
    hlpRowId = pad(rowId, 2);
  }

  // Function Code
  if (whichDropdowns == 'ALL' || whichDropdowns.indexOf('FUNCTION_CODE') != -1) {
    $("[id^='FunctionCode_" + hlpRowId + "'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
      currentSel = $(this);
      currentSelVal = $(currentSel).val() == null ? 0 : $(currentSel).val();
      currentSel.empty();
      $(me.arrFunctionCodes).each(function (cntFunctionCodes, itemFunctionCode) {
        if (itemFunctionCode[3] == true) {
          $(currentSel).append($('<option></option>').val(itemFunctionCode[1]).html(itemFunctionCode[0]));
        }
      });

      // restore previously selected option
      $(currentSel).val(currentSelVal);
    });
  }

  // Device Values
  // load attrnames depending on function code
  // Rule 01: READ codes --> INP values / WRITE codes --> OUT values
  // Rule 02: REGISTER codes --> WORD values / COIL codes --> BOOL values
  if (whichDropdowns == 'ALL' || whichDropdowns.indexOf('DEVICE_VALUE') != -1) {
    var hlpFunctionCodeName = $("[id^='FunctionCode_" + hlpRowId + "'][id$='" + me.idVersion + "']")
      .find('option:selected')
      .text();
    var hlpfunctionCodeData = me.getFunctionCodeData(hlpFunctionCodeName);
    var hlpTypeFilter = '';
    var hlpGSDTypeFilter = '';

    if (hlpFunctionCodeName.indexOf('READ') == 0) {
      hlpTypeFilter = 'INP';
    }
    if (hlpFunctionCodeName.indexOf('WRITE') == 0) {
      hlpTypeFilter = 'OUT';
    }

    // COIL codes
    if (hlpfunctionCodeData[2] == 1) {
      hlpGSDTypeFilter = 'BOOL';
    }
    // REGISTER codes
    if (hlpfunctionCodeData[2] == 16) {
      hlpGSDTypeFilter = 'WORD';
    }

    // IMPORTANT - only populate value dropdown when function code has been selected -> filters have been set!
    if (hlpTypeFilter != '' && hlpGSDTypeFilter != '') {
      var hlpAttrnames = [];
      var arrSplitAttrNames = [];
      var currentSel = '';
      var hlpDontExcludeUsed = false;

      $("[id^='DeviceValue_" + hlpRowId + "'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
        currentSel = $(this);

        currentSelVal = $(currentSel).val() == null ? 0 : $(currentSel).val();
        currentSel.empty();

        //hlpAttrnames = me.getDeviceAttr(hlpTypeFilter,hlpGSDTypeFilter,"",$(currentSel).val());
        //hlpAttrnames = me.getDeviceAttr(hlpTypeFilter,hlpGSDTypeFilter,"",true);

        // TO IMPROVE PERFORMANCE WHEN MANY ROWS EXIST OR ARE ABOUT TO BE ENTERED ...
        // decide whether conflict checking is on or off
        // ON: normal adding of rows when disable checkbox is NOT checked
        // OFF: on adding of existing rows in loading-function or when disable checkbox IS checked
        if (me.onLoad == true || $('#chk_disable_dv_conflict_checking').is(':checked') == true) {
          hlpDontExcludeUsed = true;
        }

        hlpAttrnames = me.getDeviceAttr(hlpTypeFilter, hlpGSDTypeFilter, '', hlpDontExcludeUsed);

        $(currentSel).append($('<option></option>').val(0).html('please select ...'));
        $(hlpAttrnames).each(function (cntAttrnames, attrname) {
          arrSplitAttrNames = attrname.split('|');
          // restore previously selected option IF it is still present in the dropdown options
          // (may no longer be present if function code type has changed!)
          if (arrSplitAttrNames[0] == currentSelVal) {
            $(currentSel).append(
              $('<option></option>').val(arrSplitAttrNames[0]).html(arrSplitAttrNames[0]).attr('selected', 'selected'),
            );
          } else {
            $(currentSel).append($('<option></option>').val(arrSplitAttrNames[0]).html(arrSplitAttrNames[0]));
          }
        });
      });
    } else {
      // clear value dropdown if no function has been selected ...
      $("[id^='DeviceValue_" + hlpRowId + "'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
        $(this).empty();
      });
    }
  }
};

extendedData.prototype.getNextRowNum = function () {
  var retNum = 0;

  //debugger;
  $("[id^='ActionId_']").each(function (cntActionIds, actionId) {
    retNum = parseInt($(this).attr('id').substr(9, 2));
  });

  retNum = retNum + 1;
  return retNum;
};

extendedData.prototype.renumberActionIds = function () {
  var me = this;

  var cntRows = $('#tbl_A_' + me.idVersion + ' tr').length - 1; // decrement since length also counts header rows!
  var hlpCnt = 1;

  $("[id^='ActionId_']").each(function (cnt, item) {
    $('#' + $(this).attr('id')).val(hlpCnt);

    //$().html(hlpCnt);
    hlpCnt++;
  });
};

extendedData.prototype.refreshMasks = function () {
  var me = this;

  $("[id^='SlaveAddress_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='SlaveAddress_'][id$='" + me.idVersion + "']").mask('000');

  $("[id^='SlaveIP_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='SlaveIP_'][id$='" + me.idVersion + "']").mask('0ZZ.0ZZ.0ZZ.0ZZ', {
    translation: { Z: { pattern: /[0-9]/, optional: true } },
    placeholder: '___.___.___.___',
  });

  $("[id^='RegisterAddress_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='RegisterAddress_'][id$='" + me.idVersion + "']").mask('00000');

  $("[id^='SlavePort_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='SlavePort_'][id$='" + me.idVersion + "']").mask('0000');

  $("[id^='QuantityOfRegisters_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='QuantityOfRegisters_'][id$='" + me.idVersion + "']").mask('0000');

  $("[id^='ActionInterval_'][id$='" + me.idVersion + "']").unmask();
  $("[id^='ActionInterval_'][id$='" + me.idVersion + "']").mask('0000000');
};

extendedData.prototype.refreshDelegates = function () {
  var me = this;
  var arrRowNumbers = [];

  // buttons
  $('#btnAddRow_' + me.idVersion).off();
  $('#btnAddRow_' + me.idVersion).on('click', function (e) {
    // only get number of Modbus_Action_Status once; never changes so this
    // need no be repeated on each row insert
    if (me.cntModbusActionStatus == 0) {
      me.cntModbusActionStatus = me.cntModbus_Action_Status();
    }

    // IMPORTANT: limitation of action rows to number of ActionStatus can be disabled by checkbox!
    if ($('#chk_disable_dv_row_limitation').is(':checked') == false) {
      //debugger;

      // number of table rows must be reduced by two since table contains invisible tmpl-row
      if (me.cntModbusActionStatus <= $('#tbl_A_' + me.idVersion + ' tr').length - 2) {
        alert('Max of rows reached ...');
        return;
      }
    }

    me.handleTableRows('ADD_ROW', 0, '');
    // scroll table to bottom to prevent buttons from disappearing when dailog window is filled
    $('#dialog_' + me.idVersion).animate({ scrollTop: $('#dialog_' + me.idVersion).prop('scrollHeight') });
  });

  $('#btnRemoveRows_' + me.idVersion).off();
  $('#btnRemoveRows_' + me.idVersion).on('click', function (e) {
    arrRowNumbers = [];
    $("[id^='chkRow'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
      if ($(this).prop('checked') == true) {
        arrRowNumbers.push(parseInt($(this).attr('id').substr(7, 2)));
      }
    });

    //debugger;
    $(arrRowNumbers).each(function (cntRowNum, rowNum) {
      me.handleTableRows('REMOVE_ROW', rowNum, '');
    });

    if (me.validate('') != true) {
      // just re-validate to get numbering of error messages right after removing of rows
    }
  });

  // Input fields

  $("[id^='SlaveAddress_'][id$='" + me.idVersion + "']").off();
  $("[id^='SlaveAddress_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='SlaveAddress_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    }
  });

  $("[id^='SlaveIP_'][id$='" + me.idVersion + "']").off();
  $("[id^='SlaveIP_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='SlaveIP_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    }
  });

  $("[id^='RegisterAddress_'][id$='" + me.idVersion + "']").off();
  $("[id^='RegisterAddress_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='RegisterAddress_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    }
  });

  $("[id^='QuantityOfRegisters_'][id$='" + me.idVersion + "']").off();
  $("[id^='QuantityOfRegisters_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='QuantityOfRegisters_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    }
  });

  $("[id^='ActionInterval_'][id$='" + me.idVersion + "']").off();
  $("[id^='ActionInterval_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='ActionInterval_'][id$='" + me.idVersion + "']").on('change', function (e) {
    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    }
  });

  // dropdowns
  //
  // Function code
  $("[id^='FunctionCode_'][id$='" + me.idVersion + "']").off();
  $("[id^='FunctionCode_'][id$='" + me.idVersion + "']").on('focus', function (e) {
    me.oldValue = $(this).val();
  });
  $("[id^='FunctionCode_'][id$='" + me.idVersion + "']").on('change', function (e) {
    //disable input of Quantity of Registers for SINGLE function
    var hlpFunctionCodeName = $(this).find('option:selected').text();
    var hlpRowId = me.handleTableRows('GET_ROWID', 0, $(this).attr('id'));
    if (hlpFunctionCodeName == 'WRITE_SINGLE_REGISTER') {
      $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).prop('readonly', true);
      $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).css('background-color', 'transparent');
      $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).prop('title', 'not used in this function!');
    } else {
      $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).prop('readonly', false);
      $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).css('background-color', 'white');
      $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).prop('title', '');
    }

    if (me.validate('NO_DV') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
      //$(this).val(me.oldValue);
    } else {
      //me.populateDropdowns(hlpRowId,"ALL");
    }

    me.populateDropdowns(hlpRowId, 'ALL'); //
  });

  // Device Values
  $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").off();
  $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").on('change', function (e) {
    var hlpRowId = me.handleTableRows('GET_ROWID', '', $(this).attr('id'));
    var hlpRowId2 = '';
    $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
      hlpRowId2 = me.handleTableRows('GET_ROWID', '', $(this).attr('id'));
      // don't refresh dropdown that caused refresh of all other dropdowns!
      if (hlpRowId != hlpRowId2) {
        me.populateDropdowns(hlpRowId2, 'DEVICE_VALUE');
      }
    });

    if (me.validate('') != true) {
      var hlpId = $(this).attr('id');
      setTimeout(function () {
        $('#' + hlpId).focus();
      }, 0);
    }
  });
};

extendedData.prototype.getDeviceValues = function () {
  var me = this;

  // fill ModbusActionStatus
  $("[id^='ModbusActionStatus_'][id$='" + me.idVersion + "']").each(function (cntMAS, itemMAS) {
    var this_control = $(this);
    $(tblEditStore).each(function (cntStoreItems, storeItem) {
      if (storeItem.id == me.id) {
        $(storeItem.data).each(function (cntDataItems, dataItem) {
          if (dataItem.attrGSDname == 'Modbus_Action_Status' && parseInt(dataItem.attrmulticount) == cntMAS + 1) {
            this_control.val(dataItem.attrname);
            return false;
          }
        });
      }
    });
  });

  // fill ActionStatusReset
  $("[id^='ActionStatusReset_'][id$='" + me.idVersion + "']").each(function (cntASR, itemASR) {
    var this_control = $(this);
    $(tblEditStore).each(function (cntStoreItems, storeItem) {
      if (storeItem.id == me.id) {
        $(storeItem.data).each(function (cntDataItems, dataItem) {
          if (dataItem.attrGSDname == 'Action_Status_Reset' && parseInt(dataItem.attrmulticount) == cntASR + 1) {
            this_control.val(dataItem.attrname);
            return false;
          }
        });
      }
    });
  });

  // fill ModbusMasterStatus &  MasterStatusReset
  $(tblEditStore).each(function (cntStoreItems, storeItem) {
    if (storeItem.id == me.id) {
      $(storeItem.data).each(function (cntDataItems, dataItem) {
        if (dataItem.attrGSDname == 'Modbus_Master_Status') {
          $("[id^='hid_ModbusMasterStatus_'][id$='" + me.idVersion + "']").val(dataItem.attrname);
        }
        if (dataItem.attrGSDname == 'Master_Status_Reset') {
          $("[id^='hid_MasterStatusReset_'][id$='" + me.idVersion + "']").val(dataItem.attrname);
        }
      });
    }
  });
};

// IMPORTANT: this function is intended to handles special cases where
// form data can not be 1:1 used in extended data for export!
// - not used in modbus currently -
extendedData.prototype.modifyFormData = function (formData) {
  return formData;
};

extendedData.prototype.mapAttributes = function () {
  var me = this;

  var swtMappingDone = false;
  var hlpMapItem = [];

  $(me.arrMap).each(function (cntMapItems, mapItem) {
    swtMappingDone = false;

    hlpMapItem = me.calcMapping(mapItem);

    $(tblEditStore).each(function (cntStoreItems, storeItem) {
      if (storeItem.id == me.id) {
        $(storeItem.data).each(function (cntDataItems, dataItem) {
          if (dataItem.attrGSDname == hlpMapItem[1] && parseInt(dataItem.attrmulticount) == hlpMapItem[2]) {
            dataItem.attrvalue = $('#' + hlpMapItem[0]).val();
            swtMappingDone = true;
            return false;
          }
        });
      }

      if (swtMappingDone == true) {
        return false;
      }
    });
  });
};

extendedData.prototype.calcMapping = function (arrMapItem) {
  if (arrMapItem[2] == 2) {
    arrMapItem[2] = 5;
  }

  return arrMapItem;
};

// MISC helper functions
//
extendedData.prototype.handleTableRows = function (mode, rowNum, controlId) {
  var me = this;
  var hlpSplit = [];

  // entry[0] ... Name of Control
  // entry[1] ... generate 'name' attribute -> determines whether control will be saved to RSC file!
  var arrControls = [
    ['ActionId', true],
    ['SlaveAddress', true],
    ['SlaveIP', true],
    ['SlavePort', true],
    ['FunctionCode', true],
    ['RegisterAddress', true],
    ['QuantityOfRegisters', true],
    ['ActionInterval', true],
    ['ProcessImageStartByte', true],
    ['DeviceValue', true],
    ['ModbusActionStatus', true],
    ['ActionStatusReset', true],
  ];

  if (mode == 'ADD_ROW') {
    //var cntRows = $('#tbl_A_' + me.idVersion + ' tr').length - 1; // decrement since length also counts header rows!
    var nextRowNum = me.getNextRowNum();

    var rowNumToAdd = rowNum == 0 ? nextRowNum : rowNum;

    // row level
    $('#tbl_A_' + me.idVersion + ' tbody').append($('#tmpl_row_' + me.idVersion).clone());
    $('#tbl_A_' + me.idVersion + ' tr:last').attr('id', 'row_' + pad(rowNumToAdd, 2) + '_' + me.idVersion);

    // row marker (will not be saved)
    $('#tbl_A_' + me.idVersion + ' tr:last')
      .find('#tmpl_chkRow_' + me.idVersion)
      .attr('id', 'chkRow_' + pad(rowNumToAdd, 2) + '_' + me.idVersion);

    $(arrControls).each(function (cntControls, itemControl) {
      $('#tbl_A_' + me.idVersion + ' tr:last')
        .find('#tmpl_' + itemControl[0] + '_' + me.idVersion)
        .attr('id', itemControl[0] + '_' + pad(rowNumToAdd, 2) + '_' + me.idVersion);

      // generate 'name' HTML attr?
      if (itemControl[1] == true) {
        $('#tbl_A_' + me.idVersion + ' tr:last')
          .find('#' + itemControl[0] + '_' + pad(rowNumToAdd, 2) + '_' + me.idVersion)
          .attr('name', 'data[' + itemControl[0] + '_' + pad(rowNumToAdd, 2) + '_' + me.idVersion + ']');
      }
    });

    // show dialog
    $('#tbl_A_' + me.idVersion + ' tr:last').show();

    // set init values depending on productype
    if (me.productType == me.CONST_PRODUCTTYPE_MODBUS_TCP) {
      $('#SlaveAddress_' + pad(rowNumToAdd, 2) + '_' + me.idVersion).val('255');
    } else {
      $('#SlaveAddress_' + pad(rowNumToAdd, 2) + '_' + me.idVersion).val('1');
    }

    // -Device Values- depend on selected values of -Function Code-
    //	--> we need to populate and load data in two steps!!
    me.populateDropdowns(rowNumToAdd, 'FUNCTION_CODE');
    handleExtendedDataStore(me.id, 'FILL');
    me.populateDropdowns(rowNumToAdd, 'DEVICE_VALUE');
    handleExtendedDataStore(me.id, 'FILL');

    me.renumberActionIds();
    me.refreshDelegates();
    setTimeout(function () {
      me.refreshMasks();
    }, 10); // unknown why this only works when delayed ...
    //me.validate();

    // decrement rowcount by 2 - don't count table header and invisible template row!
    $('#hid_tbl_A_rowcount').val($('#tbl_A_' + me.idVersion + ' tr').length - 2);
  }

  if (mode == 'REMOVE_ROW') {
    $('#row_' + pad(rowNum, 2) + '_' + me.idVersion).remove();

    //me.refreshDelegates(); ??????????

    me.renumberActionIds();

    // decrement rowcount by 2 - don't count table header and invisible template row!
    $('#hid_tbl_A_rowcount').val($('#tbl_A_' + me.idVersion + ' tr').length - 2);
  }

  if (mode == 'GET_ROWID') {
    hlpSplit = controlId.split('_');
    return parseInt(hlpSplit[1]);
  }
};

// returns attrname AND attrGSDname (with multi-count if multi > 1)
extendedData.prototype.getDeviceAttr = function (typeFilter, GSDtypeFilter, bitSizeFilter, dontExcludeUsed) {
  var me = this;
  var arrAttrnames = [];
  var hlpDataType = '';

  //debugger;

  $(tblEditStore).each(function (cntStoreItems, storeItem) {
    if (storeItem.id == me.id) {
      $(storeItem.data).each(function (cntDataItems, dataItem) {
        // check if attr has already been used!
        var swtAlreadyUsed = false;
        if (dontExcludeUsed == false) {
          $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").each(function (cntRows, row) {
            //if((dataItem.attrGSDname + ((dataItem.attrGSDmulti > 1) ? "_" + dataItem.attrmulticount : "") == $(this).val()) && (dataItem.attrGSDname + ((dataItem.attrGSDmulti > 1) ? "_" + dataItem.attrmulticount : "") != dontExcludeUsed)) {
            if (dataItem.attrname == $(this).val()) {
              swtAlreadyUsed = true;
            }
          });
        }

        // don't add attrs that have already been used!
        if (swtAlreadyUsed == false) {
          // get bit size only if filter is set
          if (bitSizeFilter != 0) {
            hlpDataType = getDataType(dataItem.attrGSDtype);
          }

          if (
            (typeFilter == '' || dataItem.attrtype.split(" ")[0] == typeFilter) &&
            (GSDtypeFilter == '' || dataItem.attrGSDtype == GSDtypeFilter) &&
            (bitSizeFilter == '' || hlpDataType.attr[fileDataTypesJSON.constants.BITLEN] == bitSizeFilter)
          ) {
            // don't add hidden attrs!
            if (dataItem.attrhidden == 'false') {
              arrAttrnames.push(
                dataItem.attrname +
                  '|' +
                  dataItem.attrGSDname +
                  (dataItem.attrGSDmulti > 1 ? '_' + dataItem.attrmulticount : ''),
              );
            }
          }
        }
      });
    }
  });

  return arrAttrnames;
};

extendedData.prototype.getFunctionCodeData = function (functionCodeName) {
  var me = this;
  var retData = '';

  $(me.arrFunctionCodes).each(function (cntFunctionCodes, itemFunctionCode) {
    if (functionCodeName == itemFunctionCode[0]) {
      retData = itemFunctionCode;
    }
  });

  return retData;
};

// get number of Modbus_Action_Status attributes entries in tblEditStore
// - used to limit the rows that can be inserted into dialog table
extendedData.prototype.cntModbus_Action_Status = function () {
  var me = this;
  var retCnt = 0;
  $.each(tblEditStore, function (cntStoreEntries, storeEntry) {
    if (storeEntry.id.indexOf(me.idVersion) > -1) {
      $.each(storeEntry.data, function (cntDataEntries, dataEntry) {
        if (dataEntry.attrGSDname == 'Modbus_Action_Status') {
          retCnt++;
        }
      });
    }
  });

  return retCnt;
};

// STANDARD functions
//
extendedData.prototype.handleMessage = function (mode, txtMessage) {
  var me = this;

  if (mode == 'SHOW') {
    $('#' + 'lbl_tbl_A_msg_' + me.idVersion).html(txtMessage + '<p>');
    $('#' + 'lbl_tbl_A_msg_' + me.idVersion).show();
  }

  if (mode == 'HIDE') {
    $('#' + 'lbl_tbl_A_msg_' + me.idVersion).hide();
  }
};

extendedData.prototype.validate = function (mode) {
  var me = this;
  var errText = '';
  var errControlId = '';
  var hlpRowId = 0;
  var hlpFunctionCodeName = '';
  var hlpfunctionCodeData = '';

  // reset old error message
  me.handleMessage('HIDE', '');

  // Check 01 - Function Code / Quantity of Registers ?
  //
  // Step 01: calculate used bits
  var bitsUsed = 0;
  var currentVal = 0;
  $("[id^='FunctionCode_'][id$='" + me.idVersion + "']").each(function (cntFC, itemC) {
    currentVal = $(this).val();
    $(me.arrFunctionCodes).each(function (cntFunctionCodes, itemFunctionCode) {
      if (currentVal == itemFunctionCode[1]) {
        bitsUsed += itemFunctionCode[2];
      }
    });
  });

  // Check 02 - Register Quantity
  $("[id^='FunctionCode_'][id$='" + me.idVersion + "']").each(function (cntFC, itemFC) {
    hlpRowId = me.handleTableRows('GET_ROWID', 0, $(this).attr('id'));
    hlpFunctionCodeName = $('#' + $(this).attr('id'))
      .find('option:selected')
      .text();
    hlpfunctionCodeData = me.getFunctionCodeData(hlpFunctionCodeName);

    // field is mandatory
    if ($.trim($('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).val()) == '') {
      errText = errText + 'Action Id: ' + parseInt(cntFC + 1) + ' / ERR_EXT_08: Quantity of Registers is empty<br>';
      errControlId = 'QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion;
    }

    // only test when function has been selected (NOT on 0 state)
    if (hlpfunctionCodeData[1] != 0) {
      // REGISTER code
      if (
        hlpfunctionCodeData[2] == 16 &&
        $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).val() > 125
      ) {
        errText =
          errText + 'Action Id: ' + parseInt(cntFC + 1) + ' / ERR_EXT_01: Quantity of Registers too large (1-125)<br>';
        errControlId = 'QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion;
      }

      if (
        hlpfunctionCodeData[2] == 1 &&
        $('#QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion).val() > me.MAX_REGISTER_SIZE_PER_ACTION
      ) {
        errText =
          errText + 'Action Id: ' + parseInt(cntFC + 1) + ' / ERR_EXT_02: Quantity of Registers too large (1-256)<br>';
        errControlId = 'QuantityOfRegisters_' + pad(hlpRowId, 2) + '_' + me.idVersion;
      }
    } else {
      errText = errText + 'Action Id: ' + parseInt(cntFC + 1) + ' / ERR_EXT_06: Please select Function code<br>';
      errControlId = itemFC.id;
    }
  });

  // Check 03 - Action Interval
  $("[id^='ActionInterval_'][id$='" + me.idVersion + "']").each(function (cntAI, itemAI) {
    // field is mandatory
    if ($.trim($('#' + itemAI.id).val()) == '') {
      errText = errText + 'Action Id: ' + parseInt(cntAI + 1) + ' / ERR_EXT_08: Action Interval is empty<br>';
      errControlId = itemAI.id;
    }

    if (parseInt($('#' + itemAI.id).val()) < 5 || parseInt($('#' + itemAI.id).val()) > 1000000) {
      errText =
        errText + 'Action Id: ' + parseInt(cntAI + 1) + ' / ERR_EXT_03: Action Interval out of Range (5-1000000)<br>';
      errControlId = itemAI.id;
    }
  });

  // Check 04 - SlaveAddress
  $("[id^='SlaveAddress_'][id$='" + me.idVersion + "']").each(function (cntSA, itemSA) {
    // field is mandatory
    if ($.trim($('#' + itemSA.id).val()) == '') {
      errText = errText + 'Action Id: ' + parseInt(cntSA + 1) + ' / ERR_EXT_08: Slave Addr. is empty<br>';
      errControlId = itemSA.id;
    }

    if (parseInt($('#' + itemSA.id).val()) < 1 || parseInt($('#' + itemSA.id).val()) > 255) {
      errText = errText + 'Action Id: ' + parseInt(cntSA + 1) + ' / ERR_EXT_04: Slave Address out of range (1-255)<br>';
      errControlId = itemSA.id;
    }
  });

  // Check 05 - SlaveIP
  $("[id^='SlaveIP_'][id$='" + me.idVersion + "']").each(function (cntSI, itemSI) {
    if ($('#' + itemSI.id).val() != '' && isIPaddressValid($('#' + itemSI.id).val()) == false) {
      errText = errText + 'Action Id: ' + parseInt(cntSI + 1) + ' / ERR_EXT_05: Slave IP not valid!<br>';
      errControlId = itemSI.id;
    }
  });

  // Check 06 - DeviceValue
  if (mode != 'NO_DV') {
    $("[id^='DeviceValue_'][id$='" + me.idVersion + "']").each(function (cntDV, itemDV) {
      if ($('#' + itemDV.id).val() == 0) {
        errText = errText + 'Action Id: ' + parseInt(cntDV + 1) + ' / ERR_EXT_06: Please select Device Value!<br>';
        errControlId = itemDV.id;
      }
    });
  }

  // Check 07 - RegisterAddress
  $("[id^='RegisterAddress_'][id$='" + me.idVersion + "']").each(function (cntRA, itemRA) {
    // field is mandatory
    if ($.trim($('#' + itemRA.id).val()) == '') {
      errText = errText + 'Action Id: ' + parseInt(cntRA + 1) + ' / ERR_EXT_08: Register Addr. is empty<br>';
      errControlId = itemRA.id;
    }

    if (parseInt($('#' + itemRA.id).val()) < 1 || parseInt($('#' + itemRA.id).val()) > 65536) {
      errText =
        errText + 'Action Id: ' + parseInt(cntRA + 1) + ' / ERR_EXT_07: Register Address out of range (1-65536)<br>';
      errControlId = itemRA.id;
    }
  });

  if (errText != '') {
    me.handleMessage('SHOW', errText);
    return errControlId;
  } else {
    return true;
  }
};

// this function MUST exist in every ext_????.js file since it
// is being called on every changing of an attribute name in the value editor of PiCtory!
// (but function can be empty!)
extendedData.prototype.updateChangedAttrnames = function (newName, oldName) {
  var me = this;
  // data is empty if dialog has not yet been closed with 'OK'
  // no need to update ...
  if (me.data == '') {
    return;
  }

  var objJSON = jQuery.parseJSON(me.data);
  var swtChanged = false;

  jQuery.each(objJSON.data, function (name, value) {
    if (value == oldName) {
      objJSON.data[name] = newName;
      swtChanged = true;
    }
  });

  if (typeof objJSON.deviceMisc != 'undefined') {
    jQuery.each(objJSON.deviceMisc, function (name, value) {
      if (value == oldName) {
        objJSON.deviceMisc[name] = newName;
        swtChanged = true;
      }
    });
  }

  if ((swtChanged = true)) {
    me.data = JSON.stringify(objJSON);
  }
};

extendedData.prototype.test = function () {
  var me = this;
  //alert('TEST XXX');
  // put test code here
};
