<?php
session_start();
$swtDebug = true;
$retDebug = "runActions DEBUG: ";

$jsonRet = "";
$json_params = file_get_contents('php://input');
$decoded_params = json_decode($json_params);

$arrEvents = ["onAdd","onDelete"]; // allowed events
$arrNewProjectDevices = [];
$arrExecutedCommands = [];

// do nothing if no valid session exists
if (!isset($_SESSION['RevPiSessionId']) || ($decoded_params->RevPiSessionId != $_SESSION['RevPiSessionId'])) {	
	echo "PHP_SESSION_INVALID";
	die;
}

// read rules files

function isDeviceRulesComboNew($rules, $customDevice, $customRule) {
    foreach( $rules as $rule ) {
        foreach( $rule->deviceTypes as $device ) {
            if( $device == $customDevice && $rule == $customRule ) {
                return true;
            }
        }
    }
   return false;
}

function getRuleWithoutDuplicates($rules, $newRule) {
    $devices = $newRule->deviceTypes;
    foreach($devices as $device) {
        if(!isDeviceRulesComboNew($rules, $device, $newRule)) {
            $keyToRemove = array_search($device, $devices);
            if ($keyToRemove !== false) {
                unset($newRule->deviceTypes[$keyToRemove]);
            }
        }
    }
    $newRule->deviceTypes = $devices;
    return $newRule;
}

function getCustomRulesAsArray($file) {
    $jsonCustomRules = file_get_contents($file);
    return json_decode($jsonCustomRules);
}

function appendCustomActionRules($actionRules){
    $customRulesFile = "../resources/data/rap/actionRules-custom.json" ;
    if (file_exists($customRulesFile)) {
        $arrCustomRules = getCustomRulesAsArray($customRulesFile);
        foreach($arrCustomRules as $customRule) {
            $newCustomRule = getRuleWithoutDuplicates($actionRules, $customRule);
            if(count($newCustomRule->deviceTypes) > 0){
                array_push($actionRules, $newCustomRule);
            }
        }
    }
    return $actionRules;
}

if (file_exists("../resources/data/rap/actionRules.json")) {
	$jsonActionRules = file_get_contents("../resources/data/rap/actionRules.json");
	$arrActionRules = json_decode($jsonActionRules);
	$arrActionRules = appendCustomActionRules($arrActionRules);
}

// start mode --> create LAST/NEW compare file to reflect current project file
if (isset($decoded_params->start) && ($decoded_params->start == true)) {
	if ((file_exists("../projects/_config.rsc")) && (filesize("../projects/_config.rsc") > 0)) {
		$jsonProjectData = file_get_contents("../projects/_config.rsc");
		$objProjectData = json_decode($jsonProjectData);
		// loop over all devices and create sorted array of ids
		foreach($objProjectData->Devices as $device) {
			array_push($arrNewProjectDevices , getRAPfilename($device->id,"NO_SUFFIX"));
		}
		sort($arrNewProjectDevices);
		file_put_contents("../projects/.tmpLastProjectDevices.json", json_encode ($arrNewProjectDevices));
	}

	if ($swtDebug == false) {
		echo "OK";
	} else {
		echo $retDebug;
	}

	die;
}

// populate last state of project for delta
$arrLastProjectDevices = [];
if (isset($decoded_params->reset) && ($decoded_params->reset == true)) {
	// RESET - fill the names of ALL available RAP files into LAST devices array!
	// This triggers for ALL devices which are not currently included in project file the 'onDelete' action (if any)
	$savDir = getcwd();
	chdir('../resources/data/rap'); // change dir so the glob gives back only filenames without path info!
	$hlpRapFiles = glob('*.rap');
	foreach($hlpRapFiles as $rapFilename) {
		array_push($arrLastProjectDevices, str_replace(".rap","",$rapFilename));
	}
	chdir($savDir);
} else {
	// NO RESET - get LAST device from compare file
	if (file_exists("../projects/.tmpLastProjectDevices.json")) {
		$jsonLastProjectDevices = file_get_contents("../projects/.tmpLastProjectDevices.json");
		$arrLastProjectDevices = json_decode($jsonLastProjectDevices);
	}
}

if (file_exists("../projects/_config.rsc")) {

	// get standard project file _config.rsc
	$jsonProjectData = file_get_contents("../projects/_config.rsc");
	$objProjectData = json_decode($jsonProjectData);
	// loop over all devices and create sorted array of ids
	foreach($objProjectData->Devices as $device) {
		array_push($arrNewProjectDevices , getRAPfilename($device->id,"NO_SUFFIX"));
	}
	sort($arrNewProjectDevices);

	$arrLoop = [];
	$arrSearch = [];
	$currentEvent = "";
	foreach($arrEvents as $event) {
		$currentEvent = $event;
		// fill work arrays
		if ($event == "onAdd") {
			$arrLoop = $arrNewProjectDevices;
			
			if (isset($decoded_params->reset) && ($decoded_params->reset == true)) {
				// do nothing in reset case - comparing with empty $arrSearch triggers 'onAdd' 
				// action for all devices currently in project file
			} else {	
				$arrSearch = $arrLastProjectDevices;
			}
		}
		if ($event == "onDelete") {
			$arrLoop = $arrLastProjectDevices;
			$arrSearch = $arrNewProjectDevices;
		}

		//ADD loop 		(over NEW array) ... loop over all devices that are present in NEW-array and not in LAST-array
		//DELETE loop 	(over LAST array) ... loop over all devices that are present in LAST-array and not in NEW-array
		foreach($arrLoop as $currentDevice) {
			if (!in_array($currentDevice, $arrSearch)) {
				$RAPfilename = $currentDevice . ".rap";
				if (file_exists("../resources/data/rap/".$RAPfilename)) {
					$jsonRAPData = file_get_contents("../resources/data/rap/".$RAPfilename);
					$objRAPData = json_decode($jsonRAPData);
					if (isset($objRAPData->actions)) {
						foreach($objRAPData->actions as $rapAction) {
							if (($rapAction->active == true) && ($rapAction->event == $currentEvent)) {
								$hlpExec = $rapAction->action;
								// handling of parameters
								// add slot here for every parameter to be evaluated by PHP before
								// patching it into exec string ...
								//$hlpExec = str_replace("##TEST01##","_act01.txt",$hlpExec);
								//$hlpExec = str_replace("##TEST02##","_act02.txt",$hlpExec);

								//$retDebug = $retDebug . $RAPfilename . "-" . $currentEvent . " / ";
								
								// execute!
								// IMPORTANT: this WAITS for ending of excution - no parallel threads here
								if (checkRules($currentDevice, $currentEvent) == true) {
									// execute each unique command only ONCE
									// remove blanks to allow writing variants
									if (!in_array(str_replace(' ', '', $hlpExec), $arrExecutedCommands)) {
										
										//$retDebug = $retDebug . $hlpExec . "/";
										
										exec($hlpExec);
										array_push($arrExecutedCommands , str_replace(' ', '', $hlpExec));
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// update compare file
	file_put_contents("../projects/.tmpLastProjectDevices.json", json_encode($arrNewProjectDevices));

	if ($swtDebug == false) {
		echo "OK";
	} else {
		echo $retDebug;
	}

}

function checkRules($device,$event) {
	global $swtDebug;
	global $retDebug;

	if ($swtDebug == true) {
		//$retDebug = $retDebug . "/in CheckRules; device=" . $device . "; event=" . $event;
	}

	global $arrLastProjectDevices;
	global $arrNewProjectDevices;
	global $arrActionRules;
	$ret = false;

	//search matching rule
	foreach($arrActionRules as $currentRule) {
		$eventParts = explode("_", $currentRule->rule);

		if ($swtDebug == true) {
			//$retDebug = $retDebug . "; part0=" . $eventParts[0] . "; part1=" . $eventParts[1];
		}

		if ((strtoupper($event) == strtoupper($eventParts[0])) && in_array($device, $currentRule->deviceTypes)) {
			// device was added as FIRST of all device-types of this rule into project
			if ($eventParts[1] == "FIRST") {
				//if (cntDeviceTypesInProject($currentRule->deviceTypes, $arrNewProjectDevices) == 1) {
				if ((cntDeviceTypesInProject($currentRule->deviceTypes, $arrLastProjectDevices) == 0) && (cntDeviceTypesInProject($currentRule->deviceTypes, $arrNewProjectDevices) >= 1)) {
					$ret = true;
					break;
				}
			}

			// device was deleted as LAST of all device-types of this rule from project
			if ($eventParts[1] == "LAST") {
				if ((cntDeviceTypesInProject($currentRule->deviceTypes, $arrNewProjectDevices) == 0) && (cntDeviceTypesInProject($currentRule->deviceTypes, $arrLastProjectDevices) >= 1)) {
					$ret = true;
					break;
				}
			}
		}
	}

	return $ret;
}

function cntDeviceTypesInProject($arrCheckDevices, $arrToCheck) {
	global $swtDebug;
	global $retDebug;

	if ($swtDebug == true) {
		//$retDebug = $retDebug . "/in cntDeviceTypesInProject";
	}

	global $arrNewProjectDevices;
	$retCnt = 0;

	foreach($arrCheckDevices as $checkDevice) {
		if (in_array($checkDevice, $arrToCheck)) {
			$retCnt++;
		}
	}

	if ($swtDebug == true) {
		//$retDebug = $retDebug . "; retCnt =" . $retCnt;
	}
	return $retCnt;
}

function getRAPfilename($deviceIdFull, $options) {
	global $swtDebug;
	global $retDebug;

	$strRet = "";
	$deviceIdParts = explode("_", $deviceIdFull);
	$strRet = $deviceIdParts[1]."_".$deviceIdParts[2]."_".$deviceIdParts[3]."_".$deviceIdParts[4];
	if ($options != "NO_SUFFIX") {
		$strRet = $strRet . ".rap";
	}
	return $strRet;
}

?>
