<?php
// Load session variables
session_start();

// Unset all of the session variables.
$_SESSION = array();

// Delete session cookies
if (ini_get("session.use_cookies")) {
    setcookie("Cockpit_SSO_Host", '', time() - 42000, '/', '', true, false);
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Destroy the session
session_destroy();

// Prepare a user-friendly message and manual close link
header("Content-Type: text/html; charset=UTF-8");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Logout</title>
    <script type="text/javascript">
         window.onload = function() {
             window.close(); // Attempt to close the current window
         };
   </script>
</head>
<body>
    <h1>Logged Out</h1>
    <p>You have been successfully logged out. If this window does not close, please close this window manually.</p>
</body>
</html>
